/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.Interpolation;
import roomeqwizard.LogDataSet;
import roomeqwizard.PB;
import roomeqwizard.RT60;
import roomeqwizard.YE;

class LK {
    private RT60[] F;
    private double[] E;
    private double[] H;
    private double[] I;
    private double A;
    private int G;
    private int C;
    private double B;
    private LogDataSet K;
    private LogDataSet D;
    private LogDataSet J;

    LK(int n2) {
        this.G = n2;
    }

    void A(double d2, int n2) {
        this.A = d2;
        this.F = new RT60[n2];
        this.E = new double[n2];
        this.H = new double[n2];
        this.I = new double[n2];
        this.K = new LogDataSet(d2, this.G, this.E, 0.0);
        this.D = new LogDataSet(d2, this.G, this.H, 0.0);
        this.J = new LogDataSet(d2, this.G, this.I, 0.0);
        if (this.G < 6) {
            this.K.setInterpolationType(Interpolation.LINEAR);
            this.D.setInterpolationType(Interpolation.LINEAR);
            this.J.setInterpolationType(Interpolation.LINEAR);
        }
        if (this.G < 24) {
            this.K.setTension(0.5);
            this.D.setTension(0.5);
            this.D.setTension(0.5);
        }
    }

    void A(PB pB2, double d2, double d3) {
        this.C = pB2.M;
        this.B = 1.0 / (double)this.G * Math.log(2.0);
        Thread thread = new Thread(new YE._A(pB2, this, d2, d3, this.G));
        thread.setPriority(5);
        thread.start();
    }

    void A(int n2, RT60 rT60) {
        this.F[n2] = rT60;
        if (rT60.hasModelData()) {
            this.E[n2] = rT60.modelT60;
            this.H[n2] = rT60.fitError;
            this.I[n2] = 10.0 * Math.log10(rT60.modelNoise);
        }
    }

    void A() {
        if (this.F != null) {
            for (RT60 rT60 : this.F) {
                if (rT60 == null) continue;
                rT60.validEndIndex = 0;
                rT60.modelT60 = Double.NaN;
            }
        }
    }

    void E() {
        this.E = null;
        this.H = null;
        this.I = null;
    }

    int G() {
        return this.C;
    }

    double C(double d2) {
        return this.A * Math.exp(d2 * this.B);
    }

    double E(double d2) {
        return Math.log(d2 / this.A) / this.B;
    }

    RT60 A(double d2) {
        int n2 = (int)Math.round(this.E(d2));
        if (this.F == null || n2 < 0 || n2 >= this.F.length) {
            return null;
        }
        return this.F[n2];
    }

    boolean A(float f2) {
        return (double)f2 >= this.A && (double)f2 <= this.C(this.F.length - 1);
    }

    double D() {
        return this.A;
    }

    double F() {
        return this.C(this.F.length - 1);
    }

    double B(double d2) {
        if (this.K == null) {
            return 0.0;
        }
        return this.K.value(d2);
    }

    double D(double d2) {
        if (this.D == null) {
            return 0.0;
        }
        return this.D.value(d2);
    }

    LogDataSet C() {
        return this.K;
    }

    LogDataSet B() {
        return this.D;
    }
}

