/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.IF;
import roomeqwizard.zB;

enum Interpolation {
    NONE("None"),
    LINEAR("Linear"),
    HERMITE("Hermite"),
    SINC("Windowed sinc"),
    FFT("FFT time shift");

    private final String description;

    private Interpolation(String string2) {
        this.description = string2;
    }

    public String toString() {
        return this.description;
    }

    zB oversample(float[] fArray, double d2, int n2) {
        return this.oversample(fArray, 0, fArray.length, d2, n2);
    }

    zB oversample(float[] fArray, int n2, int n3, double d2, int n4) {
        if (n4 == 1) {
            return new zB(fArray, n2, n3, n4);
        }
        switch (this) {
            case SINC: {
                return new zB(IF.A(fArray, n2, n3, d2, (double)n4), n4);
            }
            case FFT: {
                float[] fArray2;
                float[] fArray3 = IF.A(fArray, d2, n4);
                if (n2 == 0 && n3 == fArray.length) {
                    fArray2 = fArray3;
                } else {
                    fArray2 = new float[n4 * (n3 - n2)];
                    System.arraycopy(fArray3, n2 * n4, fArray2, 0, fArray2.length);
                }
                return new zB(fArray2, n4);
            }
            case NONE: {
                return new zB(fArray, n2, n3, 1);
            }
            case HERMITE: {
                return new zB(IF.B(fArray, d2, n4), n4);
            }
        }
        throw new Error(this.toString() + " overSample not implemented yet");
    }

    float interpolate(float[] fArray, int n2, float f2) {
        switch (this) {
            case LINEAR: {
                return IF.A(fArray, n2, f2);
            }
            case HERMITE: {
                return IF.B(fArray, n2, f2);
            }
        }
        throw new Error(this.toString() + " interpolate not implemented yet");
    }

    public static Interpolation getEnum(String string) {
        for (Interpolation interpolation : Interpolation.values()) {
            if (!interpolation.name().equalsIgnoreCase(string)) continue;
            return interpolation;
        }
        return NONE;
    }
}

