/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.HE;
import roomeqwizard.lH;

enum ISO3382Param {
    T60M("T60M", "T60M", "s", "REW model T60 value"),
    TOPT("Topt", "Topt", "s", "REW optimum RT60 value"),
    EDT("EDT", "EDT  0..-10 dB", "s", "Early Decay Time"),
    T20("T20", "T20 -5..-25 dB", "s", null),
    T30("T30", "T30 -5..-35 dB", "s", null),
    CURVATURE("Curvature", "Curvature", "%", "T30/T20-1 expressed as a percentage"),
    C50("C50", "Clarity C50", "dB", "Clarity C50"),
    C80("C80", "Clarity C80", "dB", "Clarity C80"),
    D50("D50", "Definition D50", "%", "Definition D50"),
    TS("TS", "Centre time TS", "s", "Centre time TS");

    static final String NA_TEXT = "N/A";
    private final String shortString;
    private final String longString;
    private final String unitSt;
    private final String toolTipSt;

    private ISO3382Param(String string2, String string3, String string4, String string5) {
        this.shortString = string2;
        this.longString = string3;
        this.unitSt = string4;
        this.toolTipSt = string5;
    }

    public String toString() {
        return this.shortString;
    }

    public String shortString() {
        return this.shortString;
    }

    String longString() {
        return this.longString;
    }

    String toolTip() {
        return this.toolTipSt;
    }

    String unitSt() {
        return this.unitSt;
    }

    String format(double d2) {
        if (!lH.A((Double)d2)) {
            return NA_TEXT;
        }
        switch (this) {
            case EDT: 
            case T20: 
            case T30: 
            case TOPT: 
            case TS: 
            case T60M: {
                if (d2 < 1.0) {
                    return HE.A.format(d2);
                }
                return HE.C(d2, 4);
            }
            case C50: 
            case C80: {
                return HE.K.format(d2);
            }
            case CURVATURE: 
            case D50: {
                return HE.U.format(d2);
            }
        }
        return "???";
    }

    boolean hasCorrelationCoefficient() {
        switch (this) {
            case EDT: 
            case T20: 
            case T30: 
            case TOPT: {
                return true;
            }
        }
        return false;
    }

    public static ISO3382Param getEnum(String string) {
        for (ISO3382Param iSO3382Param : ISO3382Param.values()) {
            if (!iSO3382Param.name().equalsIgnoreCase(string)) continue;
            return iSO3382Param;
        }
        return TOPT;
    }
}

