/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.fft.FloatFFT_1D;
import roomeqwizard.FDWUnit;
import roomeqwizard.IRFloat;
import roomeqwizard.MeasData;
import roomeqwizard.MinPhaseTails;
import roomeqwizard.OctaveFilterSettings;
import roomeqwizard.RT60;
import roomeqwizard.SampledData;
import roomeqwizard.SweepAnalyser;
import roomeqwizard.Window;
import roomeqwizard.WindowSettings;
import roomeqwizard.XD;
import roomeqwizard.lG;
import roomeqwizard.lH;
import roomeqwizard.zB;

public class IRData
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final boolean RESAMPLE_ON_START_SHIFT = false;
    private SampledData ir;
    private WindowSettings windows;
    double startFreq;
    double endFreq;
    double splOffset = 0.0;
    Boolean invertImpulse = false;
    double measurementDelay = 0.0;
    Boolean usedTimingRef = false;
    double harmFactor;
    double origPeakTime = 0.0;
    Integer unfiltIRStartIndex;
    double cumulativeStartTimeOffset = 0.0;
    double cumulativeClockRateAdjust = 0.0;
    private Boolean fdwEnabled = false;
    private Boolean fdwAsCycles = lG.\u03af() == FDWUnit.CYCLES;
    private Double fdwWidth = this.fdwAsCycles != false ? lG.\u01c6() : lG.\u014b();
    private float[] fdwData;
    private Boolean minPhase = Boolean.FALSE;
    private Double nyqMagn = null;
    private double nyqPhase;
    private double timingOffset;
    private Double refPeakIndex;
    private Double signaldBFS;
    private Double distdBFS;
    private Double noiseAndNHDdBFS;
    private Double signalToNoisedB;
    private Double signalToDistdB;
    private boolean usedNovak = false;
    private transient float[] distData;
    private transient SampledData windowedIR;
    private transient SampledData envelope;
    private transient SampledData schroeder;
    transient RT60[] octRT60Result;
    transient RT60[] thirdOctRT60Result;
    transient RT60 unfiltRT60Result;
    transient RT60 indRT60Result;

    public Object readResolve() throws ObjectStreamException {
        return this;
    }

    IRData(int n2, double d2, float[] fArray, double d3, double d4, double d5, double d6, int n3, boolean bl) {
        this.fdwEnabled = bl;
        this.ir = new SampledData(n2, d2, fArray, d5, n3);
        this.ir.setOversampler(lG.Q());
        this.startFreq = d3;
        this.endFreq = d4;
        this.splOffset = d6;
        this.harmFactor = 0.0;
        if (this.ir.absMaxVal > 1.0f) {
            this.splOffset = this.ir.absMaxVal > 10.0f ? 20.0 * Math.log10(this.ir.absMaxVal) + 3.0103 : (this.splOffset += 20.0 * Math.log10(this.ir.absMaxVal));
            this.ir.scale(1.0 / (double)this.ir.absMaxVal);
        }
    }

    IRData(IRData iRData) {
        this(iRData.ir.n, iRData.ir.T, iRData.ir.data, iRData.startFreq, iRData.endFreq, iRData.ir.startTime, iRData.splOffset, SampledData.getIROversample(iRData.ir.n), iRData.fdwEnabled());
        this.harmFactor = iRData.harmFactor;
        this.copyWindowSettings(iRData);
    }

    IRData(IRData iRData, int n2) {
        this(iRData.ir.n, iRData.ir.T, iRData.ir.data, iRData.startFreq, iRData.endFreq, iRData.ir.startTime, iRData.splOffset, n2, iRData.fdwEnabled());
        this.harmFactor = iRData.harmFactor;
        this.copyWindowSettings(iRData);
    }

    boolean usedNovak() {
        return this.usedNovak;
    }

    void setUsedNovak(boolean bl) {
        this.usedNovak = bl;
    }

    void copyWindowSettings(IRData iRData) {
        this.setWindows(iRData.getWindows().copy());
        this.setFdwWidth(iRData.getFdwWidth());
        this.setFdwAsCycles(iRData.fdwAsCycles);
        this.setFdwEnabledAndRemoveFDWIfFalse(iRData.fdwEnabled());
        if (iRData.fdwData != null) {
            this.fdwData = new float[iRData.fdwData.length];
            System.arraycopy(iRData.fdwData, 0, this.fdwData, 0, iRData.fdwData.length);
        }
    }

    IRData(IRFloat iRFloat) {
        this(iRFloat.n, iRFloat.T, iRFloat.data, iRFloat.startFreq, iRFloat.endFreq, iRFloat.startTime, iRFloat.splOffset, SampledData.getIROversample(iRFloat.n), iRFloat.fdwEnabled());
        this.harmFactor = iRFloat.harmFactor;
        this.copyWindowSettings(iRFloat);
    }

    void copyWindowSettings(IRFloat iRFloat) {
        this.setWindows(iRFloat.preWindow.type, iRFloat.preImpulseDurn, iRFloat.postWindow.type, iRFloat.postImpulseDurn, iRFloat.winRefTime);
        this.setFdwWidth(iRFloat.getFdwWidth());
        this.setFdwAsCycles(iRFloat.fdwAsCycles);
        this.setFdwEnabledAndRemoveFDWIfFalse(iRFloat.fdwEnabled());
        if (iRFloat.fdwEnabled() && iRFloat.fdwData != null) {
            this.fdwData = new float[iRFloat.fdwData.length];
            System.arraycopy(iRFloat.fdwData, 0, this.fdwData, 0, iRFloat.fdwData.length);
        }
    }

    IRData copy() {
        SampledData sampledData = this.getIR();
        IRData iRData = new IRData(sampledData.n, sampledData.T, sampledData.data, this.startFreq, this.endFreq, sampledData.startTime, this.splOffset, sampledData.oversampleFactor, this.fdwEnabled);
        iRData.copyWindowSettings(this);
        iRData.cumulativeClockRateAdjust = this.cumulativeClockRateAdjust;
        iRData.cumulativeStartTimeOffset = this.cumulativeStartTimeOffset;
        iRData.refPeakIndex = this.refPeakIndex;
        return iRData;
    }

    SampledData copyWindowedIR() {
        int n2 = this.windows.getPreImpulseIndex();
        double d2 = this.getIR().getStartTime();
        double d3 = this.getIR().getT();
        double d4 = d2 + (double)n2 * d3;
        float[] fArray = this.getWindowedData();
        SampledData sampledData = new SampledData(fArray.length, d3, fArray, d4, 1);
        return sampledData;
    }

    IRData minPhaseCopy(int n2, MinPhaseTails minPhaseTails, MeasData measData) {
        float[] fArray;
        SampledData sampledData = this.getIR();
        double d2 = sampledData.getT() / (double)n2;
        float[] fArray2 = this.getWindowedData();
        int n3 = fArray2.length;
        if (!lH.A(n3)) {
            fArray = new float[lH.C(n3)];
            System.arraycopy(fArray2, 0, fArray, 0, n3);
            fArray2 = fArray;
        }
        fArray = n2 > 1 ? lH.D(fArray2, fArray2.length, n2) : fArray2;
        float[] fArray3 = lH.B(fArray, 1.0, d2, n2, minPhaseTails, measData);
        double d3 = (double)n2 * this.endFreq;
        IRData iRData = IRData.generateIRFromMPResponse(fArray3, d2, this.startFreq, d3, this.splOffset - 20.0 * Math.log10(n2));
        iRData.cumulativeClockRateAdjust = this.cumulativeClockRateAdjust;
        return iRData;
    }

    static IRData generateIRFromMPResponse(float[] fArray, double d2, double d3, double d4, double d5) {
        int n2 = fArray.length;
        float[] fArray2 = new float[fArray.length];
        int n3 = fArray2.length / 16;
        System.arraycopy(fArray, 0, fArray2, n3, Math.min(fArray.length, fArray2.length - n3));
        IRData iRData = new IRData(fArray2.length, d2, fArray2, d3, d4, (double)(-n3) * d2, d5, 1, false);
        double d6 = 0.0;
        double d7 = (double)n2 * d2 / 16.0;
        double d8 = (double)n2 * d2 - d7;
        iRData.windows = new WindowSettings(iRData.ir, Window.Types.RECTANGULAR, d7, Window.Types.TUKEY, d8, d6);
        iRData.minPhase = Boolean.TRUE;
        return iRData;
    }

    boolean isMinPhase() {
        return this.minPhase != null && this.minPhase != false;
    }

    SampledData getWindowedIR() {
        if (this.windowedIR == null) {
            this.windowedIR = this.createWindowedIR();
        }
        return this.windowedIR;
    }

    SampledData getEnvelope() {
        return this.envelope;
    }

    SampledData getSchroeder() {
        return this.schroeder;
    }

    SampledData getIR() {
        return this.ir;
    }

    int getIRStartIndex() {
        int n2 = 0;
        if (this.unfiltIRStartIndex == null) {
            n2 = this.findImpulseStart();
        }
        if (this.unfiltIRStartIndex != null) {
            return this.unfiltIRStartIndex;
        }
        return n2;
    }

    double getIRStart() {
        int n2 = this.getIRStartIndex();
        return (double)(Math.round(this.ir.getStartTime() / this.ir.getT()) + (long)n2) * this.ir.getT();
    }

    double getTimingOffset() {
        return this.timingOffset;
    }

    public double getMeasurementDelay() {
        return this.measurementDelay;
    }

    void setTimingOffset(double d2) {
        this.timingOffset = d2;
    }

    void setRefPeakIndex(Double d2) {
        this.refPeakIndex = d2;
    }

    Double getRefPeakIndex() {
        return this.refPeakIndex;
    }

    SampledData createWindowedIR() {
        int n2 = this.windows.getWindowedSpan();
        int n3 = this.windows.getPreImpulseIndex();
        double d2 = this.getIR().getStartTime();
        double d3 = this.getIR().getT();
        double d4 = d2 + (double)n3 * d3;
        float[] fArray = new float[n2];
        if (this.fdwEnabled()) {
            System.arraycopy(this.fdwData, 0, fArray, 0, Math.min(this.fdwData.length, n2));
            SampledData sampledData = new SampledData(fArray.length, d3, fArray, d4, SampledData.getFDWOversample(fArray.length));
            sampledData.setNormVal(this.getIR().getNormVal());
            return sampledData;
        }
        boolean bl = true;
        if (bl) {
            return new SampledData(this.getIR(), this.windows);
        }
        zB zB2 = this.getIR().getOversampled(n3, n3 + n2);
        int n4 = zB2.A;
        float[] fArray2 = new float[n2 * n4];
        int n5 = zB2.D - zB2.F;
        int n6 = Math.min(n5, fArray2.length);
        System.arraycopy(zB2.E, zB2.F, fArray2, 0, n6);
        for (int i2 = 0; i2 < n2 * n4; ++i2) {
            int n7 = i2;
            fArray2[n7] = (float)((double)fArray2[n7] * this.windows.windowAmpl(d2 + (double)n3 * d3 + (double)i2 * d3 / (double)n4));
        }
        SampledData sampledData = new SampledData(fArray2.length, d3 / (double)n4, fArray2, d4, SampledData.getWINIR_OVERSAMPLE());
        sampledData.setNormVal(this.getIR().getNormVal());
        return sampledData;
    }

    void setDistData(float[] fArray) {
        this.distData = fArray;
    }

    void calculateMeasurementMetrics() {
        int n2;
        int n3;
        double d2 = this.harmFactor * Math.log(2.0);
        int n4 = (int)Math.round(d2 / this.getIR().T);
        int n5 = this.getIR().absMaxIndex;
        int n6 = n5 - n4 / 4;
        int n7 = this.getIR().getN();
        int n8 = n3 = n7 / 4;
        int n9 = n3;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = n6; n2 < n6 + n3; ++n2) {
            d3 += this.dataSq(n2);
        }
        for (n2 = n6; n2 > n6 - n8; --n2) {
            d4 += this.dataSq(n2);
        }
        for (n2 = n6 - n8; n2 > n6 - n8 - n9; --n2) {
            d5 += this.dataSq(n2);
        }
        this.noiseAndNHDdBFS = 10.0 * Math.log10(d5);
        this.distdBFS = 10.0 * Math.log10(d4);
        this.signaldBFS = 10.0 * Math.log10(d3);
        this.signalToNoisedB = this.signaldBFS - this.noiseAndNHDdBFS;
        this.signalToDistdB = this.signaldBFS - this.distdBFS;
    }

    private double dataSq(int n2) {
        float[] fArray = this.getIR().getData();
        if (n2 < 0) {
            n2 += fArray.length;
        } else if (n2 >= fArray.length) {
            n2 -= fArray.length;
        }
        return fArray[n2] * fArray[n2];
    }

    public Double getSignaldBFS() {
        return this.signaldBFS;
    }

    public Double getDistdBFS() {
        return this.distdBFS;
    }

    public Double getNoiseAndNHDdBFS() {
        return this.noiseAndNHDdBFS;
    }

    public Double getSignalToNoisedB() {
        return this.signalToNoisedB;
    }

    public Double getSignalToDistdB() {
        return this.signalToDistdB;
    }

    float[] getDistData() {
        return this.distData;
    }

    boolean hasDistData() {
        return this.distData != null;
    }

    void clearDistData() {
        this.distData = null;
    }

    void prepareForDeletion() {
        this.windowedIR = null;
        this.envelope = null;
        this.schroeder = null;
        this.ir = null;
        this.fdwData = null;
    }

    void clearTransientSampledData() {
        this.windowedIR = null;
        this.envelope = null;
        this.schroeder = null;
    }

    public WindowSettings getWindows() {
        return this.windows;
    }

    public void setWindows(WindowSettings windowSettings) {
        this.windows = windowSettings;
        this.updateWindowedIR();
    }

    void setWindows(Window.Types types, double d2, Window.Types types2, double d3, double d4) {
        this.setWindows(new WindowSettings(this.getIR(), types, d2, types2, d3, d4));
    }

    void updateWindowedIR() {
        if (this.windowedIR != null) {
            this.getIR().getOversampled();
            this.windowedIR = this.createWindowedIR();
        }
    }

    int getWinRefIndex() {
        return this.windows.getWinRefIndex();
    }

    void setFullSpanWindows(double d2) {
        int n2 = this.getIR().getN();
        double d3 = this.getIR().getT();
        double d4 = this.getIR().getStartTime();
        double d5 = Math.max(d4 + d3, Math.min(d2, d4 + (double)(n2 - 2) * d3));
        int n3 = (int)Math.max(Math.min(Math.round((d5 - d4) / d3), (long)(n2 - 1)), 0L);
        double d6 = d3 * (double)(n2 - 1 - n3);
        double d7 = d3 * (double)n3;
        this.setWindows(new WindowSettings(this.getIR(), Window.Types.RECTANGULAR, d7, Window.Types.RECTANGULAR, d6, d5));
    }

    public void setFdwEnabledAndRemoveFDWIfFalse(boolean bl) {
        if (this.fdwEnabled != bl) {
            this.fdwEnabled = bl;
            if (!bl) {
                this.fdwData = null;
                this.updateWindowedIR();
            }
        }
    }

    public void setFdwAsCycles(boolean bl) {
        this.fdwAsCycles = bl;
    }

    public void setFdwWidth(double d2) {
        this.fdwWidth = d2;
    }

    public boolean fdwEnabled() {
        return this.fdwEnabled;
    }

    public boolean isFdwAsCycles() {
        return this.fdwAsCycles;
    }

    boolean hasFDWData() {
        return this.fdwData != null;
    }

    public double getFdwWidth() {
        return this.fdwWidth;
    }

    void setFDWData(float[] fArray) {
        int n2 = this.windows.getWindowedSpan();
        this.fdwData = new float[n2];
        System.arraycopy(fArray, 0, this.fdwData, 0, n2);
        this.updateWindowedIR();
    }

    boolean hasEnvelope() {
        return this.envelope != null;
    }

    boolean hasSchroeder() {
        return this.schroeder != null;
    }

    float[] getWindowedData() {
        float[] fArray;
        if (this.fdwEnabled()) {
            fArray = new float[this.fdwData.length];
            System.arraycopy(this.fdwData, 0, fArray, 0, this.fdwData.length);
        } else {
            fArray = this.windows.apply(this.getIR().getData());
        }
        return fArray;
    }

    void setIRData(float[] fArray) {
        assert (fArray.length == this.ir.n) : "Attempt to assign different data length, " + this.ir.n;
        this.harmFactor = 0.0;
        System.arraycopy(fArray, 0, this.ir.data, 0, this.ir.n);
        this.ir.maxScan();
        this.ir.resetNormVal();
        this.dataChanged();
    }

    void scaleData(float f2) {
        float[] fArray = this.getIR().getData();
        int n2 = 0;
        while (n2 < fArray.length) {
            int n3 = n2++;
            fArray[n3] = fArray[n3] * f2;
        }
        this.getIR().maxScan();
        this.getIR().resetNormVal();
        this.dataChanged();
    }

    protected void dataChanged() {
        this.getIR().dataChanged();
        this.updateWindowedIR();
    }

    void discardAfter(int n2) {
        SampledData sampledData = this.getIR();
        sampledData.shorten(n2);
        double d2 = 1.0 / ((double)sampledData.n * sampledData.T);
        this.endFreq = d2 * (double)Math.round(this.endFreq / d2);
        this.startFreq = d2 * (double)Math.max(Math.round(this.startFreq / d2), 1L);
    }

    void trimToWindow() {
        int n2 = this.windows.getWindowedSpan();
        int n3 = this.windows.getPreImpulseIndex();
        int n4 = lH.B(n2);
        SampledData sampledData = this.getIR();
        int n5 = Math.min(n3 + n4, sampledData.n);
        int n6 = n5 - n4;
        sampledData.trimTo(n6, n5);
        if (this.refPeakIndex != null) {
            this.refPeakIndex = this.refPeakIndex - (double)n6;
        }
        this.setWindows(new WindowSettings(sampledData, this.windows.getPreWindowType(), this.windows.getPreImpulseDurn(), this.windows.getPostWindowType(), this.windows.getPostImpulseDurn(), this.windows.getWinRefTime()));
        this.updateWindowedIR();
    }

    double peakTime() {
        return this.getIR().getPeakTime();
    }

    double windowedDataVal(int n2) {
        double d2 = this.fdwEnabled() ? this.fdwData(n2) : this.windowedData(n2);
        return d2;
    }

    private double fdwData(int n2) {
        if (n2 < this.windows.getPreImpulseIndex() || n2 > this.windows.getPostImpulseIndex()) {
            return 0.0;
        }
        return this.fdwData[n2 - this.windows.getPreImpulseIndex()];
    }

    double windowedData(int n2) {
        return this.windows.windowedData(this.getIR().getData(), n2);
    }

    double windowedData(int n2, WindowSettings windowSettings) {
        return windowSettings.windowedData(this.getIR().getData(), n2);
    }

    double windowAmpl(double d2) {
        return this.windows.windowAmpl(d2);
    }

    void calcEnvelope() {
        SampledData sampledData = this.getIR();
        this.envelope = new SampledData(sampledData.data.length, sampledData.T, SweepAnalyser.B(sampledData.data), sampledData.startTime, SampledData.getENVELOPE_OVERSAMPLE());
    }

    RT60 rt60Val(float f2, int n2) {
        if (n2 == 1 && this.octRT60Result != null) {
            if ((double)f2 < XD.D[0] || (double)f2 > XD.D[XD.D.length - 1]) {
                return new RT60();
            }
            int n3 = Arrays.binarySearch(XD.D, (double)f2);
            if (n3 < 0 && (n3 = -n3 - 2) < 0) {
                n3 = 0;
            }
            if (this.octRT60Result[n3] != null) {
                return this.octRT60Result[n3];
            }
            return new RT60();
        }
        if (n2 == 3 && this.thirdOctRT60Result != null) {
            if ((double)f2 < XD.C[0] || (double)f2 > XD.C[XD.C.length - 1]) {
                return new RT60();
            }
            int n4 = Arrays.binarySearch(XD.C, (double)f2);
            if (n4 < 0 && (n4 = -n4 - 2) < 0) {
                n4 = 0;
            }
            if (this.thirdOctRT60Result[n4] != null) {
                return this.thirdOctRT60Result[n4];
            }
            return new RT60();
        }
        return new RT60();
    }

    void calcSchroeder() {
        int n2 = this.findImpulseStart();
        boolean bl = true;
        SampledData sampledData = this.getIR();
        float[] fArray = XD.A(sampledData.data, null, n2, 10, bl, sampledData.T, this.getFilterFc(), this.getOctaveFrac(), this.unfiltRT60Result);
        fArray[0] = 0.0f;
        double d2 = sampledData.startTime + (double)n2 * sampledData.T;
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = (float)Math.pow(10.0, fArray[i2] / 10.0f);
        }
        this.schroeder = new SampledData(fArray2.length, sampledData.T, fArray2, d2, SampledData.getSCHROEDER_OVERSAMPLE());
    }

    RT60 calcSchroederAndRT60() {
        int n2 = this.findImpulseStart();
        boolean bl = true;
        SampledData sampledData = this.getIR();
        float[] fArray = XD.A(sampledData.data, null, n2, 10, bl, sampledData.T, this.getFilterFc(), this.getOctaveFrac(), this.unfiltRT60Result);
        float f2 = fArray[0];
        fArray[0] = 0.0f;
        double d2 = sampledData.startTime + (double)n2 * sampledData.T;
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = (float)Math.pow(10.0, fArray[i2] / 10.0f);
        }
        this.schroeder = new SampledData(fArray2.length, sampledData.T, fArray2, d2, SampledData.getSCHROEDER_OVERSAMPLE());
        RT60 rT60 = XD.A(fArray, sampledData.T, d2);
        rT60.Fc = this.getFilterFc();
        rT60.octaveFrac = this.getOctaveFrac();
        rT60.order = this.getFilterOrder();
        rT60.reverseFiltered = this.isReverseFiltered();
        rT60.zeroPhaseFiltered = this.isZeroPhaseFiltered();
        rT60.TS = f2;
        double d3 = XD.A(sampledData.getUnfilteredData(), n2, fArray.length, 0.05, sampledData.T, sampledData.getFiltSettings());
        double d4 = XD.A(sampledData.getUnfilteredData(), n2, fArray.length, 0.08, sampledData.T, sampledData.getFiltSettings());
        rT60.C50 = 10.0 * Math.log10(d3);
        rT60.C80 = 10.0 * Math.log10(d4);
        rT60.D50 = 100.0 * d3 / (1.0 + d3);
        double d5 = this.schroeder.T * (double)this.schroeder.n;
        double d6 = 0.001;
        int n3 = (int)(d5 / d6);
        float[] fArray3 = new float[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            fArray3[i3] = 10.0f * (float)Math.log10(this.schroeder.value(this.schroeder.startTime + (double)i3 * d6));
        }
        rT60.decayCurve = fArray3;
        rT60.decayCurveStartTime = d2;
        rT60.timeStep = d6;
        return rT60;
    }

    int findImpulseStart() {
        int n2;
        SampledData sampledData = this.getIR();
        double d2 = 0.1;
        if (this.getFilterFc() <= 0.0) {
            this.unfiltIRStartIndex = null;
        } else if (this.unfiltIRStartIndex != null && !this.isReverseFiltered()) {
            return this.unfiltIRStartIndex;
        }
        if (this.envelope == null || this.getFilterFc() > 0.0) {
            this.calcEnvelope();
        }
        float f2 = (float)this.envelope.getAbsMaxVal();
        int n3 = this.envelope.getAbsMaxIndex();
        if (this.harmFactor > 0.0) {
            double d3 = Math.log(2.0) * this.harmFactor;
            n2 = Math.max(n3 - (int)Math.round(d3 / 3.0 / sampledData.T), 0);
        } else {
            n2 = Math.max(n3 - (int)Math.round(0.15 / sampledData.T), 0);
        }
        if (n2 < 1) {
            n2 = 1;
        }
        boolean bl = false;
        int n4 = n3;
        boolean bl2 = false;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!bl2 && (double)Math.abs(sampledData.data[i2] / sampledData.absMaxVal) > 0.02) {
                bl2 = true;
            }
            if (!((double)(this.envelope.getData()[i2] / f2) > 0.1) || !bl2) continue;
            n4 = i2 - 1;
            break;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        if (this.getFilterFc() == 0.0) {
            float f3 = this.envelope.getData()[n4 - 1];
            float f4 = this.envelope.getData()[n4];
            float f5 = sampledData.data[n4 - 1];
            float f6 = sampledData.data[n4];
            while (f3 < f4 && n4 > n2 && f5 * f6 > 0.0f && (double)Math.abs(f6 / sampledData.absMaxVal) > 0.01 && Math.abs(f5) < Math.abs(f6)) {
                f4 = f3;
                f3 = this.envelope.getData()[--n4 - 1];
                f6 = f5;
                f5 = sampledData.data[n4 - 1];
            }
            this.unfiltIRStartIndex = n4;
        }
        return n4;
    }

    boolean invalidRT60(int n2, boolean bl, boolean bl2, int n3) {
        switch (n2) {
            case 1: {
                return this.octRT60Result == null || this.octRT60Result[0] == null || this.octRT60Result[0].filterDirectionDifferent(bl) || this.octRT60Result[0].filterPhaseDifferent(bl2) || this.octRT60Result[0].filterOrderDifferent(n3) || !RT60.hasClarity(this.octRT60Result);
            }
            case 3: {
                return this.thirdOctRT60Result == null || this.thirdOctRT60Result[0] == null || this.thirdOctRT60Result[0].filterDirectionDifferent(bl) || this.thirdOctRT60Result[0].filterPhaseDifferent(bl2) || this.thirdOctRT60Result[0].filterOrderDifferent(n3) || !RT60.hasClarity(this.thirdOctRT60Result);
            }
        }
        return true;
    }

    boolean invalidIndRT60(Double d2, int n2, boolean bl, boolean bl2, int n3) {
        boolean bl3 = d2 != null ? this.getFilterFc() != d2.doubleValue() : this.getFilterFc() != 0.0;
        boolean bl4 = n2 != this.getOctaveFrac();
        return this.indRT60Result == null || bl3 || bl4 || this.indRT60Result.filterDirectionDifferent(bl) || this.indRT60Result.filterPhaseDifferent(bl2) || this.indRT60Result.filterOrderDifferent(n3);
    }

    boolean applyOctaveFilter(OctaveFilterSettings octaveFilterSettings, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.getFilterFc() == 0.0 && this.unfiltIRStartIndex == null) {
            this.findImpulseStart();
        }
        if (bl3 = this.ir.octaveFilter(octaveFilterSettings, bl2)) {
            if (!bl2) {
                this.updateWindowedIR();
            }
            if (!(this.envelope == null || bl && octaveFilterSettings.filterFc != 0.0)) {
                double d2 = this.envelope.getSmoothTC();
                this.calcEnvelope();
                if (d2 > 0.0) {
                    this.envelope.smooth(d2);
                }
            }
            if (this.schroeder != null && !bl && !bl2) {
                this.calcSchroederAndRT60();
            }
        }
        return bl3;
    }

    void smoothEnvelope(double d2) {
        if (this.envelope != null) {
            this.envelope.smooth(d2);
        }
    }

    void clockRateAdjust(double d2) {
        if (d2 == 0.0) {
            return;
        }
        SampledData sampledData = this.getIR();
        float[] fArray = sampledData.getData();
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        double d3 = sampledData.getT();
        int n2 = sampledData.getN();
        DoubleFFT_1D doubleFFT_1D = SweepAnalyser.A(n2);
        doubleFFT_1D.realForward(dArray);
        if (this.nyqMagn == null) {
            this.nyqMagn = dArray[1];
            this.nyqPhase = 0.0;
        }
        double d4 = Math.PI / ((double)n2 * d3);
        double d5 = d4 / (0.25 / (Math.PI * d3));
        double d6 = -d2 * 0.685;
        for (int i3 = 2; i3 < n2; i3 += 2) {
            double d7 = d6 + d2 * Math.log10((double)i3 * d5);
            double d8 = d7 * (double)i3 * d4;
            double d9 = Math.cos(d8);
            double d10 = Math.sin(d8);
            double d11 = dArray[i3];
            double d12 = dArray[i3 + 1];
            dArray[i3] = d11 * d9 - d12 * d10;
            dArray[i3 + 1] = d11 * d10 + d12 * d9;
        }
        double d13 = d6 + d2 * Math.log10((double)n2 * d5);
        this.nyqPhase += d13 * Math.PI / d3;
        if (this.nyqPhase < -Math.PI) {
            this.nyqPhase += Math.PI * 2;
        } else if (this.nyqPhase > Math.PI) {
            this.nyqPhase -= Math.PI * 2;
        }
        dArray[1] = this.nyqMagn * Math.cos(this.nyqPhase);
        doubleFFT_1D.realInverse(dArray, true);
        for (int i4 = 0; i4 < fArray.length; ++i4) {
            fArray[i4] = (float)dArray[i4];
        }
        sampledData.maxScan();
        sampledData.resetNormVal();
        if (this.unfiltIRStartIndex != null) {
            this.unfiltIRStartIndex = null;
            this.findImpulseStart();
        }
        this.indRT60Result = null;
        this.schroeder = null;
        this.envelope = null;
        if (this.windows != null) {
            this.windows.setWinRefTime(this.peakTime());
        }
        this.dataChanged();
    }

    void offsetIRStartTemporary(double d2) {
        SampledData sampledData = this.getIR();
        if (d2 == 0.0) {
            return;
        }
        double d3 = d2;
        FloatFFT_1D floatFFT_1D = SweepAnalyser.B(sampledData.n);
        floatFFT_1D.realForward(sampledData.data);
        double d4 = Math.PI / ((double)sampledData.n * sampledData.T);
        for (int i2 = 2; i2 < sampledData.n; i2 += 2) {
            double d5 = d3 * (double)i2 * d4;
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            double d8 = sampledData.data[i2];
            double d9 = sampledData.data[i2 + 1];
            sampledData.data[i2] = (float)(d8 * d6 - d9 * d7);
            sampledData.data[i2 + 1] = (float)(d8 * d7 + d9 * d6);
        }
        sampledData.data[1] = (float)((double)sampledData.data[1] * Math.cos(d3 * Math.PI / sampledData.T));
        floatFFT_1D.realInverse(sampledData.data, true);
    }

    void adjustStartToInterpolatedPeak() {
        SampledData sampledData = this.getIR();
        double d2 = sampledData.getAbsMaxInterpIndex() - (double)sampledData.absMaxIndex + 1.0;
        this.offsetIRStart(d2 * sampledData.T);
    }

    void offsetIRStart(double d2) {
        this.offsetIRStart(d2, false, false);
    }

    void offsetIRStartAndZeroWinRef(double d2) {
        this.offsetIRStart(d2, false, true);
    }

    void offsetIRStartAndWinRef(double d2) {
        this.offsetIRStart(d2, true, false);
    }

    void offsetIRStartAndWinRef(int n2) {
        this.offsetIRStart(n2, true);
    }

    private void offsetIRStart(int n2, boolean bl) {
        SampledData sampledData = this.getIR();
        if (n2 == 0) {
            return;
        }
        this.cumulativeStartTimeOffset += (double)n2 * sampledData.T;
        double d2 = (double)(-n2) * sampledData.T;
        double d3 = sampledData.startTime + d2;
        sampledData.setStartTime(d3);
        if (this.windows != null) {
            this.windows.setStartTime(d3);
            if (bl) {
                this.windows.setWinRefTime(this.windows.getWinRefTime() + d2);
            }
            this.updateWindowedIR();
        }
    }

    void offsetIRStart(double d2, boolean bl, boolean bl2) {
        if (d2 == 0.0) {
            return;
        }
        this.offsetIRStartNoResample(d2, bl, bl2);
    }

    private void offsetIRStartWithResample(double d2, boolean bl, boolean bl2) {
        int n2;
        SampledData sampledData = this.getIR();
        float[] fArray = sampledData.getData();
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        double d3 = sampledData.getT();
        int n3 = sampledData.getN();
        int n4 = (int)Math.round(d2 / d3);
        this.offsetIRStart(n4, bl);
        double d4 = d2 - (double)n4 * d3;
        this.cumulativeStartTimeOffset += d4;
        DoubleFFT_1D doubleFFT_1D = SweepAnalyser.A(n3);
        doubleFFT_1D.realForward(dArray);
        if (this.nyqMagn == null) {
            this.nyqMagn = dArray[1];
            this.nyqPhase = 0.0;
        }
        double d5 = Math.PI / ((double)n3 * d3);
        for (n2 = 2; n2 < n3; n2 += 2) {
            double d6 = d4 * (double)n2 * d5;
            double d7 = Math.cos(d6);
            double d8 = Math.sin(d6);
            double d9 = dArray[n2];
            double d10 = dArray[n2 + 1];
            dArray[n2] = d9 * d7 - d10 * d8;
            dArray[n2 + 1] = d9 * d8 + d10 * d7;
        }
        this.nyqPhase += d4 * Math.PI / d3;
        if (this.nyqPhase < -Math.PI) {
            this.nyqPhase += Math.PI * 2;
        } else if (this.nyqPhase > Math.PI) {
            this.nyqPhase -= Math.PI * 2;
        }
        dArray[1] = this.nyqMagn * Math.cos(this.nyqPhase);
        doubleFFT_1D.realInverse(dArray, true);
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray[n2] = (float)dArray[n2];
        }
        n2 = 16;
        int n5 = Math.max(sampledData.absMaxIndex - n2, 0);
        int n6 = Math.min(sampledData.absMaxIndex + n2, sampledData.n);
        sampledData.maxScan(n5, n6);
        sampledData.resetNormVal();
        if (this.windows != null) {
            if (bl) {
                this.windows.setWinRefTime(this.windows.getWinRefTime() - d4);
            } else if (bl2) {
                this.windows.setWinRefTime(0.0);
            }
        }
        if (this.unfiltIRStartIndex != null) {
            this.unfiltIRStartIndex = null;
            this.findImpulseStart();
        }
        this.dataChanged();
    }

    void alignZeroToSample() {
        int n2;
        SampledData sampledData = this.getIR();
        float[] fArray = sampledData.getData();
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        double d2 = sampledData.getT();
        int n3 = sampledData.getN();
        double d3 = -sampledData.getStartTime() / d2;
        double d4 = (d3 - (double)(n2 = (int)Math.round(d3))) * d2;
        if (Math.abs(d4 / d2) > 0.001) {
            int n4;
            if (this.refPeakIndex != null) {
                this.refPeakIndex = this.refPeakIndex - d4 / d2;
            }
            double d5 = sampledData.startTime + d4;
            sampledData.setStartTime(d5);
            DoubleFFT_1D doubleFFT_1D = SweepAnalyser.A(n3);
            doubleFFT_1D.realForward(dArray);
            if (this.nyqMagn == null) {
                this.nyqMagn = dArray[1];
                this.nyqPhase = 0.0;
            }
            double d6 = Math.PI / ((double)n3 * d2);
            for (n4 = 2; n4 < n3; n4 += 2) {
                double d7 = d4 * (double)n4 * d6;
                double d8 = Math.cos(d7);
                double d9 = Math.sin(d7);
                double d10 = dArray[n4];
                double d11 = dArray[n4 + 1];
                dArray[n4] = d10 * d8 - d11 * d9;
                dArray[n4 + 1] = d10 * d9 + d11 * d8;
            }
            this.nyqPhase += d4 * Math.PI / d2;
            if (this.nyqPhase < -Math.PI) {
                this.nyqPhase += Math.PI * 2;
            } else if (this.nyqPhase > Math.PI) {
                this.nyqPhase -= Math.PI * 2;
            }
            dArray[1] = this.nyqMagn * Math.cos(this.nyqPhase);
            doubleFFT_1D.realInverse(dArray, true);
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = (float)dArray[n4];
            }
            n4 = 16;
            int n5 = Math.max(sampledData.absMaxIndex - n4, 0);
            int n6 = Math.min(sampledData.absMaxIndex + n4, sampledData.n);
            sampledData.maxScan(n5, n6);
            sampledData.resetNormVal();
            if (this.unfiltIRStartIndex != null) {
                this.unfiltIRStartIndex = null;
                this.findImpulseStart();
            }
            this.dataChanged();
        }
    }

    private void offsetIRStartNoResample(double d2, boolean bl, boolean bl2) {
        SampledData sampledData = this.getIR();
        if (d2 == 0.0) {
            return;
        }
        double d3 = -d2;
        this.cumulativeStartTimeOffset -= d3;
        double d4 = sampledData.startTime;
        double d5 = sampledData.startTime + d3;
        sampledData.setStartTime(d5);
        if (lG.\u0292()) {
            this.alignZeroToSample();
        }
        if (this.windows != null) {
            this.windows.setStartTime(sampledData.startTime);
            if (bl) {
                this.windows.setWinRefTime(this.windows.getWinRefTime() + sampledData.startTime - d4);
            } else if (bl2) {
                this.windows.setWinRefTime(0.0);
            }
            this.updateWindowedIR();
        }
    }

    Boolean getInvertImpulse() {
        return this.invertImpulse;
    }

    void setInvertImpulse(Boolean bl) {
        if (!this.invertImpulse.equals(bl)) {
            for (int i2 = 0; i2 < this.ir.data.length; ++i2) {
                this.ir.data[i2] = -this.ir.data[i2];
            }
            this.invertImpulse = bl;
            this.dataChanged();
        }
    }

    double fWindowMin() {
        SampledData sampledData = this.getIR();
        double d2 = 1.0 / (sampledData.T * (double)sampledData.n);
        double d3 = lG.\u01c0() ? this.windows.getPostImpulseDurn() : this.windows.getWindowedDurn();
        return Math.min(d2 * Math.ceil(1.0 / d3 / d2), this.endFreq - d2);
    }

    double getFilterFc() {
        SampledData sampledData = this.getIR();
        if (sampledData != null) {
            return sampledData.getFiltSettings().filterFc;
        }
        return 0.0;
    }

    int getOctaveFrac() {
        return this.getIR().getFiltSettings().octaveFrac;
    }

    int getFilterOrder() {
        return this.getIR().getFiltSettings().order;
    }

    boolean isFractionalOctaveFiltered() {
        return this.getFilterFc() > 0.0;
    }

    boolean isReverseFiltered() {
        return this.getIR().getFiltSettings().timeReversedFilters;
    }

    boolean isZeroPhaseFiltered() {
        return this.getIR().getFiltSettings().zeroPhaseFilters;
    }
}

