/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import roomeqwizard.OA;
import roomeqwizard.wA;

public class HelpsetExternalLinkLauncher
extends JButton
implements ActionListener,
ViewAwareComponent {
    private static final Cursor handCursor = Cursor.getPredefinedCursor(12);
    private Cursor origCursor;
    private View myView;
    private SimpleAttributeSet textAttribs;
    private HTMLDocument doc;
    private String content = "";

    public HelpsetExternalLinkLauncher() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setFont(OA.P());
        this.createLinkLabel();
        this.addActionListener(this);
        this.origCursor = this.getCursor();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                HelpsetExternalLinkLauncher.this.setCursor(handCursor);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                HelpsetExternalLinkLauncher.this.setCursor(HelpsetExternalLinkLauncher.this.origCursor);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    @Override
    public void setText(String string) {
        super.setText(string);
    }

    @Override
    public void setViewData(View view) {
        this.myView = view;
        this.doc = (HTMLDocument)this.myView.getDocument();
        Font font = this.getFont();
        this.textAttribs = new SimpleAttributeSet();
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, font.getName());
        this.textAttribs.addAttribute(StyleConstants.FontSize, font.getSize());
        this.textAttribs.addAttribute(StyleConstants.Bold, font.isBold());
        this.textAttribs.addAttribute(StyleConstants.Italic, font.isItalic());
    }

    public void setContent(String string) {
        this.content = string;
    }

    public String getContent() {
        return this.content;
    }

    private void createLinkLabel() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setAlignmentY(this.getPreferredLabelAlignment());
        this.setContentAreaFilled(false);
        this.setHorizontalAlignment(2);
        this.setBackground(wA.A("EditorPane.background"));
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(wA.A(6));
        }
        this.setBlueUnderlinedFont(true);
        this.invalidate();
    }

    private void setBlueUnderlinedFont(boolean bl) {
        Map<TextAttribute, ?> map = this.getFont().getAttributes();
        if (bl) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            map.put(TextAttribute.FOREGROUND, new Color(4224704));
        } else {
            map.remove(TextAttribute.UNDERLINE);
            map.remove(TextAttribute.FOREGROUND);
        }
        Font font = new Font(map);
        this.setFont(font);
    }

    private float getPreferredLabelAlignment() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        Insets insets = this.getInsets();
        if ((n2 += insets.top + insets.bottom) % 2 == 0) {
            ++n2;
        }
        float f2 = fontMetrics.getAscent() + insets.top + 1;
        return f2 / (float)n2;
    }

    public void setTextFontFamily(String string) {
        this.textAttribs.removeAttribute(StyleConstants.FontFamily);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, string);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
    }

    public String getTextFontFamily() {
        return StyleConstants.getFontFamily(this.textAttribs);
    }

    public void setTextFontSize(String string) {
        int n2;
        StyleSheet styleSheet = this.doc.getStyleSheet();
        try {
            if (string.equals("xx-small")) {
                n2 = (int)styleSheet.getPointSize(0);
            } else if (string.equals("x-small")) {
                n2 = (int)styleSheet.getPointSize(1);
            } else if (string.equals("small")) {
                n2 = (int)styleSheet.getPointSize(2);
            } else if (string.equals("medium")) {
                n2 = (int)styleSheet.getPointSize(3);
            } else if (string.equals("large")) {
                n2 = (int)styleSheet.getPointSize(4);
            } else if (string.equals("x-large")) {
                n2 = (int)styleSheet.getPointSize(5);
            } else if (string.equals("xx-large")) {
                n2 = (int)styleSheet.getPointSize(6);
            } else if (string.equals("bigger")) {
                n2 = (int)styleSheet.getPointSize("+1");
            } else if (string.equals("smaller")) {
                n2 = (int)styleSheet.getPointSize("-1");
            } else if (string.endsWith("pt")) {
                String string2 = string.substring(0, string.length() - 2);
                n2 = Integer.parseInt(string2);
            } else {
                n2 = (int)styleSheet.getPointSize(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.addAttribute(StyleConstants.FontSize, n2);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
    }

    public String getTextFontSize() {
        return Integer.toString(StyleConstants.getFontSize(this.textAttribs));
    }

    public void setTextFontWeight(String string) {
        boolean bl = string.compareTo("bold") == 0;
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.addAttribute(StyleConstants.Bold, bl);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
    }

    public String getTextFontWeight() {
        if (StyleConstants.isBold(this.textAttribs)) {
            return "bold";
        }
        return "plain";
    }

    public void setTextFontStyle(String string) {
        boolean bl = string.compareTo("italic") == 0;
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.Italic, bl);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
    }

    public String getTextFontStyle() {
        if (StyleConstants.isItalic(this.textAttribs)) {
            return "italic";
        }
        return "plain";
    }

    public void setTextColor(String string) {
        Color color = null;
        if (string.equalsIgnoreCase("black")) {
            color = Color.black;
        } else if (string.equalsIgnoreCase("blue")) {
            color = Color.blue;
        } else if (string.equalsIgnoreCase("cyan")) {
            color = Color.cyan;
        } else if (string.equalsIgnoreCase("darkGray")) {
            color = Color.darkGray;
        } else if (string.equalsIgnoreCase("gray")) {
            color = Color.gray;
        } else if (string.equalsIgnoreCase("green")) {
            color = Color.green;
        } else if (string.equalsIgnoreCase("lightGray")) {
            color = Color.lightGray;
        } else if (string.equalsIgnoreCase("magenta")) {
            color = Color.magenta;
        } else if (string.equalsIgnoreCase("orange")) {
            color = Color.orange;
        } else if (string.equalsIgnoreCase("pink")) {
            color = Color.pink;
        } else if (string.equalsIgnoreCase("red")) {
            color = Color.red;
        } else if (string.equalsIgnoreCase("white")) {
            color = Color.white;
        } else if (string.equalsIgnoreCase("yellow")) {
            color = Color.yellow;
        }
        if (color == null) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.Foreground);
        this.textAttribs.addAttribute(StyleConstants.Foreground, color);
        this.setForeground(color);
    }

    public String getTextColor() {
        Color color = this.getForeground();
        return color.toString();
    }

    private Font getAttributeSetFont(AttributeSet attributeSet) {
        int n2 = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n2 |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n2 |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n3 = StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            n3 -= 2;
        }
        return this.doc.getStyleSheet().getFont(string, n2, n3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            URL uRL = new URL(this.content);
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(uRL.toURI());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }
}

