/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.$B;

final class HarmDistReadouts
extends Enum<HarmDistReadouts> {
    public static final /* enum */ HarmDistReadouts ASYAXIS = new HarmDistReadouts($B.Y);
    public static final /* enum */ HarmDistReadouts DBREL = new HarmDistReadouts($B.s);
    public static final /* enum */ HarmDistReadouts PERCENT = new HarmDistReadouts($B._);
    private $B yAxisType;
    private static final /* synthetic */ HarmDistReadouts[] $VALUES;

    public static HarmDistReadouts[] values() {
        return (HarmDistReadouts[])$VALUES.clone();
    }

    public static HarmDistReadouts valueOf(String string) {
        return Enum.valueOf(HarmDistReadouts.class, string);
    }

    private HarmDistReadouts($B $B) {
        this.yAxisType = $B;
    }

    void setYAxisType($B $B) {
        this.yAxisType = $B;
    }

    $B getEffectiveYAxisType() {
        switch (this) {
            case ASYAXIS: {
                return this.yAxisType;
            }
            case DBREL: {
                return $B.s;
            }
            case PERCENT: {
                return $B._;
            }
        }
        assert (false) : "Unhandled distortion readout in toString";
        return this.yAxisType;
    }

    public String toString() {
        switch (this) {
            case ASYAXIS: {
                return "As Y axis";
            }
            case DBREL: {
                return "dB relative";
            }
            case PERCENT: {
                return "Percent";
            }
        }
        assert (false) : "Unhandled distortion readout in toString";
        return "???";
    }

    public static HarmDistReadouts getEnum(String string) {
        for (HarmDistReadouts harmDistReadouts : HarmDistReadouts.values()) {
            if (!harmDistReadouts.name().equalsIgnoreCase(string)) continue;
            return harmDistReadouts;
        }
        return ASYAXIS;
    }

    boolean isRelative() {
        return this.getEffectiveYAxisType().T();
    }

    float distortionFigure(float f2, float f3) {
        switch (this) {
            case ASYAXIS: {
                if (this.yAxisType.T()) {
                    return (float)this.yAxisType.J(f2 - f3);
                }
                return (float)this.yAxisType.J(f2);
            }
            case DBREL: {
                return f2 - f3;
            }
            case PERCENT: {
                return f2 == 0.0f ? 0.0f : (float)Math.pow(10.0, (f2 - f3) / 20.0f) * 100.0f;
            }
        }
        assert (false) : "Unhandled distortion readout in distortionFigure";
        return 0.0f;
    }

    String units() {
        return this.getEffectiveYAxisType().U();
    }

    String format(float f2) {
        return this.getEffectiveYAxisType().C(f2);
    }

    String formatForExport(float f2) {
        return this.getEffectiveYAxisType().I(f2);
    }

    String formatForExportLinearAsSci(float f2) {
        return this.getEffectiveYAxisType().H(f2);
    }

    static {
        $VALUES = new HarmDistReadouts[]{ASYAXIS, DBREL, PERCENT};
    }
}

