/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.HE;
import roomeqwizard.api.API;

public enum FourToneSignal {
    QUAD_AKL("Klingelnberg (19, 9.4, 18, 20 kHz)", "Quad_19k_9k4_18k_20k", "Klingelnberg", 18941.0, 9443.0, 17929.0, 19864.0),
    CUSTOM("Custom", "Quad_19k_9k4_18k_20k", "Custom", 18941.0, 9443.0, 17929.0, 19864.0);

    private final String description;
    private String shortDescription;
    private String typeDescription;
    private double f1;
    private double f2;
    private double f3;
    private double f4;

    private FourToneSignal(String string2, String string3, String string4, double d2, double d3, double d4, double d5) {
        this.description = string2;
        this.shortDescription = string3;
        this.typeDescription = string4;
        this.f1 = d2;
        this.f2 = d3;
        this.f3 = d4;
        this.f4 = d5;
    }

    public String description() {
        return this.description;
    }

    public String shortDescription() {
        return this.shortDescription;
    }

    public String apiName() {
        return API.toKebabCase(this.typeDescription);
    }

    public double getF1() {
        return this.f1;
    }

    public double getF2() {
        return this.f2;
    }

    public double getF3() {
        return this.f3;
    }

    public double getF4() {
        return this.f4;
    }

    public void setF1(double d2) {
        this.f1 = d2;
        this.updateShortDesc();
    }

    public void setF2(double d2) {
        this.f2 = d2;
        this.updateShortDesc();
    }

    public void setF3(double d2) {
        this.f3 = d2;
        this.updateShortDesc();
    }

    public void setF4(double d2) {
        this.f4 = d2;
        this.updateShortDesc();
    }

    private void updateShortDesc() {
        this.shortDescription = "Quad_" + HE.H.format(this.f1) + "_" + HE.H.format(this.f2) + "_" + HE.H.format(this.f3) + "_" + HE.H.format(this.f4);
    }

    public static FourToneSignal getEnum(String string) {
        for (FourToneSignal fourToneSignal : FourToneSignal.values()) {
            if (!fourToneSignal.name().equalsIgnoreCase(string)) continue;
            return fourToneSignal;
        }
        return QUAD_AKL;
    }

    public static FourToneSignal getFromApiName(String string) {
        for (FourToneSignal fourToneSignal : FourToneSignal.values()) {
            if (!fourToneSignal.apiName().equalsIgnoreCase(string)) continue;
            return fourToneSignal;
        }
        return null;
    }
}

