/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;
import roomeqwizard.AE;
import roomeqwizard.ED;
import roomeqwizard.EK;
import roomeqwizard.Equaliser;
import roomeqwizard.Filter;
import roomeqwizard.FilterGroup;
import roomeqwizard.FilterResponse;
import roomeqwizard.GF;
import roomeqwizard.MeasData;
import roomeqwizard.NoiseSelection;
import roomeqwizard.UK;
import roomeqwizard.XOverChoice;
import roomeqwizard.XOverFilter;
import roomeqwizard.XOverShape;
import roomeqwizard.XOverSlope;
import roomeqwizard.api.model.FilterSetting;
import roomeqwizard.api.model.Result;
import roomeqwizard.jG;
import roomeqwizard.qK;
import roomeqwizard.wA;

public class FilterSet
implements Serializable,
PropertyChangeListener {
    static final long serialVersionUID = 1122334455L;
    static final String FILTERS_UPDATE = "FilterSet.filtersUpdate";
    static final String FILTER_SET_UPDATE = "FilterSet.filterSetUpdate";
    private static final int XOVER_OFFSET = 100;
    private Filter[] filters;
    private XOverFilter[] xOverFilters;
    private int hiddenFilters;
    private transient SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    private transient ArrayList<Integer> activeFilterNumbers;
    private transient jG state;
    private static final Color[] filterColorsDefault = wA.\u00c5();

    static boolean isRegularFilter(int n2) {
        return n2 < 100;
    }

    static int getXOverIndex(int n2) {
        return n2 - 100;
    }

    static void updateDefaultColors() {
        wA.A(filterColorsDefault);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl = false;
        for (PropertyChangeListener propertyChangeListener2 : this.pcs.getPropertyChangeListeners()) {
            if (!propertyChangeListener2.equals(propertyChangeListener)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removeAllPropertyChangeListeners() {
        for (PropertyChangeListener propertyChangeListener : this.pcs.getPropertyChangeListeners()) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    FilterSet(Equaliser equaliser, MeasData measData) {
        this(equaliser.getTotalFilters(), equaliser.getFiltSampleRate(measData));
        int n2;
        this.hiddenFilters = equaliser.getHiddenFilters();
        for (n2 = this.filters.length - this.hiddenFilters; n2 < this.filters.length; ++n2) {
            this.filters[n2].setAutomatic(false);
        }
        for (n2 = 0; n2 < this.filters.length; ++n2) {
            this.filters[n2].setFilterType(equaliser.getDefaultFilterType(n2));
            this.filters[n2].setColor(FilterSet.getDefaultFilterColor(n2));
            this.filters[n2].addPropertyChangeListener(this);
        }
        if (equaliser.getNumXOverFilters() > 0) {
            this.initXOverFilters(equaliser, measData);
        } else {
            this.xOverFilters = null;
        }
    }

    FilterSet(int n2, double d2) {
        this.filters = new Filter[n2];
        for (int i2 = 0; i2 < this.filters.length; ++i2) {
            this.setFilter(i2, new Filter(d2));
            this.filters[i2].setColor(FilterSet.getDefaultFilterColor(i2));
        }
        this.hiddenFilters = 0;
    }

    FilterSet(Filter[] filterArray) {
        this.filters = filterArray;
        this.hiddenFilters = 0;
        for (int i2 = 0; i2 < filterArray.length; ++i2) {
            if (filterArray[i2] == null || !XOverFilter.isXOverFilter(filterArray[i2])) continue;
            int n2 = (filterArray.length - i2) / 4;
            this.xOverFilters = new XOverFilter[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                int n3 = i2 + i3 * 4;
                this.xOverFilters[i3] = new XOverFilter(filterArray, n3);
                this.xOverFilters[i3].copyXOverFilterSettings(filterArray[n3]);
            }
            break;
        }
    }

    static FilterSet CTA2034Set(double d2) {
        FilterSet filterSet = new FilterSet(3, d2);
        filterSet.filters[0].setFilterType(Filter.FilterTypes.HP);
        filterSet.filters[0].setFilterFc(20.0);
        filterSet.filters[1].setFilterType(Filter.FilterTypes.LP1);
        filterSet.filters[1].setFilterFc(4400.0);
        filterSet.filters[2].setFilterType(Filter.FilterTypes.LP1);
        filterSet.filters[2].setFilterFc(8000.0);
        return filterSet;
    }

    static FilterSet SubCalSet(double d2) {
        FilterSet filterSet = new FilterSet(2, d2);
        filterSet.filters[0].setFilterType(Filter.FilterTypes.HP);
        filterSet.filters[0].setFilterFc(30.0);
        filterSet.filters[1].setFilterType(Filter.FilterTypes.LP);
        filterSet.filters[1].setFilterFc(80.0);
        return filterSet;
    }

    static FilterSet SpkrCalSet(double d2) {
        FilterSet filterSet = new FilterSet(2, d2);
        filterSet.filters[0].setFilterType(Filter.FilterTypes.HP);
        filterSet.filters[0].setFilterFc(500.0);
        filterSet.filters[1].setFilterType(Filter.FilterTypes.LP);
        filterSet.filters[1].setFilterFc(2000.0);
        return filterSet;
    }

    static FilterSet CustomSet(double d2, GF gF2) {
        XOverChoice xOverChoice;
        int n2 = 2;
        FilterSet filterSet = new FilterSet(n2 * 4, d2);
        filterSet.initXOverFilters(n2, d2);
        if (gF2.D) {
            xOverChoice = gF2.A;
            filterSet.getXOverFilters()[0].setLPHPFilter(FilterGroup.HIGHPASS, xOverChoice.getShape(), xOverChoice.getSlope(), gF2.C);
        }
        if (gF2.B) {
            xOverChoice = gF2.A;
            filterSet.getXOverFilters()[1].setLPHPFilter(FilterGroup.LOWPASS, xOverChoice.getShape(), xOverChoice.getSlope(), gF2.E);
        }
        return filterSet;
    }

    static FilterSet noiseFilters(NoiseSelection noiseSelection, GF gF2, double d2) {
        FilterSet filterSet;
        switch (noiseSelection) {
            case SUB: {
                filterSet = FilterSet.SubCalSet(d2);
                break;
            }
            case SPKR: {
                filterSet = FilterSet.SpkrCalSet(d2);
                break;
            }
            case OCTAVE: 
            case THIRD_OCTAVE: 
            case CUSTOM: {
                filterSet = FilterSet.CustomSet(d2, gF2);
                break;
            }
            case CTA2034: {
                filterSet = FilterSet.CTA2034Set(d2);
                break;
            }
            default: {
                filterSet = null;
            }
        }
        if (filterSet != null) {
            filterSet.initActiveFilterNumbers();
            filterSet.initFilterSetState();
        }
        return filterSet;
    }

    public String toString() {
        return this.getDescription(false);
    }

    String getDescription(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.filters.length - 1; ++i2) {
            Filter filter = this.filters[i2];
            if (XOverFilter.isXOverFilter(filter)) {
                if (filter.getFilterType() != Filter.FilterTypes.NONE || bl) {
                    stringBuilder.append(XOverFilter.getDescription(filter)).append("\n");
                }
                i2 += 3;
                continue;
            }
            if (filter.getFilterType() == Filter.FilterTypes.NONE && !bl) continue;
            stringBuilder.append(Filter.getDescription(filter, false)).append("\n");
        }
        if (this.filters[this.filters.length - 1].getFilterType() != Filter.FilterTypes.NONE || bl) {
            stringBuilder.append(Filter.getDescription(this.filters[this.filters.length - 1], false));
        }
        return stringBuilder.toString();
    }

    boolean matches(FilterSet filterSet) {
        if (filterSet == null) {
            return false;
        }
        if (this.filters.length != filterSet.filters.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.filters.length; ++i2) {
            if (this.filters[i2].matches(filterSet.filters[i2])) continue;
            return false;
        }
        return true;
    }

    FilterSet copy() {
        int n2;
        FilterSet filterSet = new FilterSet(this.filters.length, this.filters[0].getSampleRate());
        filterSet.hiddenFilters = this.hiddenFilters;
        int n3 = this.getNumXOverFilters();
        int n4 = this.getNumRegularFilters();
        if (n3 != 0) {
            filterSet.initXOverFilters(n3, this.filters[0].getSampleRate());
        }
        for (n2 = 0; n2 < n4; ++n2) {
            filterSet.filters[n2] = this.filters[n2].copy();
        }
        for (n2 = n4; n2 < this.filters.length - this.hiddenFilters; ++n2) {
            filterSet.filters[n2] = this.filters[n2].copy();
        }
        for (n2 = this.filters.length - this.hiddenFilters; n2 < this.filters.length; ++n2) {
            filterSet.filters[n2] = this.filters[n2].copy();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            filterSet.xOverFilters[n2].setFilter(this.xOverFilters[n2]);
        }
        return filterSet;
    }

    void setSampleRate(double d2) {
        for (Filter filter : this.filters) {
            filter.setSampleRate(d2);
        }
    }

    private void initXOverFilters(Equaliser equaliser, MeasData measData) {
        this.xOverFilters = new XOverFilter[equaliser.getNumXOverFilters()];
        int n2 = equaliser.getNumRegularFilters();
        for (int i2 = 0; i2 < equaliser.getNumXOverFilters(); ++i2) {
            this.xOverFilters[i2] = new XOverFilter(this.filters, n2 + i2 * 4);
            this.xOverFilters[i2].setFilterFc(equaliser.getDefaultFc(i2));
            this.xOverFilters[i2].setColor(FilterSet.getDefaultFilterColor(i2));
            this.xOverFilters[i2].setSampleRate(equaliser.getFiltSampleRate(measData));
            this.xOverFilters[i2].addPropertyChangeListener(this);
        }
    }

    void initXOverFilters(int n2, double d2) {
        this.xOverFilters = new XOverFilter[n2];
        int n3 = this.getNumRegularFilters();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xOverFilters[i2] = new XOverFilter(this.filters, n3 + i2 * 4);
            this.xOverFilters[i2].setColor(FilterSet.getDefaultFilterColor(i2));
            this.xOverFilters[i2].setSampleRate(d2);
        }
    }

    void initialiseColors() {
        int n2;
        for (n2 = 0; n2 < this.filters.length; ++n2) {
            if (this.filters[n2] == null || this.filters[n2].getColor() != null) continue;
            this.filters[n2].setColor(FilterSet.getDefaultFilterColor(n2));
        }
        if (this.xOverFilters != null) {
            for (n2 = 0; n2 < this.xOverFilters.length; ++n2) {
                if (this.xOverFilters[n2].getColor() != null) continue;
                this.xOverFilters[n2].setColor(FilterSet.getDefaultFilterColor(n2));
            }
        }
    }

    public Object readResolve() throws ObjectStreamException {
        int n2;
        this.pcs = new SwingPropertyChangeSupport(this);
        for (n2 = 0; n2 < this.filters.length; ++n2) {
            if (this.filters[n2] == null) continue;
            this.filters[n2].setColor(FilterSet.getDefaultFilterColor(n2));
            this.filters[n2].addPropertyChangeListener(this);
        }
        if (this.xOverFilters != null) {
            for (n2 = 0; n2 < this.xOverFilters.length; ++n2) {
                if (this.xOverFilters[n2] == null) continue;
                this.xOverFilters[n2].setColor(FilterSet.getDefaultFilterColor(n2));
                this.xOverFilters[n2].addPropertyChangeListener(this);
            }
        }
        return this;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcs.firePropertyChange(FILTERS_UPDATE, null, null);
    }

    float filtersdB(float f2, float f3) {
        float f4 = 1.0f;
        for (Filter filter : this.filters) {
            f4 *= filter.getFilterMagnSq(f2, f3);
        }
        return 10.0f * (float)Math.log10(Math.max(f4, Float.MIN_VALUE));
    }

    float filtersdB(float f2) {
        if (this.filters.length == 0) {
            return 0.0f;
        }
        double d2 = this.filtersMagnSq(f2);
        return 10.0f * (float)Math.log10(Math.max(d2, (double)1.4E-45f));
    }

    float hiddenFiltersdB(float f2) {
        int n2;
        int n3;
        if (this.hiddenFilters == 0) {
            return 0.0f;
        }
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n3 = n2 = this.getNumRegularFilters(); n3 < n2 + this.hiddenFilters; ++n3) {
            if (this.filters[n3].hasNoEffect()) continue;
            d2 = this.filters[n3].getMagnSq(f2);
            d3 = this.filters[n3].getsTh();
            d4 = this.filters[n3].getsTh2();
            ++n3;
            break;
        }
        while (n3 < n2 + this.hiddenFilters) {
            d2 *= this.filters[n3].getMagnSq(d3, d4);
            ++n3;
        }
        return 10.0f * (float)Math.log10(Math.max(d2, (double)1.4E-45f));
    }

    float filtersMagn(float f2) {
        if (this.filters.length == 0) {
            return 1.0f;
        }
        double d2 = this.filtersMagnSq(f2);
        if (d2 <= 0.0) {
            return 0.0f;
        }
        return (float)Math.sqrt(d2);
    }

    double filtersMagnSq(float f2) {
        int n2;
        if (this.filters.length == 0) {
            return 1.0;
        }
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 < this.filters.length; ++n2) {
            if (this.filters[n2].hasNoEffect()) continue;
            d2 = this.filters[n2].getMagnSq(f2);
            d3 = this.filters[n2].getsTh();
            d4 = this.filters[n2].getsTh2();
            ++n2;
            break;
        }
        while (n2 < this.filters.length) {
            d2 *= this.filters[n2].getMagnSq(d3, d4);
            ++n2;
        }
        return d2;
    }

    static float filtersPhase(float f2, Filter[] filterArray) {
        float f3 = 0.0f;
        for (Filter filter : filterArray) {
            if (!filter.isActive()) continue;
            f3 += filter.getFilterPhase(f2);
        }
        return f3;
    }

    static float filtersdB(float f2, Filter[] filterArray) {
        int n2;
        if (filterArray.length == 0) {
            return 0.0f;
        }
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 < filterArray.length; ++n2) {
            if (filterArray[n2].hasNoEffect()) continue;
            d2 = filterArray[n2].getMagnSq(f2);
            d3 = filterArray[n2].getsTh();
            d4 = filterArray[n2].getsTh2();
            ++n2;
            break;
        }
        while (n2 < filterArray.length) {
            d2 *= filterArray[n2].getMagnSq(d3, d4);
            ++n2;
        }
        return 10.0f * (float)Math.log10(Math.max(d2, (double)1.4E-45f));
    }

    static float filtersdBFast(double d2, double d3, Filter[] filterArray, int n2) {
        if (n2 == 0) {
            return 0.0f;
        }
        double d4 = 1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d4 *= filterArray[i2].getMagnSqFast(d2, d3);
        }
        if (d4 < (double)1.4E-45f) {
            d4 = 1.4E-45f;
        }
        return 10.0f * (float)Math.log10(d4);
    }

    float filtersPhase(float f2) {
        float f3 = 0.0f;
        for (Filter filter : this.filters) {
            f3 += filter.getFilterPhase(f2);
        }
        return f3;
    }

    EK filtersComplex(double d2) {
        return FilterSet.filtersComplex(d2, this.filters);
    }

    static EK filtersComplex(double d2, Filter[] filterArray) {
        if (filterArray == null || filterArray.length == 0 || filterArray[0] == null) {
            return new EK(1.0, 0.0);
        }
        if (d2 >= (double)(filterArray[0].getSampleRate() / 2)) {
            return new EK(0.0, 0.0);
        }
        AE aE2 = new AE(1.0, 0.0);
        double d3 = filterArray[0].getFreqNorm();
        qK qK2 = new qK(d2, d3);
        for (Filter filter : filterArray) {
            AE aE3 = filter.getMagnSqPhi(d2, qK2);
            aE2.B *= aE3.B;
            aE2.A += aE3.A;
        }
        if (aE2.B <= 0.0) {
            aE2.B = 1.4E-45f;
        }
        double d4 = Math.sqrt(aE2.B);
        return new EK(d4 * Math.cos(aE2.A), d4 * Math.sin(aE2.A));
    }

    boolean hasNoEffect() {
        boolean bl = true;
        for (Filter filter : this.filters) {
            if (filter == null || filter.hasNoEffect()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static boolean hasNoEffect(Filter[] filterArray) {
        boolean bl = true;
        for (Filter filter : filterArray) {
            if (filter == null || filter.hasNoEffect()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static boolean hasNoNetEffect(Filter[] filterArray) {
        boolean bl = FilterSet.hasNoEffect(filterArray);
        if (!bl) {
            float[] fArray;
            float f2 = filterArray[0].getSampleRate() / 2;
            for (float f3 : fArray = new float[]{f2 * 0.01f, f2 / 2.0f, f2 * 0.9f}) {
                double d2 = FilterSet.filtersdB(f3, filterArray);
                double d3 = FilterSet.filtersPhase(f3, filterArray);
                if (!(Math.abs(d2) > 1.0E-10) && !(Math.abs(d3) > 1.0E-10)) continue;
                return false;
            }
            return true;
        }
        return bl;
    }

    void initActiveFilterNumbers() {
        int n2 = this.filters.length;
        this.activeFilterNumbers = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.filters[i2].isActive()) continue;
            this.activeFilterNumbers.add(i2);
        }
    }

    void initFilterSetState() {
        int n2;
        if (this.activeFilterNumbers == null) {
            this.initActiveFilterNumbers();
        }
        if ((n2 = this.activeFilterNumbers.size()) > 0) {
            this.state = new jG(this);
        }
    }

    ArrayList<Integer> getActiveFilterNumbers() {
        return this.activeFilterNumbers;
    }

    void applyFilters(float[] fArray) {
        this.applyFilters(fArray, true);
    }

    void applyFilters(float[] fArray, boolean bl) {
        int n2 = fArray.length;
        this.initActiveFilterNumbers();
        int n3 = this.activeFilterNumbers.size();
        if (n3 > 0) {
            int n4;
            int n5;
            int n6;
            this.state = new jG(this);
            if (bl) {
                n6 = 0;
                n5 = n2 - 1;
                n4 = 1;
            } else {
                n6 = n2 - 1;
                n5 = 0;
                n4 = -1;
            }
            this.applyActiveFilters(n6, n5, n4, fArray);
        }
    }

    private void applyActiveFilters(int n2, int n3, int n4, float[] fArray) {
        if (this.state != null) {
            for (int i2 = n2; i2 != n3 + n4; i2 += n4) {
                fArray[i2] = (float)this.applyActiveFilters(fArray[i2]);
            }
        }
    }

    double applyActiveFilters(double d2) {
        double[] dArray = this.state.A[0];
        this.state.D = d2 - dArray[0] * this.state.C[0] - dArray[1] * this.state.B[0];
        this.state.E[0] = dArray[2] * this.state.D + dArray[3] * this.state.C[0] + dArray[4] * this.state.B[0];
        this.state.B[0] = this.state.C[0];
        this.state.C[0] = this.state.D;
        int n2 = this.state.A.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            dArray = this.state.A[i2];
            this.state.D = this.state.E[i2 - 1] - dArray[0] * this.state.C[i2] - dArray[1] * this.state.B[i2];
            this.state.E[i2] = dArray[2] * this.state.D + dArray[3] * this.state.C[i2] + dArray[4] * this.state.B[i2];
            this.state.B[i2] = this.state.C[i2];
            this.state.C[i2] = this.state.D;
        }
        return this.state.E[n2 - 1];
    }

    Filter[] getFilters() {
        return this.filters;
    }

    XOverFilter[] getXOverFilters() {
        return this.xOverFilters;
    }

    public List<FilterSetting> getAPIFilterList() {
        ArrayList<FilterSetting> arrayList = new ArrayList<FilterSetting>();
        int n2 = 1;
        for (int i2 = 0; i2 < this.getNumRegularFilters(); ++i2) {
            Filter filter = this.filters[i2];
            Filter.FilterTypes filterTypes = filter.getFilterType();
            FilterSetting object = FilterSetting.builder().index(n2++).enabled(filter.isEnabled()).isAuto(filter.isAutomatic()).type(filterTypes.apiName()).build();
            if (filterTypes != Filter.FilterTypes.NONE) {
                if (filterTypes.hasFreq()) {
                    object.setFrequency(filter.getFilterFc());
                }
                if (filterTypes.hasGain()) {
                    object.setGaindB(filter.getFilterGain());
                }
                if (filterTypes.hasAdjustableQ()) {
                    object.setQ(filter.getFilterQ());
                }
                if (filterTypes.hasT60()) {
                    object.setT60Target(filter.getFilterT60Target());
                }
                if (filterTypes.hasQ2()) {
                    object.setQ2(filter.getFilterQ2());
                }
                if (filterTypes.hasFreq2()) {
                    object.setFrequency2(filter.getFilterFc2());
                }
            }
            arrayList.add(object);
        }
        if (this.xOverFilters != null && this.xOverFilters.length > 0) {
            for (XOverFilter xOverFilter : this.xOverFilters) {
                FilterGroup filterGroup = xOverFilter.getFilterGroup();
                FilterSetting filterSetting = FilterSetting.builder().index(n2++).enabled(xOverFilter.isEnabled()).isAuto(xOverFilter.isAutomatic()).type(filterGroup.apiName()).build();
                if (filterGroup != FilterGroup.NONE) {
                    if (filterGroup.hasFreq()) {
                        filterSetting.setFrequency(xOverFilter.getFilterFc());
                    }
                    if (filterGroup.hasGain()) {
                        filterSetting.setGaindB(xOverFilter.getFilterGain());
                    }
                    if (filterGroup.hasAdjustableQ()) {
                        filterSetting.setQ(xOverFilter.getFilterQ());
                    }
                    if (filterGroup.hasT60()) {
                        filterSetting.setT60Target(xOverFilter.getFilterT60Target());
                    }
                    if (filterGroup.hasQ2()) {
                        filterSetting.setQ2(xOverFilter.getFilterQ2());
                    }
                    if (filterGroup.hasFreq2()) {
                        filterSetting.setFrequency2(xOverFilter.getFilterFc2());
                    }
                    if (filterGroup.hasShape()) {
                        filterSetting.setShape(xOverFilter.getFilterShape().apiName());
                    }
                    if (filterGroup.hasSlope()) {
                        filterSetting.setSlopedBPerOctave(xOverFilter.getFilterSlope().getSlopedB());
                    }
                    if (filterGroup.hasSlope2()) {
                        filterSetting.setSlope2dBPerOctave(xOverFilter.getFilterSlope2().getSlopedB());
                    }
                }
                arrayList.add(filterSetting);
            }
        }
        return arrayList;
    }

    public Result updateFilter(int n2, FilterSetting filterSetting) {
        if (n2 < this.getNumRegularFilters()) {
            return this.updateRegularFilter(n2, filterSetting);
        }
        return this.updateXOverFilter(n2, filterSetting);
    }

    private Result updateRegularFilter(int n2, FilterSetting filterSetting) {
        Filter filter = this.filters[n2];
        if (filterSetting.getEnabled() != null) {
            filter.setEnabled(filterSetting.getEnabled());
        }
        if (filterSetting.getType() != null) {
            Filter.FilterTypes filterTypes = Filter.FilterTypes.getFromApiName(filterSetting.getType());
            if (filterTypes == null) {
                return Result.builder().success(false).failureMessage(filterSetting.getType() + " is not a recognised filter type").build();
            }
            filter.setFilterType(filterTypes);
        }
        if (filterSetting.getIsAuto() != null) {
            if (filterSetting.getIsAuto().booleanValue() && !filter.getFilterType().allowsAutomatic()) {
                return Result.builder().success(false).failureMessage(filter.getFilterType().apiName() + " filters cannot be set to auto").build();
            }
            filter.setAutomatic(filterSetting.getIsAuto());
        }
        if (filterSetting.getFrequency() != null) {
            if (!filter.getFilterType().hasFreq()) {
                return Result.builder().success(false).failureMessage(filter.getFilterType().apiName() + " filters do not have a frequency").build();
            }
            filter.setFilterFc(filterSetting.getFrequency());
        }
        if (filterSetting.getFrequency2() != null) {
            if (!filter.getFilterType().hasFreq2()) {
                return Result.builder().success(false).failureMessage(filter.getFilterType().apiName() + " filters do not have a second frequency").build();
            }
            filter.setFilterFc2(filterSetting.getFrequency2());
        }
        if (filterSetting.getGaindB() != null) {
            if (!filter.getFilterType().hasGain()) {
                return Result.builder().success(false).failureMessage(filter.getFilterType().apiName() + " filters do not have gain").build();
            }
            filter.setFilterGain(filterSetting.getGaindB());
        }
        if (filterSetting.getQ() != null) {
            if (!filter.getFilterType().hasAdjustableQ()) {
                return Result.builder().success(false).failureMessage(filter.getFilterType().apiName() + " filters do not have a q").build();
            }
            filter.setFilterQ(filterSetting.getQ());
        }
        if (filterSetting.getQ2() != null) {
            if (!filter.getFilterType().hasQ2()) {
                return Result.builder().success(false).failureMessage(filter.getFilterType().apiName() + " filters do not have a second q").build();
            }
            filter.setFilterQ2(filterSetting.getQ2());
        }
        if (filterSetting.getT60Target() != null) {
            if (!filter.getFilterType().hasT60()) {
                return Result.builder().success(false).failureMessage(filter.getFilterType().apiName() + " filters do not have a T60 target").build();
            }
            filter.setFilterT60Target(filterSetting.getT60Target());
        }
        return Result.builder().success(true).failureMessage(null).build();
    }

    private Result updateXOverFilter(int n2, FilterSetting filterSetting) {
        Enum enum_;
        XOverFilter xOverFilter = this.xOverFilters[n2 - this.getNumRegularFilters()];
        if (filterSetting.getEnabled() != null) {
            xOverFilter.setEnabled(filterSetting.getEnabled());
        }
        if (filterSetting.getType() != null) {
            enum_ = FilterGroup.getFromApiName(filterSetting.getType());
            if (enum_ == null) {
                return Result.builder().success(false).failureMessage(filterSetting.getType() + " is not a recognised filter type").build();
            }
            xOverFilter.setFilterGroup((FilterGroup)enum_);
        }
        if (filterSetting.getIsAuto() != null) {
            if (filterSetting.getIsAuto().booleanValue() && !xOverFilter.getFilterGroup().allowsAutomatic()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters cannot be set to auto").build();
            }
            xOverFilter.setAutomatic(filterSetting.getIsAuto());
        }
        if (filterSetting.getFrequency() != null) {
            if (!xOverFilter.getFilterGroup().hasFreq()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a frequency").build();
            }
            xOverFilter.setFilterFc(filterSetting.getFrequency());
        }
        if (filterSetting.getFrequency2() != null) {
            if (!xOverFilter.getFilterGroup().hasFreq2()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a second frequency").build();
            }
            xOverFilter.setFilterFc2(filterSetting.getFrequency2());
        }
        if (filterSetting.getGaindB() != null) {
            if (!xOverFilter.getFilterGroup().hasGain()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have gain").build();
            }
            xOverFilter.setFilterGain(filterSetting.getGaindB());
        }
        if (filterSetting.getQ() != null) {
            if (!xOverFilter.getFilterGroup().hasAdjustableQ()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a q").build();
            }
            xOverFilter.setFilterQ(filterSetting.getQ());
        }
        if (filterSetting.getQ2() != null) {
            if (!xOverFilter.getFilterGroup().hasQ2()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a second q").build();
            }
            xOverFilter.setFilterQ2(filterSetting.getQ2());
        }
        if (filterSetting.getT60Target() != null) {
            if (!xOverFilter.getFilterGroup().hasT60()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a T60 target").build();
            }
            xOverFilter.setFilterT60Target(filterSetting.getT60Target());
        }
        if (filterSetting.getShape() != null) {
            enum_ = XOverShape.getFromApiName(filterSetting.getShape());
            if (enum_ == null) {
                return Result.builder().success(false).failureMessage(filterSetting.getShape() + " is not a recognised shape").build();
            }
            if (!xOverFilter.getFilterGroup().hasShape()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a shape").build();
            }
            xOverFilter.setFilterShape((XOverShape)enum_);
        }
        if (filterSetting.getSlopedBPerOctave() != null) {
            enum_ = XOverSlope.getSlopeFromdBPerOctave(filterSetting.getSlopedBPerOctave());
            if (enum_ == null) {
                return Result.builder().success(false).failureMessage(filterSetting.getSlopedBPerOctave() + " is not a recognised slope").build();
            }
            if (!xOverFilter.getFilterGroup().hasSlope()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a slope").build();
            }
            xOverFilter.setFilterSlope((XOverSlope)enum_);
        }
        if (filterSetting.getSlope2dBPerOctave() != null) {
            enum_ = XOverSlope.getSlopeFromdBPerOctave(filterSetting.getSlope2dBPerOctave());
            if (enum_ == null) {
                return Result.builder().success(false).failureMessage(filterSetting.getSlope2dBPerOctave() + " is not a recognised slope").build();
            }
            if (!xOverFilter.getFilterGroup().hasSlope2()) {
                return Result.builder().success(false).failureMessage(xOverFilter.getFilterGroup().apiName() + " filters do not have a second slope").build();
            }
            xOverFilter.setFilterSlope2((XOverSlope)enum_);
        }
        return Result.builder().success(true).failureMessage(null).build();
    }

    int getNumRegularFilters() {
        int n2 = this.filters.length - this.hiddenFilters;
        if (this.xOverFilters != null && this.xOverFilters.length > 0) {
            n2 = this.filters.length - this.hiddenFilters - this.xOverFilters.length * 4;
        }
        return n2;
    }

    int getNumFilters() {
        return this.filters.length;
    }

    int getNumHiddenFilters() {
        return this.hiddenFilters;
    }

    int getNumXOverFilters() {
        if (this.xOverFilters != null) {
            return this.xOverFilters.length;
        }
        return 0;
    }

    void clearFilters() {
        int n2;
        if (this.xOverFilters != null && this.xOverFilters.length > 0) {
            XOverFilter[] xOverFilterArray = this.xOverFilters;
            n2 = xOverFilterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                XOverFilter xOverFilter = xOverFilterArray[i2];
                xOverFilter.clearFilter();
            }
        }
        int n3 = this.getNumRegularFilters();
        for (n2 = 0; n2 < n3; ++n2) {
            this.filters[n2].setFilterType(Filter.FilterTypes.NONE);
        }
        for (n2 = this.filters.length - this.hiddenFilters; n2 < this.filters.length; ++n2) {
            this.filters[n2].setFilterType(Filter.FilterTypes.NONE);
        }
    }

    void clearNotHiddenFilters() {
        int n2;
        if (this.xOverFilters != null && this.xOverFilters.length > 0) {
            XOverFilter[] xOverFilterArray = this.xOverFilters;
            n2 = xOverFilterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                XOverFilter xOverFilter = xOverFilterArray[i2];
                xOverFilter.clearFilter();
            }
        }
        int n3 = this.getNumRegularFilters();
        for (n2 = 0; n2 < n3; ++n2) {
            this.filters[n2].setFilterType(Filter.FilterTypes.NONE);
        }
    }

    void clearXOverFilters() {
        if (this.xOverFilters != null && this.xOverFilters.length > 0) {
            for (XOverFilter xOverFilter : this.xOverFilters) {
                xOverFilter.clearFilter();
            }
        }
    }

    UK filtersApproxMaxGain() {
        float[] fArray;
        UK uK2 = new UK();
        uK2.B = 0.0;
        for (int i2 = 0; i2 < this.getNumFilters() - this.getNumHiddenFilters(); ++i2) {
            Filter filter = this.filters[i2];
            if (filter.hasNoEffect()) continue;
            this.updateHeadroom((float)filter.getFilterFc(), uK2);
        }
        float f2 = 20.0f;
        int n2 = 96;
        float f3 = (float)Math.pow(2.0, 1.0 / (double)n2);
        do {
            this.updateHeadroom(f2, uK2);
        } while ((f2 *= f3) < (float)this.filters[0].getSampleRate() * 0.499f);
        for (float f4 : fArray = new float[]{2.0f, (float)this.filters[0].getSampleRate() * 0.499f}) {
            this.updateHeadroom(f4, uK2);
        }
        return uK2;
    }

    private void updateHeadroom(float f2, UK uK2) {
        double d2 = this.filtersdB(f2) - this.hiddenFiltersdB(f2);
        if (d2 > uK2.B) {
            uK2.B = d2;
            uK2.A = f2;
        }
    }

    private void setFilters(Filter[] filterArray) {
        for (Filter filter : this.filters) {
            if (filter == null) continue;
            filter.removePropertyChangeListener(this);
        }
        for (Filter filter : filterArray) {
            if (filter == null) continue;
            filter.addPropertyChangeListener(this);
        }
        this.filters = filterArray;
    }

    void setFilter(int n2, Filter filter) {
        if (this.filters[n2] != null) {
            this.filters[n2].removePropertyChangeListener(this);
        }
        this.filters[n2] = filter;
        this.filters[n2].addPropertyChangeListener(this);
    }

    ArrayList<ED> getDefinedFilters(int n2) {
        ArrayList<ED> arrayList = new ArrayList<ED>();
        for (int i2 = n2; i2 < this.getNumRegularFilters(); ++i2) {
            if (this.filters[i2].hasNoEffect()) continue;
            arrayList.add(new ED("" + (i2 - n2 + 1), this.filters[i2].getFilterFc(), this.filters[i2].isEnabled(), this.filters[i2].isAutomatic(), this.filters[i2].getColor()));
        }
        String string = this.getNumRegularFilters() > 0 ? "X" : "";
        for (int i3 = 0; i3 < this.getNumXOverFilters(); ++i3) {
            if (this.xOverFilters[i3].hasNoEffect()) continue;
            arrayList.add(new ED(string + (i3 + 1), this.xOverFilters[i3].getFilterFc(), this.xOverFilters[i3].isEnabled(), this.xOverFilters[i3].isAutomatic(), this.xOverFilters[i3].getColor()));
        }
        return arrayList;
    }

    ArrayList<FilterResponse> getActiveFilters() {
        Comparable comparable;
        int n2;
        ArrayList<FilterResponse> arrayList = new ArrayList<FilterResponse>(this.filters.length);
        for (n2 = 0; n2 < this.getNumRegularFilters(); ++n2) {
            comparable = this.filters[n2];
            if (!comparable.isActive()) continue;
            arrayList.add((FilterResponse)((Object)comparable));
        }
        for (n2 = 0; n2 < this.getNumXOverFilters(); ++n2) {
            comparable = this.xOverFilters[n2];
            if (!comparable.isActive()) continue;
            arrayList.add((FilterResponse)((Object)comparable));
        }
        return arrayList;
    }

    ArrayList<FilterResponse> getFilterResponses() {
        Comparable comparable;
        int n2;
        ArrayList<FilterResponse> arrayList = new ArrayList<FilterResponse>(this.filters.length);
        for (n2 = 0; n2 < this.getNumRegularFilters(); ++n2) {
            comparable = this.filters[n2];
            comparable.setIndex(n2);
            arrayList.add((FilterResponse)((Object)comparable));
        }
        for (n2 = 0; n2 < this.getNumXOverFilters(); ++n2) {
            comparable = this.xOverFilters[n2];
            comparable.setIndex(n2 + 100);
            arrayList.add((FilterResponse)((Object)comparable));
        }
        return arrayList;
    }

    int getActiveBiquads() {
        Comparable comparable;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.getNumRegularFilters(); ++n2) {
            comparable = this.filters[n2];
            if (!comparable.isActive()) continue;
            ++n3;
        }
        for (n2 = 0; n2 < this.getNumXOverFilters(); ++n2) {
            comparable = this.xOverFilters[n2];
            if (!((XOverFilter)comparable).isActive()) continue;
            n3 += ((XOverFilter)comparable).getActiveBiquads();
        }
        return n3;
    }

    static Color getDefaultFilterColor(int n2) {
        return filterColorsDefault[n2 % filterColorsDefault.length];
    }

    void sortFilters(Equaliser equaliser) {
        int n2 = equaliser.getSortStartIndex();
        int n3 = equaliser.getSortEndIndex();
        if (n3 <= equaliser.getNumRegularFilters()) {
            Arrays.sort(this.filters, n2, n3);
        } else {
            assert (n2 >= equaliser.getNumRegularFilters()) : "sortStart " + n2 + ", unitEQ.getNumRegularFilters() " + equaliser.getNumRegularFilters() + ", sortEnd " + n3;
            assert (this.xOverFilters != null);
            XOverFilter.sort(this.xOverFilters, n2 / 4, n3 / 4, this.filters);
        }
    }

    void updateForEQ(Equaliser equaliser, MeasData measData) {
        Comparable comparable;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Filter[] filterArray = this.filters;
        XOverFilter[] xOverFilterArray = this.xOverFilters;
        boolean bl = this.hasNoEffect();
        int n9 = this.hiddenFilters;
        boolean bl2 = xOverFilterArray != null;
        int n10 = bl2 ? xOverFilterArray.length : 0;
        int n11 = filterArray.length - n9 - n10 * 4;
        if (bl2 && n10 > 0) {
            XOverFilter[] xOverFilterArray2 = xOverFilterArray;
            n8 = xOverFilterArray2.length;
            for (n7 = 0; n7 < n8; ++n7) {
                XOverFilter xOverFilter = xOverFilterArray2[n7];
                xOverFilter.updateToFilterGroup();
            }
        }
        this.setFilters(new Filter[equaliser.getTotalFilters()]);
        for (n6 = 0; n6 < this.filters.length; ++n6) {
            this.setFilter(n6, new Filter(equaliser.getFiltSampleRate(measData)));
            this.filters[n6].addPropertyChangeListener(this);
            this.filters[n6].setFilterType(equaliser.getDefaultFilterType(n6));
            if (this.filters[n6].getFilterType() != Filter.FilterTypes.NONE) continue;
            this.filters[n6].setFilterFc(equaliser.getDefaultFc(n6));
            this.filters[n6].setFilterQ(equaliser.getNearestActualQ(equaliser.getDefaultQ(n6), 0.0, equaliser.getDefaultFc(n6)));
        }
        if (equaliser.getHiddenFilters() > 0) {
            for (n6 = 0; n6 < Math.min(this.hiddenFilters, equaliser.getHiddenFilters()); ++n6) {
                this.filters[this.filters.length - equaliser.getHiddenFilters() + n6] = filterArray[filterArray.length - n9 + n6].copy();
            }
        }
        n6 = equaliser.getNumRegularFilters() - equaliser.getSortStartIndex();
        int n12 = n8 = equaliser.getNumXOverFilters() > 0 ? 1 : 0;
        if (n8 != 0) {
            this.initXOverFilters(equaliser, measData);
        } else {
            this.xOverFilters = null;
        }
        n7 = n11 > 0 ? 1 : 0;
        boolean bl3 = n6 > 0;
        int n13 = 0;
        int n14 = 0;
        boolean[] blArray = new boolean[n10];
        for (n5 = 0; n5 < n10; ++n5) {
            if (xOverFilterArray[n5].getFilterGroup() == FilterGroup.NONE) {
                blArray[n5] = false;
                ++n14;
                continue;
            }
            blArray[n5] = true;
        }
        if (bl2 && n8 != 0 && n7 == 0 && !bl3) {
            for (n5 = 0; n5 < equaliser.getNumXOverFilters() && n5 < xOverFilterArray.length; ++n5) {
                if (blArray[n5] && equaliser.supportsGroup(xOverFilterArray[n5].getFilterGroup(), n13)) {
                    this.xOverFilters[n13].setFilter(xOverFilterArray[n5]);
                    this.alignXOverToEqResolutions(this.xOverFilters[n13], equaliser);
                    ++n13;
                }
                ++n14;
                blArray[n5] = false;
            }
        }
        n5 = 0;
        int n15 = 0;
        boolean[] blArray2 = new boolean[n11];
        for (n4 = 0; n4 < n11; ++n4) {
            if (filterArray[n4].getFilterType() == Filter.FilterTypes.NONE) continue;
            blArray2[n4] = true;
            ++n15;
        }
        n4 = n15 - n6;
        if (n4 > 0) {
            if (n8 != 0) {
                n4 -= equaliser.getNumXOverFilters() - n13;
            }
            if (n4 > 0) {
                this.ignoreUnsupportedDisabledOrNoEffectFilters(n4, n11, filterArray, equaliser, blArray2);
            }
            n3 = equaliser.getSortStartIndex();
            for (n2 = 0; n2 < n11; ++n2) {
                if (!blArray2[n2] || !equaliser.supports(filterArray[n2].getFilterType(), n3)) continue;
                blArray2[n2] = false;
                this.setFilter(n3, Filter.copy(filterArray[n2]));
                comparable = this.filters[n3];
                ((Filter)comparable).setSampleRate(equaliser.getFiltSampleRate(measData));
                if (((Filter)comparable).getFilterType() == Filter.FilterTypes.NONE) {
                    ((Filter)comparable).setFilterFc(equaliser.getDefaultFc(n3));
                    ((Filter)comparable).setFilterQ(equaliser.getDefaultQ(n3));
                } else {
                    ((Filter)comparable).setFilterFc(equaliser.getNearestFreq(((Filter)comparable).getFilterFc()));
                    double d2 = equaliser.getNearestGain(n3, ((Filter)comparable).getFilterGain());
                    ((Filter)comparable).setFilterGain(d2);
                    ((Filter)comparable).setFilterQ(equaliser.getNearestActualQ(((Filter)comparable).getFilterQ(), d2, ((Filter)comparable).getFilterFc()));
                }
                ++n5;
                if (++n3 >= n6) break;
            }
            if (equaliser.getNumXOverFilters() - n13 > 0) {
                for (n2 = 0; n2 < n11; ++n2) {
                    comparable = filterArray[n2];
                    FilterGroup filterGroup = FilterGroup.convertsTo((Filter)comparable);
                    if (!blArray2[n2] || !equaliser.supportsGroup(filterGroup, n13)) continue;
                    blArray2[n2] = false;
                    this.xOverFilters[n13].setUpFrom((Filter)comparable);
                    if (equaliser.getNumXOverFilters() != ++n13) {
                        continue;
                    }
                    break;
                }
            }
        } else if (n11 > 0 && n6 > 0) {
            for (n3 = equaliser.getSortStartIndex(); n3 < n6; ++n3) {
                n2 = n3 - equaliser.getSortStartIndex();
                if (n2 >= n11) continue;
                if (equaliser.supports(filterArray[n2].getFilterType(), n3)) {
                    this.setFilter(n3, Filter.copy(filterArray[n2]));
                }
                this.filters[n3].setSampleRate(equaliser.getFiltSampleRate(measData));
                if (this.filters[n3].getFilterType() == Filter.FilterTypes.NONE) {
                    this.filters[n3].setFilterFc(equaliser.getDefaultFc(n3));
                    this.filters[n3].setFilterQ(equaliser.getDefaultQ(n3));
                } else {
                    this.filters[n3].setFilterFc(equaliser.getNearestFreq(this.filters[n3].getFilterFc()));
                    double d3 = equaliser.getNearestGain(n3, this.filters[n3].getFilterGain());
                    this.filters[n3].setFilterGain(d3);
                    this.filters[n3].setFilterQ(equaliser.getNearestActualQ(this.filters[n3].getFilterQ(), d3, this.filters[n3].getFilterFc()));
                }
                ++n5;
            }
        }
        if (bl2 && n14 < xOverFilterArray.length && equaliser.getNumXOverFilters() > n13) {
            for (n3 = 0; n3 < xOverFilterArray.length && n13 < equaliser.getNumXOverFilters(); ++n3) {
                if (!blArray[n3] || xOverFilterArray[n3].canBeConvertedTo() != null || !equaliser.supportsGroup(xOverFilterArray[n3].getFilterGroup(), n13)) continue;
                this.xOverFilters[n13].setFilter(xOverFilterArray[n3]);
                this.alignXOverToEqResolutions(this.xOverFilters[n13], equaliser);
                ++n13;
                ++n14;
                blArray[n3] = false;
            }
        }
        if (bl2 && n14 < xOverFilterArray.length && n5 < n6) {
            for (n3 = 0; n3 < xOverFilterArray.length && n5 < n6; ++n3) {
                int n16;
                if (!blArray[n3]) continue;
                n2 = equaliser.getSortStartIndex() + n5;
                comparable = xOverFilterArray[n3];
                Filter.FilterTypes filterTypes = ((XOverFilter)comparable).canBeConvertedTo();
                if (filterTypes != null) {
                    if (!equaliser.supports(filterTypes, n2)) continue;
                    this.setFilter(n2, ((XOverFilter)comparable).getConvertedFilter());
                    this.adaptFilterToEQ(n2, equaliser, measData);
                    ++n5;
                    ++n14;
                    blArray[n3] = false;
                    continue;
                }
                int n17 = ((XOverFilter)comparable).getActiveBiquads();
                if (n17 >= n6 - n5 || n2 + n17 > equaliser.getSortEndIndex()) continue;
                Filter[] filterArray2 = ((XOverFilter)comparable).getFilters();
                boolean bl4 = true;
                for (n16 = 0; n16 < n17; ++n16) {
                    Filter filter = filterArray2[((XOverFilter)comparable).getIndexOffset() + n16];
                    bl4 &= equaliser.supports(filter.getFilterType(), n2 + n16);
                }
                if (!bl4) continue;
                for (n16 = 0; n16 < n17; ++n16) {
                    int n18 = n2 + n16;
                    this.setFilter(n18, Filter.copy(filterArray2[((XOverFilter)comparable).getIndexOffset() + n16]));
                    this.adaptFilterToEQ(n18, equaliser, measData);
                }
                n5 += n17;
                ++n14;
                blArray[n3] = false;
            }
        }
        if (bl2 && n14 < xOverFilterArray.length && equaliser.getNumXOverFilters() > n13) {
            for (n3 = 0; n3 < xOverFilterArray.length && n13 < equaliser.getNumXOverFilters(); ++n3) {
                if (!blArray[n3] || !equaliser.supportsGroup(xOverFilterArray[n3].getFilterGroup(), n13)) continue;
                this.xOverFilters[n13].setFilter(xOverFilterArray[n3]);
                this.alignXOverToEqResolutions(this.xOverFilters[n13], equaliser);
                ++n13;
                ++n14;
                blArray[n3] = false;
            }
        }
        this.initialiseColors();
        this.hiddenFilters = equaliser.getHiddenFilters();
        n3 = this.hasNoEffect() ? 1 : 0;
        this.pcs.firePropertyChange(FILTER_SET_UPDATE, true, bl && n3 != 0);
    }

    private void adaptFilterToEQ(int n2, Equaliser equaliser, MeasData measData) {
        Filter filter = this.filters[n2];
        filter.setGroup(null);
        Filter.FilterTypes filterTypes = filter.getFilterType();
        filter.setSampleRate(equaliser.getFiltSampleRate(measData));
        filter.setFilterFc(equaliser.getNearestFreq(filter.getFilterFc()));
        if (filterTypes.hasFreq2()) {
            filter.setFilterFc2(equaliser.getNearestFreq(filter.getFilterFc2()));
        }
        double d2 = equaliser.getNearestGain(n2, filter.getFilterGain());
        filter.setFilterGain(d2);
        if (filterTypes.isPK()) {
            filter.setFilterQ(equaliser.getNearestActualQ(filter.getFilterQ(), d2, filter.getFilterFc()));
        } else if (filterTypes.hasQNonPK()) {
            filter.setFilterQ(equaliser.roundedQ(filter.getFilterQ()));
        }
        if (filterTypes.hasQ2()) {
            filter.setFilterQ2(equaliser.roundedQ(filter.getFilterQ2()));
        }
    }

    private void ignoreUnsupportedDisabledOrNoEffectFilters(int n2, int n3, Filter[] filterArray, Equaliser equaliser, boolean[] blArray) {
        Filter filter;
        int n4;
        if (n2 > 0) {
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                filter = filterArray[n4];
                Filter.FilterTypes filterTypes = filter.getFilterType();
                if (filterTypes != Filter.FilterTypes.NONE && equaliser.supports(filterTypes, n4)) continue;
                blArray[n4] = false;
                if (--n2 == 0) break;
            }
        }
        if (n2 > 0) {
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                filter = filterArray[n4];
                if (filter.isEnabled()) continue;
                blArray[n4] = false;
                if (--n2 == 0) break;
            }
        }
        if (n2 > 0) {
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                filter = filterArray[n4];
                if (!filter.hasNoEffect() || !blArray[n4]) continue;
                blArray[n4] = false;
                if (--n2 == 0) break;
            }
        }
    }

    private void alignXOverToEqResolutions(XOverFilter xOverFilter, Equaliser equaliser) {
        xOverFilter.setFilterFc(equaliser.getNearestFreq(xOverFilter.getFilterFc()));
        xOverFilter.setFilterFc2(equaliser.getNearestFreq(xOverFilter.getFilterFc2()));
        xOverFilter.setFilterGain(equaliser.getNearestGain(xOverFilter.getFilterGain()));
        if (xOverFilter.getFilterGroup().isPK()) {
            double d2 = xOverFilter.getFilterFc();
            double d3 = xOverFilter.getFilterGain();
            double d4 = xOverFilter.getFilterQ();
            xOverFilter.setFilterQ(equaliser.getNearestActualQ(d4, d3, d2));
        }
        if (xOverFilter.getFilterGroup().hasQNonPK()) {
            xOverFilter.setFilterQ(equaliser.getNearestDispQNonPK(xOverFilter.getFilterQ()));
        }
        if (xOverFilter.getFilterGroup().hasQ2()) {
            xOverFilter.setFilterQ2(equaliser.getNearestDispQNonPK(xOverFilter.getFilterQ2()));
        }
    }

    float[] getImpulseResponse(double d2, int n2, int n3) {
        float[] fArray = new float[n2];
        if (this.hasNoEffect()) {
            fArray[n3] = 1.0f;
        } else {
            int n4;
            int n5;
            int n6 = this.getFilters().length;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n6);
            for (n5 = 0; n5 < n6; ++n5) {
                if (!this.getFilters()[n5].isEnabled() || this.getFilters()[n5].getFilterType() == Filter.FilterTypes.NONE) continue;
                arrayList.add(n5);
            }
            n5 = arrayList.size();
            double[] dArray = new double[n5];
            double[][] dArray2 = new double[n5][5];
            double[] dArray3 = new double[n5];
            double[] dArray4 = new double[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                Filter filter = this.getFilters()[(Integer)arrayList.get(n4)];
                dArray2[n4] = filter.getCoefficients(d2);
            }
            for (n4 = n3; n4 < n2; ++n4) {
                double d3 = n4 == n3 ? 1.0 : 0.0;
                double d4 = d3 - dArray2[0][0] * dArray3[0] - dArray2[0][1] * dArray4[0];
                dArray[0] = dArray2[0][2] * d4 + dArray2[0][3] * dArray3[0] + dArray2[0][4] * dArray4[0];
                dArray4[0] = dArray3[0];
                dArray3[0] = d4;
                for (int i2 = 1; i2 < n5; ++i2) {
                    d4 = dArray[i2 - 1] - dArray2[i2][0] * dArray3[i2] - dArray2[i2][1] * dArray4[i2];
                    dArray[i2] = dArray2[i2][2] * d4 + dArray2[i2][3] * dArray3[i2] + dArray2[i2][4] * dArray4[i2];
                    dArray4[i2] = dArray3[i2];
                    dArray3[i2] = d4;
                }
                fArray[n4] = (float)dArray[n5 - 1];
            }
        }
        return fArray;
    }
}

