/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.HashMap;
import java.util.Set;
import roomeqwizard.Equaliser;
import roomeqwizard.Filter;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.YH;

public enum FilterGroup {
    NONE("None", "None"),
    PEAKING("PK", "PK"),
    LOWPASS("Low pass", "LP"),
    HIGHPASS("High pass", "HP"),
    LOWSHELF("Low shelf", "LS"),
    HIGHSHELF("High shelf", "HS"),
    ASYMMETRIC("Asym.", "Asym"),
    LS("LS RBJ", "LSRBJ"),
    HS("HS RBJ", "HSRBJ"),
    LPQ("LP Q", "LPQ"),
    HPQ("HP Q", "HPQ"),
    LSQ("LS Q", "LSQ"),
    HSQ("HS Q", "HSQ"),
    NOTCH("Notch", "NO"),
    NOTCHQ("Notch Q", "NOQ"),
    MODAL("Modal", "Modal"),
    ALLPASS("All pass", "AP"),
    LINKWITZT("L-T", "LT"),
    RESONANT("RES", "RES");

    private final String apiName;
    private final String shortName;
    private static final HashMap<FilterGroup, Filter.FilterTypes> groupToType;
    private static final HashMap<Filter.FilterTypes, FilterGroup> typeToGroup;
    private static final HashMap<Filter.FilterTypes, FilterGroup> canConvert;
    static final int MAX_ST_W = 10;

    static FilterGroup convertsTo(Filter filter) {
        Filter.FilterTypes filterTypes = filter.getFilterType();
        FilterGroup filterGroup = canConvert.get((Object)filterTypes);
        if (filterGroup != null) {
            return filterGroup;
        }
        return FilterGroup.typeToGroup(filterTypes);
    }

    static boolean canConvert(Filter filter) {
        return canConvert.get((Object)filter.getFilterType()) != null;
    }

    static Set<Filter.FilterTypes> directConversions() {
        return typeToGroup.keySet();
    }

    static FilterGroup typeToGroup(Filter.FilterTypes filterTypes) {
        return typeToGroup.get((Object)filterTypes);
    }

    public static FilterGroup getFromApiName(String string) {
        for (FilterGroup filterGroup : FilterGroup.values()) {
            if (!filterGroup.apiName().equalsIgnoreCase(string)) continue;
            return filterGroup;
        }
        return null;
    }

    private FilterGroup(String string2, String string3) {
        this.apiName = string2;
        this.shortName = string3;
    }

    Filter.FilterTypes toFilterType() {
        return groupToType.get((Object)this);
    }

    String apiName() {
        return this.apiName;
    }

    public String toString() {
        Equaliser equaliser = YH.\u0161() ? YH.\u0164().\u0167() : RoomEQ_Wizard.l;
        return this.toString(equaliser);
    }

    public String toString(Equaliser equaliser) {
        switch (this) {
            case PEAKING: {
                if (equaliser != null) {
                    return equaliser.pkName;
                }
                return "Peaking";
            }
            case LSQ: 
            case HSQ: {
                if (equaliser != null && equaliser.omitQInShelfLabels()) {
                    return this.apiName.replace(" Q", "");
                }
                return this.apiName;
            }
        }
        return this.apiName;
    }

    public String toShortString() {
        if (this == PEAKING) {
            Equaliser equaliser = YH.\u0161() ? YH.\u0164().\u0167() : RoomEQ_Wizard.l;
            if (equaliser != null) {
                return equaliser.pkName;
            }
            return "PK";
        }
        return this.apiName;
    }

    public String toFixedWidthSt() {
        return FilterGroup.toFixedWidthSt(this.toShortString());
    }

    public static String toFixedWidthSt(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < 10 - n2; ++i2) {
            string = string + " ";
        }
        return string;
    }

    boolean hasFreq() {
        switch (this) {
            case NONE: {
                return false;
            }
        }
        return true;
    }

    boolean hasFreq2() {
        switch (this) {
            case ASYMMETRIC: 
            case LINKWITZT: {
                return true;
            }
        }
        return false;
    }

    boolean hasBW() {
        switch (this) {
            case PEAKING: 
            case MODAL: {
                return true;
            }
        }
        return false;
    }

    boolean hasT60() {
        return this == MODAL;
    }

    boolean hasGain() {
        switch (this) {
            case PEAKING: 
            case LSQ: 
            case HSQ: 
            case ASYMMETRIC: 
            case MODAL: 
            case LOWSHELF: 
            case HIGHSHELF: 
            case LS: 
            case HS: {
                return true;
            }
        }
        return false;
    }

    boolean hasSlope() {
        switch (this) {
            case ASYMMETRIC: 
            case LOWSHELF: 
            case HIGHSHELF: 
            case LOWPASS: 
            case HIGHPASS: {
                return true;
            }
        }
        return false;
    }

    boolean hasSlope2() {
        return this == ASYMMETRIC;
    }

    boolean hasQ2() {
        return this == LINKWITZT;
    }

    boolean hasShape() {
        switch (this) {
            case LOWPASS: 
            case HIGHPASS: {
                return true;
            }
        }
        return false;
    }

    boolean isPK() {
        switch (this) {
            case PEAKING: 
            case MODAL: {
                return true;
            }
        }
        return false;
    }

    boolean hasQNonPK() {
        switch (this) {
            case LSQ: 
            case HSQ: 
            case LINKWITZT: 
            case LPQ: 
            case HPQ: 
            case RESONANT: 
            case ALLPASS: 
            case NOTCHQ: {
                return true;
            }
        }
        return false;
    }

    boolean hasAdjustableQ() {
        return (this.isPK() || this.hasQNonPK()) && this != MODAL;
    }

    boolean isShelf() {
        switch (this) {
            case LSQ: 
            case HSQ: 
            case ASYMMETRIC: 
            case LOWSHELF: 
            case HIGHSHELF: 
            case LS: 
            case HS: {
                return true;
            }
        }
        return false;
    }

    boolean allowsAutomatic() {
        switch (this) {
            case PEAKING: 
            case NONE: 
            case MODAL: {
                return true;
            }
        }
        return false;
    }

    static {
        groupToType = new HashMap();
        groupToType.put(PEAKING, Filter.FilterTypes.PK);
        groupToType.put(ALLPASS, Filter.FilterTypes.AP);
        groupToType.put(LPQ, Filter.FilterTypes.LPQ);
        groupToType.put(HPQ, Filter.FilterTypes.HPQ);
        groupToType.put(LS, Filter.FilterTypes.LS);
        groupToType.put(HS, Filter.FilterTypes.HS);
        groupToType.put(LSQ, Filter.FilterTypes.LSQ);
        groupToType.put(HSQ, Filter.FilterTypes.HSQ);
        groupToType.put(MODAL, Filter.FilterTypes.MODAL);
        groupToType.put(NOTCH, Filter.FilterTypes.NO);
        groupToType.put(NOTCHQ, Filter.FilterTypes.NOQ);
        groupToType.put(RESONANT, Filter.FilterTypes.RES);
        groupToType.put(LINKWITZT, Filter.FilterTypes.LINKWITZT);
        typeToGroup = new HashMap();
        typeToGroup.put(Filter.FilterTypes.PK, PEAKING);
        typeToGroup.put(Filter.FilterTypes.AP, ALLPASS);
        typeToGroup.put(Filter.FilterTypes.LPQ, LPQ);
        typeToGroup.put(Filter.FilterTypes.HPQ, HPQ);
        typeToGroup.put(Filter.FilterTypes.LSQ, LSQ);
        typeToGroup.put(Filter.FilterTypes.HSQ, HSQ);
        typeToGroup.put(Filter.FilterTypes.LS, LS);
        typeToGroup.put(Filter.FilterTypes.HS, HS);
        typeToGroup.put(Filter.FilterTypes.MODAL, MODAL);
        typeToGroup.put(Filter.FilterTypes.NO, NOTCH);
        typeToGroup.put(Filter.FilterTypes.NOQ, NOTCHQ);
        typeToGroup.put(Filter.FilterTypes.RES, RESONANT);
        typeToGroup.put(Filter.FilterTypes.LINKWITZT, LINKWITZT);
        canConvert = new HashMap();
        canConvert.put(Filter.FilterTypes.LP, LOWPASS);
        canConvert.put(Filter.FilterTypes.HP, HIGHPASS);
        canConvert.put(Filter.FilterTypes.LP1, LOWPASS);
        canConvert.put(Filter.FilterTypes.HP1, HIGHPASS);
        canConvert.put(Filter.FilterTypes.HS6, HIGHSHELF);
        canConvert.put(Filter.FilterTypes.HS12, HIGHSHELF);
        canConvert.put(Filter.FilterTypes.LS6, LOWSHELF);
        canConvert.put(Filter.FilterTypes.LS12, LOWSHELF);
    }
}

