/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.event.SwingPropertyChangeSupport;
import roomeqwizard.AE;
import roomeqwizard.DA;
import roomeqwizard.EK;
import roomeqwizard.Equaliser;
import roomeqwizard.FilterGroup;
import roomeqwizard.FilterResponse;
import roomeqwizard.HE;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.XOverChoice;
import roomeqwizard.XOverShape;
import roomeqwizard.XOverSlope;
import roomeqwizard.XOverType;
import roomeqwizard.YH;
import roomeqwizard.qK;

class Filter
implements Comparable,
Serializable,
FilterResponse {
    static final long serialVersionUID = -4660202271775858613L;
    private static final double SQRT2OVER2;
    static final int MANUAL = 0;
    static final int AUTOMATIC = 1;
    static final double DEFAULT_FC = 100.0;
    static final double PK_DEFAULT_Q = 10.0;
    static final double NOTCH_Q = 30.0;
    static final double NOQ_Q;
    static final double HPLP_DEFAULT_Q;
    static final double BP_DEFAULT_Q = 0.3333333333333333;
    static final double SHELF_DEFAULT_Q = 0.7071;
    static final double DEFAULT_FSAMPLE = 48000.0;
    static final double LK_DEFAULT_FC = 50.0;
    static final double LK_DEFAULT_FC2 = 30.0;
    static final double LK_DEFAULT_Q = 1.2;
    static final double LK_DEFAULT_Q2 = 0.5;
    static final int SORTKEY_FREQ = 0;
    static final int SORTKEY_GAIN = 1;
    static final int SORTKEY_Q = 2;
    static final int SORTKEY_BW = 3;
    static final int SORTKEY_AREA = 4;
    private static int sortKey;
    static final int NO_SORT = 0;
    static final int SORT_ASCENDING = 1;
    static final int SORT_DESCENDING = 2;
    private static int sortDirn;
    static final String FILTER_ENABLED = "Filter.enabled";
    private FilterTypes filterType;
    private int control = 1;
    private boolean enabled = true;
    private boolean assignedForMatch = false;
    private int type;
    private double fc = 100.0;
    private double Q = 10.0;
    private double gain = 0.0;
    private double a0;
    private double a1;
    private double a2;
    private double b0;
    private double b1;
    private double b2;
    private double aC2;
    private double aC3;
    private double bC2;
    private double bC3;
    private double aSum;
    private double bSum;
    private double p1;
    private double p2;
    private double p3;
    private double p4;
    private double p5;
    private double sampleRate;
    private double freqNorm;
    private double t60Target = 0.3;
    private double M = 1.0;
    private double m = 1.0;
    @Deprecated
    private XOverChoice xOverChoice;
    @Deprecated
    private XOverType xOverType;
    private FilterGroup group;
    private XOverSlope slope;
    private XOverSlope slope2;
    private XOverShape shape;
    private double xOverGain;
    private double fc2;
    private double q2;
    private int xOverIndex;
    private double omega;
    private double cs;
    private double sn;
    private double A;
    private double alpha;
    private double betasn;
    private double sTh;
    private double sTh2;
    private transient Color color;
    private transient boolean highlighted = false;
    private transient boolean calcDone = false;
    private transient double calcRate = 0.0;
    private transient int index;
    private transient SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl = false;
        for (PropertyChangeListener propertyChangeListener2 : this.pcs.getPropertyChangeListeners()) {
            if (!propertyChangeListener2.equals(propertyChangeListener)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removeAllPropertyChangeListeners() {
        for (PropertyChangeListener propertyChangeListener : this.pcs.getPropertyChangeListeners()) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    Filter() {
        this(48000.0);
    }

    Filter(double d2) {
        this.filterType = FilterTypes.NONE;
        this.sampleRate = d2;
        this.freqNorm = Math.PI * 2 / this.sampleRate;
        this.a0 = 1.0;
        this.a1 = 0.0;
        this.a2 = 0.0;
        this.b0 = 1.0;
        this.b1 = 0.0;
        this.b2 = 0.0;
    }

    Filter(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this(d2);
        this.a0 = d6;
        this.a1 = d7;
        this.a2 = d8;
        this.b0 = d3;
        this.b1 = d4;
        this.b2 = d5;
        this.calcIntermediates();
    }

    Filter(FilterTypes filterTypes) {
        this(48000.0);
        this.setFilterType(filterTypes);
    }

    Filter(FilterTypes filterTypes, double d2) {
        this(d2);
        this.setFilterType(filterTypes);
    }

    public Object readResolve() throws ObjectStreamException {
        this.pcs = new SwingPropertyChangeSupport(this);
        this.calcDone = false;
        this.calcRate = 0.0;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 2;
        int n3 = 3;
        int n4 = 4;
        int n5 = 5;
        int n6 = 6;
        int n7 = 7;
        int n8 = 8;
        int n9 = 9;
        int n10 = 10;
        if (this.filterType == null) {
            switch (this.type) {
                case 0: {
                    this.filterType = FilterTypes.NONE;
                    break;
                }
                case 1: {
                    this.filterType = FilterTypes.PK;
                    break;
                }
                case 10: {
                    this.filterType = FilterTypes.MODAL;
                    break;
                }
                case 2: {
                    this.filterType = FilterTypes.LP;
                    break;
                }
                case 3: {
                    this.filterType = FilterTypes.HP;
                    break;
                }
                case 8: {
                    this.filterType = FilterTypes.LP2;
                    break;
                }
                case 9: {
                    this.filterType = FilterTypes.HP2;
                    break;
                }
                case 4: {
                    this.filterType = FilterTypes.LS;
                    break;
                }
                case 5: {
                    this.filterType = FilterTypes.HS;
                    break;
                }
                case 6: {
                    this.filterType = FilterTypes.NO;
                    break;
                }
                default: {
                    this.filterType = FilterTypes.NONE;
                }
            }
        }
        return this;
    }

    XOverChoice getXOverChoice() {
        return this.xOverChoice;
    }

    void setXOverChoice(XOverChoice xOverChoice) {
        assert (false) : "getting filter xOverChoice";
        XOverChoice xOverChoice2 = this.xOverChoice;
        this.xOverChoice = xOverChoice;
        this.pcs.firePropertyChange("Filter.xOverChoice", (Object)xOverChoice2, (Object)this.xOverChoice);
    }

    XOverType getXOverType() {
        return this.xOverType;
    }

    void setXOverType(XOverType xOverType) {
        assert (false) : "setting filter xOVerType";
        XOverType xOverType2 = this.xOverType;
        this.xOverType = xOverType;
        this.pcs.firePropertyChange("Filter.xOverType", (Object)xOverType2, (Object)this.xOverType);
    }

    void clearXOverFilterSettings() {
        this.group = null;
        this.xOverIndex = 0;
        this.slope = null;
        this.slope2 = null;
        this.shape = null;
        this.fc2 = 0.0;
        this.xOverGain = 0.0;
        this.xOverChoice = null;
        this.xOverType = null;
    }

    FilterGroup getGroup() {
        return this.group;
    }

    void setGroup(FilterGroup filterGroup) {
        this.group = filterGroup;
    }

    XOverSlope getSlope() {
        return this.slope;
    }

    void setSlope(XOverSlope xOverSlope) {
        this.slope = xOverSlope;
    }

    XOverSlope getSlope2() {
        return this.slope2;
    }

    void setSlope2(XOverSlope xOverSlope) {
        this.slope2 = xOverSlope;
    }

    XOverShape getShape() {
        return this.shape;
    }

    void setShape(XOverShape xOverShape) {
        this.shape = xOverShape;
    }

    double getXOverGain() {
        return this.xOverGain;
    }

    void setXOverGain(double d2) {
        this.xOverGain = d2;
    }

    void setFilterFc2(double d2) {
        if (d2 > 0.0 && d2 != this.fc2) {
            boolean bl = this.hasNoEffect();
            double d3 = this.fc2;
            this.fc2 = d2;
            if (this.filterType.hasFreq2()) {
                this.calcBiquad(this.sampleRate);
                if (!bl || !this.hasNoEffect()) {
                    this.pcs.firePropertyChange("Filter.fc2", d3, this.fc2);
                }
            }
        }
    }

    double getFilterQ2() {
        return this.q2;
    }

    void setFilterQ2(double d2) {
        if (d2 > 0.0 && d2 != this.q2) {
            boolean bl = this.hasNoEffect();
            double d3 = d2;
            this.q2 = d2;
            if (this.filterType.hasQ2()) {
                this.calcBiquad(this.sampleRate);
                if (!bl || !this.hasNoEffect()) {
                    this.pcs.firePropertyChange("Filter.Q2", d3, d2);
                }
            }
        }
    }

    double getShelfOrder() {
        return this.M;
    }

    void setShelfParams(double d2, double d3, double d4, double d5) {
        this.fc = d2;
        this.gain = d3;
        this.M = d4;
        this.m = d5;
        this.calcBiquad(this.sampleRate);
        this.pcs.firePropertyChange("Filter.shelfParams", false, true);
    }

    double getShelfSection() {
        return this.m;
    }

    int getXOverIndex() {
        return this.xOverIndex;
    }

    void setXOverIndex(int n2) {
        this.xOverIndex = n2;
    }

    static void setSortKey(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                assert (false) : "Invalid sort key for filters, " + n2;
                n2 = 0;
            }
        }
        sortKey = n2;
    }

    static int getSortKey() {
        return sortKey;
    }

    static void setSortDirn(int n2) {
        switch (n2) {
            case 1: {
                sortDirn = 1;
                break;
            }
            default: {
                sortDirn = -1;
            }
        }
    }

    static int getSortDirn() {
        return sortDirn;
    }

    public int compareTo(Object object) {
        Filter filter = (Filter)object;
        if (filter.filterType == FilterTypes.NONE || !filter.isEnabled()) {
            return -1;
        }
        if (this.filterType == FilterTypes.NONE || !this.isEnabled()) {
            return 1;
        }
        switch (filter.filterType) {
            case PK: 
            case MODAL: {
                if (this.filterType == FilterTypes.PK || this.filterType == FilterTypes.MODAL) {
                    switch (sortKey) {
                        case 0: {
                            if (filter.fc < this.fc) {
                                return sortDirn;
                            }
                            if (filter.fc == this.fc) {
                                return 0;
                            }
                            return -sortDirn;
                        }
                        case 2: {
                            if (filter.Q < this.Q) {
                                return sortDirn;
                            }
                            if (filter.Q == this.Q) {
                                return 0;
                            }
                            return -sortDirn;
                        }
                        case 3: {
                            if (filter.fc / filter.Q < this.fc / this.Q) {
                                return sortDirn;
                            }
                            if (filter.fc / filter.Q == this.fc / this.Q) {
                                return 0;
                            }
                            return -sortDirn;
                        }
                        case 4: {
                            if (Math.abs(filter.gain / filter.Q) < Math.abs(this.gain / this.Q)) {
                                return sortDirn;
                            }
                            if (Math.abs(filter.gain / filter.Q) == Math.abs(this.gain / this.Q)) {
                                return 0;
                            }
                            return -sortDirn;
                        }
                    }
                    if (filter.gain < this.gain) {
                        return sortDirn;
                    }
                    if (filter.gain == this.gain) {
                        return 0;
                    }
                    return -sortDirn;
                }
                switch (sortKey) {
                    case 0: {
                        if (filter.fc < this.fc) {
                            return sortDirn;
                        }
                        if (filter.fc == this.fc) {
                            return 0;
                        }
                        return -sortDirn;
                    }
                    case 1: {
                        if (this.filterType.hasGain()) {
                            if (filter.gain < this.gain) {
                                return sortDirn;
                            }
                            if (filter.gain == this.gain) {
                                return 0;
                            }
                            return -sortDirn;
                        }
                        return 1;
                    }
                }
                return 1;
            }
        }
        if (this.filterType == FilterTypes.PK || this.filterType == FilterTypes.MODAL) {
            switch (sortKey) {
                case 0: {
                    if (filter.fc < this.fc) {
                        return sortDirn;
                    }
                    if (filter.fc == this.fc) {
                        return 0;
                    }
                    return -sortDirn;
                }
                case 1: {
                    if (filter.filterType.hasGain()) {
                        if (filter.gain < this.gain) {
                            return sortDirn;
                        }
                        if (filter.gain == this.gain) {
                            return 0;
                        }
                        return -sortDirn;
                    }
                    return -1;
                }
                case 2: {
                    if (filter.filterType.isPK() || filter.filterType.hasQNonPK()) {
                        if (filter.Q < this.Q) {
                            return sortDirn;
                        }
                        if (filter.Q == this.Q) {
                            return 0;
                        }
                        return -sortDirn;
                    }
                    return -1;
                }
            }
            return -1;
        }
        switch (sortKey) {
            case 1: {
                if (filter.filterType.hasGain() && this.filterType.hasGain()) {
                    if (filter.gain < this.gain) {
                        return sortDirn;
                    }
                    if (filter.gain == this.gain) {
                        return 0;
                    }
                    return -sortDirn;
                }
                if (filter.filterType.hasGain()) {
                    return 1;
                }
                if (filter.fc < this.fc) {
                    return sortDirn;
                }
                if (filter.fc == this.fc) {
                    return 0;
                }
                return -sortDirn;
            }
            case 2: {
                if ((filter.filterType.isPK() || filter.filterType.hasQNonPK()) && (this.filterType.isPK() || this.filterType.hasQNonPK())) {
                    if (filter.Q < this.Q) {
                        return sortDirn;
                    }
                    if (filter.Q == this.Q) {
                        return 0;
                    }
                    return -sortDirn;
                }
                if (filter.filterType.isPK() || filter.filterType.hasQNonPK()) {
                    return 1;
                }
                if (filter.fc < this.fc) {
                    return sortDirn;
                }
                if (filter.fc == this.fc) {
                    return 0;
                }
                return -sortDirn;
            }
        }
        if (filter.fc < this.fc) {
            return sortDirn;
        }
        if (filter.fc == this.fc) {
            return 0;
        }
        return -sortDirn;
    }

    private void calcBiquad(double d2) {
        double d3 = Math.PI * 2 / d2;
        this.omega = this.fc * d3;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        double d4 = Math.sin(this.omega / 2.0);
        double d5 = Math.cos(this.omega / 2.0);
        double d6 = 2.0 * d4 * d4;
        double d7 = 2.0 * d5 * d5;
        this.A = Math.pow(10.0, this.gain / 40.0);
        switch (this.filterType) {
            case LINKWITZT: {
                double d8 = (this.fc + this.fc2) * 0.5;
                double d9 = Math.pow(Math.PI * 2 * this.fc, 2.0);
                double d10 = Math.PI * 2 * this.fc / this.Q;
                double d11 = 1.0;
                double d12 = Math.pow(Math.PI * 2 * this.fc2, 2.0);
                double d13 = Math.PI * 2 * this.fc2 / this.q2;
                double d14 = 1.0;
                double d15 = Math.PI * 2 * d8 / Math.tan(Math.PI * d8 / d2);
                double d16 = d12 + d15 * (d13 + d15 * d14);
                this.a0 = 1.0;
                this.a1 = 2.0 * (d12 - d15 * d15) * d14 / d16;
                this.a2 = (d12 - d15 * d13 + d15 * d15 * d14) / d16;
                this.b0 = (d9 + d15 * d10 + d15 * d15 * d11) / d16;
                this.b1 = 2.0 * (d9 - d15 * d15 * d11) / d16;
                this.b2 = (d9 - d15 * d10 + d15 * d15 + d11) / d16;
                this.calcIntermediates();
                break;
            }
            case RES: {
                double d17 = 0.999;
                double d18 = 9.994999999999865E-4;
                this.b0 = 9.994999999999865E-4;
                this.b1 = 0.0;
                this.b2 = -this.b0;
                this.a0 = 1.0;
                this.a1 = -this.cs * 1.998001;
                this.a2 = 0.998001;
                double d19 = 1.0 + this.a1 * this.a1 + this.a2 * this.a2;
                this.aC2 = 2.0 * this.a1 * (1.0 + this.a2);
                this.aC3 = 2.0 * this.a2;
                this.aSum = d19 + this.aC2 + this.aC3;
                double d20 = 2.0 * this.b0 * this.b0;
                this.bC2 = 0.0;
                this.bC3 = -d20;
                this.bSum = 0.0;
                this.p1 = 1.998000499999946E-6;
                this.p2 = 0.0;
                this.p3 = -this.p1;
                this.p4 = 0.001998999999999973 * this.a1;
                this.p5 = 0.003994003998999946;
                break;
            }
            case PK: 
            case MODAL: {
                this.alpha = this.sn / (2.0 * this.Q);
                this.b0 = 1.0 + this.alpha * this.A;
                this.b1 = -2.0 * this.cs;
                this.b2 = 1.0 - this.alpha * this.A;
                this.a0 = 1.0 + this.alpha / this.A;
                this.a1 = -2.0 * this.cs;
                this.a2 = 1.0 - this.alpha / this.A;
                this.aC2 = -8.0 * this.cs;
                this.aC3 = 2.0 * (1.0 - this.alpha * this.alpha / this.A / this.A);
                this.aSum = 16.0 * d4 * d4 * d4 * d4;
                this.bC2 = this.aC2;
                this.bC3 = 2.0 * (1.0 - this.alpha * this.alpha * this.A * this.A);
                this.bSum = this.aSum;
                this.p1 = 2.0 * (this.alpha * this.alpha + 2.0 * this.cs * this.cs + 1.0);
                this.p2 = -8.0 * this.cs;
                this.p3 = -2.0 * this.alpha * this.alpha + 2.0;
                this.p4 = -4.0 * this.cs * this.alpha * (this.A - 1.0 / this.A);
                this.p5 = 4.0 * this.alpha * (this.A - 1.0 / this.A);
                break;
            }
            case LP: {
                this.Q = SQRT2OVER2;
            }
            case LPQ: {
                this.alpha = this.sn / (2.0 * this.Q);
                this.b0 = d6 / 2.0;
                this.b1 = d6;
                this.b2 = this.b0;
                this.a0 = 1.0 + this.alpha;
                this.a1 = -2.0 * this.cs;
                this.a2 = 1.0 - this.alpha;
                this.aC2 = 4.0 * this.a1;
                this.aC3 = 2.0 * this.a0 * this.a2;
                this.aSum = 4.0 * d6 * d6;
                this.bC2 = 8.0 * this.b0 * this.b0;
                this.bC3 = 2.0 * this.b0 * this.b0;
                this.bSum = 16.0 * this.b0 * this.b0;
                this.p1 = d6 * (1.0 - 2.0 * this.cs);
                this.p2 = 2.0 * d6 * d6;
                this.p3 = d6;
                this.p5 = this.p4 = -2.0 * d6 * this.alpha;
                break;
            }
            case HP: {
                this.Q = SQRT2OVER2;
            }
            case HPQ: {
                this.alpha = this.sn / (2.0 * this.Q);
                this.b0 = d7 / 2.0;
                this.b1 = -d7;
                this.b2 = this.b0;
                this.a0 = 1.0 + this.alpha;
                this.a1 = -2.0 * this.cs;
                this.a2 = 1.0 - this.alpha;
                this.aC2 = 4.0 * this.a1;
                this.aC3 = 2.0 * this.a0 * this.a2;
                this.aSum = 4.0 * d6 * d6;
                this.bC2 = -8.0 * this.b0 * this.b0;
                this.bC3 = 2.0 * this.b0 * this.b0;
                this.bSum = 0.0;
                this.p1 = d7 * (1.0 + 2.0 * this.cs);
                this.p2 = -2.0 * d7 * d7;
                this.p3 = d7;
                this.p4 = 2.0 * d7 * this.alpha;
                this.p5 = -this.p4;
                break;
            }
            case LS: {
                this.lowShelf(1.0);
                break;
            }
            case HS: {
                this.highShelf(1.0);
                break;
            }
            case LSQ: {
                this.lowShelf(this.qToS(this.Q));
                break;
            }
            case HSQ: {
                this.highShelf(this.qToS(this.Q));
                break;
            }
            case BASS_8C: {
                this.fc = 250.0;
                this.Q = 0.3;
                this.lowShelf(this.qToS(this.Q));
                break;
            }
            case SUB_8C: {
                this.fc = 125.0;
                this.Q = 1.0;
                this.lowShelf(this.qToS(this.Q));
                break;
            }
            case TREBLE_8C: {
                this.fc = 2000.0;
                this.Q = 0.3;
                this.highShelf(this.qToS(this.Q));
                break;
            }
            case LS6: {
                double d21 = Math.pow(10.0, Math.abs(this.gain) / 40.0);
                this.omega = 2.0 * Math.atan(Math.PI * this.correctedFc(this.fc, d3) * d21 / d2);
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                this.lowShelf(0.5);
                break;
            }
            case HS6: {
                double d22 = Math.pow(10.0, Math.abs(this.gain) / 40.0);
                this.omega = 2.0 * Math.atan(Math.PI * this.correctedFc(this.fc, d3) / d22 / d2);
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                this.highShelf(0.5);
                break;
            }
            case LS12: {
                double d23 = Math.pow(10.0, Math.abs(this.gain) / 80.0);
                this.omega = 2.0 * Math.atan(Math.PI * this.correctedFc(this.fc, d3) * d23 / d2);
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                this.lowShelf(1.0);
                break;
            }
            case HS12: {
                double d24 = Math.pow(10.0, Math.abs(this.gain) / 80.0);
                this.omega = 2.0 * Math.atan(Math.PI * this.correctedFc(this.fc, d3) / d24 / d2);
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                this.highShelf(1.0);
                break;
            }
            case LSODD: {
                this.calcOddSection(this.M, d6, this.gain > 0.0);
                if (this.gain > 0.0) {
                    this.flipCoefficients();
                }
                this.calcIntermediates();
                break;
            }
            case HSODD: {
                this.omega = (0.5 * d2 - this.fc) * d3;
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                d4 = Math.sin(this.omega / 2.0);
                d6 = 2.0 * d4 * d4;
                this.calcOddSection(this.M, d6, this.gain > 0.0);
                if (this.gain > 0.0) {
                    this.flipCoefficients();
                }
                this.a1 = -this.a1;
                this.b1 = -this.b1;
                this.calcIntermediates();
                break;
            }
            case HSEVEN: {
                this.omega = (0.5 * d2 - this.fc) * d3;
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                d4 = Math.sin(this.omega / 2.0);
                d5 = Math.cos(this.omega / 2.0);
                d6 = 2.0 * d4 * d4;
                d7 = 2.0 * d5 * d5;
                this.calcEvenSection(this.M, this.m, d7, d6, this.gain > 0.0);
                if (this.gain > 0.0) {
                    this.flipCoefficients();
                }
                this.a1 = -this.a1;
                this.b1 = -this.b1;
                this.calcIntermediates();
                break;
            }
            case HS2ODD: {
                this.omega = (0.5 * d2 - this.fc) * d3;
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                d4 = Math.sin(this.omega / 2.0);
                d6 = 2.0 * d4 * d4;
                this.calcOddSection(this.M, d6, this.gain < 0.0);
                if (this.gain < 0.0) {
                    this.flipCoefficients();
                }
                this.a1 = -this.a1;
                this.b1 = -this.b1;
                this.calcIntermediates();
                break;
            }
            case LSEVEN: {
                this.calcEvenSection(this.M, this.m, d7, d6, this.gain > 0.0);
                if (this.gain > 0.0) {
                    this.flipCoefficients();
                }
                this.calcIntermediates();
                break;
            }
            case HS2EVEN: {
                this.omega = (0.5 * d2 - this.fc) * d3;
                this.cs = Math.cos(this.omega);
                this.sn = Math.sin(this.omega);
                d4 = Math.sin(this.omega / 2.0);
                d5 = Math.cos(this.omega / 2.0);
                d6 = 2.0 * d4 * d4;
                d7 = 2.0 * d5 * d5;
                this.calcEvenSection(this.M, this.m, d7, d6, this.gain < 0.0);
                if (this.gain < 0.0) {
                    this.flipCoefficients();
                }
                this.a1 = -this.a1;
                this.b1 = -this.b1;
                this.calcIntermediates();
                break;
            }
            case LS12OA: {
                this.lowShelf(1.0);
                break;
            }
            case HS12OA: {
                this.highShelf(1.0);
                break;
            }
            case NO: {
                this.Q = 30.0;
                this.initNotch(d6);
                break;
            }
            case NOQ: {
                this.initNotch(d6);
                break;
            }
            case BP: {
                this.b0 = this.alpha = this.sn * Math.sinh(Math.log(2.0) / 2.0 * this.Q * this.omega / this.sn);
                this.b1 = 0.0;
                this.b2 = -this.b0;
                this.a0 = 1.0 + this.alpha;
                this.a1 = -2.0 * this.cs;
                this.a2 = 1.0 - this.alpha;
                this.calcIntermediates();
                break;
            }
            case LP2: {
                this.b0 = this.omega * this.omega / 4.0;
                this.b1 = 2.0 * this.b0;
                this.b2 = this.b0;
                this.a0 = (1.0 + this.omega / 2.0) * (1.0 + this.omega / 2.0);
                this.a1 = -2.0 * (1.0 + this.omega / 2.0) * (1.0 - this.omega / 2.0);
                this.a2 = (1.0 - this.omega / 2.0) * (1.0 - this.omega / 2.0);
                this.calcIntermediates();
                break;
            }
            case HP2: {
                this.b0 = 1.0;
                this.b1 = -2.0;
                this.b2 = 1.0;
                this.a0 = (1.0 + this.omega / 2.0) * (1.0 + this.omega / 2.0);
                this.a1 = -2.0 * (1.0 + this.omega / 2.0) * (1.0 - this.omega / 2.0);
                this.a2 = (1.0 - this.omega / 2.0) * (1.0 - this.omega / 2.0);
                this.calcIntermediates();
                break;
            }
            case AP: {
                this.alpha = this.sn / (2.0 * this.Q);
                this.b0 = 1.0 - this.alpha;
                this.b1 = -2.0 * this.cs;
                this.b2 = 1.0 + this.alpha;
                this.a0 = 1.0 + this.alpha;
                this.a1 = -2.0 * this.cs;
                this.a2 = 1.0 - this.alpha;
                double d25 = this.a0 * this.a0 + this.a1 * this.a1 + this.a2 * this.a2;
                this.aC2 = 4.0 * this.a1;
                this.aC3 = 2.0 * this.a0 * this.a2;
                this.aSum = d25 + this.aC2 + this.aC3;
                double d26 = this.b0 * this.b0 + this.b1 * this.b1 + this.b2 * this.b2;
                this.bC2 = 4.0 * this.b1;
                this.bC3 = 2.0 * this.b0 * this.b2;
                this.bSum = d26 + this.bC2 + this.bC3;
                this.p1 = 2.0 * ((1.0 + this.alpha) * (1.0 - this.alpha) + 2.0 * this.cs * this.cs);
                this.p2 = -8.0 * this.cs;
                this.p3 = 2.0 * (1.0 + this.alpha * this.alpha);
                this.p4 = 8.0 * this.alpha * this.cs;
                this.p5 = -8.0 * this.alpha;
                break;
            }
            case LP1: {
                boolean bl = true;
                if (bl) {
                    this.a0 = this.sn + d7;
                    this.a1 = this.sn - d7;
                    this.a2 = 0.0;
                    this.b0 = this.sn;
                    this.b1 = this.sn;
                    this.b2 = 0.0;
                    this.aC2 = -4.0 * this.cs * d7;
                    this.aC3 = 0.0;
                    this.aSum = 4.0 * this.sn * this.sn;
                    this.bC2 = 2.0 * this.sn * this.sn;
                    this.bC3 = 0.0;
                    this.bSum = 4.0 * this.sn * this.sn;
                    this.p2 = this.p1 = 2.0 * this.sn * this.sn;
                    this.p3 = 0.0;
                    this.p4 = -2.0 * this.sn * d7;
                    this.p5 = 0.0;
                    break;
                }
                double d27 = 1.0 / Math.tan(Math.PI * this.fc / d2);
                this.b0 = 1.0;
                this.b1 = 0.0;
                this.b2 = -1.0;
                this.a0 = d27 + 1.0;
                this.a1 = -2.0 * d27;
                this.a2 = d27 - 1.0;
                this.aC2 = -8.0 * d27 * d27;
                this.aC3 = 2.0 * this.a0 * this.a2;
                this.aSum = 0.0;
                this.bC2 = 0.0;
                this.bC3 = -2.0;
                this.bSum = 0.0;
                this.p1 = 2.0;
                this.p2 = 0.0;
                this.p3 = -2.0;
                this.p4 = -4.0 * d27;
                this.p5 = 4.0 * d27;
                break;
            }
            case HP1: {
                double d28;
                boolean bl = true;
                if (bl) {
                    this.a0 = this.sn + d7;
                    this.a1 = this.sn - d7;
                    this.a2 = 0.0;
                    this.b0 = d7;
                    this.b1 = -this.b0;
                    this.b2 = 0.0;
                    this.aC2 = -4.0 * this.cs * d7;
                    this.aC3 = 0.0;
                    this.aSum = 4.0 * this.sn * this.sn;
                    this.bC2 = -2.0 * d7 * d7;
                    this.bC3 = 0.0;
                    this.bSum = 0.0;
                    this.p1 = 2.0 * d7 * d7;
                    this.p2 = -this.p1;
                    this.p3 = 0.0;
                    this.p4 = 2.0 * d7 * this.sn;
                    this.p5 = 0.0;
                    break;
                }
                this.b0 = d28 = 1.0 / Math.tan(Math.PI * this.fc / d2);
                this.b1 = -2.0 * d28;
                this.b2 = d28;
                this.a0 = d28 + 1.0;
                this.a1 = -2.0 * d28;
                this.a2 = d28 - 1.0;
                this.aC2 = -8.0 * d28 * d28;
                this.aC3 = 2.0 * this.a0 * this.a2;
                this.aSum = 0.0;
                this.bC2 = -8.0 * d28 * d28;
                this.bC3 = 2.0 * d28 * d28;
                this.bSum = 0.0;
                this.p1 = 6.0 * d28 * d28;
                this.p2 = -8.0 * d28 * d28;
                this.p3 = 2.0 * d28 * d28;
                this.p4 = 4.0 * d28;
                this.p5 = -this.p4;
                break;
            }
            default: {
                this.a0 = 1.0;
                this.a1 = 0.0;
                this.a2 = 0.0;
                this.b0 = 1.0;
                this.b1 = 0.0;
                this.b2 = 0.0;
                this.aC2 = 0.0;
                this.aC3 = 0.0;
                this.aSum = 1.0;
                this.bC2 = 0.0;
                this.bC3 = 0.0;
                this.bSum = 1.0;
                this.p1 = 1.0;
                this.p2 = 0.0;
                this.p3 = 0.0;
                this.p4 = 0.0;
                this.p5 = 0.0;
            }
        }
        this.calcDone = true;
        this.calcRate = d2;
    }

    private void flipCoefficients() {
        double d2 = this.a0;
        double d3 = this.a1;
        double d4 = this.a2;
        this.a0 = this.b0;
        this.a1 = this.b1;
        this.a2 = this.b2;
        this.b0 = d2;
        this.b1 = d3;
        this.b2 = d4;
    }

    private double correctedFc(double d2, double d3) {
        double d4 = 2.0 + 0.015707963267948967 * Math.exp(10.98 * d2 / this.sampleRate);
        double d5 = 0.5 * d2 * d3;
        double d6 = Math.pow(d5 / Math.sin(d5), d4);
        return d2 * d6;
    }

    private void initNotch(double d2) {
        this.alpha = this.sn / (2.0 * this.Q);
        this.b0 = 1.0;
        this.b1 = -2.0 * this.cs;
        this.b2 = 1.0;
        this.a0 = 1.0 + this.alpha;
        this.a1 = -2.0 * this.cs;
        this.a2 = 1.0 - this.alpha;
        this.aC2 = -8.0 * this.cs;
        this.aC3 = 2.0 * (1.0 - this.alpha) * (1.0 + this.alpha);
        this.aSum = 4.0 * d2 * d2;
        this.bC2 = this.aC2;
        this.bC3 = 2.0;
        this.bSum = this.aSum;
        this.p1 = 4.0 * this.cs * this.cs + 2.0;
        this.p2 = -8.0 * this.cs;
        this.p3 = 2.0;
        this.p4 = 4.0 * this.cs * this.alpha;
        this.p5 = -4.0 * this.alpha;
    }

    private double qToS(double d2) {
        return 1.0 / (1.0 + (1.0 / (d2 * d2) - 2.0) / (this.A + 1.0 / this.A));
    }

    private void lowShelf(double d2) {
        this.Q = 1.0 / Math.sqrt((this.A + 1.0 / this.A) * (1.0 / d2 - 1.0) + 2.0);
        this.betasn = Math.sqrt((this.A * this.A + 1.0) / d2 - (this.A - 1.0) * (this.A - 1.0)) * this.sn;
        this.b0 = this.A * (this.A + 1.0 - (this.A - 1.0) * this.cs + this.betasn);
        this.b1 = 2.0 * this.A * (this.A - 1.0 - (this.A + 1.0) * this.cs);
        this.b2 = this.A * (this.A + 1.0 - (this.A - 1.0) * this.cs - this.betasn);
        this.a0 = this.A + 1.0 + (this.A - 1.0) * this.cs + this.betasn;
        this.a1 = -2.0 * (this.A - 1.0 + (this.A + 1.0) * this.cs);
        this.a2 = this.A + 1.0 + (this.A - 1.0) * this.cs - this.betasn;
        this.calcIntermediates();
    }

    private void highShelf(double d2) {
        this.Q = 1.0 / Math.sqrt((this.A + 1.0 / this.A) * (1.0 / d2 - 1.0) + 2.0);
        this.betasn = Math.sqrt((this.A * this.A + 1.0) / d2 - (this.A - 1.0) * (this.A - 1.0)) * this.sn;
        this.b0 = this.A * (this.A + 1.0 + (this.A - 1.0) * this.cs + this.betasn);
        this.b1 = -2.0 * this.A * (this.A - 1.0 + (this.A + 1.0) * this.cs);
        this.b2 = this.A * (this.A + 1.0 + (this.A - 1.0) * this.cs - this.betasn);
        this.a0 = this.A + 1.0 - (this.A - 1.0) * this.cs + this.betasn;
        this.a1 = 2.0 * (this.A - 1.0 - (this.A + 1.0) * this.cs);
        this.a2 = this.A + 1.0 - (this.A - 1.0) * this.cs - this.betasn;
        this.calcIntermediates();
    }

    private void calcIntermediates() {
        double d2 = this.a0 * this.a0 + this.a1 * this.a1 + this.a2 * this.a2;
        this.aC2 = 2.0 * this.a1 * (this.a0 + this.a2);
        this.aC3 = 2.0 * this.a0 * this.a2;
        this.aSum = d2 + this.aC2 + this.aC3;
        double d3 = this.b0 * this.b0 + this.b1 * this.b1 + this.b2 * this.b2;
        this.bC2 = 2.0 * this.b1 * (this.b0 + this.b2);
        this.bC3 = 2.0 * this.b0 * this.b2;
        this.bSum = d3 + this.bC2 + this.bC3;
        this.p1 = this.a0 * this.b0 + this.a1 * this.b1 + this.a2 * this.b2;
        this.p2 = this.b1 * (this.a0 + this.a2) + this.a1 * (this.b0 + this.b2);
        this.p3 = this.a0 * this.b2 + this.a2 * this.b0;
        this.p4 = this.a1 * (this.b0 - this.b2) - this.b1 * (this.a0 - this.a2);
        this.p5 = 2.0 * (-this.a0 * this.b2 + this.a2 * this.b0);
    }

    boolean isAutomatic() {
        return this.control == 1;
    }

    void setAssignedForMatch(boolean bl) {
        this.assignedForMatch = bl;
    }

    boolean wasAssignedForMatch() {
        return this.assignedForMatch;
    }

    boolean useForMatch() {
        if (this.enabled && this.filterType.allowsAutomatic()) {
            return this.control == 1;
        }
        return false;
    }

    boolean showAsAutomatic() {
        return this.filterType.allowsAutomatic() && this.control == 1;
    }

    void setAutomatic(boolean bl) {
        this.control = bl ? 1 : 0;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    FilterTypes getFilterType() {
        return this.filterType;
    }

    @Override
    public double getFilterFc() {
        return this.fc;
    }

    @Override
    public boolean plotFullSpan() {
        return false;
    }

    double getFilterFc2() {
        return this.fc2;
    }

    @Override
    public double getFilterQ() {
        return this.Q;
    }

    double getFilterT60Target() {
        return this.t60Target;
    }

    @Override
    public double getFilterGain() {
        return this.gain;
    }

    @Override
    public float getFilterMagnSq(float f2, float f3) {
        if (!this.isActive() || this.filterType == FilterTypes.AP) {
            return 1.0f;
        }
        if ((double)f2 >= this.sampleRate / 2.0) {
            f2 = (float)(0.9999 * this.sampleRate / 2.0);
        }
        if (Math.abs(this.fc - (double)f2) < (double)(f3 / 2.0f)) {
            f2 = (float)this.fc;
        }
        return (float)this.getMagnSq(f2);
    }

    @Override
    public float getFilterDisabledMagnSq(float f2, float f3) {
        if ((double)f2 >= this.sampleRate / 2.0) {
            f2 = (float)(0.9999 * this.sampleRate / 2.0);
        }
        if (Math.abs(this.fc - (double)f2) < (double)(f3 / 2.0f)) {
            f2 = (float)this.fc;
        }
        return (float)this.getDisabledMagnSq(f2);
    }

    @Override
    public boolean isActive() {
        return this.isEnabled() && this.filterType != FilterTypes.NONE;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int n2) {
        this.index = n2;
    }

    @Override
    public boolean hasGain() {
        return this.filterType.hasGain();
    }

    @Override
    public boolean hasAdjustableQ() {
        return this.filterType.hasAdjustableQ();
    }

    @Override
    public boolean isPk() {
        return this.filterType.isPK();
    }

    void setColor(Color color) {
        this.color = color;
    }

    double getMagnSq(double d2) {
        if (!this.enabled || this.filterType == FilterTypes.NONE || this.filterType == FilterTypes.AP) {
            return 1.0;
        }
        if (d2 >= this.sampleRate / 2.0) {
            d2 = 0.9999 * this.sampleRate / 2.0;
        }
        if (!this.calcDone) {
            this.calcBiquad(this.sampleRate);
        }
        double d3 = d2 * this.freqNorm;
        this.sTh = Math.sin(d3);
        this.sTh = 2.0 * this.sTh * this.sTh;
        this.sTh2 = Math.sin(d3 / 2.0);
        this.sTh2 = 2.0 * this.sTh2 * this.sTh2;
        double d4 = this.aSum - (this.aC2 * this.sTh2 + this.aC3 * this.sTh);
        double d5 = this.bSum - (this.bC2 * this.sTh2 + this.bC3 * this.sTh);
        return Math.abs(d5 / d4);
    }

    double getDisabledMagnSq(double d2) {
        if (this.filterType == FilterTypes.NONE) {
            return 1.0;
        }
        if (d2 >= this.sampleRate / 2.0) {
            d2 = 0.9999 * this.sampleRate / 2.0;
        }
        if (!this.calcDone) {
            this.calcBiquad(this.sampleRate);
        }
        double d3 = d2 * this.freqNorm;
        this.sTh = Math.sin(d3);
        this.sTh = 2.0 * this.sTh * this.sTh;
        this.sTh2 = Math.sin(d3 / 2.0);
        this.sTh2 = 2.0 * this.sTh2 * this.sTh2;
        double d4 = this.aSum - (this.aC2 * this.sTh2 + this.aC3 * this.sTh);
        double d5 = this.bSum - (this.bC2 * this.sTh2 + this.bC3 * this.sTh);
        return Math.abs(d5 / d4);
    }

    double getsTh() {
        return this.sTh;
    }

    double getsTh2() {
        return this.sTh2;
    }

    double getFreqNorm() {
        return this.freqNorm;
    }

    double getMagnSq(double d2, double d3) {
        if (this.hasNoEffect()) {
            return 1.0;
        }
        if (!this.calcDone) {
            this.calcBiquad(this.sampleRate);
        }
        double d4 = this.aSum - (this.aC2 * d3 + this.aC3 * d2);
        double d5 = this.bSum - (this.bC2 * d3 + this.bC3 * d2);
        return d5 / d4;
    }

    double getMagnSqFast(double d2, double d3) {
        double d4 = this.aSum - (this.aC2 * d3 + this.aC3 * d2);
        double d5 = this.bSum - (this.bC2 * d3 + this.bC3 * d2);
        return d5 / d4;
    }

    AE getMagnSqPhi(double d2) {
        if (this.hasNoEffect()) {
            return new AE(1.0, 0.0);
        }
        double d3 = d2 * this.freqNorm;
        double d4 = Math.sin(d3);
        double d5 = 2.0 * d4 * d4;
        double d6 = Math.sin(d3 / 2.0);
        double d7 = 2.0 * d6 * d6;
        double d8 = this.aSum - (this.aC2 * d7 + this.aC3 * d5);
        double d9 = this.bSum - (this.bC2 * d7 + this.bC3 * d5);
        double d10 = Math.cos(d3);
        double d11 = Math.cos(2.0 * d3);
        return new AE(d9 / d8, Math.atan2((this.p4 + this.p5 * d10) * d4, this.p1 + this.p2 * d10 + this.p3 * d11));
    }

    AE getMagnSqPhi(double d2, qK qK2) {
        if (this.hasNoEffect()) {
            return new AE(1.0, 0.0);
        }
        double d3 = this.aSum - (this.aC2 * qK2.D + this.aC3 * qK2.A);
        double d4 = this.bSum - (this.bC2 * qK2.D + this.bC3 * qK2.A);
        return new AE(d4 / d3, Math.atan2((this.p4 + this.p5 * qK2.B) * qK2.E, this.p1 + this.p2 * qK2.B + this.p3 * qK2.F));
    }

    float getFilterdB(float f2) {
        float f3 = this.getFilterMagnSq(f2, 0.0f);
        return (float)(10.0 * Math.log10(Math.max(f3, Float.MIN_VALUE)));
    }

    float getFilterPhase(float f2) {
        double d2 = (double)f2 * this.freqNorm;
        double d3 = Math.cos(d2);
        double d4 = Math.cos(2.0 * d2);
        return (float)Math.toDegrees(Math.atan2((this.p4 + this.p5 * d3) * Math.sin(d2), this.p1 + this.p2 * d3 + this.p3 * d4));
    }

    @Override
    public int getSampleRate() {
        return (int)this.sampleRate;
    }

    void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            boolean bl2 = this.hasNoEffect();
            this.enabled = bl;
            if (!bl2 || !this.hasNoEffect()) {
                this.pcs.firePropertyChange(FILTER_ENABLED, !bl, bl);
            }
        }
    }

    void setSampleRate(double d2) {
        this.sampleRate = d2;
        this.freqNorm = Math.PI * 2 / this.sampleRate;
        this.calcBiquad(this.sampleRate);
    }

    final void setFilterType(FilterTypes filterTypes) {
        if (filterTypes != this.filterType) {
            this.assignedForMatch = false;
            boolean bl = this.hasNoEffect();
            FilterTypes filterTypes2 = this.filterType;
            this.filterType = filterTypes;
            switch (this.filterType) {
                case NONE: {
                    this.gain = 0.0;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case LINKWITZT: {
                    this.gain = 0.0;
                    this.fc = 50.0;
                    this.fc2 = 30.0;
                    this.Q = 1.2;
                    this.q2 = 0.5;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case MODAL: {
                    if (this.t60Target > 0.0) {
                        double d2 = Math.PI * 2 / this.sampleRate;
                        double d3 = this.fc * d2;
                        double d4 = Math.sin(d3);
                        double d5 = Math.pow(10.0, this.gain / 40.0);
                        double d6 = Math.exp(-2.0 * Math.log(1000.0) / (this.sampleRate * this.t60Target));
                        this.Q = 0.5 * d5 * d4 * (1.0 + d6) / (1.0 - d6);
                    } else {
                        this.gain = 0.0;
                    }
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case PK: {
                    if (filterTypes2 != FilterTypes.MODAL) {
                        this.gain = 0.0;
                    }
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case RES: 
                case LP: 
                case HP: 
                case NO: 
                case LP2: 
                case HP2: 
                case LP1: 
                case HP1: {
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case LPQ: 
                case HPQ: 
                case AP: {
                    if (filterTypes2 == FilterTypes.NONE) {
                        this.fc = 100.0;
                    }
                    this.Q = HPLP_DEFAULT_Q;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case NOQ: {
                    if (filterTypes2 == FilterTypes.NONE) {
                        this.fc = 100.0;
                    }
                    this.Q = NOQ_Q;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case LS: 
                case HS: 
                case LS6: 
                case HS6: 
                case LS12: 
                case HS12: 
                case LS12OA: 
                case HS12OA: 
                case LSODD: 
                case LSEVEN: 
                case HSODD: 
                case HSEVEN: 
                case HS2ODD: 
                case HS2EVEN: {
                    if (!filterTypes2.isShelf()) {
                        this.gain = 0.0;
                    }
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case BASS_8C: {
                    this.fc = 250.0;
                    this.Q = 0.3;
                    this.gain = 0.0;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case TREBLE_8C: {
                    this.fc = 2000.0;
                    this.Q = 0.3;
                    this.gain = 0.0;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case SUB_8C: {
                    this.fc = 125.0;
                    this.Q = 1.0;
                    this.gain = 0.0;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case LSQ: 
                case HSQ: {
                    if (!filterTypes2.isShelf()) {
                        this.gain = 0.0;
                    }
                    this.Q = 0.7071;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                case BP: {
                    this.fc = 100.0;
                    this.Q = 0.3333333333333333;
                    this.calcBiquad(this.sampleRate);
                    break;
                }
                default: {
                    assert (false) : "unhandled filter type: " + (Object)((Object)this.filterType);
                    break;
                }
            }
            if (!bl || !this.hasNoEffect()) {
                this.pcs.firePropertyChange("Filter.type", (Object)filterTypes2, (Object)this.filterType);
            }
        }
    }

    boolean hasNoEffect() {
        if (!this.enabled || this.filterType == FilterTypes.NONE) {
            return true;
        }
        switch (this.filterType) {
            case LPQ: 
            case HPQ: 
            case RES: 
            case AP: 
            case NOQ: 
            case LINKWITZT: 
            case LP: 
            case HP: 
            case NO: 
            case BP: 
            case LP2: 
            case HP2: 
            case LP1: 
            case HP1: 
            case COEFF: {
                return false;
            }
            case PK: 
            case LSQ: 
            case HSQ: 
            case BASS_8C: 
            case TREBLE_8C: 
            case SUB_8C: 
            case LS: 
            case HS: 
            case LS6: 
            case HS6: 
            case LS12: 
            case HS12: 
            case LS12OA: 
            case HS12OA: 
            case MODAL: 
            case LSODD: 
            case LSEVEN: 
            case HSODD: 
            case HSEVEN: 
            case HS2ODD: 
            case HS2EVEN: {
                return this.gain == 0.0;
            }
        }
        assert (false) : "unhandled filter type: " + (Object)((Object)this.filterType);
        return false;
    }

    public String toString() {
        return Filter.getDescription(this, true);
    }

    public ArrayList<String> toStringTokens() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.showAsAutomatic() ? "Auto" : "Manual");
        Equaliser equaliser = YH.\u0161() ? YH.\u0164().\u0167() : RoomEQ_Wizard.l;
        String string2 = this.filterType.toString();
        arrayList.add(string2);
        if (this.filterType.hasFreq()) {
            string = this.fc < 99.995 ? HE.L.format(this.fc) : (this.fc < 999.95 ? HE.T.format(this.fc) : HE.H.format(this.fc));
            arrayList.add(string);
        }
        switch (this.filterType) {
            case LINKWITZT: {
                arrayList.add("");
                arrayList.add(HE.L.format(this.Q));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                string = HE.H.format(this.fc2);
                arrayList.add(string);
                arrayList.add(HE.L.format(this.q2));
                break;
            }
            case PK: {
                arrayList.add(HE.L.format(this.gain));
                double d2 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                arrayList.add(this.formattedQ(d2, equaliser.getQFormat(d2), false));
                arrayList.add(this.filterBWHzFormat(this.fc / this.Q));
                break;
            }
            case MODAL: {
                arrayList.add(HE.L.format(this.gain));
                double d3 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                arrayList.add(this.formattedQ(d3, equaliser.getQFormat(d3), false));
                arrayList.add(this.filterBWHzFormat(this.fc / this.Q));
                arrayList.add(HE.H.format(1000.0 * this.t60Target));
                break;
            }
            case RES: 
            case LP: 
            case HP: 
            case NO: 
            case LP2: 
            case HP2: 
            case LP1: 
            case HP1: {
                break;
            }
            case BASS_8C: 
            case TREBLE_8C: 
            case SUB_8C: 
            case LS: 
            case HS: 
            case LS6: 
            case HS6: 
            case LS12: 
            case HS12: 
            case LS12OA: 
            case HS12OA: {
                arrayList.add(HE.L.format(this.gain));
                break;
            }
            case LSQ: 
            case HSQ: {
                arrayList.add(HE.L.format(this.gain));
                arrayList.add(Filter.filterQFormat(this.Q));
                break;
            }
            case LPQ: 
            case HPQ: 
            case AP: 
            case NOQ: {
                arrayList.add(HE.L.format(0L));
                arrayList.add(Filter.filterQFormat(this.Q));
                break;
            }
            case NONE: 
            case COEFF: {
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)this.filterType);
                break;
            }
        }
        return arrayList;
    }

    public ArrayList<String> toStringTokens(Equaliser equaliser) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.showAsAutomatic() ? "Auto" : "Manual");
        String string2 = this.filterType.toString();
        arrayList.add(string2);
        if (this.filterType.hasFreq()) {
            string = this.format(this.fc, equaliser.getMaxFreqDP());
            arrayList.add(string);
        }
        switch (this.filterType) {
            case LINKWITZT: {
                arrayList.add("");
                arrayList.add(this.format(this.Q, equaliser.getMaxQNonPKDP()));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                string = this.format(this.fc2, equaliser.getMaxFreqDP());
                arrayList.add(string);
                arrayList.add(this.format(this.q2, equaliser.getMaxQNonPKDP()));
                break;
            }
            case PK: {
                arrayList.add(this.format(this.gain, equaliser.getMaxGainDP()));
                double d2 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                arrayList.add(this.formattedQ(d2, equaliser.getQFormat(d2), false));
                arrayList.add(this.filterBWHzFormat(this.fc / this.Q));
                break;
            }
            case MODAL: {
                arrayList.add(this.format(this.gain, equaliser.getMaxGainDP()));
                double d3 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                arrayList.add(this.formattedQ(d3, equaliser.getQFormat(d3), false));
                arrayList.add(this.filterBWHzFormat(this.fc / this.Q));
                arrayList.add(HE.H.format(1000.0 * this.t60Target));
                break;
            }
            case RES: 
            case LP: 
            case HP: 
            case NO: 
            case LP2: 
            case HP2: 
            case LP1: 
            case HP1: {
                break;
            }
            case BASS_8C: 
            case TREBLE_8C: 
            case SUB_8C: 
            case LS: 
            case HS: 
            case LS6: 
            case HS6: 
            case LS12: 
            case HS12: 
            case LS12OA: 
            case HS12OA: {
                arrayList.add(this.format(this.gain, equaliser.getMaxGainDP()));
                break;
            }
            case LSQ: 
            case HSQ: {
                arrayList.add(this.format(this.gain, equaliser.getMaxGainDP()));
                arrayList.add(Filter.filterQFormat(this.Q));
                break;
            }
            case LPQ: 
            case HPQ: 
            case AP: 
            case NOQ: {
                arrayList.add(this.format(0.0, equaliser.getMaxGainDP()));
                arrayList.add(Filter.filterQFormat(this.Q));
                break;
            }
            case NONE: 
            case COEFF: {
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)this.filterType);
                break;
            }
        }
        return arrayList;
    }

    static String filterQFormat(double d2) {
        if (d2 < 1.0) {
            return HE.B.format(d2);
        }
        if (d2 < 10.0) {
            return HE.L.format(d2);
        }
        return HE.T.format(d2);
    }

    private String filterBWHzFormat(double d2) {
        if (d2 < 99.95) {
            return HE.L.format(d2);
        }
        if (d2 < 999.5) {
            return HE.T.format(d2);
        }
        return HE.H.format(d2);
    }

    private String format(double d2, int n2) {
        switch (n2) {
            case 3: {
                return HE.B.format(d2);
            }
            case 2: {
                return HE.L.format(d2);
            }
            case 1: {
                return HE.T.format(d2);
            }
            case 0: {
                return HE.H.format(d2);
            }
        }
        return HE.L.format(d2);
    }

    public String toFormattedString(Equaliser equaliser) {
        String string;
        if (this.filterType.equals((Object)FilterTypes.NONE)) {
            return this.filterType.toFixedWidthSt();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.filterType.toFixedWidthSt();
        if (this.filterType.hasFreq()) {
            stringBuilder.append(string2).append("  Fc ");
            string = this.paddedFC(equaliser);
            stringBuilder.append(string).append(" Hz ");
        }
        switch (this.filterType) {
            case LINKWITZT: {
                stringBuilder.append(" Q ");
                string = "  " + this.format(this.Q, equaliser.getMaxQNonPKDP());
                if (string.length() == 3) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string);
                stringBuilder.append(" Fp ").append(this.format(this.fc2, equaliser.getMaxFreqDP()));
                stringBuilder.append(" Qp ");
                stringBuilder.append(this.format(this.q2, equaliser.getMaxQNonPKDP()));
                break;
            }
            case PK: {
                if (equaliser.freqLabelReqd) {
                    stringBuilder.append("(").append(equaliser.getFreqLabelText(this.fc)).append(")");
                }
                stringBuilder.append(" Gain ").append(this.paddedGain(equaliser)).append(" dB  ");
                stringBuilder.append(equaliser.getQHeader().trim()).append(" ");
                double d2 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                string = this.formattedQ(d2, equaliser.getQFormat(d2), true);
                stringBuilder.append(string);
                break;
            }
            case MODAL: {
                if (equaliser.freqLabelReqd) {
                    stringBuilder.append("(").append(equaliser.getFreqLabelText(this.fc)).append(")");
                }
                stringBuilder.append(" Gain ").append(this.paddedGain()).append(" dB  ");
                stringBuilder.append(equaliser.getQHeader().trim()).append(" ");
                double d3 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                string = this.formattedQ(d3, equaliser.getQFormat(d3), true);
                stringBuilder.append(string);
                string = HE.H.format(1000.0 * this.t60Target);
                switch (string.length()) {
                    case 2: {
                        string = "   " + string;
                        break;
                    }
                    case 3: {
                        string = "  " + string;
                        break;
                    }
                    case 4: {
                        string = " " + string;
                        break;
                    }
                }
                stringBuilder.append("  T60 target ").append(string).append(" ms");
                break;
            }
            case RES: 
            case LP: 
            case HP: 
            case NO: 
            case LP2: 
            case HP2: 
            case LP1: 
            case HP1: {
                break;
            }
            case BASS_8C: 
            case TREBLE_8C: 
            case SUB_8C: 
            case LS: 
            case HS: 
            case LS6: 
            case HS6: 
            case LS12: 
            case HS12: 
            case LS12OA: 
            case HS12OA: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain(equaliser)).append(" dB");
                break;
            }
            case LSQ: 
            case HSQ: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain(equaliser)).append(" dB");
                stringBuilder.append(" Q ");
                stringBuilder.append(this.paddedQNonPK(equaliser));
                break;
            }
            case LPQ: 
            case HPQ: 
            case AP: 
            case NOQ: {
                stringBuilder.append(" Q ");
                stringBuilder.append(this.paddedQNonPK(equaliser));
                break;
            }
            case COEFF: {
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)this.filterType);
                break;
            }
        }
        return stringBuilder.toString();
    }

    public String toFormattedString() {
        String string;
        if (this.filterType.equals((Object)FilterTypes.NONE)) {
            return this.filterType.toFixedWidthSt();
        }
        Equaliser equaliser = YH.\u0161() ? YH.\u0164().\u0167() : RoomEQ_Wizard.l;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.filterType.toFixedWidthSt();
        if (this.filterType.hasFreq()) {
            stringBuilder.append(string2).append("  Fc ");
            string = this.fc < 99.995 ? this.paddedFC2dp() : (this.fc < 999.95 ? this.paddedFC1dp() : this.paddedFC());
            stringBuilder.append(string).append(" Hz ");
        }
        switch (this.filterType) {
            case LINKWITZT: {
                stringBuilder.append(" Q ");
                string = "  " + HE.L.format(this.Q);
                if (string.length() == 3) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string);
                stringBuilder.append(" Fp ").append(HE.H.format(this.fc2));
                stringBuilder.append(" Qp ");
                stringBuilder.append(HE.L.format(this.q2));
                break;
            }
            case PK: {
                if (equaliser.freqLabelReqd) {
                    stringBuilder.append("(").append(equaliser.getFreqLabelText(this.fc)).append(")");
                }
                stringBuilder.append(" Gain ").append(this.paddedGain()).append(" dB  ");
                stringBuilder.append(equaliser.getQHeader().trim()).append(" ");
                double d2 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                string = this.formattedQ(d2, equaliser.getQFormat(d2), true);
                stringBuilder.append(string);
                break;
            }
            case MODAL: {
                if (equaliser.freqLabelReqd) {
                    stringBuilder.append("(").append(equaliser.getFreqLabelText(this.fc)).append(")");
                }
                stringBuilder.append(" Gain ").append(this.paddedGain()).append(" dB  ");
                stringBuilder.append(equaliser.getQHeader().trim()).append(" ");
                double d3 = equaliser.qToDisp(this.Q, this.gain, this.fc);
                string = this.formattedQ(d3, equaliser.getQFormat(d3), true);
                stringBuilder.append(string);
                string = HE.H.format(1000.0 * this.t60Target);
                switch (string.length()) {
                    case 2: {
                        string = "   " + string;
                        break;
                    }
                    case 3: {
                        string = "  " + string;
                        break;
                    }
                    case 4: {
                        string = " " + string;
                        break;
                    }
                }
                stringBuilder.append("  T60 target ").append(string).append(" ms");
                break;
            }
            case RES: 
            case LP: 
            case HP: 
            case NO: 
            case LP2: 
            case HP2: 
            case LP1: 
            case HP1: {
                break;
            }
            case BASS_8C: 
            case TREBLE_8C: 
            case SUB_8C: 
            case LS: 
            case HS: 
            case LS6: 
            case HS6: 
            case LS12: 
            case HS12: 
            case LS12OA: 
            case HS12OA: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain()).append(" dB");
                break;
            }
            case LSQ: 
            case HSQ: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain()).append(" dB");
                stringBuilder.append(" Q ");
                string = this.Q < 1.0 ? " " + HE.B.format(this.Q) : (this.Q < 10.0 ? "  " + HE.L.format(this.Q) : "  " + HE.T.format(this.Q));
                if (string.length() == 3) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string);
                break;
            }
            case LPQ: 
            case HPQ: 
            case AP: 
            case NOQ: {
                stringBuilder.append(" Q ");
                string = this.Q < 1.0 ? " " + HE.B.format(this.Q) : (this.Q < 10.0 ? "  " + HE.L.format(this.Q) : "  " + HE.T.format(this.Q));
                if (string.length() == 3) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string);
                break;
            }
            case COEFF: {
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)this.filterType);
                break;
            }
        }
        return stringBuilder.toString();
    }

    String paddedGain() {
        String string = HE.L.format(this.gain);
        switch (string.length()) {
            case 3: {
                return "   " + string;
            }
            case 4: {
                return "  " + string;
            }
            case 5: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedGain(Equaliser equaliser) {
        String string = this.format(this.gain, equaliser.getMaxGainDP());
        switch (string.length()) {
            case 3: {
                return "   " + string;
            }
            case 4: {
                return "  " + string;
            }
            case 5: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedQNonPK(Equaliser equaliser) {
        String string = this.format(this.gain, equaliser.getMaxQNonPKDP());
        switch (string.length()) {
            case 3: {
                return "   " + string;
            }
            case 4: {
                return "  " + string;
            }
            case 5: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC(Equaliser equaliser) {
        String string = this.format(this.fc, equaliser.getMaxFreqDP());
        switch (string.length()) {
            case 2: {
                return "     " + string;
            }
            case 3: {
                return "    " + string;
            }
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC() {
        String string = HE.H.format(this.fc);
        switch (string.length()) {
            case 2: {
                return "     " + string;
            }
            case 3: {
                return "    " + string;
            }
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC1dp() {
        String string = HE.T.format(this.fc);
        switch (string.length()) {
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC2dp() {
        String string = HE.L.format(this.fc);
        switch (string.length()) {
            case 3: {
                return "    " + string;
            }
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    private String formattedQ(double d2, String string, boolean bl) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).applyPattern(string);
            HE.A((DecimalFormat)numberFormat);
        }
        String string2 = numberFormat.format(d2);
        if (!bl) {
            return string2;
        }
        switch (string2.length()) {
            case 1: {
                return "     " + string2;
            }
            case 2: {
                return "    " + string2;
            }
            case 3: {
                return "   " + string2;
            }
            case 4: {
                return "  " + string2;
            }
            case 5: {
                return " " + string2;
            }
        }
        return string2;
    }

    DA getPoleZero(double d2) {
        double d3 = Math.log(1000.0) / d2;
        DA dA2 = new DA();
        if (this.calcRate != d2 || !this.calcDone) {
            this.calcBiquad(d2);
        }
        if (4.0 * this.a2 * this.a0 > this.a1 * this.a1) {
            dA2.F = new EK(-(0.5 * this.a1 / this.a0), 0.5 * Math.sqrt(4.0 * this.a2 * this.a0 - this.a1 * this.a1) / this.a0);
            dA2.E = EK.G(dA2.F);
            dA2.A = -d3 / Math.log(EK.H(dA2.F));
        } else {
            dA2.F = new EK(-(0.5 / this.a0) * (this.a1 + Math.sqrt(this.a1 * this.a1 - 4.0 * this.a2 * this.a0)), 0.0);
            dA2.E = new EK(-(0.5 / this.a0) * (this.a1 - Math.sqrt(this.a1 * this.a1 - 4.0 * this.a2 * this.a0)), 0.0);
            dA2.A = 0.0;
        }
        if (4.0 * this.b2 * this.b0 > this.b1 * this.b1) {
            dA2.D = new EK(-(0.5 * this.b1 / this.b0), 0.5 * Math.sqrt(4.0 * this.b2 * this.b0 - this.b1 * this.b1) / this.b0);
            dA2.C = EK.G(dA2.D);
            dA2.B = -d3 / Math.log(EK.H(dA2.D));
        } else {
            dA2.D = new EK(-(0.5 / this.b0) * (this.b1 + Math.sqrt(this.b1 * this.b1 - 4.0 * this.b2 * this.b0)), 0.0);
            dA2.C = new EK(-(0.5 / this.b0) * (this.b1 - Math.sqrt(this.b1 * this.b1 - 4.0 * this.b2 * this.b0)), 0.0);
            dA2.B = 0.0;
        }
        if (d2 != this.sampleRate) {
            this.calcBiquad(this.sampleRate);
        }
        return dA2;
    }

    static String getDescription(Filter filter, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (filter.filterType) {
            case LINKWITZT: {
                stringBuilder.append("LT ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.L.format(filter.Q));
                stringBuilder.append("Fp = ");
                stringBuilder.append(HE.H.format(filter.fc2));
                stringBuilder.append("Qp = ");
                stringBuilder.append(HE.L.format(filter.q2));
                break;
            }
            case NONE: {
                stringBuilder.append("None");
                break;
            }
            case PK: {
                stringBuilder.append("PA ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB, ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.L.format(filter.Q));
                break;
            }
            case MODAL: {
                stringBuilder.append("Modal ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB, ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.L.format(filter.Q));
                stringBuilder.append(", T60 = ");
                stringBuilder.append(HE.B.format(filter.t60Target));
                break;
            }
            case LP: {
                stringBuilder.append("Low pass ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case HP: {
                stringBuilder.append("High pass ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case LPQ: {
                stringBuilder.append("Low pass ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.B.format(filter.Q));
                break;
            }
            case HPQ: {
                stringBuilder.append("High pass ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.B.format(filter.Q));
                break;
            }
            case LP1: {
                stringBuilder.append("Low pass 1st ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case HP1: {
                stringBuilder.append("High pass 1st ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case LS: 
            case LS12OA: {
                stringBuilder.append("Low shelf ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case HS: 
            case HS12OA: {
                stringBuilder.append("High shelf ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case LSQ: {
                stringBuilder.append("Low shelf ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB, ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.B.format(filter.Q));
                break;
            }
            case HSQ: {
                stringBuilder.append("High shelf ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB, ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.B.format(filter.Q));
                break;
            }
            case LS6: {
                stringBuilder.append("Low shelf 6dB/octave ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case HS6: {
                stringBuilder.append("High shelf 6dB/octave ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case LS12: {
                stringBuilder.append("Low shelf 12dB/octave ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case HS12: {
                stringBuilder.append("High shelf 12dB/octave ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case LSODD: {
                stringBuilder.append("Low shelf ").append((int)filter.M * 6).append(" dB/octave odd section ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case HSODD: {
                stringBuilder.append("High shelf ").append((int)filter.M * 6).append(" dB/octave odd section ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case HS2ODD: {
                stringBuilder.append("High shelf 2 ").append((int)filter.M * 6).append(" dB/octave odd section ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case LSEVEN: {
                stringBuilder.append("Low shelf ").append((int)filter.M * 6).append(" dB/octave even section ").append((int)filter.m).append(" ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case HSEVEN: {
                stringBuilder.append("High shelf ").append((int)filter.M * 6).append(" dB/octave even section ").append((int)filter.m).append(" ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case HS2EVEN: {
                stringBuilder.append("High shelf 2 ").append((int)filter.M * 6).append(" dB/octave even section ").append((int)filter.m).append(" ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append(HE.T.format(filter.gain));
                stringBuilder.append(" dB");
                break;
            }
            case NO: {
                stringBuilder.append("Notch ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case NOQ: {
                stringBuilder.append("Notch ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case RES: {
                stringBuilder.append("Resonator ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case AP: {
                stringBuilder.append("All pass ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(", ");
                stringBuilder.append("Q = ");
                stringBuilder.append(HE.A(filter.fc));
                break;
            }
            case COEFF: {
                stringBuilder.append("Coeff");
                break;
            }
            case BASS_8C: {
                stringBuilder.append("Bass 8c ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(" dB");
                break;
            }
            case SUB_8C: {
                stringBuilder.append("Sub 8c ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(" dB");
                break;
            }
            case TREBLE_8C: {
                stringBuilder.append("Treble 8c ");
                stringBuilder.append(HE.A(filter.fc));
                stringBuilder.append(" dB");
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)filter.filterType);
                break;
            }
        }
        if (bl) {
            stringBuilder.append(", ");
            stringBuilder.append(filter.showAsAutomatic() ? "automatic, " : "manual, ");
            stringBuilder.append(filter.isEnabled() ? "enabled" : "disabled");
        }
        return stringBuilder.toString();
    }

    static Filter copy(Filter filter) {
        Filter filter2 = new Filter();
        if (filter != null) {
            filter2.setEnabled(filter.enabled);
            filter2.setSampleRate(filter.getSampleRate());
            filter2.setFilterType(filter.filterType);
            filter2.setFilterFc(filter.fc);
            filter2.setFilterQ(filter.Q);
            if (filter.filterType == FilterTypes.MODAL) {
                filter2.setFilterT60Target(filter.t60Target);
            }
            filter2.setFilterGain(filter.gain);
            filter2.setAutomatic(filter.isAutomatic());
            filter2.setGroup(filter.group);
            filter2.setShape(filter.shape);
            filter2.setSlope(filter.slope);
            filter2.setFilterFc2(filter.fc2);
            filter2.setFilterQ2(filter.q2);
            filter2.setXOverGain(filter.xOverGain);
            filter2.setXOverIndex(filter.xOverIndex);
            filter2.setAssignedForMatch(filter.wasAssignedForMatch());
            filter2.setColor(filter.getColor());
        }
        return filter2;
    }

    Filter copy() {
        return Filter.copy(this);
    }

    boolean matches(Filter filter) {
        return this.a0 == filter.a0 && this.a1 == filter.a1 && this.a2 == filter.a2 && this.b0 == filter.b0 && this.b1 == filter.b1 && this.b2 == filter.b2;
    }

    void setFilterFc(double d2) {
        if (d2 > 0.0 && d2 != this.fc) {
            boolean bl = this.hasNoEffect();
            double d3 = this.fc;
            this.fc = d2;
            if (this.filterType == FilterTypes.MODAL && this.t60Target > 0.0) {
                double d4 = Math.PI * 2 / this.sampleRate;
                double d5 = this.fc * d4;
                double d6 = Math.sin(d5);
                double d7 = Math.pow(10.0, this.gain / 40.0);
                double d8 = Math.exp(-2.0 * Math.log(1000.0) / (this.sampleRate * this.t60Target));
                this.Q = 0.5 * d7 * d6 * (1.0 + d8) / (1.0 - d8);
            }
            if (this.filterType.hasFreq()) {
                this.calcBiquad(this.sampleRate);
            }
            if (!bl || !this.hasNoEffect()) {
                this.pcs.firePropertyChange("Filter.fc", d3, this.fc);
            }
        }
    }

    void setFilterQ(double d2) {
        if (d2 > 0.0 && d2 != this.Q) {
            boolean bl = this.hasNoEffect();
            double d3 = this.Q;
            this.Q = d2;
            if (this.filterType.isPK() || this.filterType.hasQNonPK()) {
                this.calcBiquad(this.sampleRate);
            }
            if (!bl || !this.hasNoEffect()) {
                this.pcs.firePropertyChange("Filter.Q", d3, this.Q);
            }
        }
    }

    void setFilterT60Target(double d2) {
        if (d2 > 0.0 && d2 != this.t60Target) {
            boolean bl = this.hasNoEffect();
            double d3 = this.t60Target;
            this.t60Target = d2;
            if (this.t60Target > 0.0) {
                double d4 = Math.PI * 2 / this.sampleRate;
                double d5 = this.fc * d4;
                double d6 = Math.sin(d5);
                double d7 = Math.pow(10.0, this.gain / 40.0);
                double d8 = Math.exp(-2.0 * Math.log(1000.0) / (this.sampleRate * this.t60Target));
                this.Q = 0.5 * d7 * d6 * (1.0 + d8) / (1.0 - d8);
            }
            if (this.filterType.hasT60()) {
                this.calcBiquad(this.sampleRate);
            }
            if (!bl || !this.hasNoEffect()) {
                this.pcs.firePropertyChange("Filter.T60", d3, this.t60Target);
            }
        }
    }

    void setFilterGain(double d2) {
        if (d2 != this.gain) {
            boolean bl = this.hasNoEffect();
            double d3 = this.gain;
            this.gain = d2;
            if (this.filterType == FilterTypes.MODAL && this.t60Target > 0.0) {
                double d4 = Math.PI * 2 / this.sampleRate;
                double d5 = this.fc * d4;
                double d6 = Math.sin(d5);
                double d7 = Math.pow(10.0, this.gain / 40.0);
                double d8 = Math.exp(-2.0 * Math.log(1000.0) / (this.sampleRate * this.t60Target));
                this.Q = 0.5 * d7 * d6 * (1.0 + d8) / (1.0 - d8);
            }
            if (this.filterType.hasGain()) {
                this.calcBiquad(this.sampleRate);
            }
            if (!bl || !this.hasNoEffect()) {
                this.pcs.firePropertyChange("Filter.gain", d3, this.gain);
            }
        }
    }

    double[] getCoefficients(double d2) {
        double[] dArray = new double[5];
        if (this.enabled) {
            this.calcBiquad(d2);
            dArray[0] = this.a1 / this.a0;
            dArray[1] = this.a2 / this.a0;
            dArray[2] = this.b0 / this.a0;
            dArray[3] = this.b1 / this.a0;
            dArray[4] = this.b2 / this.a0;
            this.calcBiquad(this.sampleRate);
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 1.0;
            dArray[3] = 0.0;
            dArray[4] = 0.0;
        }
        return dArray;
    }

    double[] getCoefficients() {
        double[] dArray = new double[5];
        if (this.enabled) {
            dArray[0] = this.a1 / this.a0;
            dArray[1] = this.a2 / this.a0;
            dArray[2] = this.b0 / this.a0;
            dArray[3] = this.b1 / this.a0;
            dArray[4] = this.b2 / this.a0;
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 1.0;
            dArray[3] = 0.0;
            dArray[4] = 0.0;
        }
        return dArray;
    }

    double[] getAllCoefficients() {
        double[] dArray = new double[6];
        if (this.enabled) {
            dArray[0] = this.a0;
            dArray[1] = this.a1;
            dArray[2] = this.a2;
            dArray[3] = this.b0;
            dArray[4] = this.b1;
            dArray[5] = this.b2;
        } else {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = 1.0;
            dArray[4] = 0.0;
            dArray[5] = 0.0;
        }
        return dArray;
    }

    void calcOddSection(double d2, double d3, boolean bl) {
        double d4 = bl ? 1.0 / (this.A * this.A) : this.A * this.A;
        double d5 = Math.pow(d4, -1.0 / d2);
        double d6 = d5 * d3;
        this.a0 = this.sn + d6;
        this.a1 = 2.0 * d6;
        this.a2 = d6 - this.sn;
        this.b0 = this.sn + d3;
        this.b1 = 2.0 * d3;
        this.b2 = d3 - this.sn;
    }

    void calcEvenSection(double d2, double d3, double d4, double d5, boolean bl) {
        double d6 = 1.5707963267948966 * (1.0 - (2.0 * d3 - 1.0) / d2);
        double d7 = Math.cos(d6);
        double d8 = bl ? 1.0 / (this.A * this.A) : this.A * this.A;
        double d9 = Math.pow(d8, -1.0 / d2);
        double d10 = 2.0 * d7 * d9 * this.sn;
        double d11 = d9 * d9 * d5;
        double d12 = 2.0 * d7 * this.sn;
        this.a0 = d4 + d10 + d11;
        this.a1 = 2.0 * (d11 - d4);
        this.a2 = d4 + d11 - d10;
        this.b0 = 2.0 + d12;
        this.b1 = -4.0 * this.cs;
        this.b2 = 2.0 - d12;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    static {
        NOQ_Q = SQRT2OVER2 = Math.sqrt(2.0) / 2.0;
        HPLP_DEFAULT_Q = SQRT2OVER2;
        sortKey = 0;
        sortDirn = 1;
    }

    static enum FilterTypes {
        NONE("None"),
        PK("PK"),
        LP("LP"),
        HP("HP"),
        LS("LS"),
        HS("HS"),
        NO("Notch"),
        BP("BP"),
        LP2("LP2"),
        HP2("HP2"),
        MODAL("Modal"),
        LS6("LS 6dB"),
        LS12("LS 12dB"),
        HS6("HS 6dB"),
        HS12("HS 12dB"),
        LSQ("LS Q"),
        HSQ("HS Q"),
        RES("RES"),
        HPQ("HP Q"),
        LPQ("LP Q"),
        AP("All pass"),
        LS12OA("LS"),
        HS12OA("HS"),
        COEFF("Coeff"),
        LP1("LP1"),
        HP1("HP1"),
        NOQ("Notch Q"),
        BASS_8C("Bass"),
        TREBLE_8C("Treble"),
        SUB_8C("Sub"),
        LSODD("LSodd"),
        HSODD("HSodd"),
        LSEVEN("LSeven"),
        HSEVEN("HSeven"),
        LINKWITZT("L-T"),
        HS2ODD("HS2odd"),
        HS2EVEN("HS2even");

        static final int MAX_ST_W = 7;
        private final String apiName;

        private FilterTypes(String string2) {
            this.apiName = string2;
        }

        public String toString() {
            Equaliser equaliser = YH.\u0161() ? YH.\u0164().\u0167() : RoomEQ_Wizard.l;
            return this.toString(equaliser);
        }

        public String toString(Equaliser equaliser) {
            switch (this) {
                case PK: {
                    if (equaliser != null) {
                        return equaliser.pkName;
                    }
                    return "Peaking";
                }
                case LSQ: 
                case HSQ: {
                    if (equaliser != null && equaliser.omitQInShelfLabels()) {
                        return this.apiName.replace(" Q", "");
                    }
                    return this.apiName;
                }
            }
            return this.apiName;
        }

        public String apiName() {
            return this.apiName;
        }

        public String toFixedWidthSt() {
            return FilterTypes.toFixedWidthSt(this.toString());
        }

        public static String toFixedWidthSt(String string) {
            int n2 = string.length();
            for (int i2 = 0; i2 < 7 - n2; ++i2) {
                string = string + " ";
            }
            return string;
        }

        public static FilterTypes getFromApiName(String string) {
            for (FilterTypes filterTypes : FilterTypes.values()) {
                if (!filterTypes.apiName().equalsIgnoreCase(string)) continue;
                return filterTypes;
            }
            return null;
        }

        boolean hasFreq() {
            switch (this) {
                case NONE: 
                case BASS_8C: 
                case TREBLE_8C: 
                case SUB_8C: {
                    return false;
                }
            }
            return true;
        }

        boolean hasGain() {
            switch (this) {
                case PK: 
                case LSQ: 
                case HSQ: 
                case BASS_8C: 
                case TREBLE_8C: 
                case SUB_8C: 
                case LS: 
                case HS: 
                case LS6: 
                case HS6: 
                case LS12: 
                case HS12: 
                case LS12OA: 
                case HS12OA: 
                case MODAL: 
                case LSODD: 
                case LSEVEN: 
                case HSODD: 
                case HSEVEN: 
                case HS2ODD: 
                case HS2EVEN: {
                    return true;
                }
            }
            return false;
        }

        boolean isShelf() {
            switch (this) {
                case LSQ: 
                case HSQ: 
                case LS: 
                case HS: 
                case LS6: 
                case HS6: 
                case LS12: 
                case HS12: 
                case LS12OA: 
                case HS12OA: 
                case LSODD: 
                case LSEVEN: 
                case HSODD: 
                case HSEVEN: 
                case HS2ODD: 
                case HS2EVEN: {
                    return true;
                }
            }
            return false;
        }

        boolean isPK() {
            switch (this) {
                case PK: 
                case MODAL: {
                    return true;
                }
            }
            return false;
        }

        boolean hasQNonPK() {
            switch (this) {
                case LSQ: 
                case HSQ: 
                case LPQ: 
                case HPQ: 
                case RES: 
                case AP: 
                case NOQ: 
                case LINKWITZT: {
                    return true;
                }
            }
            return false;
        }

        boolean hasAdjustableQ() {
            return (this.isPK() || this.hasQNonPK()) && this != MODAL;
        }

        boolean hasBW() {
            switch (this) {
                case PK: 
                case MODAL: {
                    return true;
                }
            }
            return false;
        }

        boolean hasT60() {
            return this == MODAL;
        }

        boolean hasPoleZeroDecay() {
            switch (this) {
                case PK: 
                case MODAL: {
                    return true;
                }
            }
            return false;
        }

        boolean allowsAutomatic() {
            switch (this) {
                case PK: 
                case NONE: 
                case MODAL: {
                    return true;
                }
            }
            return false;
        }

        boolean hasFreq2() {
            return this == LINKWITZT;
        }

        boolean hasSlope2() {
            return false;
        }

        boolean hasQ2() {
            return this == LINKWITZT;
        }
    }
}

