/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import roomeqwizard.FilePreferencesFactory;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.WizardLogger;

public class FilePreferences
extends AbstractPreferences {
    private Map<String, String> root = new TreeMap<String, String>();
    private Map<String, FilePreferences> children = new TreeMap<String, FilePreferences>();
    private boolean isRemoved = false;
    private volatile boolean initialised = false;

    public FilePreferences(AbstractPreferences abstractPreferences, String string) {
        super(abstractPreferences, string);
        try {
            this.sync();
        }
        catch (BackingStoreException backingStoreException) {
            WizardLogger.getLogger().log(Level.SEVERE, "Unable to sync on creation of node " + string, backingStoreException);
        }
    }

    @Override
    protected void putSpi(String string, String string2) {
        this.root.put(string, string2);
    }

    @Override
    protected String getSpi(String string) {
        return this.root.get(string);
    }

    @Override
    protected void removeSpi(String string) {
        this.root.remove(string);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.isRemoved = true;
        this.flush();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return this.root.keySet().toArray(new String[0]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.children.keySet().toArray(new String[0]);
    }

    @Override
    protected FilePreferences childSpi(String string) {
        FilePreferences filePreferences = this.children.get(string);
        if (filePreferences == null || filePreferences.isRemoved()) {
            filePreferences = new FilePreferences(this, string);
            this.children.put(string, filePreferences);
        }
        return filePreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        Serializable serializable;
        if (this.isRemoved()) {
            return;
        }
        File file = FilePreferencesFactory.getPreferencesFile();
        if (!file.exists()) {
            return;
        }
        Object object = file;
        synchronized (object) {
            serializable = new Properties();
            try {
                ((Properties)serializable).load(new FileInputStream(file));
                StringBuilder stringBuilder = new StringBuilder();
                this.getPath(stringBuilder);
                String string = stringBuilder.toString();
                Enumeration<?> enumeration = ((Properties)serializable).propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith(string) || (string2 = string3.substring(string.length())).indexOf(46) != -1) continue;
                    this.root.put(string2, ((Properties)serializable).getProperty(string3));
                }
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
        if (!this.initialised && !this.name().isEmpty()) {
            object = RoomEQ_Wizard.R();
            if (object != null && ((String)object).length() > 0) {
                try {
                    serializable = new File((String)object);
                    if (((File)serializable).exists() && file.compareTo((File)serializable) != 0) {
                        this.syncSpi((File)serializable);
                        WizardLogger.getLogger().log(Level.INFO, this.name() + " preferences initialised from {0}", object);
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    WizardLogger.getLogger().log(Level.SEVERE, "Exception setting initial preferences ", backingStoreException);
                }
            }
            this.initialised = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncSpi(File file) throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        File file2 = file;
        synchronized (file2) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
                StringBuilder stringBuilder = new StringBuilder();
                this.getPath(stringBuilder);
                String string = stringBuilder.toString();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith(string) || (string2 = string3.substring(string.length())).indexOf(46) != -1) continue;
                    this.root.put(string2, properties.getProperty(string3));
                }
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
    }

    private void getPath(StringBuilder stringBuilder) {
        if (this.isRemoved()) {
            return;
        }
        FilePreferences filePreferences = (FilePreferences)this.parent();
        if (filePreferences == null) {
            return;
        }
        filePreferences.getPath(stringBuilder);
        stringBuilder.append(this.name()).append('.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        File file;
        File file2 = file = FilePreferencesFactory.getPreferencesFile();
        synchronized (file2) {
            Properties properties = new Properties();
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.getPath(stringBuilder);
                String string = stringBuilder.toString();
                if (file.exists()) {
                    String string2;
                    Object object;
                    properties.load(new FileInputStream(file));
                    ArrayList arrayList = new ArrayList();
                    Enumeration<?> object2 = properties.propertyNames();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (!((String)object).startsWith(string) || (string2 = ((String)object).substring(string.length())).indexOf(46) != -1) continue;
                        arrayList.add(object);
                    }
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        string2 = (String)object.next();
                        properties.remove(string2);
                    }
                }
                if (!this.isRemoved) {
                    for (String string3 : this.root.keySet()) {
                        properties.setProperty(string + string3, this.root.get(string3));
                    }
                }
                properties.store(new FileOutputStream(file), "FilePreferences");
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
    }
}

