/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import roomeqwizard.EQConfig;
import roomeqwizard.Filter;
import roomeqwizard.FilterGroup;
import roomeqwizard.FilterSet;
import roomeqwizard.HE;
import roomeqwizard.IB;
import roomeqwizard.MeasData;
import roomeqwizard.PE;
import roomeqwizard.XOverShape;
import roomeqwizard.XOverSlope;
import roomeqwizard.fC;
import roomeqwizard.g;
import roomeqwizard.iA;

public class Equaliser {
    private static final int MAX_REGULAR_FILTERS = 31;
    private static final int MAX_XOVER_FILTERS = 20;
    private static final int MAX_FILTERS = 31;
    private static final double[] THIRD_OCTAVE_CENTRES = new double[]{20.0, 25.0, 31.5, 40.0, 50.0, 63.0, 80.0, 100.0, 125.0, 160.0, 200.0, 250.0, 315.0, 400.0, 500.0, 630.0, 800.0, 1000.0, 1250.0, 1600.0, 2000.0, 2500.0, 3150.0, 4000.0, 5000.0, 6300.0, 8000.0, 10000.0, 12500.0, 16000.0, 20000.0};
    protected EQConfig eqConfig;
    boolean freqLabelReqd = false;
    String filterTypesToolTip = "Select filter type";
    String freqLabelText = "";
    String auxTitle = "Aux";
    String pkName = "PK";
    String sendFiltersLabel = "Send filter settings to equaliser";
    String readFiltersLabel = "Retrieve filter settings from equaliser";
    String saveCoefficientsSt = "Save filter coefficients to file";
    protected String customActionLabel = "";
    protected String filterPKQToolTip;
    protected String filterQToolTip;
    protected String filterGainToolTip;
    protected String filterFreqToolTip;
    ArrayList<Filter.FilterTypes> filterTypes;
    ArrayList<XOverShape> lpShapes;
    ArrayList<XOverShape> hpShapes;
    ArrayList<XOverSlope> shelfSlopes;
    HashMap<XOverShape, ArrayList<XOverSlope>> lpShapeSlopes;
    HashMap<XOverShape, ArrayList<XOverSlope>> hpShapeSlopes;
    ArrayList<FilterGroup> filterGroups;
    private double initialMinGain;
    protected int hiddenFilters = 0;
    int bank = 0;
    protected transient ProgressMonitor progMonitor;

    Equaliser(fC fC2) {
        this.eqConfig = new EQConfig(fC2);
        assert (this.eqConfig.getNumRegularFilters() + this.eqConfig.getNumXOverFilters() <= 31);
        this.initialMinGain = fC2.A;
        this.initCollections();
        this.setUpToolTips();
    }

    Equaliser(EQConfig eQConfig) {
        this.eqConfig = eQConfig.clone();
        this.initialMinGain = eQConfig.getMinGain();
        this.initCollections();
        this.setUpToolTips();
    }

    private void initCollections() {
        this.filterTypes = new ArrayList();
        this.filterGroups = new ArrayList();
        this.shelfSlopes = new ArrayList();
        this.shelfSlopes.add(XOverSlope.SLOPE_12DB);
        this.lpShapes = new ArrayList();
        this.lpShapes.add(XOverShape.BUTTERWORTH);
        this.hpShapes = new ArrayList();
        this.hpShapes.add(XOverShape.BUTTERWORTH);
        ArrayList<XOverSlope> arrayList = new ArrayList<XOverSlope>();
        arrayList.add(XOverSlope.SLOPE_12DB);
        this.lpShapeSlopes = new HashMap();
        this.lpShapeSlopes.put(XOverShape.BUTTERWORTH, arrayList);
        this.hpShapeSlopes = new HashMap();
        this.hpShapeSlopes.put(XOverShape.BUTTERWORTH, arrayList);
    }

    EQConfig getEQConfigCopy() {
        return this.eqConfig.clone();
    }

    void setEQConfig(EQConfig eQConfig) {
        this.eqConfig = eQConfig.clone();
        this.eqConfig.setPeqFormat(eQConfig.getPeqFormat());
        this.initialMinGain = eQConfig.getMinGain();
        this.setUpToolTips();
    }

    void setUpToolTips() {
        this.setFilterFreqToolTip("Frequency range is from " + HE.U.format(this.getMinFreq()) + " to " + HE.U.format(this.getMaxFreq()) + " Hz");
        this.setFilterGainToolTip("Gain range is from " + HE.U.format(this.getMinGain()) + " to " + HE.U.format(this.getMaxGain()) + " dB");
        this.setFilterPKQToolTip("Q range is from " + HE.U.format(this.getMinQorBWSpVal()) + " to " + HE.U.format(this.getMaxQorBWSpVal()));
        this.setFilterQToolTip("Q range is from " + HE.U.format(this.getMinQNonPK()) + " to " + HE.U.format(this.getMaxQNonPK()));
    }

    static double truncTo(double d2, int n2) {
        int n3 = 1 + (int)Math.log10(Math.abs(d2));
        double d3 = Math.pow(10.0, n3 - n2);
        double d4 = (double)((int)(d2 / d3)) * d3;
        return d4;
    }

    public int getTotalFilters() {
        return this.getMaxBiquads() + this.hiddenFilters;
    }

    public int getNumXOverFilters() {
        return this.eqConfig.getNumXOverFilters();
    }

    public int getNumRegularFilters() {
        return this.eqConfig.getNumRegularFilters();
    }

    boolean supportsHiddenFilters() {
        return this.hiddenFilters != 0;
    }

    boolean supports(Filter.FilterTypes filterTypes, int n2) {
        return n2 < this.getNumRegularFilters() && this.filterTypes(n2).contains((Object)filterTypes);
    }

    boolean supportsGroup(FilterGroup filterGroup, int n2) {
        return this.filterGroups(n2).contains((Object)filterGroup);
    }

    boolean hasGroupWithF2(int n2) {
        for (FilterGroup filterGroup : this.filterGroups(n2)) {
            if (!filterGroup.hasFreq2()) continue;
            return true;
        }
        return false;
    }

    boolean hasGroupWithSlope2(int n2) {
        for (FilterGroup filterGroup : this.filterGroups(n2)) {
            if (!filterGroup.hasSlope2()) continue;
            return true;
        }
        return false;
    }

    boolean hasGroupWithQ2(int n2) {
        for (FilterGroup filterGroup : this.filterGroups(n2)) {
            if (!filterGroup.hasQ2()) continue;
            return true;
        }
        return false;
    }

    boolean hasTypeWithF2(int n2) {
        for (Filter.FilterTypes filterTypes : this.filterTypes(n2)) {
            if (!filterTypes.hasFreq2()) continue;
            return true;
        }
        return false;
    }

    boolean hasTypeWithQ2(int n2) {
        for (Filter.FilterTypes filterTypes : this.filterTypes(n2)) {
            if (!filterTypes.hasQ2()) continue;
            return true;
        }
        return false;
    }

    boolean hasTypeWithSlope2(int n2) {
        for (Filter.FilterTypes filterTypes : this.filterTypes(n2)) {
            if (!filterTypes.hasSlope2()) continue;
            return true;
        }
        return false;
    }

    boolean hasLinkwitz() {
        return this.filterTypes.contains((Object)Filter.FilterTypes.LINKWITZT) || this.filterGroups.contains((Object)FilterGroup.LINKWITZT);
    }

    boolean hasShelfFilters() {
        return this.filterTypes.contains((Object)Filter.FilterTypes.LS) || this.filterTypes.contains((Object)Filter.FilterTypes.LS12) || this.filterTypes.contains((Object)Filter.FilterTypes.LSQ) || this.filterGroups.contains((Object)FilterGroup.LSQ) || this.filterGroups.contains((Object)FilterGroup.LS);
    }

    boolean hasSettings() {
        return false;
    }

    void showSettingsDialog(JComponent jComponent) {
    }

    boolean omitQInShelfLabels() {
        return false;
    }

    boolean supportsSmoothParamVariation() {
        return false;
    }

    boolean supportsFileRead() {
        return false;
    }

    boolean supportsFileWrite() {
        return false;
    }

    boolean supportsReadFilters() {
        return false;
    }

    boolean supportsSendFilters() {
        return false;
    }

    boolean supportsCustomAction() {
        return false;
    }

    boolean runsAtResponseRate() {
        return false;
    }

    void setBank(int n2) {
        this.bank = n2;
    }

    int getBank() {
        return this.bank;
    }

    int firstMatchFilterIndex() {
        return 0;
    }

    int lastMatchFilterIndex() {
        return this.getNumRegularFilters() == 0 ? this.getMaxBiquads() : this.getNumRegularFilters();
    }

    int getSortStartIndex() {
        return this.firstMatchFilterIndex();
    }

    int getSortEndIndex() {
        return this.lastMatchFilterIndex();
    }

    void sendFilters(FilterSet filterSet, MeasData measData) {
    }

    void readFilters(FilterSet filterSet, MeasData measData) {
    }

    void saveFilters(FilterSet filterSet, MeasData measData) {
    }

    void loadFilters(FilterSet filterSet, MeasData measData) {
    }

    void customAction() {
    }

    void setLowerMinGain(double d2) {
        this.initialMinGain = this.eqConfig.getMinGain();
        this.eqConfig.setMinGain(d2);
    }

    void restoreInitialMinGain() {
        this.eqConfig.setMinGain(this.initialMinGain);
    }

    String getEqualiserName() {
        return (Object)((Object)this.getManufacturer()) + " " + this.getModel();
    }

    public PE getManufacturer() {
        return PE.K;
    }

    public String getModel() {
        return "Generic";
    }

    public String toString() {
        return this.getModel();
    }

    public String getHeaderNumber() {
        return "Number";
    }

    public String getHeaderEnabled() {
        return "Enabled";
    }

    public String getHeaderControl() {
        return "Control";
    }

    public String getHeaderType() {
        return "Type";
    }

    public String getHeaderFrequency() {
        return "Frequency(Hz)";
    }

    public String getHeaderGain() {
        return "Gain(dB)";
    }

    public String getHeaderBandwidth() {
        return "Bandwidth(Hz)";
    }

    public String getHeaderTargetT60() {
        return "TargetT60(ms)";
    }

    public String getHeaderShape() {
        return "Shape";
    }

    public String getHeaderSlope() {
        return "Slope dB/oct";
    }

    public String getHeaderFrequency2() {
        return "Frequency2(Hz)";
    }

    public String getHeaderQ2() {
        return " Q2 ";
    }

    public String getHeaderSlope2() {
        return "Slope2 dB/oct";
    }

    double getMaxQorBW() {
        return this.getMaxQorBWSpVal();
    }

    double getMinQorBW() {
        return this.getMinQorBWSpVal();
    }

    double getMaxQ(double d2, double d3) {
        return this.getMaxQorBW();
    }

    double getMinQ(double d2, double d3) {
        return this.getMinQorBW();
    }

    double getMaxQNonPK() {
        return this.eqConfig.getMaxQNonPK();
    }

    double getMinQNonPK() {
        return this.eqConfig.getMinQNonPK();
    }

    double getQStepNonPK() {
        return this.eqConfig.getQStepNonPK();
    }

    double getNextDispQNonPK(double d2, int n2) {
        return Math.min(this.getQStepNonPK() * (double)Math.round(d2 / this.getQStepNonPK() + (double)n2), this.getMaxQNonPK());
    }

    double getPrevDispQNonPK(double d2, int n2) {
        return Math.max(this.getQStepNonPK() * (double)Math.round(d2 / this.getQStepNonPK() - (double)n2), this.getMinQNonPK());
    }

    double getNearestDispQNonPK(double d2) {
        return Math.max(Math.min((double)Math.round(d2 / this.getQStepNonPK()) * this.getQStepNonPK(), this.getMaxQNonPK()), this.getMinQNonPK());
    }

    String getFreqFormatSt(double d2) {
        String string;
        String string2 = "##,###";
        String string3 = "#,##0.0";
        String string4 = "##0.00";
        switch (this.getMaxFreqDP()) {
            case 0: {
                string = "##,###";
                break;
            }
            case 1: {
                if (d2 < 100.0 && this.getFreqStep(d2) < 1.0) {
                    string = "#,##0.0";
                    break;
                }
                string = "##,###";
                break;
            }
            default: {
                string = d2 < 100.0 && this.getFreqStep(d2) < 0.1 ? "##0.00" : (d2 < 1000.0 && this.getFreqStep(d2) < 1.0 ? "#,##0.0" : "##,###");
            }
        }
        return string;
    }

    double getFreqStep(double d2) {
        switch (this.getMaxFreqDP()) {
            case 0: {
                return 1.0;
            }
            case 1: {
                if (d2 < 100.0) {
                    return 0.1;
                }
                return 1.0;
            }
        }
        if (d2 < 50.0) {
            return 0.05;
        }
        if (d2 < 100.0) {
            return 0.1;
        }
        if (d2 < 200.0) {
            return 0.5;
        }
        return 1.0;
    }

    double getNextFreq(double d2) {
        double d3 = Math.max(this.getFreqStep(), this.getFreqStep(d2));
        return Math.min(d3 * (double)Math.round(d2 / d3 + 1.0), this.getMaxFreq());
    }

    double getPrevFreq(double d2) {
        double d3 = Math.max(this.getFreqStep(), this.getFreqStep(d2));
        return Math.max(d3 * (double)Math.round(d2 / d3 - 1.0), this.getMinFreq());
    }

    double getNextFreq(double d2, int n2) {
        double d3 = Math.max(this.getFreqStep(), this.getFreqStep(d2));
        return Math.min(d3 * (double)Math.round(d2 / d3 + (double)n2), this.getMaxFreq());
    }

    double getPrevFreq(double d2, int n2) {
        double d3 = Math.max(this.getFreqStep(), this.getFreqStep(d2));
        return Math.max(d3 * (double)Math.round(d2 / d3 - (double)n2), this.getMinFreq());
    }

    double getNearestFreq(double d2) {
        double d3 = Math.max(this.getFreqStep(), this.getFreqStep(d2));
        return Math.max(Math.min((double)Math.round(d2 / d3) * d3, this.getMaxFreq()), this.getMinFreq());
    }

    IB getBFDFreq(double d2) {
        return null;
    }

    String getFreqLabelText(double d2) {
        return "";
    }

    String getBWText(double d2, double d3) {
        return HE.A(d2 / d3);
    }

    double getNextGain(double d2) {
        return Math.min(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() + 1.0), this.getMaxGain());
    }

    double getPrevGain(double d2) {
        return Math.max(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() - 1.0), this.getMinGain());
    }

    double getNextGain(double d2, int n2) {
        return Math.min(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() + (double)n2), this.getMaxGain());
    }

    double getPrevGain(double d2, int n2) {
        return Math.max(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() - (double)n2), this.getMinGain());
    }

    double getNearestGain(double d2) {
        return Math.max(Math.min((double)Math.round(d2 / this.getGainStep()) * this.getGainStep(), this.getMaxGain()), this.getMinGain());
    }

    double getNextGain(int n2, double d2) {
        return this.getNextGain(d2);
    }

    double getPrevGain(int n2, double d2) {
        return this.getPrevGain(d2);
    }

    double getNextGain(int n2, double d2, int n3) {
        return this.getNextGain(d2, n3);
    }

    double getPrevGain(int n2, double d2, int n3) {
        return this.getPrevGain(d2, n3);
    }

    double getNearestGain(int n2, double d2) {
        return this.getNearestGain(d2);
    }

    double getMinGain(int n2) {
        return this.getMinGain();
    }

    double getMaxGain(int n2) {
        return this.getMaxGain();
    }

    double getNextDispQ(double d2) {
        return Math.min(this.getQorBWSpStep() * (double)Math.round(d2 / this.getQorBWSpStep() + 1.0), this.getMaxQorBWSpVal());
    }

    double getPrevDispQ(double d2) {
        return Math.max(this.getQorBWSpStep() * (double)Math.round(d2 / this.getQorBWSpStep() - 1.0), this.getMinQorBWSpVal());
    }

    double getNextDispQ(double d2, int n2) {
        return Math.min(this.getQorBWSpStep() * (double)Math.round(d2 / this.getQorBWSpStep() + (double)n2), this.getMaxQorBWSpVal());
    }

    double getPrevDispQ(double d2, int n2) {
        return Math.max(this.getQorBWSpStep() * (double)Math.round(d2 / this.getQorBWSpStep() - (double)n2), this.getMinQorBWSpVal());
    }

    double getHigherDispQ(double d2) {
        return this.getNextDispQ(d2);
    }

    double getLowerDispQ(double d2) {
        return this.getPrevDispQ(d2);
    }

    double getNearestDispQ(double d2) {
        return Math.max(Math.min((double)Math.round(d2 / this.getQorBWSpStep()) * this.getQorBWSpStep(), this.getMaxQorBWSpVal()), this.getMinQorBWSpVal());
    }

    double getNearestActualQ(double d2, double d3, double d4) {
        return this.dispToQ(this.getNearestDispQ(this.qToDisp(d2, d3, d4)), d3, d4);
    }

    double qToDisp(double d2, double d3, double d4) {
        return d2;
    }

    double roundedQ(double d2) {
        return Math.max(Math.min((double)Math.round(d2 / this.getQStepNonPK()) * this.getQStepNonPK(), this.getMaxQNonPK()), this.getMinQNonPK());
    }

    double dispToQ(double d2, double d3, double d4) {
        return d2;
    }

    double getDefaultFc(int n2) {
        return this.getNearestFreq(THIRD_OCTAVE_CENTRES[n2 % THIRD_OCTAVE_CENTRES.length]);
    }

    double getDefaultQ(int n2) {
        return this.getNearestActualQ(10.0, 0.0, this.getDefaultFc(n2));
    }

    int getXOverIndex(int n2) {
        if (n2 < this.getNumRegularFilters()) {
            return -1;
        }
        return (n2 - this.getNumRegularFilters()) / 4;
    }

    ArrayList<Filter.FilterTypes> filterTypes(int n2) {
        return this.filterTypes;
    }

    Filter.FilterTypes getDefaultFilterType(int n2) {
        if (this.filterTypes == null || this.filterTypes.isEmpty()) {
            return Filter.FilterTypes.NONE;
        }
        return this.filterTypes.get(0);
    }

    FilterGroup getDefaultFilterGroup(int n2) {
        if (this.filterGroups == null || this.filterGroups.isEmpty()) {
            return FilterGroup.NONE;
        }
        return this.filterGroups.get(0);
    }

    ArrayList<XOverShape> lpShapes(int n2) {
        return this.lpShapes;
    }

    ArrayList<XOverSlope> lpSlopes(int n2, XOverShape xOverShape) {
        return this.lpShapeSlopes.get((Object)xOverShape);
    }

    ArrayList<XOverShape> hpShapes(int n2) {
        return this.hpShapes;
    }

    ArrayList<XOverSlope> hpSlopes(int n2, XOverShape xOverShape) {
        return this.hpShapeSlopes.get((Object)xOverShape);
    }

    ArrayList<XOverSlope> shelfSlopes(int n2) {
        return this.shelfSlopes;
    }

    ArrayList<FilterGroup> filterGroups(int n2) {
        return this.filterGroups;
    }

    void onSelection() {
        if (g.getMeasPanesList() != null && iA.\u01d5()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    iA.\u01d1().B(Equaliser.this);
                }
            });
        }
    }

    void onDeselection() {
    }

    int getFiltSampleRate(MeasData measData) {
        if (this.runsAtResponseRate() && measData != null && measData.getSampleRate() != 0.0) {
            int n2 = (int)Math.round(measData.getSampleRate());
            if (n2 < 44100) {
                int[] nArray;
                for (int n3 : nArray = new int[]{2, 4, 8, 16, 32}) {
                    if (n2 == 44100 / n3) {
                        return 44100;
                    }
                    if (n2 != 48000 / n3) continue;
                    return 48000;
                }
            }
            return n2;
        }
        return this.eqConfig.getSampleRate().intValue();
    }

    int getMaxBiquads() {
        return this.eqConfig.getNumRegularFilters() + this.eqConfig.getNumXOverFilters() * 4;
    }

    int getHiddenFilters() {
        return this.hiddenFilters;
    }

    static int getMAX_REGULAR_FILTERS() {
        return 31;
    }

    static int getMAX_XOVER_FILTERS() {
        return 20;
    }

    private static String getFormat(double d2) {
        int n2 = (int)Math.round(d2 * 1000.0);
        int n3 = n2 % 10;
        int n4 = n2 % 100 / 10;
        int n5 = n2 % 1000 / 100;
        if (n3 != 0) {
            return "#0.000";
        }
        if (n4 != 0) {
            return "#0.00";
        }
        if (n5 != 0) {
            return "#0.0";
        }
        return "##";
    }

    private static int getDP(double d2) {
        int n2 = (int)Math.round(d2 * 1000.0);
        int n3 = n2 % 10;
        int n4 = n2 % 100 / 10;
        int n5 = n2 % 1000 / 100;
        if (n3 != 0) {
            return 3;
        }
        if (n4 != 0) {
            return 2;
        }
        if (n5 != 0) {
            return 1;
        }
        return 0;
    }

    String getQFormat(double d2) {
        return Equaliser.getFormat(this.eqConfig.getQorBWSpStep());
    }

    String getQNonPKFormat(double d2) {
        return Equaliser.getFormat(this.eqConfig.getQStepNonPK());
    }

    String getGainFormat() {
        String string = Equaliser.getFormat(this.eqConfig.getGainStep());
        return "+" + string + ";-" + string;
    }

    int getMaxFreqDP() {
        return Equaliser.getDP(this.eqConfig.getFreqStep());
    }

    int getMaxQDP() {
        return Equaliser.getDP(this.eqConfig.getQorBWSpStep());
    }

    int getMaxQNonPKDP() {
        return Equaliser.getDP(this.eqConfig.getQStepNonPK());
    }

    int getMaxGainDP() {
        return Equaliser.getDP(this.eqConfig.getGainStep());
    }

    String getCustomActionLabel() {
        return this.customActionLabel;
    }

    void setCustomActionLabel(String string) {
        this.customActionLabel = string;
    }

    String getFilterPKQToolTip() {
        return this.filterPKQToolTip;
    }

    String getFilterQToolTip() {
        return this.filterQToolTip;
    }

    void setFilterPKQToolTip(String string) {
        this.filterPKQToolTip = string;
    }

    void setFilterQToolTip(String string) {
        this.filterQToolTip = string;
    }

    String getFilterGainToolTip() {
        return this.filterGainToolTip;
    }

    void setFilterGainToolTip(String string) {
        this.filterGainToolTip = string;
    }

    String getFilterFreqToolTip() {
        return this.filterFreqToolTip;
    }

    void setFilterFreqToolTip(String string) {
        this.filterFreqToolTip = string;
    }

    double getMinFreq() {
        return this.eqConfig.getMinFreq();
    }

    double getMaxFreq() {
        return this.eqConfig.getMaxFreq();
    }

    double getFreqStep() {
        return this.eqConfig.getFreqStep();
    }

    double getMinGain() {
        return this.eqConfig.getMinGain();
    }

    double getMaxGain() {
        return this.eqConfig.getMaxGain();
    }

    double getGainStep() {
        return this.eqConfig.getGainStep();
    }

    double getMinQorBWSpVal() {
        return this.eqConfig.getMinQorBWSpVal();
    }

    double getMaxQorBWSpVal() {
        return this.eqConfig.getMaxQorBWSpVal();
    }

    double getQorBWSpStep() {
        return this.eqConfig.getQorBWSpStep();
    }

    String getqOrBWUnit() {
        return "";
    }

    String getQHeader() {
        return " Q ";
    }
}

