/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Level;
import roomeqwizard.Equaliser;
import roomeqwizard.PEQFormat;
import roomeqwizard.SampleRates;
import roomeqwizard.WizardLogger;
import roomeqwizard.fC;

class EQConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 931013590427144442L;
    static final String NUM_REGULAR_ST = "eqnumregular";
    static final String NUM_XOVER_ST = "eqnumxover";
    static final String MIN_FREQ_ST = "eqminfreq";
    static final String MAX_FREQ_ST = "eqmaxfreq";
    static final String FREQ_STEP_ST = "eqfreqstep";
    static final String MIN_GAIN_ST = "eqmingain";
    static final String MAX_GAIN_ST = "eqmaxgain";
    static final String GAIN_STEP_ST = "eqgainstep";
    static final String MIN_Q_ST = "eqminq";
    static final String MAX_Q_ST = "eqmaxq";
    static final String Q_STEP_ST = "eqqstep";
    static final String SAMPLERATE_ST = "eqsamplerateval";
    static final String PEQ_FORMAT_ST = "eqpeqformat";
    private int regularFilters;
    private int xOverFilters;
    private double minFreq;
    private double maxFreq;
    private double freqStep;
    private double minGain;
    private double maxGain;
    private double gainStep;
    private double minQorBWSpVal;
    private double maxQorBWSpVal;
    private double qorBWSpStep;
    private SampleRates sampleRate;
    private PEQFormat peqFormat;
    private double minQNonPK;
    private double maxQNonPK;
    private double qStepNonPK;

    static int getDefaultNumRegularFilters() {
        return 10;
    }

    static int getDefaultNumXOverFilters() {
        return 0;
    }

    static double getDefaultMinFreq() {
        return 20.0;
    }

    static double getDefaultMaxFreq() {
        return 20000.0;
    }

    static double getDefaultFreqStep() {
        return 1.0;
    }

    static double getDefaultMinGain() {
        return -36.0;
    }

    static double getDefaultMaxGain() {
        return 12.0;
    }

    static double getDefaultGainStep() {
        return 0.1;
    }

    static double getDefaultMinQ() {
        return 0.1;
    }

    static double getDefaultMaxQ() {
        return 50.0;
    }

    static double getDefaultQStep() {
        return 0.01;
    }

    static SampleRates getDefaultSampleRate() {
        return SampleRates.RATE48K;
    }

    static PEQFormat getDefaultPEQFormat() {
        return PEQFormat.RBJ;
    }

    EQConfig() {
        this.regularFilters = EQConfig.getDefaultNumRegularFilters();
        this.xOverFilters = EQConfig.getDefaultNumXOverFilters();
        this.minFreq = EQConfig.getDefaultMinFreq();
        this.maxFreq = EQConfig.getDefaultMaxFreq();
        this.freqStep = EQConfig.getDefaultFreqStep();
        this.minGain = EQConfig.getDefaultMinGain();
        this.maxGain = EQConfig.getDefaultMaxGain();
        this.gainStep = EQConfig.getDefaultGainStep();
        this.minQorBWSpVal = EQConfig.getDefaultMinQ();
        this.maxQorBWSpVal = EQConfig.getDefaultMaxQ();
        this.qorBWSpStep = EQConfig.getDefaultQStep();
        this.sampleRate = EQConfig.getDefaultSampleRate();
        this.peqFormat = EQConfig.getDefaultPEQFormat();
        this.minQNonPK = EQConfig.getDefaultMinQ();
        this.maxQNonPK = EQConfig.getDefaultMaxQ();
        this.qStepNonPK = EQConfig.getDefaultQStep();
    }

    EQConfig(fC fC2) {
        assert (fC2.D <= Equaliser.getMAX_REGULAR_FILTERS());
        assert (fC2.C <= Equaliser.getMAX_XOVER_FILTERS());
        this.regularFilters = fC2.D;
        this.xOverFilters = fC2.C;
        this.minFreq = fC2.B;
        this.maxFreq = fC2.N;
        this.freqStep = fC2.I;
        this.minGain = fC2.A;
        this.maxGain = fC2.M;
        this.gainStep = fC2.G;
        this.minQorBWSpVal = fC2.F;
        this.maxQorBWSpVal = fC2.E;
        this.qorBWSpStep = fC2.J;
        this.minQNonPK = fC2.O;
        this.maxQNonPK = fC2.H;
        this.qStepNonPK = fC2.L;
        this.sampleRate = fC2.K;
    }

    public int getNumRegularFilters() {
        return this.regularFilters;
    }

    public void setNumRegularFilters(int n2) {
        this.regularFilters = n2;
    }

    public int getNumXOverFilters() {
        return this.xOverFilters;
    }

    public void setNumXOverFilters(int n2) {
        this.xOverFilters = n2;
    }

    public double getMinFreq() {
        return this.minFreq;
    }

    public void setMinFreq(double d2) {
        this.minFreq = d2;
    }

    public double getMaxFreq() {
        return this.maxFreq;
    }

    public void setMaxFreq(double d2) {
        this.maxFreq = d2;
    }

    public double getFreqStep() {
        return this.freqStep;
    }

    public void setFreqStep(double d2) {
        this.freqStep = d2;
    }

    public double getMinGain() {
        return this.minGain;
    }

    public void setMinGain(double d2) {
        this.minGain = d2;
    }

    public double getMaxGain() {
        return this.maxGain;
    }

    public void setMaxGain(double d2) {
        this.maxGain = d2;
    }

    public double getGainStep() {
        return this.gainStep;
    }

    public void setGainStep(double d2) {
        this.gainStep = d2;
    }

    public double getMinQorBWSpVal() {
        return this.minQorBWSpVal;
    }

    public void setMinQorBWSpVal(double d2) {
        this.minQorBWSpVal = d2;
    }

    public double getMaxQorBWSpVal() {
        return this.maxQorBWSpVal;
    }

    public void setMaxQorBWSpVal(double d2) {
        this.maxQorBWSpVal = d2;
    }

    public double getQorBWSpStep() {
        return this.qorBWSpStep;
    }

    public void setQorBWSpStep(double d2) {
        this.qorBWSpStep = d2;
    }

    public double getMinQNonPK() {
        return this.minQNonPK;
    }

    public void setMinQNonPK(double d2) {
        this.minQNonPK = d2;
    }

    public double getMaxQNonPK() {
        return this.maxQNonPK;
    }

    public void setMaxQNonPK(double d2) {
        this.maxQNonPK = d2;
    }

    public double getQStepNonPK() {
        return this.qStepNonPK;
    }

    public void setQStepNonPK(double d2) {
        this.qStepNonPK = d2;
    }

    public SampleRates getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(SampleRates sampleRates) {
        this.sampleRate = sampleRates;
    }

    public PEQFormat getPeqFormat() {
        return this.peqFormat;
    }

    public void setPeqFormat(PEQFormat pEQFormat) {
        this.peqFormat = pEQFormat;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 17 * n2 + this.regularFilters;
        n2 = 17 * n2 + this.xOverFilters;
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.minFreq) ^ Double.doubleToLongBits(this.minFreq) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.maxFreq) ^ Double.doubleToLongBits(this.maxFreq) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.freqStep) ^ Double.doubleToLongBits(this.freqStep) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.minGain) ^ Double.doubleToLongBits(this.minGain) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.maxGain) ^ Double.doubleToLongBits(this.maxGain) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.gainStep) ^ Double.doubleToLongBits(this.gainStep) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.minQorBWSpVal) ^ Double.doubleToLongBits(this.minQorBWSpVal) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.maxQorBWSpVal) ^ Double.doubleToLongBits(this.maxQorBWSpVal) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.qorBWSpStep) ^ Double.doubleToLongBits(this.qorBWSpStep) >>> 32);
        n2 = 17 * n2 + Objects.hashCode((Object)this.sampleRate);
        n2 = 17 * n2 + Objects.hashCode((Object)this.peqFormat);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.minQNonPK) ^ Double.doubleToLongBits(this.minQNonPK) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.maxQNonPK) ^ Double.doubleToLongBits(this.maxQNonPK) >>> 32);
        n2 = 17 * n2 + (int)(Double.doubleToLongBits(this.qStepNonPK) ^ Double.doubleToLongBits(this.qStepNonPK) >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EQConfig eQConfig = (EQConfig)object;
        if (this.regularFilters != eQConfig.regularFilters) {
            return false;
        }
        if (this.xOverFilters != eQConfig.xOverFilters) {
            return false;
        }
        if (Double.doubleToLongBits(this.minFreq) != Double.doubleToLongBits(eQConfig.minFreq)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxFreq) != Double.doubleToLongBits(eQConfig.maxFreq)) {
            return false;
        }
        if (Double.doubleToLongBits(this.freqStep) != Double.doubleToLongBits(eQConfig.freqStep)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minGain) != Double.doubleToLongBits(eQConfig.minGain)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxGain) != Double.doubleToLongBits(eQConfig.maxGain)) {
            return false;
        }
        if (Double.doubleToLongBits(this.gainStep) != Double.doubleToLongBits(eQConfig.gainStep)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minQorBWSpVal) != Double.doubleToLongBits(eQConfig.minQorBWSpVal)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxQorBWSpVal) != Double.doubleToLongBits(eQConfig.maxQorBWSpVal)) {
            return false;
        }
        if (Double.doubleToLongBits(this.qorBWSpStep) != Double.doubleToLongBits(eQConfig.qorBWSpStep)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minQNonPK) != Double.doubleToLongBits(eQConfig.minQNonPK)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxQNonPK) != Double.doubleToLongBits(eQConfig.maxQNonPK)) {
            return false;
        }
        if (Double.doubleToLongBits(this.qStepNonPK) != Double.doubleToLongBits(eQConfig.qStepNonPK)) {
            return false;
        }
        if (this.sampleRate != eQConfig.sampleRate) {
            return false;
        }
        return this.peqFormat == eQConfig.peqFormat;
    }

    public EQConfig clone() {
        EQConfig eQConfig = null;
        try {
            eQConfig = (EQConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WizardLogger.getLogger().log(Level.SEVERE, null, cloneNotSupportedException);
        }
        return eQConfig;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getNumRegularFilters()).append(" regular filters, ");
        stringBuilder.append(this.getNumXOverFilters()).append(" compound filters").append("\n");
        stringBuilder.append("Freq range ").append(this.getMinFreq()).append(" to ").append(this.getMaxFreq()).append(", step ").append(this.getFreqStep()).append("\n");
        stringBuilder.append("Gain range ").append(this.getMinGain()).append(" to ").append(this.getMaxGain()).append(", step ").append(this.getGainStep()).append("\n");
        stringBuilder.append("PK Q/BW format ").append((Object)this.getPeqFormat()).append("\n");
        stringBuilder.append("PK Q/BW range ").append(this.getMinQorBWSpVal()).append(" to ").append(this.getMaxQorBWSpVal()).append(", step ").append(this.getQorBWSpStep()).append("\n");
        stringBuilder.append("Q range ").append(this.getMinQNonPK()).append(" to ").append(this.getMaxQNonPK()).append(", step ").append(this.getQStepNonPK()).append("\n");
        stringBuilder.append("Sample rate ").append((Object)this.getSampleRate());
        return stringBuilder.toString();
    }

    String differencesTo(EQConfig eQConfig) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getNumRegularFilters() != eQConfig.getNumRegularFilters()) {
            stringBuilder.append("Biquad filters from ").append(this.getNumRegularFilters()).append(" to ").append(eQConfig.getNumRegularFilters()).append("\n");
        }
        if (this.getNumXOverFilters() != eQConfig.getNumXOverFilters()) {
            stringBuilder.append("Compound filters from ").append(this.getNumXOverFilters()).append(" to ").append(eQConfig.getNumXOverFilters()).append("\n");
        }
        if (this.getMinFreq() != eQConfig.getMinFreq()) {
            stringBuilder.append("Min freq from ").append(this.getMinFreq()).append(" to ").append(eQConfig.getMinFreq()).append("\n");
        }
        if (this.getMaxFreq() != eQConfig.getMaxFreq()) {
            stringBuilder.append("Max freq from ").append(this.getMaxFreq()).append(" to ").append(eQConfig.getMaxFreq()).append("\n");
        }
        if (this.getFreqStep() != eQConfig.getFreqStep()) {
            stringBuilder.append("Freq step from ").append(this.getFreqStep()).append(" to ").append(eQConfig.getFreqStep()).append("\n");
        }
        if (this.getMinGain() != eQConfig.getMinGain()) {
            stringBuilder.append("Min gain from ").append(this.getMinGain()).append(" to ").append(eQConfig.getMinGain()).append("\n");
        }
        if (this.getMaxGain() != eQConfig.getMaxGain()) {
            stringBuilder.append("Max gain from ").append(this.getMaxGain()).append(" to ").append(eQConfig.getMaxGain()).append("\n");
        }
        if (this.getGainStep() != eQConfig.getGainStep()) {
            stringBuilder.append("Gain step from ").append(this.getGainStep()).append(" to ").append(eQConfig.getGainStep()).append("\n");
        }
        if (this.getPeqFormat() != eQConfig.getPeqFormat()) {
            stringBuilder.append("Q/BW format from ").append((Object)this.getPeqFormat()).append(" to ").append((Object)eQConfig.getPeqFormat()).append("\n");
        }
        if (this.getMinQorBWSpVal() != eQConfig.getMinQorBWSpVal()) {
            stringBuilder.append("Min Q/BW from ").append(this.getMinQorBWSpVal()).append(" to ").append(eQConfig.getMinQorBWSpVal()).append("\n");
        }
        if (this.getMaxQorBWSpVal() != eQConfig.getMaxQorBWSpVal()) {
            stringBuilder.append("Max Q/BW from ").append(this.getMaxQorBWSpVal()).append(" to ").append(eQConfig.getMaxQorBWSpVal()).append("\n");
        }
        if (this.getQorBWSpStep() != eQConfig.getQorBWSpStep()) {
            stringBuilder.append("Q/BW step from ").append(this.getQorBWSpStep()).append(" to ").append(eQConfig.getQorBWSpStep()).append("\n");
        }
        if (this.getSampleRate() != eQConfig.getSampleRate()) {
            stringBuilder.append("Sample rate from ").append((Object)this.getSampleRate()).append(" to ").append((Object)eQConfig.getSampleRate()).append("\n");
        }
        return stringBuilder.toString();
    }
}

