/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.text.NumberFormat;
import roomeqwizard.HE;

public final class DistortionUnit
extends Enum<DistortionUnit> {
    public static final /* enum */ DistortionUnit PERCENT = new DistortionUnit(" %", "Show distortion in %", "percent");
    public static final /* enum */ DistortionUnit DB = new DistortionUnit(" dB", "Show distortion in dB", "dB");
    private final String unitSt;
    private final String description;
    private final String apiName;
    private static final /* synthetic */ DistortionUnit[] $VALUES;

    public static DistortionUnit[] values() {
        return (DistortionUnit[])$VALUES.clone();
    }

    public static DistortionUnit valueOf(String string) {
        return Enum.valueOf(DistortionUnit.class, string);
    }

    private DistortionUnit(String string2, String string3, String string4) {
        this.unitSt = string2;
        this.description = string3;
        this.apiName = string4;
    }

    public String getDescription() {
        return this.description;
    }

    public String apiName() {
        return this.apiName;
    }

    public String format(double d2) {
        if (d2 == 0.0) {
            return "N/A";
        }
        switch (this) {
            case PERCENT: {
                NumberFormat numberFormat = DistortionUnit.getDistFormatter(d2);
                return numberFormat.format(d2) + this.unitSt;
            }
            case DB: {
                return HE.U.format(20.0 * Math.log10(d2 / 100.0)) + this.unitSt;
            }
        }
        assert (false) : "Unhandled enum type";
        return "";
    }

    public double displayValue(double d2) {
        switch (this) {
            case PERCENT: {
                return d2;
            }
            case DB: {
                return 20.0 * Math.log10(d2 / 100.0);
            }
        }
        assert (false) : "Unhandled enum type";
        return d2;
    }

    public static DistortionUnit getEnum(String string) {
        for (DistortionUnit distortionUnit : DistortionUnit.values()) {
            if (!distortionUnit.name().equalsIgnoreCase(string)) continue;
            return distortionUnit;
        }
        return PERCENT;
    }

    public static DistortionUnit getFromApiName(String string) {
        for (DistortionUnit distortionUnit : DistortionUnit.values()) {
            if (!distortionUnit.apiName().equalsIgnoreCase(string)) continue;
            return distortionUnit;
        }
        return null;
    }

    private static NumberFormat getDistFormatter(double d2) {
        if (Math.round(10.0 * d2) >= 100L) {
            return HE.U;
        }
        if (Math.round(100.0 * d2) >= 100L) {
            return HE.K;
        }
        if (Math.round(1000.0 * d2) >= 100L) {
            return HE.K;
        }
        if (Math.round(10000.0 * d2) >= 100L) {
            return HE.A;
        }
        if (Math.round(100000.0 * d2) >= 100L) {
            return HE.O;
        }
        if (Math.round(1000000.0 * d2) >= 100L) {
            return HE.E;
        }
        if (d2 == 0.0) {
            return HE.U;
        }
        return HE.R;
    }

    static {
        $VALUES = new DistortionUnit[]{PERCENT, DB};
    }
}

