/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jtransforms.fft.FloatFFT_1D;
import roomeqwizard.$B;
import roomeqwizard.AxisOption;
import roomeqwizard.F;
import roomeqwizard.IF;
import roomeqwizard.IRData;
import roomeqwizard.IRFloat;
import roomeqwizard.MeasData;
import roomeqwizard.StepTest;
import roomeqwizard.SteppedSineDataPoint;
import roomeqwizard.SweepAnalyser;
import roomeqwizard.Window;
import roomeqwizard.eJ;
import roomeqwizard.lG;
import roomeqwizard.lH;

class DistortionData
implements Serializable,
Cloneable {
    static final long serialVersionUID = -1234567890111111111L;
    static final int THD_ORDER = 0;
    static final int THD_PLUS_N_ORDER = -1;
    static final int N_AND_NHD_ORDER = -2;
    static final int NOISE_FLOOR_ORDER = -3;
    static final int IMD_ORDER = -4;
    static final int TD_PLUS_N_ORDER = -5;
    static final float FUND_LIMIT = 30.0f;
    static final int PPO = 96;
    private static final int HIGHEST_HARMONIC = 9;
    private static final double UPPER_DIST_LIMIT_FACTOR = 0.95;
    private static final double preProp = 0.25;
    private float[][] harmData;
    private float[] freqs;
    private float[] levels;
    private float[] imddB;
    private float[] tdPlusNdB;
    @Deprecated
    private float[] imdRefdB;
    private float[] refdB;
    private float[] indexData;
    double logStep;
    double logStepLog;
    int dataLength;
    private float startFreq;
    private float firstTone;
    private float endFreq;
    private float lastTone;
    private float irEndFreq;
    private float startLevel;
    private float endLevel;
    Float fundamentalPeak;
    int ppo;
    Double splOffset;
    int sampleRate;
    float[] thdPlusN;
    float[][] spectrum;
    int distortionHP;
    int distortionLP;
    float[] dBNandNHD;
    private float[] noiseFloorSPL;
    double spectrumStartFreq;
    double spectrumEndFreq;
    double spectrumFreqStep;
    double spectrumLogStep;
    double spectrumLogStepLog;
    int spectrumPPO;
    private Boolean isFromIR;
    private boolean usedNovak = false;
    private boolean isSteppedInLevel = false;
    private boolean isIMD = false;
    private boolean isMT = false;
    private String imdSt;
    private String signalDescription;
    Boolean genFSIsZero = null;
    private IRFloat ir;
    transient boolean calcInProgress = false;
    transient boolean lastNormalise = false;
    private transient HashMap<float[], float[][]> tangentSet;
    private transient float[] logFreqs;

    protected DistortionData clone() throws CloneNotSupportedException {
        DistortionData distortionData = (DistortionData)super.clone();
        if (this.noiseFloorSPL != null) {
            distortionData.noiseFloorSPL = (float[])this.noiseFloorSPL.clone();
        }
        if (this.dBNandNHD != null) {
            distortionData.dBNandNHD = (float[])this.dBNandNHD.clone();
        }
        if (this.thdPlusN != null) {
            distortionData.thdPlusN = (float[])this.thdPlusN.clone();
        }
        if (this.freqs != null) {
            distortionData.freqs = (float[])this.freqs.clone();
        }
        if (this.levels != null) {
            distortionData.levels = (float[])this.levels.clone();
        }
        if (this.spectrum != null) {
            distortionData.spectrum = DistortionData.deepCopy(this.spectrum);
        }
        if (this.harmData != null) {
            distortionData.harmData = DistortionData.deepCopy(this.harmData);
        }
        if (this.imddB != null) {
            distortionData.imddB = (float[])this.imddB.clone();
        }
        if (this.tdPlusNdB != null) {
            distortionData.tdPlusNdB = (float[])this.tdPlusNdB.clone();
        }
        if (this.imdRefdB != null) {
            distortionData.imdRefdB = (float[])this.imdRefdB.clone();
        }
        if (this.refdB != null) {
            distortionData.refdB = (float[])this.refdB.clone();
        }
        return distortionData;
    }

    static DistortionData average(DistortionData ... distortionDataArray) throws CloneNotSupportedException {
        int n2;
        int n3;
        DistortionData distortionData = distortionDataArray[0].clone();
        distortionData.spectrum = null;
        int n4 = distortionDataArray.length;
        for (n3 = 1; n3 < n4; ++n3) {
            if (Arrays.equals(distortionDataArray[0].freqs, distortionDataArray[n3].freqs)) continue;
            throw new IllegalArgumentException("Data set frequencies don't match");
        }
        if (distortionData.noiseFloorSPL != null) {
            float[] fArray = new float[distortionData.noiseFloorSPL.length];
            for (n2 = 0; n2 < n4; ++n2) {
                DistortionData.sumMagn(fArray, distortionDataArray[n2].noiseFloorSPL);
            }
            DistortionData.toLogAvg(fArray, n4);
            distortionData.noiseFloorSPL = fArray;
        }
        if (distortionData.dBNandNHD != null) {
            float[] fArray = new float[distortionData.dBNandNHD.length];
            for (n2 = 0; n2 < n4; ++n2) {
                DistortionData.sumMagn(fArray, distortionDataArray[n2].dBNandNHD);
            }
            DistortionData.toLogAvg(fArray, n4);
            distortionData.dBNandNHD = fArray;
        }
        if (distortionData.harmData != null) {
            for (n3 = 0; n3 < distortionData.harmData.length; ++n3) {
                if (distortionData.harmData[n3] == null) continue;
                float[] fArray = new float[distortionData.harmData[n3].length];
                for (int i2 = 0; i2 < n4; ++i2) {
                    DistortionData.sumMagn(fArray, distortionDataArray[i2].harmData[n3]);
                }
                DistortionData.toLogAvg(fArray, n4);
                distortionData.harmData[n3] = fArray;
            }
        }
        return distortionData;
    }

    static void toLogAvg(float[] fArray, int n2) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = (float)(20.0 * Math.log10(fArray[i2] / (float)n2));
        }
    }

    static void sumMagn(float[] fArray, float[] fArray2) {
        if (fArray2 == null) {
            throw new IllegalArgumentException("Data set missing");
        }
        int n2 = 0;
        while (n2 < fArray.length) {
            double d2 = Math.pow(10.0, fArray2[n2] / 20.0f);
            int n3 = n2++;
            fArray[n3] = fArray[n3] + (float)d2;
        }
    }

    static float[][] deepCopy(float[][] fArray) {
        float[][] fArrayArray = new float[fArray.length][];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (fArray[i2] == null) continue;
            fArrayArray[i2] = (float[])fArray[i2].clone();
        }
        return fArrayArray;
    }

    DistortionData(IRData iRData) {
        int n2;
        this.splOffset = iRData.splOffset;
        this.sampleRate = (int)Math.round(1.0 / iRData.getIR().getT());
        this.ppo = 96;
        this.harmData = new float[10][];
        this.startFreq = (float)Math.max(iRData.startFreq, 10.0);
        double d2 = Math.pow(2.0, 1.0 / (double)this.ppo);
        this.logStep = (float)d2;
        this.logStepLog = Math.log(d2);
        double d3 = this.startFreq;
        this.irEndFreq = (float)iRData.endFreq;
        this.endFreq = iRData.usedNovak() ? (float)Math.min(iRData.endFreq * 9.0, 0.475 / iRData.getIR().getT()) : (float)Math.min(iRData.endFreq, 0.475 / iRData.getIR().getT());
        int n3 = (int)Math.floor((double)this.ppo * Math.log(this.endFreq / this.startFreq) / Math.log(2.0)) + 1;
        this.freqs = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.freqs[n2] = (float)d3;
            if (!((d3 *= this.logStep) > (double)this.endFreq)) continue;
            this.endFreq = (float)(d3 / this.logStep);
            ++n2;
            break;
        }
        this.dataLength = n2;
        if (n2 < n3) {
            float[] fArray = new float[n2];
            System.arraycopy(this.freqs, 0, fArray, 0, n2);
            this.freqs = fArray;
        }
        this.isFromIR = true;
        this.usedNovak = iRData.usedNovak();
        this.indexData = this.freqs;
        this.signalDescription = "Swept sine";
    }

    DistortionData(ArrayList<SteppedSineDataPoint> arrayList, float[] fArray, StepTest stepTest, double d2, int n2, int n3, int n4, int n5, String string) {
        double d3;
        this.isFromIR = false;
        this.isIMD = stepTest.isIMD();
        this.isMT = stepTest.isMT();
        this.isSteppedInLevel = stepTest.isLevel();
        this.signalDescription = string;
        this.splOffset = d2;
        this.sampleRate = n2;
        this.distortionHP = n4;
        this.distortionLP = n5;
        this.dataLength = arrayList.size();
        SteppedSineDataPoint[] steppedSineDataPointArray = new SteppedSineDataPoint[this.dataLength];
        SteppedSineDataPoint steppedSineDataPoint = arrayList.get(0);
        SteppedSineDataPoint steppedSineDataPoint2 = arrayList.get(arrayList.size() - 1);
        double d4 = steppedSineDataPoint.generatorLeveldBFS;
        double d5 = steppedSineDataPoint2.generatorLeveldBFS;
        if (d4 > d5) {
            for (int i2 = 0; i2 < this.dataLength; ++i2) {
                steppedSineDataPointArray[i2] = arrayList.get(this.dataLength - 1 - i2);
            }
        } else {
            arrayList.toArray(steppedSineDataPointArray);
        }
        this.startFreq = (float)steppedSineDataPointArray[0].freq;
        this.endFreq = (float)steppedSineDataPointArray[this.dataLength - 1].freq;
        this.startLevel = (float)steppedSineDataPointArray[0].generatorLeveldBFS;
        this.endLevel = (float)steppedSineDataPointArray[this.dataLength - 1].generatorLeveldBFS;
        this.freqs = new float[this.dataLength];
        this.levels = new float[this.dataLength];
        if (this.isIMD) {
            this.imddB = new float[this.dataLength];
            this.tdPlusNdB = new float[this.dataLength];
            this.refdB = new float[this.dataLength];
            this.imdSt = steppedSineDataPointArray[0].imdSt;
        } else if (this.isMT) {
            this.tdPlusNdB = new float[this.dataLength];
            this.refdB = new float[this.dataLength];
        } else {
            this.harmData = new float[10][];
            this.harmData[0] = new float[this.dataLength];
            this.thdPlusN = new float[this.dataLength];
            this.dBNandNHD = new float[this.dataLength];
        }
        double d6 = (double)n2 / (double)n3;
        int n6 = 0;
        if (fArray != null && steppedSineDataPointArray[0].spectrumData != null) {
            this.spectrumPPO = 96;
            this.spectrum = new float[this.dataLength + 1][];
            this.spectrumStartFreq = 10.0;
            this.spectrumLogStep = Math.pow(2.0, 1.0 / (double)this.spectrumPPO);
            this.spectrumLogStepLog = Math.log(this.spectrumLogStep);
            n6 = (int)Math.floor((double)this.spectrumPPO * Math.log(((double)(n2 / 2) - d6) / this.spectrumStartFreq) / Math.log(2.0)) + 1;
            this.spectrumEndFreq = this.spectrumStartFreq * Math.pow(this.spectrumLogStep, n6 - 1);
            this.spectrum[this.dataLength] = DistortionData.convertToLogSpaced(fArray, this.spectrumStartFreq, d6, this.spectrumLogStep, n6, d2, d6);
        }
        for (int i3 = 0; i3 < this.dataLength; ++i3) {
            this.freqs[i3] = (float)steppedSineDataPointArray[i3].freq;
            this.levels[i3] = (float)steppedSineDataPointArray[i3].generatorLeveldBFS;
            if (this.isIMD) {
                this.imddB[i3] = (float)(steppedSineDataPointArray[i3].imddB + d2);
                this.tdPlusNdB[i3] = (float)(steppedSineDataPointArray[i3].tdPlusNdB + d2);
                this.refdB[i3] = (float)(steppedSineDataPointArray[i3].imdRef + d2);
            } else if (this.isMT) {
                this.tdPlusNdB[i3] = (float)(steppedSineDataPointArray[i3].tdPlusNdB + d2);
                this.refdB[i3] = (float)(steppedSineDataPointArray[i3].tdPlusNRef + d2);
            } else {
                d3 = steppedSineDataPointArray[i3].dBThd;
                this.harmData[0][i3] = (float)(d3 + d2);
                double d7 = steppedSineDataPointArray[i3].dBThdPlusN;
                this.thdPlusN[i3] = (float)(d7 + d2);
                this.dBNandNHD[i3] = (float)(steppedSineDataPointArray[i3].dBNandNHD + d2);
                for (int i4 = 1; i4 <= steppedSineDataPointArray[i3].dBHarmonicData.length; ++i4) {
                    if (this.harmData[i4] == null) {
                        this.harmData[i4] = new float[this.dataLength];
                    }
                    this.harmData[i4][i3] = (float)(steppedSineDataPointArray[i3].dBHarmonicData[i4 - 1] + d2);
                }
            }
            if (steppedSineDataPointArray[i3].spectrumData == null) continue;
            this.spectrum[i3] = DistortionData.convertToLogSpaced(steppedSineDataPointArray[i3].spectrumData, this.spectrumStartFreq, d6, this.spectrumLogStep, n6, d2, d6);
        }
        this.indexData = this.isSteppedInLevel ? this.levels : this.freqs;
        if (fArray != null) {
            this.noiseFloorSPL = new float[this.dataLength];
            if (this.isSteppedInLevel) {
                float f2 = this.freqs[0];
                d3 = 1.0;
                float f3 = (float)Math.pow(2.0, 0.5);
                float f4 = this.getNoiseMaxInSpan(f2, f2 / f3, d6, fArray, f2 * f3);
                Arrays.fill(this.noiseFloorSPL, f4 + (float)d2);
            } else {
                float f5 = this.freqs[0];
                float f6 = this.freqs[0];
                for (int i5 = 0; i5 < this.dataLength; ++i5) {
                    int n7 = i5 + 1;
                    if (n7 == this.dataLength) {
                        n7 = this.dataLength - 1;
                    }
                    float f7 = this.freqs[n7];
                    float f8 = this.getNoiseMaxInSpan(f5, f6, d6, fArray, f7);
                    this.noiseFloorSPL[i5] = f8 + (float)d2;
                    f6 = f5;
                    f5 = f7;
                }
            }
        }
    }

    String getIMDSt() {
        return this.imdSt;
    }

    String getSignalDescription() {
        return this.signalDescription;
    }

    private float getNoiseMaxInSpan(float f2, float f3, double d2, float[] fArray, float f4) {
        double d3 = Math.sqrt(f2 * f3);
        int n2 = (int)Math.round(d3 / d2) - 1;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= fArray.length) {
            n2 = fArray.length - 1;
        }
        double d4 = Math.sqrt(f2 * f4);
        int n3 = (int)Math.round(d4 / d2) - 2;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= fArray.length) {
            n3 = fArray.length - 1;
        }
        float f5 = -3.4028235E38f;
        if (n3 < n2) {
            n3 = n2;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!(fArray[i2] > f5)) continue;
            f5 = fArray[i2];
        }
        return f5;
    }

    DistortionData(double d2, int n2, int n3, int n4, String string, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] ... fArray5) {
        this.isFromIR = false;
        this.signalDescription = string;
        this.splOffset = d2;
        this.sampleRate = n2;
        this.distortionHP = n3;
        this.distortionLP = n4;
        this.dataLength = fArray.length;
        this.startFreq = fArray[0];
        this.endFreq = fArray[this.dataLength - 1];
        this.freqs = new float[this.dataLength];
        System.arraycopy(fArray, 0, this.freqs, 0, this.dataLength);
        this.harmData = new float[10][];
        this.harmData[1] = new float[this.dataLength];
        System.arraycopy(fArray2, 0, this.harmData[1], 0, this.dataLength);
        if (fArray3 != null) {
            this.harmData[0] = new float[this.dataLength];
            System.arraycopy(fArray3, 0, this.harmData[0], 0, this.dataLength);
        }
        if (fArray4 != null) {
            this.thdPlusN = new float[this.dataLength];
            System.arraycopy(fArray4, 0, this.thdPlusN, 0, this.dataLength);
        }
        int n5 = 2;
        for (float[] fArray6 : fArray5) {
            if (fArray6 == null) continue;
            this.harmData[n5] = new float[this.dataLength];
            System.arraycopy(fArray6, 0, this.harmData[n5], 0, this.dataLength);
            if (++n5 >= this.harmData.length) break;
        }
        this.indexData = this.freqs;
    }

    DistortionData(double d2, int n2, int n3, int n4, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float f2, float f3, String string) {
        this.isFromIR = false;
        this.isMT = true;
        this.signalDescription = string;
        this.splOffset = d2;
        this.sampleRate = n2;
        this.distortionHP = n3;
        this.distortionLP = n4;
        this.dataLength = fArray.length;
        this.startFreq = fArray[0];
        this.endFreq = fArray[this.dataLength - 1];
        this.firstTone = f2;
        this.lastTone = f3;
        this.freqs = new float[this.dataLength];
        System.arraycopy(fArray, 0, this.freqs, 0, this.dataLength);
        this.refdB = new float[this.dataLength];
        System.arraycopy(fArray2, 0, this.refdB, 0, this.dataLength);
        if (fArray3 != null) {
            this.tdPlusNdB = new float[this.dataLength];
            System.arraycopy(fArray3, 0, this.tdPlusNdB, 0, this.dataLength);
        }
        if (fArray4 != null) {
            this.noiseFloorSPL = new float[this.dataLength];
            System.arraycopy(fArray4, 0, this.noiseFloorSPL, 0, this.dataLength);
        }
        this.indexData = this.freqs;
    }

    int getExportStartFreqIndex() {
        if (this.isMT) {
            double d2 = (this.freqs[this.freqs.length - 1] - this.freqs[0]) / (float)(this.freqs.length - 1);
            return (int)Math.round((double)this.firstTone / d2) - 1;
        }
        return 0;
    }

    int getExportEndFreqIndex() {
        if (this.isMT) {
            double d2 = (this.freqs[this.freqs.length - 1] - this.freqs[0]) / (float)(this.freqs.length - 1);
            return (int)Math.round((double)this.lastTone / d2) - 1;
        }
        return this.freqs.length - 1;
    }

    boolean isFromStepped() {
        return this.isFromIR == false;
    }

    boolean isFromIR() {
        return this.isFromIR;
    }

    boolean isSteppedInLevel() {
        return this.isSteppedInLevel;
    }

    boolean isSteppedInLevelTHD() {
        return this.isSteppedInLevel && !this.isIMD && !this.isMT;
    }

    boolean isSteppedInLevelIMD() {
        return this.isSteppedInLevel && this.isIMD;
    }

    boolean isSteppedInLevelMT() {
        return this.isSteppedInLevel && this.isMT;
    }

    boolean isSingleMT() {
        return this.isMT && !this.isSteppedInLevel;
    }

    boolean isMultitone() {
        return this.isMT;
    }

    boolean hasTHD() {
        return this.harmData != null;
    }

    float[] getFundamental() {
        return this.isIMD || this.isMT ? this.refdB : this.harmData[1];
    }

    float[] getTHD() {
        return this.harmData[0];
    }

    float[] getGeneratorLevels() {
        return this.levels;
    }

    float[] getFrequencies() {
        return this.freqs;
    }

    float maxFundamental() {
        float[] fArray;
        float f2 = -3.4028235E38f;
        for (float f3 : fArray = this.getFundamental()) {
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    float minFundamental() {
        float[] fArray;
        float f2 = Float.MAX_VALUE;
        for (float f3 : fArray = this.getFundamental()) {
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    float maxDist() {
        float f2 = -3.4028235E38f;
        float[] fArray = this.isIMD ? this.imddB : (this.isMT ? this.tdPlusNdB : this.harmData[0]);
        for (float f3 : fArray) {
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    float minDist() {
        float f2 = Float.MAX_VALUE;
        float[] fArray = this.isIMD ? this.imddB : (this.isMT ? this.tdPlusNdB : this.harmData[0]);
        for (float f3 : fArray) {
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    float[] getXAxisData() {
        if (this.isSteppedInLevel) {
            return this.levels;
        }
        return this.freqs;
    }

    void calculateNoiseFloorSPL(MeasData measData) {
        int n2;
        float[] fArray = measData.getPreCaptureData();
        int n3 = measData.getNumSweeps();
        int n4 = 16384;
        int n5 = 8192;
        int n6 = fArray.length / 8192 - 2;
        if (n6 == 0) {
            n6 = 1;
        }
        float[] fArray2 = new float[16384];
        float[] fArray3 = new float[8191];
        boolean bl = true;
        for (n2 = 0; n2 < n6; ++n2) {
            int n7;
            System.arraycopy(fArray, n2 * 8192, fArray2, 0, 16384);
            double d2 = Window.Types.HANNING.coherentGain();
            for (n7 = 0; n7 < 16384; ++n7) {
                int n8 = n7;
                fArray2[n8] = (float)((double)fArray2[n8] * (Window.Types.HANNING.fullWindowVal((double)n7 / 16385.0) / d2));
            }
            SweepAnalyser.A(fArray2, 16384);
            for (n7 = 1; n7 < 8192; ++n7) {
                int n9 = 2 * n7;
                float f2 = fArray2[n9] * fArray2[n9] + fArray2[n9 + 1] * fArray2[n9 + 1];
                if (!(f2 > fArray3[n7 - 1])) continue;
                fArray3[n7 - 1] = f2;
            }
        }
        this.calcNoiseFloorRTASet(96, F.h(), 16384, fArray3, Window.Types.HANNING.noiseBW());
        if (n3 > 1) {
            float f3 = (float)(10.0 * Math.log10(n3));
            int n10 = 0;
            while (n10 < this.noiseFloorSPL.length) {
                int n11 = n10++;
                this.noiseFloorSPL[n11] = this.noiseFloorSPL[n11] - f3;
            }
        }
        if (lG.\u020e()) {
            for (n2 = 0; n2 < this.noiseFloorSPL.length; ++n2) {
                this.noiseFloorSPL[n2] = (float)SweepAnalyser.A((double)this.noiseFloorSPL[n2], 0.0, this.freqs[n2], true, measData.meterCal, measData.scCal);
            }
        }
    }

    private void calcNoiseFloorRTASet(int n2, int n3, int n4, float[] fArray, double d2) {
        double d3;
        float f22;
        int n5 = 2;
        ArrayList<Float> arrayList = new ArrayList<Float>(500);
        double d4 = Math.pow(10.0, 0.3 / (double)n2);
        double d5 = Math.sqrt(d4);
        double d6 = d5 - 1.0 / d5;
        double d7 = (double)n3 / (double)n4;
        for (float f22 : this.freqs) {
            double d8;
            int n6 = (int)Math.round((double)f22 / d7);
            if (n6 == 0) {
                n6 = 1;
            }
            if ((d8 = d6 * (double)n6) < 2.0) {
                arrayList.add(Float.valueOf((float)d8));
                continue;
            }
            d3 = (double)f22 / d5;
            arrayList.add(Float.valueOf((float)(d3 / d7)));
        }
        double d9 = (double)this.freqs[this.freqs.length - 1] * d5;
        arrayList.add(Float.valueOf((float)(d9 / d7)));
        arrayList.trimToSize();
        Float[] floatArray = new Float[arrayList.size()];
        floatArray = arrayList.toArray(floatArray);
        this.noiseFloorSPL = new float[this.freqs.length];
        f22 = (float)(10.0 * Math.log10(n2) + this.splOffset);
        double d10 = 1.0 / (double)(n4 * n4);
        for (int i2 = 0; i2 < this.freqs.length; ++i2) {
            int n7;
            d3 = 0.0;
            if (floatArray[i2].floatValue() < 2.0f) {
                n7 = (int)Math.round((double)this.freqs[i2] / d7) - 1;
                if (n7 < 0) {
                    n7 = 0;
                }
                d3 = fArray[n7] * floatArray[i2].floatValue();
            } else {
                n7 = (int)Math.ceil((double)floatArray[i2].floatValue() + 0.5);
                int n8 = (int)Math.floor((double)floatArray[i2 + 1].floatValue() - 0.5);
                for (int i3 = n7; i3 <= n8; ++i3) {
                    d3 += (double)fArray[i3 - 1];
                }
                if (n7 > n8 + 1) {
                    d3 -= (double)fArray[n8 + 1];
                } else {
                    d3 += (double)fArray[n7 - 2] * ((double)n7 - 0.5 - (double)floatArray[i2].floatValue());
                    d3 += (double)fArray[n8] * ((double)(floatArray[i2 + 1].floatValue() - (float)n8) - 0.5);
                }
            }
            this.noiseFloorSPL[i2] = f22 + (float)(10.0 * Math.log10(Math.max(d10 * d3 / d2, 1.0E-24)));
        }
    }

    static float[] convertToLogSpaced(float[] fArray, double d2, double d3, double d4, int n2, double d5, double d6) {
        float[] fArray2 = new float[n2];
        double d7 = d2;
        double d8 = Math.sqrt(d4);
        double d9 = d7 / d8;
        boolean[] blArray = new boolean[fArray.length];
        Arrays.fill(blArray, false);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4;
            d9 = d7 * d8;
            double d10 = d9;
            if (d9 - d10 < d3) {
                n4 = (int)Math.round((d7 - d6) / d3);
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 >= fArray.length) {
                    n4 = fArray.length - 1;
                }
                double d11 = (double)n4 * d3 + d6;
                if (d10 <= d11 && d9 > d11) {
                    fArray2[i2] = fArray[n4] + (float)d5;
                } else {
                    n3 = (int)((d7 - d6) / d3);
                    if (n3 >= 0 && n3 <= fArray.length - 1) {
                        float f2 = (float)((d7 - d6) / d3 - (double)n3);
                        if (n3 == 0) {
                            n3 = 1;
                            f2 -= 1.0f;
                        } else if (n3 > fArray.length - 3) {
                            f2 += (float)(fArray.length - 1 - n3);
                            n3 = fArray.length - 3;
                        }
                        float f3 = IF.A(f2, fArray[n3 - 1], fArray[n3], fArray[n3 + 1], fArray[n3 + 2], 0.0f);
                        fArray2[i2] = (float)((double)f3 + d5);
                    }
                }
                blArray[n4] = true;
            } else {
                n4 = (int)Math.ceil((d10 - d6) / d3);
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 >= fArray.length) {
                    n4 = fArray.length - 1;
                }
                int n5 = (int)((d9 - d6) / d3);
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 >= fArray.length) {
                    n5 = fArray.length - 1;
                }
                if (n5 < n4) {
                    n5 = n4;
                }
                float f4 = -3.4028235E38f;
                for (n3 = n4; n3 <= n5; ++n3) {
                    if (fArray[n3] > f4) {
                        f4 = fArray[n3];
                    }
                    blArray[n3] = true;
                }
                fArray2[i2] = f4 + (float)d5;
            }
            d7 *= d4;
        }
        return fArray2;
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.ppo == 0) {
            this.ppo = 96;
        }
        if (this.isFromIR == null) {
            this.isFromIR = this.ir != null;
        }
        if (this.irEndFreq == 0.0f) {
            this.irEndFreq = this.endFreq;
        }
        if (this.splOffset == null) {
            this.splOffset = this.isFromIR != false ? Double.valueOf(this.ir.splOffset) : Double.valueOf(0.0);
        }
        if (this.sampleRate == 0 && this.isFromIR.booleanValue()) {
            this.sampleRate = (int)Math.round(1.0 / this.ir.T);
        }
        this.ir = null;
        this.calcInProgress = false;
        if (this.indexData == null) {
            this.indexData = this.freqs;
        }
        if (this.imdRefdB != null) {
            this.refdB = (float[])this.imdRefdB.clone();
            this.imdRefdB = null;
        }
        return this;
    }

    boolean thdIsFiltered() {
        return this.distortionHP != 0 || this.distortionLP != 0;
    }

    private boolean rangeValid(int n2) {
        return !this.isMT || this.isSteppedInLevel;
    }

    String distortionSpan(int n2) {
        if (this.thdIsFiltered() && this.rangeValid(n2)) {
            int n3 = this.distortionHP;
            int n4 = this.distortionLP != 0 ? this.distortionLP : (int)(0.95 * (double)this.sampleRate / 2.0);
            return " [" + n3 + ".." + n4 + " Hz]";
        }
        return "";
    }

    void addOffset(double d2) {
        for (float[] fArray : this.harmData) {
            if (fArray == null || fArray.length <= 0) continue;
            int n2 = 0;
            while (n2 < fArray.length) {
                int n3 = n2++;
                fArray[n3] = fArray[n3] + (float)d2;
            }
        }
        this.updatePeak();
        if (this.dBNandNHD != null) {
            int n4 = 0;
            while (n4 < this.dBNandNHD.length) {
                int n5 = n4++;
                this.dBNandNHD[n5] = this.dBNandNHD[n5] + (float)d2;
            }
        }
        if (this.noiseFloorSPL != null) {
            int n6 = 0;
            while (n6 < this.noiseFloorSPL.length) {
                int n7 = n6++;
                this.noiseFloorSPL[n7] = this.noiseFloorSPL[n7] + (float)d2;
            }
        }
        this.calcTHD(this.lastNormalise);
    }

    void updatePeak() {
        float f2 = -3.4028235E38f;
        float[] fArray = this.getFundamental();
        if (fArray != null) {
            for (float f3 : fArray) {
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
        }
        this.fundamentalPeak = Float.valueOf(f2);
    }

    int length() {
        return this.dataLength;
    }

    boolean hasDataToExport() {
        return this.hasTHD() ? this.getHighestHarmonic() > 1 : true;
    }

    boolean hasData(int n2) {
        if (n2 == 1) {
            return this.isIMD || this.isMT ? this.refdB != null && this.refdB.length > 1 : this.harmData != null && this.harmData[n2] != null && this.harmData[n2].length > 1;
        }
        if (n2 >= 0) {
            return this.harmData != null && this.harmData[n2] != null && this.harmData[n2].length > 1;
        }
        if (n2 == -1) {
            return this.thdPlusN != null && this.thdPlusN.length > 1;
        }
        if (n2 == -2) {
            return this.dBNandNHD != null && this.dBNandNHD.length > 1;
        }
        if (n2 == -3) {
            return this.noiseFloorSPL != null && this.noiseFloorSPL.length > 1;
        }
        if (n2 == -4) {
            return this.imddB != null && this.imddB.length > 1;
        }
        if (n2 == -5) {
            return this.tdPlusNdB != null && this.tdPlusNdB.length > 1;
        }
        return false;
    }

    boolean hasValueAt(float f2, int n2, boolean bl) {
        if (this.isSteppedInLevel) {
            float[] fArray = this.getFundamental();
            float[] fArray2 = bl ? this.levels : fArray;
            return f2 >= fArray2[0] && f2 <= fArray2[fArray2.length - 1];
        }
        return f2 >= this.getStartFreq(n2) && f2 <= this.maxValidFreq(n2, false);
    }

    boolean hasDataInSpan(float f2, float f3, $B $B, MeasData measData, boolean bl) {
        if (this.isSteppedInLevel) {
            float[] fArray = this.getFundamental();
            float[] fArray2 = bl ? this.levels : fArray;
            double d2 = eJ.B($B, bl, measData);
            return (double)f3 + d2 >= (double)fArray2[0] && (double)f2 + d2 <= (double)fArray2[fArray2.length - 1];
        }
        return f3 >= this.startFreq && f2 <= this.maxValidFreq(1, false);
    }

    boolean hasSpectrumData() {
        return this.spectrum != null && this.spectrum[0] != null;
    }

    int getHighestHarmonic() {
        for (int i2 = 0; i2 < this.harmData.length; ++i2) {
            if (this.harmData[i2] != null && this.harmData[i2].length >= 2) continue;
            return i2 - 1;
        }
        return this.harmData.length - 1;
    }

    void calcTHD(boolean bl) {
        boolean bl2 = lG.\u0257() == AxisOption.GENERATOR;
        this.lastNormalise = bl;
        if (this.harmData[2] != null) {
            this.calcInProgress = true;
            this.harmData[0] = new float[this.dataLength];
            boolean bl3 = true;
            for (int i2 = 0; i2 < this.dataLength; ++i2) {
                double d2 = 0.0;
                float f2 = this.indexData[i2];
                for (int i3 = 2; i3 <= lG.\u0195 && i3 < this.harmData.length; ++i3) {
                    if (this.harmData[i3] == null || !this.isValid(f2, i3, true)) continue;
                    double d3 = this.harmSPL(f2, 0.0f, i3, bl, true, bl2);
                    d2 += Math.pow(10.0, d3 / 10.0);
                }
                this.harmData[0][i2] = d2 == 0.0 && i2 > 0 ? this.harmData[0][i2 - 1] : (float)(10.0 * Math.log10(d2));
                if (this.dBNandNHD == null) continue;
                double d4 = Math.pow(10.0, this.harmSPL(f2, 0.0f, -2, bl, true, bl2) / 10.0f);
                this.thdPlusN[i2] = (float)(10.0 * Math.log10(d2 + d4));
            }
            this.calcInProgress = false;
        }
    }

    float calcNormTHD(float f2) {
        boolean bl;
        double d2 = 0.0;
        boolean bl2 = bl = lG.\u0257() == AxisOption.GENERATOR;
        if (this.harmData[2] != null) {
            boolean bl3 = true;
            for (int i2 = 2; i2 <= lG.\u0195 && i2 < this.harmData.length; ++i2) {
                if (this.harmData[i2] == null || !this.isValid(f2, i2, true)) continue;
                float f3 = this.useFundAtHarmFreq(true) ? f2 * (float)i2 : f2;
                float f4 = this.harmSPL(f3, 0.0f, 1, false, true, bl);
                float f5 = this.harmSPL(f2, 0.0f, i2, false, true, bl);
                double d3 = f5 - f4;
                d2 += Math.pow(10.0, d3 / 10.0);
            }
        }
        return (float)(10.0 * Math.log10(d2));
    }

    private boolean useFundAtHarmFreq(boolean bl) {
        if (bl) {
            return !this.isSteppedInLevel && (lG.\u0266() || lG.\u010d() && this.isFromIR());
        }
        return !this.isSteppedInLevel && lG.\u0266() && (!lG.\u010d() || !this.isFromIR());
    }

    boolean isValid(float f2, int n2, boolean bl) {
        if (this.isSteppedInLevel) {
            return f2 >= this.indexData[0] && f2 <= this.indexData[this.indexData.length - 1];
        }
        return f2 <= this.maxValidFreq(n2, bl);
    }

    float calcNormTHDPlusN(float f2) {
        boolean bl = lG.\u0257() == AxisOption.GENERATOR;
        double d2 = Math.pow(10.0, this.calcNormTHD(f2) / 10.0f);
        if (this.dBNandNHD != null) {
            double d3 = this.harmSPL(f2, 0.0f, -2, false, true, bl);
            float f3 = this.dataCubic(this.harmData[1], f2, 0.0f, bl);
            if (lG.\u041f && !this.isSteppedInLevel) {
                if (this.fundamentalPeak == null) {
                    this.updatePeak();
                }
                if (f3 < this.fundamentalPeak.floatValue() - 30.0f) {
                    f3 = this.fundamentalPeak.floatValue() - 30.0f;
                }
            }
            return (float)(10.0 * Math.log10(d2 + Math.pow(10.0, (d3 -= (double)f3) / 10.0)));
        }
        return (float)(10.0 * Math.log10(d2));
    }

    void calcHarmonic(int n2, MeasData measData) {
        int n3;
        float[] fArray;
        IRData iRData = measData.irData;
        double d2 = iRData.getIR().getT();
        if (iRData.hasDistData() && n2 > 1) {
            fArray = iRData.getDistData();
            n3 = fArray.length - 1;
        } else {
            fArray = iRData.getIR().getData();
            n3 = iRData.getIR().absMaxIndex;
        }
        double d3 = iRData.harmFactor * Math.log(n2);
        int n4 = n2 > 1 ? (int)Math.round(d3 / d2) : 0;
        int n5 = n3 - n4;
        double d4 = n2 > 1 ? iRData.harmFactor * (Math.log(n2) - Math.log(n2 - 1)) : iRData.harmFactor / Math.log(2.0);
        double d5 = iRData.harmFactor * (Math.log(n2 + 1) - Math.log(n2));
        double d6 = 0.2;
        double d7 = 0.67;
        double d8 = 0.2 * d5 + 0.67 * d4;
        int n6 = (int)Math.round(d8 / d2);
        if (n5 > 0 && n6 > 64) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            double d9 = 2.0;
            double d10 = 1.0;
            if (d8 > 2.0) {
                d10 = 2.0 / d8;
            }
            if ((n11 = lH.C((int)Math.round(d10 * d8 / d2))) > n6) {
                n11 = lH.C(n6);
            }
            FloatFFT_1D floatFFT_1D = SweepAnalyser.B(n11);
            if (n6 > n11) {
                n6 = n11;
            }
            float[] fArray2 = new float[n11];
            if (n2 == 1) {
                n10 = (int)Math.min(0.25 * (double)n6, (double)n5);
                n9 = (int)Math.min((double)n6 * 0.75, (double)(fArray.length - n5));
            } else {
                n10 = (int)Math.min(Math.round(d10 * 0.2 * d5 / d2), (long)n5);
                n9 = (int)Math.min(Math.round(d10 * 0.67 * d4 / d2), (long)(fArray.length - n5));
            }
            Arrays.fill(fArray2, 0.0f);
            System.arraycopy(fArray, n5 - n10, fArray2, 0, n10 + n9);
            for (n8 = 0; n8 < n10; ++n8) {
                int n12 = n8;
                fArray2[n12] = (float)((double)fArray2[n12] * Window.Types.HANNING.leftWindowVal((double)n8 / (double)(n10 - 1)));
            }
            for (n8 = 1; n8 < n9; ++n8) {
                int n13 = n8 + n10;
                fArray2[n13] = (float)((double)fArray2[n13] * Window.Types.HANNING.rightWindowVal((double)n8 / (double)(n9 - 1)));
            }
            floatFFT_1D.realForward(fArray2);
            float[][] fArray3 = this.toSPL(fArray2, iRData);
            this.smoothIIR(0.25 * (double)this.ppo, fArray3[0], fArray3[1][0], fArray3[1][2]);
            float[] fArray4 = new float[this.dataLength];
            for (n7 = 0; n7 < this.dataLength; ++n7) {
                fArray4[n7] = this.splHermite(this.freqs[n7], fArray3[0], fArray3[1][0], fArray3[1][1], fArray3[1][2]);
                assert (fArray4[n7] != 0.0f) : "zero SPL ";
            }
            if (lG.\u020e()) {
                for (n7 = 0; n7 < fArray4.length; ++n7) {
                    fArray4[n7] = (float)SweepAnalyser.A((double)fArray4[n7], 0.0, this.freqs[n7], true, measData.meterCal, measData.scCal);
                }
            }
            this.harmData[n2] = fArray4;
        }
    }

    private float[][] toSPL(float[] fArray, IRData iRData) {
        int n2 = fArray.length / 2;
        double d2 = 1.0 / (iRData.getIR().getT() * (double)n2 * 2.0);
        int n3 = (int)Math.floor((double)this.startFreq / d2);
        int n4 = (int)Math.min(Math.round((double)this.endFreq / d2), (long)(n2 - 1));
        float[] fArray2 = new float[n4 - n3 + 1];
        for (int i2 = n3; i2 <= n4; ++i2) {
            int n5 = i2 << 1;
            float f2 = fArray[n5];
            float f3 = fArray[n5 + 1];
            double d3 = f2 * f2 + f3 * f3;
            double d4 = iRData.splOffset - 3.0 + 10.0 * Math.log10(Math.max(d3, (double)1.4E-45f));
            fArray2[i2 - n3] = (float)d4;
        }
        float[][] fArrayArray = new float[2][];
        fArrayArray[0] = fArray2;
        float[] fArray3 = new float[]{(float)(d2 * (double)n3), (float)(d2 * (double)n4), (float)d2};
        fArrayArray[1] = fArray3;
        return fArrayArray;
    }

    float maxValidFreq(int n2, boolean bl) {
        float f2;
        float f3 = (float)(0.95 * (double)this.sampleRate * 0.5);
        if (this.isFromIR.booleanValue()) {
            switch (n2) {
                case 0: {
                    if (this.usedNovak) {
                        float f4 = Math.min(f3, this.irEndFreq);
                        return lG.\u0266() ? f4 / 2.0f : f4;
                    }
                    return Math.min(f3, this.endFreq) / 2.0f;
                }
                case -2: 
                case -1: {
                    return Math.min(f3, this.endFreq);
                }
                case -3: {
                    return this.endFreq;
                }
            }
            if (this.usedNovak) {
                if (lG.\u0266()) {
                    return Math.min(f3, this.irEndFreq) / (float)this.lookupFactor(n2, bl);
                }
                if (lG.\u010d()) {
                    return Math.min(f3, this.irEndFreq * (float)n2);
                }
                return Math.min(f3, this.irEndFreq);
            }
            return Math.min(f3, this.endFreq) / (float)this.lookupFactor(n2, bl);
        }
        switch (n2) {
            case 0: {
                f2 = Math.min(f3 / 2.0f, this.endFreq);
                if (this.distortionLP <= 0) break;
                f2 = Math.min(f2, (float)(this.distortionLP / 2));
                break;
            }
            case -2: 
            case -1: {
                f2 = Math.min(f3, this.endFreq);
                if (this.distortionLP <= 0) break;
                f2 = Math.min(f2, (float)this.distortionLP);
                break;
            }
            case -5: 
            case -4: 
            case -3: {
                f2 = this.endFreq;
                break;
            }
            case 1: {
                f2 = Math.min(f3, this.getEndFreq(1));
                break;
            }
            default: {
                f2 = Math.min(f3 / (float)n2, this.getEndFreq(n2));
                if (this.distortionLP <= 0) break;
                f2 = Math.min(f2, (float)(this.distortionLP / n2));
            }
        }
        if (f2 < this.endFreq) {
            for (int i2 = this.dataLength - 1; i2 >= 0; --i2) {
                if (!(this.freqs[i2] <= f2)) continue;
                f2 = this.freqs[i2];
                break;
            }
        }
        return f2;
    }

    float harmSPL(float f2, float f3, int n2, boolean bl, boolean bl2, boolean bl3) {
        float f4;
        boolean bl4 = lG.\u041f && !this.isSteppedInLevel;
        switch (n2) {
            case -4: {
                f4 = this.dataCubic(this.imddB, f2, f3, bl3);
                if (!bl) break;
                float[] fArray = this.getFundamental();
                float f5 = this.dataCubic(fArray, f2, f3, bl3);
                f4 -= f5;
                break;
            }
            case -5: {
                f4 = this.dataCubic(this.tdPlusNdB, f2, f3, bl3);
                if (!bl) break;
                float[] fArray = this.getFundamental();
                float f6 = this.dataCubic(fArray, f2, f3, bl3);
                f4 -= f6;
                break;
            }
            case -3: {
                f4 = this.dataCubic(this.noiseFloorSPL, f2, f3, bl3);
                if (!bl) break;
                float[] fArray = this.getFundamental();
                float f7 = this.dataCubic(fArray, f2, f3, bl3);
                if (bl4) {
                    if (this.fundamentalPeak == null) {
                        this.updatePeak();
                    }
                    if (f7 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f7 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                }
                f4 -= f7;
                break;
            }
            case -2: {
                f4 = this.dataCubic(this.dBNandNHD, f2, f3, bl3);
                if (!bl || !this.isFromStepped()) break;
                float f8 = this.dataCubic(this.harmData[1], f2, f3, bl3);
                if (bl4) {
                    if (this.fundamentalPeak == null) {
                        this.updatePeak();
                    }
                    if (f8 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f8 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                }
                f4 -= f8;
                break;
            }
            case -1: {
                f4 = this.dataCubic(this.thdPlusN, f2, f3, bl3);
                break;
            }
            case 0: {
                f4 = this.dataCubic(this.harmData[n2], f2, f3, bl3);
                break;
            }
            case 1: {
                float[] fArray = this.getFundamental();
                f4 = bl ? 0.0f : this.dataCubic(fArray, f2, f3, bl3);
                break;
            }
            default: {
                int n3 = this.lookupFactor(n2, bl2);
                f4 = this.dataCubic(this.harmData[n2], f2 * (float)n3, f3 * (float)n3, bl3);
                if (!bl) break;
                float f9 = this.useFundAtHarmFreq(bl2) ? f2 * (float)n2 : f2;
                float f10 = this.dataCubic(this.harmData[1], f9, f3, bl3);
                if (bl4) {
                    if (this.fundamentalPeak == null) {
                        this.updatePeak();
                    }
                    if (f10 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f10 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                }
                f4 -= f10;
            }
        }
        assert (!Float.isNaN(f4)) : "indexValue " + f2 + ", harmonic " + n2 + ", xIsGeneratorLevel " + bl3;
        return f4;
    }

    float dataValue(int n2, int n3, boolean bl) {
        float f2;
        switch (n2) {
            case -4: {
                f2 = this.imddB[n3];
                if (!bl) break;
                float[] fArray = this.getFundamental();
                float f3 = fArray[n3];
                f2 -= f3;
                break;
            }
            case -5: {
                f2 = this.tdPlusNdB[n3];
                if (!bl) break;
                float[] fArray = this.getFundamental();
                float f4 = fArray[n3];
                f2 -= f4;
                break;
            }
            case -3: {
                f2 = this.noiseFloorSPL[n3];
                if (!bl) break;
                float[] fArray = this.getFundamental();
                float f5 = fArray[n3];
                f2 -= f5;
                break;
            }
            case -2: {
                f2 = this.dBNandNHD[n3];
                if (!bl) break;
                float[] fArray = this.getFundamental();
                float f6 = fArray[n3];
                f2 -= f6;
                break;
            }
            case -1: {
                f2 = this.thdPlusN[n3];
                break;
            }
            case 0: {
                f2 = this.harmData[n2][n3];
                break;
            }
            case 1: {
                float[] fArray = this.getFundamental();
                f2 = bl ? 0.0f : fArray[n3];
                break;
            }
            default: {
                f2 = this.harmData[n2][n3];
                if (!bl) break;
                float[] fArray = this.harmData[1];
                float f7 = fArray[n3];
                f2 -= f7;
            }
        }
        return f2;
    }

    int dataPoints(int n2) {
        switch (n2) {
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: {
                return this.dataLength;
            }
        }
        return this.harmData[n2].length;
    }

    private boolean plotHarmonicsAtHarmonicFrequency() {
        return lG.\u010d();
    }

    int lookupFactor(int n2, boolean bl) {
        if ((bl || !this.plotHarmonicsAtHarmonicFrequency()) && this.isFromIR()) {
            return n2;
        }
        return 1;
    }

    Line2D.Float harmMinMax(float f2, float f3, int n2, boolean bl) {
        Line2D.Float float_ = new Line2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        if (f2 < this.startFreq || f2 > this.endFreq) {
            return float_;
        }
        boolean bl2 = lG.\u041f && !this.isSteppedInLevel;
        boolean bl3 = lG.\u0257() == AxisOption.GENERATOR;
        switch (n2) {
            case -4: {
                this.minMax(this.imddB, f2, f3, float_, bl3);
                break;
            }
            case -5: {
                this.minMax(this.tdPlusNdB, f2, f3, float_, bl3);
                break;
            }
            case -3: {
                this.minMax(this.noiseFloorSPL, f2, f3, float_, bl3);
                if (!bl) break;
                float f4 = this.dataCubic(this.harmData[1], float_.x1, 0.0f, bl3);
                float f5 = this.dataCubic(this.harmData[1], float_.x2, 0.0f, bl3);
                if (bl2) {
                    if (this.fundamentalPeak == null) {
                        this.updatePeak();
                    }
                    if (f4 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f4 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                    if (f5 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f5 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                }
                float_.y1 -= f4;
                float_.y2 -= f5;
                break;
            }
            case -2: {
                this.minMax(this.dBNandNHD, f2, f3, float_, bl3);
                if (!bl || !this.isFromStepped()) break;
                float f6 = this.dataCubic(this.harmData[1], float_.x1, 0.0f, bl3);
                float f7 = this.dataCubic(this.harmData[1], float_.x2, 0.0f, bl3);
                if (bl2) {
                    if (this.fundamentalPeak == null) {
                        this.updatePeak();
                    }
                    if (f6 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f6 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                    if (f7 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f7 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                }
                float_.y1 -= f6;
                float_.y2 -= f7;
                break;
            }
            case -1: {
                this.minMax(this.thdPlusN, f2, f3, float_, bl3);
                break;
            }
            case 0: {
                this.minMax(this.harmData[n2], f2, f3, float_, bl3);
                break;
            }
            case 1: {
                float[] fArray = this.getFundamental();
                if (bl) {
                    float_.x1 = f2;
                    float_.x2 = f2;
                    break;
                }
                this.minMax(fArray, f2, f3, float_, bl3);
                break;
            }
            default: {
                this.minMax(this.harmData[n2], f2 * (float)this.lookupFactor(n2, false), f3 * (float)this.lookupFactor(n2, false), float_, bl3);
                float_.x1 /= (float)this.lookupFactor(n2, false);
                float_.x2 /= (float)this.lookupFactor(n2, false);
                if (!bl) break;
                float f8 = this.useFundAtHarmFreq(false) ? float_.x1 * (float)n2 : float_.x1;
                float f9 = this.useFundAtHarmFreq(false) ? float_.x2 * (float)n2 : float_.x2;
                float f10 = this.dataCubic(this.harmData[1], f8, 0.0f, bl3);
                float f11 = this.dataCubic(this.harmData[1], f9, 0.0f, bl3);
                if (bl2) {
                    if (this.fundamentalPeak == null) {
                        this.updatePeak();
                    }
                    if (f10 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f10 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                    if (f11 < this.fundamentalPeak.floatValue() - 30.0f) {
                        f11 = this.fundamentalPeak.floatValue() - 30.0f;
                    }
                }
                float_.y1 -= f10;
                float_.y2 -= f11;
            }
        }
        return float_;
    }

    private void minMax(float[] fArray, float f2, float f3, Line2D.Float float_, boolean bl) {
        if (this.isFromIR.booleanValue()) {
            int n2;
            int n3 = (int)Math.round(Math.log(f2 / this.startFreq) / this.logStepLog);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > fArray.length - 1) {
                n3 = fArray.length - 1;
            }
            if ((n2 = (int)Math.round(Math.log((f2 + f3) / this.startFreq) / this.logStepLog)) < 0) {
                n2 = 0;
            }
            if (n2 > fArray.length - 1) {
                n2 = fArray.length - 1;
            }
            if (n2 <= n3) {
                float f4;
                float_.x1 = f4 = (float)((double)this.startFreq * Math.pow(this.logStep, n3));
                float_.y1 = fArray[n3];
                float_.x2 = float_.x1;
                float_.y2 = float_.y1;
            } else {
                float f5;
                float f6;
                float f7 = f6 = fArray[n3];
                int n4 = n3;
                int n5 = n3;
                for (int i2 = n3 + 1; i2 <= n2; ++i2) {
                    f5 = fArray[i2];
                    if (f5 < f6) {
                        f6 = f5;
                        n4 = i2;
                        continue;
                    }
                    if (!(f5 > f7)) continue;
                    f7 = f5;
                    n5 = i2;
                }
                float f8 = (float)((double)this.startFreq * Math.pow(this.logStep, n4));
                f5 = (float)((double)this.startFreq * Math.pow(this.logStep, n5));
                if (n4 <= n5) {
                    float_.x1 = f8;
                    float_.y1 = f6;
                    float_.x2 = f5;
                    float_.y2 = f7;
                } else {
                    float_.x1 = f5;
                    float_.y1 = f7;
                    float_.x2 = f8;
                    float_.y2 = f6;
                }
            }
        } else {
            int n6 = Arrays.binarySearch(this.freqs, f2);
            if (n6 < 0) {
                n6 = -n6 - 2;
            }
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 >= fArray.length - 2) {
                n6 = fArray.length - 2;
            }
            int n7 = Arrays.binarySearch(this.freqs, f2 + f3);
            if (n7 < 0) {
                n7 = -n6 - 2;
            }
            if (n7 < 0) {
                n7 = 0;
            } else if (n7 >= fArray.length - 1) {
                n7 = fArray.length - 1;
            }
            if (n7 <= n6) {
                float_.x1 = f2;
                float_.y1 = this.dataCubic(fArray, f2, f3, bl);
                float_.x2 = float_.x1;
                float_.y2 = float_.y1;
            } else {
                float f9;
                float f10;
                float f11 = f10 = fArray[n6];
                float f12 = f9 = this.freqs[n6];
                int n8 = n6;
                int n9 = n6;
                for (int i3 = n6 + 1; i3 <= n7; ++i3) {
                    float f13 = fArray[i3];
                    if (f13 < f10) {
                        f10 = f13;
                        f9 = this.freqs[i3];
                        n8 = i3;
                        continue;
                    }
                    if (!(f13 > f11)) continue;
                    f11 = f13;
                    f12 = this.freqs[i3];
                    n9 = i3;
                }
                if (n8 <= n9) {
                    float_.x1 = f9;
                    float_.y1 = f10;
                    float_.x2 = f12;
                    float_.y2 = f11;
                } else {
                    float_.x1 = f12;
                    float_.y1 = f11;
                    float_.x2 = f9;
                    float_.y2 = f10;
                }
            }
        }
    }

    void smoothIIR(double d2, float[] fArray, double d3, double d4) {
        double d5;
        int n2;
        double d6 = Math.pow(2.0, 0.25 / d2);
        double d7 = d6 - 1.0 / d6;
        double d8 = 1.0 + d3 * d7 / d4;
        double d9 = fArray[0];
        for (n2 = 1; n2 < fArray.length; ++n2) {
            d5 = d8 + (double)n2 * d7;
            d9 += ((double)fArray[n2] - d9) / d5;
            fArray[n2] = (float)d9;
        }
        for (n2 = fArray.length - 2; n2 >= 0; --n2) {
            d5 = d8 + (double)n2 * d7;
            d9 += ((double)fArray[n2] - d9) / d5;
            fArray[n2] = (float)d9;
        }
    }

    float dataCubic(float[] fArray, float f2, float f3, boolean bl) {
        float f4;
        if (this.isSteppedInLevel) {
            float[] fArray2 = this.getFundamental();
            this.indexData = bl ? this.levels : fArray2;
        } else {
            this.indexData = this.freqs;
        }
        if (f2 <= this.indexData[0] || fArray.length < 3) {
            return fArray[0];
        }
        if (f2 >= this.indexData[fArray.length - 1]) {
            return fArray[fArray.length - 1];
        }
        if (this.isFromIR.booleanValue()) {
            int n2 = (int)Math.floor(Math.log(f2 / this.indexData[0]) / this.logStepLog);
            if (n2 == 0) {
                float f5 = (float)(Math.log(f2 / this.indexData[0]) / this.logStepLog);
                return fArray[0] + f5 * (fArray[1] - fArray[0]);
            }
            if (n2 < 1) {
                n2 = 1;
            } else if (n2 > fArray.length - 3) {
                n2 = fArray.length - 3;
            }
            float f6 = (float)((double)this.indexData[0] * Math.pow(this.logStep, n2));
            float f7 = (float)(Math.log(f2 / f6) / this.logStepLog);
            f4 = IF.A(f7, fArray[n2 - 1], fArray[n2], fArray[n2 + 1], fArray[n2 + 2], 0.0f);
            if (n2 > 0 && Math.abs(f2 - f6) < f3) {
                boolean bl2;
                float f8 = fArray[n2];
                boolean bl3 = f8 < fArray[n2 - 1] && f8 < fArray[n2 + 1];
                boolean bl4 = bl2 = f8 > fArray[n2 - 1] && f8 > fArray[n2 + 1];
                if (bl3 && f8 < f4 || bl2 && f8 > f4) {
                    f4 = f8;
                }
            }
        } else {
            float[][] fArray3;
            int n3 = Arrays.binarySearch(this.indexData, f2);
            if (n3 < 0) {
                n3 = -n3 - 2;
            }
            if (n3 < 0) {
                return fArray[0];
            }
            if (n3 >= fArray.length - 1) {
                return fArray[fArray.length - 1];
            }
            if (this.isSteppedInLevel) {
                float f9 = (f2 - this.indexData[n3]) / (this.indexData[n3 + 1] - this.indexData[n3]);
                return fArray[n3] + f9 * (fArray[n3 + 1] - fArray[n3]);
            }
            if (this.tangentSet == null) {
                this.tangentSet = new HashMap();
                this.logFreqs = new float[this.freqs.length];
                for (int i2 = 0; i2 < this.freqs.length; ++i2) {
                    this.logFreqs[i2] = (float)Math.log(this.freqs[i2]);
                }
            }
            if ((fArray3 = this.tangentSet.get(fArray)) == null) {
                fArray3 = IF.A(this.logFreqs, fArray, 0.0f);
                this.tangentSet.put(fArray, fArray3);
            }
            float f10 = this.logFreqs[n3 + 1] == this.logFreqs[n3] ? 0.0f : ((float)Math.log(f2) - this.logFreqs[n3]) / (this.logFreqs[n3 + 1] - this.logFreqs[n3]);
            Point2D.Float float_ = IF.A(n3, this.logFreqs, f10, fArray, fArray3);
            f4 = float_.y;
        }
        return f4;
    }

    float splHermite(float f2, float[] fArray, float f3, float f4, float f5) {
        if (f2 - f3 < -0.001f) {
            return fArray[0];
        }
        if (f2 - f4 > 0.001f) {
            return fArray[fArray.length - 1];
        }
        int n2 = (int)Math.floor((f2 - f3) / f5);
        if ((n2 = Math.max(n2, 0)) < fArray.length - 2 && n2 > 0) {
            float f6 = (f2 - f3) / f5 - (float)n2;
            return IF.A(f6, fArray[n2 - 1], fArray[n2], fArray[n2 + 1], fArray[n2 + 2], 0.0f);
        }
        if (n2 < fArray.length - 1) {
            return fArray[n2] + (fArray[n2 + 1] - fArray[n2]) * ((f2 - f3) / f5 - (float)n2);
        }
        return fArray[fArray.length - 1];
    }

    static double getUPPER_DIST_LIMIT_FACTOR() {
        return 0.95;
    }

    static int getHIGHEST_HARMONIC() {
        return 9;
    }

    float getStartFreq(int n2) {
        if (n2 == 1 && this.isMT && !this.isSteppedInLevel) {
            return this.firstTone;
        }
        if (lG.\u010d() && n2 > 1) {
            return this.startFreq * (float)n2;
        }
        return this.startFreq;
    }

    float getEndFreq(int n2) {
        if (n2 == 1 && this.isMT && !this.isSteppedInLevel) {
            return this.lastTone;
        }
        return this.endFreq;
    }
}

