/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.ArrayList;
import roomeqwizard.pA;

public enum DecadeFraction implements pA
{
    HALF(2, "1/2 decade"),
    THIRD(3, "1/3 decade"),
    QUARTER(4, "1/4 decade"),
    FIFTH(5, "1/5 decade"),
    TENTH(10, "1/10 decade"),
    TWENTIETH(20, "1/20 decade");

    private final double fraction;
    private final int ppd;
    private final String description;

    private DecadeFraction(int n3, String string2) {
        this.ppd = n3;
        this.fraction = 1.0 / (double)n3;
        this.description = string2;
    }

    public String toString() {
        return this.description;
    }

    public String apiName() {
        return this.description;
    }

    public double getFraction() {
        return this.fraction;
    }

    public static DecadeFraction getEnum(String string) {
        for (DecadeFraction decadeFraction : DecadeFraction.values()) {
            if (!decadeFraction.name().equalsIgnoreCase(string)) continue;
            return decadeFraction;
        }
        return TENTH;
    }

    public static DecadeFraction getFromApiName(String string) {
        for (DecadeFraction decadeFraction : DecadeFraction.values()) {
            if (!decadeFraction.apiName().equalsIgnoreCase(string)) continue;
            return decadeFraction;
        }
        return null;
    }

    public double freqFactor() {
        return Math.pow(10.0, this.fraction);
    }

    @Override
    public Double[] generateFreqList(double d2, double d3) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d4 = d2;
        double d5 = Math.pow(10.0, 1.0 / (double)this.ppd);
        do {
            arrayList.add(d4);
        } while ((d4 *= d5) <= d3);
        Double[] doubleArray = new Double[arrayList.size()];
        arrayList.toArray(doubleArray);
        return doubleArray;
    }
}

