/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public final class CoefficientFormat
extends Enum<CoefficientFormat> {
    public static final /* enum */ CoefficientFormat MINIDSP = new CoefficientFormat("miniDSP", true);
    public static final /* enum */ CoefficientFormat SIGMASTUDIO = new CoefficientFormat("SigmaStudio", false);
    private final String label;
    private final boolean negateA1A2;
    private final DecimalFormat nf;
    private static final /* synthetic */ CoefficientFormat[] $VALUES;

    public static CoefficientFormat[] values() {
        return (CoefficientFormat[])$VALUES.clone();
    }

    public static CoefficientFormat valueOf(String string) {
        return Enum.valueOf(CoefficientFormat.class, string);
    }

    private CoefficientFormat(String string2, boolean bl) {
        this.label = string2;
        this.negateA1A2 = bl;
        this.nf = new DecimalFormat("0.0###############");
        DecimalFormatSymbols decimalFormatSymbols = this.nf.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.nf.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    boolean negateA1A2() {
        return this.negateA1A2;
    }

    public void writeCoefficients(double[] dArray, int n2, boolean bl, PrintWriter printWriter) {
        if (this.negateA1A2) {
            if (dArray[0] != 0.0) {
                dArray[0] = dArray[0] * -1.0;
            }
            if (dArray[1] != 0.0) {
                dArray[1] = dArray[1] * -1.0;
            }
        }
        switch (this) {
            case MINIDSP: {
                printWriter.println("biquad" + (n2 + 1) + ",");
                printWriter.println("b0=" + this.nf.format(dArray[2]) + ",");
                printWriter.println("b1=" + this.nf.format(dArray[3]) + ",");
                printWriter.println("b2=" + this.nf.format(dArray[4]) + ",");
                printWriter.println("a1=" + this.nf.format(dArray[0]) + ",");
                if (bl) {
                    printWriter.println("a2=" + this.nf.format(dArray[1]));
                    break;
                }
                printWriter.println("a2=" + this.nf.format(dArray[1]) + ",");
                break;
            }
            case SIGMASTUDIO: {
                printWriter.println(this.nf.format(dArray[2]));
                printWriter.println(this.nf.format(dArray[3]));
                printWriter.println(this.nf.format(dArray[4]));
                printWriter.println(this.nf.format(dArray[0]));
                printWriter.println(this.nf.format(dArray[1]));
                break;
            }
            default: {
                assert (false) : "Unhandled enum type";
                break;
            }
        }
    }

    public String toString() {
        return this.label;
    }

    public String apiName() {
        return this.label;
    }

    public static CoefficientFormat getEnum(String string) {
        for (CoefficientFormat coefficientFormat : CoefficientFormat.values()) {
            if (!coefficientFormat.name().equalsIgnoreCase(string)) continue;
            return coefficientFormat;
        }
        return MINIDSP;
    }

    public static CoefficientFormat getFromApiName(String string) {
        for (CoefficientFormat coefficientFormat : CoefficientFormat.values()) {
            if (!coefficientFormat.apiName().equalsIgnoreCase(string)) continue;
            return coefficientFormat;
        }
        return null;
    }

    static {
        $VALUES = new CoefficientFormat[]{MINIDSP, SIGMASTUDIO};
    }
}

