/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.TreeSet;

public class CliArgs {
    private String[] args = null;
    private HashMap<String, Integer> switchIndexes = new HashMap();
    private TreeSet<Integer> takenIndexes = new TreeSet();

    public CliArgs(String[] stringArray) {
        this.parse(stringArray);
    }

    public void parse(String[] stringArray) {
        this.args = stringArray;
        this.switchIndexes.clear();
        this.takenIndexes.clear();
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            if (!this.args[i2].startsWith("-")) continue;
            this.switchIndexes.put(this.args[i2], i2);
            this.takenIndexes.add(i2);
        }
    }

    public String[] args() {
        return this.args;
    }

    public String arg(int n2) {
        return this.args[n2];
    }

    public boolean switchPresent(String string) {
        return this.switchIndexes.containsKey(string);
    }

    public String switchValue(String string) {
        return this.switchValue(string, null);
    }

    public String switchValue(String string, String string2) {
        if (!this.switchIndexes.containsKey(string)) {
            return string2;
        }
        int n2 = this.switchIndexes.get(string);
        if (n2 + 1 < this.args.length) {
            this.takenIndexes.add(n2 + 1);
            return this.args[n2 + 1];
        }
        return string2;
    }

    public Long switchLongValue(String string) {
        return this.switchLongValue(string, null);
    }

    public Long switchLongValue(String string, Long l2) {
        String string2 = this.switchValue(string, null);
        if (string2 == null) {
            return l2;
        }
        return Long.valueOf(string2);
    }

    public Double switchDoubleValue(String string) {
        return this.switchDoubleValue(string, null);
    }

    public Double switchDoubleValue(String string, Double d2) {
        String string2 = this.switchValue(string, null);
        if (string2 == null) {
            return d2;
        }
        return Double.valueOf(string2);
    }

    public String[] switchValues(String string) {
        int n2;
        if (!this.switchIndexes.containsKey(string)) {
            return new String[0];
        }
        int n3 = this.switchIndexes.get(string);
        for (n2 = n3 + 1; n2 < this.args.length && !this.args[n2].startsWith("-"); ++n2) {
            this.takenIndexes.add(n2);
        }
        String[] stringArray = new String[n2 - n3 - 1];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.args[n3 + i2 + 1];
        }
        return stringArray;
    }

    public <T> T switchPojo(Class<T> clazz) {
        try {
            Field[] fieldArray;
            T t2 = clazz.newInstance();
            for (Field field : fieldArray = clazz.getFields()) {
                String[] stringArray;
                Class<?> clazz2 = field.getType();
                String string = "-" + field.getName().replace('_', '-');
                if (clazz2.equals(Boolean.class) || clazz2.equals(Boolean.TYPE)) {
                    field.set(t2, this.switchPresent(string));
                    continue;
                }
                if (clazz2.equals(String.class)) {
                    if (this.switchValue(string) == null) continue;
                    field.set(t2, this.switchValue(string));
                    continue;
                }
                if (clazz2.equals(Long.class) || clazz2.equals(Long.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t2, this.switchLongValue(string));
                    continue;
                }
                if (clazz2.equals(Integer.class) || clazz2.equals(Integer.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t2, this.switchLongValue(string).intValue());
                    continue;
                }
                if (clazz2.equals(Short.class) || clazz2.equals(Short.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t2, this.switchLongValue(string).shortValue());
                    continue;
                }
                if (clazz2.equals(Byte.class) || clazz2.equals(Byte.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t2, this.switchLongValue(string).byteValue());
                    continue;
                }
                if (clazz2.equals(Double.class) || clazz2.equals(Double.TYPE)) {
                    if (this.switchDoubleValue(string) == null) continue;
                    field.set(t2, this.switchDoubleValue(string));
                    continue;
                }
                if (clazz2.equals(Float.class) || clazz2.equals(Float.TYPE)) {
                    if (this.switchDoubleValue(string) == null) continue;
                    field.set(t2, Float.valueOf(this.switchDoubleValue(string).floatValue()));
                    continue;
                }
                if (!clazz2.equals(String[].class) || (stringArray = this.switchValues(string)).length == 0) continue;
                field.set(t2, stringArray);
            }
            return t2;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException exception) {
            throw new RuntimeException("Error creating switch POJO", exception);
        }
    }

    public String[] targets() {
        String[] stringArray = new String[this.args.length - this.takenIndexes.size()];
        int n2 = 0;
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            if (this.takenIndexes.contains(i2)) continue;
            stringArray[n2++] = this.args[i2];
        }
        return stringArray;
    }
}

