/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import roomeqwizard.EK;
import roomeqwizard.FA;
import roomeqwizard.HE;
import roomeqwizard.MeasData;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.SampleRates;
import roomeqwizard.WizardLogger;
import roomeqwizard.api.model.ActionResult;
import roomeqwizard.fI;
import roomeqwizard.g;
import roomeqwizard.iE;
import roomeqwizard.lG;
import roomeqwizard.lH;
import roomeqwizard.mE;
import roomeqwizard.rC;

public class CalData
implements Serializable {
    static final long serialVersionUID = -1234567899999999999L;
    static final double BOOST_LIMIT = -20.0;
    private static final String SENS_PREFIX = "sens factor =";
    private static final String SENS_SUFFIX = "db";
    private static final String SERNO_PREFIX = "serno:";
    private static final String SENS_DBFS_PREFIX = "sensitivity";
    private static final String SENS_DBFS_SUFFIX = "dbfs";
    private static final double MIN_ACCEPTED_FREQ = 0.1;
    private static final int MIN_DATA_VALUES = 2;
    private static int dialogPosn = 0;
    private static final Pattern leadingZeroComma = Pattern.compile("[\t ;]0,[0-9]");
    private static final Pattern p1b = Pattern.compile("^0,[0-9]");
    private static final Pattern p2 = Pattern.compile("[0-9],[0-9]{3}[0-9]+");
    private static final Pattern p2b = Pattern.compile("[0-9],([0-9]{1,2})([^0-9]|$)");
    private static final Pattern p2c = Pattern.compile("[0-9]{3}[0-9]+,[0-9]{3}");
    private static final Pattern commaAsGrouping = Pattern.compile("([0-9]),([0-9]{3})(\t| |.)");
    private static final Pattern commaBetweenDigits = Pattern.compile("([0-9]),([0-9])");
    private static final Pattern pointBetweenDigits = Pattern.compile("([0-9])\\.([0-9])");
    private static final Pattern pointThenCommaThenNotDigit = Pattern.compile("([0-9]+)\\.([0-9]+),[^0-9]");
    private static final Pattern tabsEtc = Pattern.compile("\t|\"|,|;");
    private ArrayList<Float> freqList;
    private ArrayList<Float> gainList;
    private ArrayList<Float> phaseList;
    private float[] freqArray;
    private float[] gainArray;
    private float[] phaseArray;
    private String sourcePath = "";
    private String sourceName = "";
    private boolean inverseCSelected = false;
    private Double sensitivitydB = null;
    private Double sensitivitydBFS = null;
    private Integer serialNum = null;
    private static final double C_dB_5HZ = mE.B(5.0);

    public CalData copy(boolean bl) {
        CalData calData = new CalData();
        if (this.freqArray != null) {
            int n2 = this.freqArray.length;
            calData.freqArray = new float[n2];
            calData.gainArray = new float[n2];
            calData.phaseArray = new float[n2];
            System.arraycopy(this.freqArray, 0, calData.freqArray, 0, n2);
            System.arraycopy(this.gainArray, 0, calData.gainArray, 0, n2);
            if (bl) {
                System.arraycopy(this.phaseArray, 0, calData.phaseArray, 0, n2);
            }
        }
        calData.sourceName = this.sourceName;
        calData.sourcePath = this.sourcePath;
        calData.sensitivitydB = this.sensitivitydB;
        calData.sensitivitydBFS = this.sensitivitydBFS;
        calData.inverseCSelected = this.inverseCSelected;
        calData.serialNum = this.serialNum;
        return calData;
    }

    public CalData() {
        dialogPosn = 0;
    }

    public void clear() {
        this.sourceName = "";
        this.sourcePath = "";
        this.sensitivitydB = null;
        this.sensitivitydBFS = null;
        this.inverseCSelected = false;
        this.serialNum = null;
        dialogPosn = 0;
        this.freqList = null;
        this.gainList = null;
        this.phaseList = null;
        this.freqArray = null;
        this.gainArray = null;
        this.phaseArray = null;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourcePath(String string) {
        this.sourcePath = string;
    }

    public void setSourceName(String string) {
        this.sourceName = string;
    }

    public boolean isActive() {
        return this.size() > 0 || this.inverseCSelected;
    }

    public boolean isInverseCOnly() {
        return this.size() == 0 && this.inverseCSelected;
    }

    public boolean isInverseCSelected() {
        return this.inverseCSelected;
    }

    public void setInverseCSelected(boolean bl) {
        this.inverseCSelected = bl;
    }

    public void addCalData(CalData calData, boolean bl) {
        if (!calData.isActive()) {
            return;
        }
        if (calData.size() > 0) {
            this.sourceName = this.sourceName + "with " + calData.sourceName + " added";
            this.sourcePath = this.sourcePath + "with " + calData.sourcePath + " added";
        } else if (calData.isInverseCSelected()) {
            this.sourceName = this.sourceName + "with inverse C added";
            this.sourcePath = this.sourcePath + "with inverse C added";
        }
        if (this.freqArray == null) {
            this.generateDefaultArrays(bl);
        }
        for (int i2 = 0; i2 < this.freqArray.length; ++i2) {
            float f2 = this.freqArray[i2];
            if (bl) {
                int n2 = i2;
                this.gainArray[n2] = (float)((double)this.gainArray[n2] + calData.meterGaindB(f2, true));
                this.phaseArray[i2] = (float)lH.B((double)this.phaseArray[i2] + calData.meterPhase(f2, true) + (this.inverseCSelected ? mE.C(f2) : 0.0));
                continue;
            }
            int n3 = i2;
            this.gainArray[n3] = this.gainArray[n3] + (float)calData.calDataGaindB(f2, false);
            this.phaseArray[i2] = (float)lH.B((double)this.phaseArray[i2] + calData.calDataPhase(f2, false));
        }
        MeasData.unwrapPhase(this.phaseArray, this.gainArray);
    }

    public void merge(CalData calData, double d2, boolean bl) {
        float f2;
        float f3;
        float f4;
        if (!(calData != null && calData.isActive() || this.isActive())) {
            return;
        }
        if (calData != null && calData.isInverseCOnly() && this.isInverseCOnly()) {
            return;
        }
        if (calData != null && calData.sourcePath.equals(this.sourcePath) && calData.isInverseCSelected() == this.isInverseCSelected()) {
            return;
        }
        if (this.isInverseCOnly()) {
            this.sourceName = "Inverse C";
            this.sourcePath = "Inverse C";
        } else if (this.size() == 0) {
            this.sourceName = "Empty cal";
            this.sourcePath = "Empty cal";
        }
        if (calData == null) {
            calData = new CalData();
            this.sourceName = this.sourceName + " merged with empty cal below " + HE.I.format(d2) + " Hz";
            this.sourcePath = this.sourcePath + " merged with empty cal below " + HE.I.format(d2) + " Hz";
        } else if (calData.size() > 0) {
            this.sourceName = this.sourceName + " merged with " + calData.sourceName + " below " + HE.I.format(d2) + " Hz";
            this.sourcePath = this.sourcePath + " merged with " + calData.sourcePath + " below " + HE.I.format(d2) + " Hz";
        } else if (calData.isInverseCSelected()) {
            this.sourceName = this.sourceName + " merged with inverseC below " + HE.I.format(d2) + " Hz";
            this.sourcePath = this.sourcePath + " merged with inverseC below " + HE.I.format(d2) + " Hz";
        }
        if (this.freqArray == null) {
            this.generateDefaultArrays(bl);
        }
        if (bl) {
            f4 = (float)(calData.meterGaindB(d2, true) - this.meterGaindB(d2, true));
            f3 = (float)(calData.meterPhase(d2, true) - this.meterPhase(d2, true));
        } else {
            f4 = (float)(calData.calDataGaindB(d2, false) - this.calDataGaindB(d2, false));
            f3 = (float)(calData.calDataPhase(d2, false) - this.calDataPhase(d2, false));
        }
        for (int i2 = 0; i2 < this.freqArray.length && (double)(f2 = this.freqArray[i2]) < d2; ++i2) {
            if (bl) {
                this.gainArray[i2] = (float)calData.meterGaindB(f2, true) - f4;
                this.phaseArray[i2] = (float)lH.B(calData.meterPhase(f2, true) - (double)f3);
                continue;
            }
            this.gainArray[i2] = (float)calData.calDataGaindB(f2, false) - f4;
            this.phaseArray[i2] = (float)lH.B(calData.calDataPhase(f2, false) - (double)f3);
        }
        MeasData.unwrapPhase(this.phaseArray, this.gainArray);
    }

    private void generateDefaultArrays(boolean bl) {
        double d2;
        double d3;
        int n2 = 24000;
        if (this.freqList == null) {
            this.freqList = new ArrayList(500);
            this.gainList = new ArrayList(500);
            this.phaseList = new ArrayList(500);
        } else {
            this.freqList.clear();
            this.gainList.clear();
            this.phaseList.clear();
        }
        if (bl) {
            d3 = Math.pow(10.0, 0.0031249999999999997);
            d2 = 0.0;
        } else {
            d3 = 1.0;
            d2 = 1.0;
        }
        if (bl && this.inverseCSelected) {
            double d4 = 5.0;
            while (d4 <= 24000.0) {
                this.addCalPoint(d4, CalData.cWeightdBTo5Hz(d4), mE.C(d4));
                d4 = d4 * d3 + d2;
            }
        } else {
            double d5 = 1.0;
            while (d5 <= 24000.0) {
                this.addCalPoint(d5, 0.0, 0.0);
                d5 = d5 * d3 + d2;
            }
        }
        this.generateArrays();
    }

    public void subtractCalData(CalData calData, boolean bl) {
        if (!calData.isActive()) {
            return;
        }
        if (calData.size() > 0) {
            this.sourceName = this.sourceName + "with " + calData.sourceName + " subtracted";
            this.sourcePath = this.sourcePath + "with " + calData.sourcePath + " subtracted";
        } else if (calData.isInverseCSelected()) {
            this.sourceName = this.sourceName + "with inverse C subtracted";
            this.sourcePath = this.sourcePath + "with inverse C subtracted";
        }
        if (this.freqArray == null) {
            this.generateDefaultArrays(bl);
        }
        for (int i2 = 0; i2 < this.freqArray.length; ++i2) {
            float f2 = this.freqArray[i2];
            if (bl) {
                int n2 = i2;
                this.gainArray[n2] = (float)((double)this.gainArray[n2] - calData.meterGaindB(f2, true));
                this.phaseArray[i2] = (float)lH.B((double)this.phaseArray[i2] - calData.meterPhase(f2, true) + (this.inverseCSelected ? mE.C(f2) : 0.0));
                continue;
            }
            int n3 = i2;
            this.gainArray[n3] = (float)((double)this.gainArray[n3] - calData.calDataGaindB(f2, false));
            this.phaseArray[i2] = (float)lH.B((double)this.phaseArray[i2] - calData.calDataPhase(f2, false));
        }
        MeasData.unwrapPhase(this.phaseArray, this.gainArray);
    }

    public double meterGaindB(double d2, boolean bl) {
        int n2;
        double d3 = this.freqArray == null ? (this.inverseCSelected ? CalData.cWeightdBTo5Hz(d2) : 0.0) : ((n2 = Arrays.binarySearch(this.freqArray, (float)d2)) >= 0 ? (double)this.gainArray[n2] : ((n2 = -n2 - 1) == 0 ? (this.inverseCSelected ? (double)this.gainArray[0] + CalData.cWeightdBTo5Hz(d2) - CalData.cWeightdBTo5Hz(this.freqArray[0]) : (double)this.gainArray[0]) : (n2 > this.freqArray.length - 1 ? (this.inverseCSelected ? (double)this.gainArray[this.freqArray.length - 1] + CalData.cWeightdBTo5Hz(d2) - CalData.cWeightdBTo5Hz(this.freqArray[this.freqArray.length - 1]) : (double)this.gainArray[this.freqArray.length - 1]) : this.interpolatedValue(n2, bl, d2, this.gainArray))));
        return d3;
    }

    public double calDataGaindB(double d2, boolean bl) {
        int n2;
        double d3 = this.freqArray == null ? 0.0 : ((n2 = Arrays.binarySearch(this.freqArray, (float)d2)) >= 0 ? (double)this.gainArray[n2] : ((n2 = -n2 - 1) == 0 ? (double)this.gainArray[0] : (n2 > this.freqArray.length - 1 ? (double)this.gainArray[this.freqArray.length - 1] : this.interpolatedValue(n2, bl, d2, this.gainArray))));
        return d3;
    }

    public double meterPhase(double d2, boolean bl) {
        int n2;
        double d3 = this.freqArray == null ? (this.inverseCSelected ? mE.C(d2) : 0.0) : ((n2 = Arrays.binarySearch(this.freqArray, (float)d2)) >= 0 ? (double)this.phaseArray[n2] : ((n2 = -n2 - 1) == 0 ? (this.inverseCSelected ? (double)this.phaseArray[0] + mE.C(d2) - mE.C(this.freqArray[0]) : (double)this.phaseArray[0]) : (n2 > this.freqArray.length - 1 ? (this.inverseCSelected ? (double)this.phaseArray[this.freqArray.length - 1] + mE.C(d2) - mE.C(this.freqArray[this.freqArray.length - 1]) : (double)this.phaseArray[this.freqArray.length - 1]) : this.interpolatedValue(n2, bl, d2, this.phaseArray))));
        return d3;
    }

    public double calDataPhase(double d2, boolean bl) {
        int n2;
        double d3 = this.freqArray == null ? 0.0 : ((n2 = Arrays.binarySearch(this.freqArray, (float)d2)) >= 0 ? (double)this.phaseArray[n2] : ((n2 = -n2 - 1) == 0 ? (double)this.phaseArray[0] : (n2 > this.freqArray.length - 1 ? (double)this.phaseArray[this.freqArray.length - 1] : this.interpolatedValue(n2, bl, d2, this.phaseArray))));
        return d3;
    }

    public EK calDataComplex(double d2, double d3, boolean bl) {
        double d4;
        double d5;
        if (this.freqArray == null) {
            d5 = 0.0;
            d4 = 0.0;
        } else {
            int n2 = Arrays.binarySearch(this.freqArray, (float)d2);
            if (n2 >= 0) {
                d5 = this.gainArray[n2];
                d4 = this.phaseArray[n2];
            } else if ((n2 = -n2 - 1) == 0) {
                d5 = this.gainArray[0];
                d4 = this.phaseArray[0];
            } else if (n2 > this.freqArray.length - 1) {
                d5 = this.gainArray[this.freqArray.length - 1];
                d4 = this.phaseArray[this.freqArray.length - 1];
            } else {
                d5 = this.interpolatedValue(n2, bl, d2, this.gainArray);
                d4 = this.interpolatedValue(n2, bl, d2, this.phaseArray);
            }
        }
        double d6 = Math.toRadians(d4);
        double d7 = d5 * Math.cos(d6) / d3;
        double d8 = d5 * Math.sin(d6) / d3;
        return new EK(d7, d8);
    }

    public void addCalPoint(double d2, double d3, double d4) {
        if (this.freqList == null) {
            this.freqList = new ArrayList(500);
            this.gainList = new ArrayList(500);
            this.phaseList = new ArrayList(500);
        }
        this.freqList.add(Float.valueOf((float)d2));
        this.gainList.add(Float.valueOf((float)d3));
        this.phaseList.add(Float.valueOf((float)d4));
    }

    public void generateArrays() {
        int n2 = this.freqList.size();
        if (n2 >= 2) {
            this.gainList.trimToSize();
            this.freqList.trimToSize();
            this.phaseList.trimToSize();
            this.freqArray = new float[n2];
            this.gainArray = new float[n2];
            this.phaseArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.freqArray[i2] = this.freqList.get(i2).floatValue();
                this.gainArray[i2] = this.gainList.get(i2).floatValue();
                this.phaseArray[i2] = this.phaseList.get(i2).floatValue();
            }
            MeasData.unwrapPhase(this.phaseArray, this.gainArray);
            this.freqList.clear();
            this.gainList.clear();
            this.phaseList.clear();
        }
    }

    public void addGainOffset(double d2) {
        int n2 = 0;
        while (n2 < this.gainArray.length) {
            int n3 = n2++;
            this.gainArray[n3] = (float)((double)this.gainArray[n3] + d2);
        }
    }

    public int size() {
        return this.freqArray != null ? this.freqArray.length : 0;
    }

    public void setSensitivity(Double d2) {
        this.sensitivitydB = d2;
    }

    public void setSensitivitydBFS(Double d2) {
        this.sensitivitydBFS = d2;
    }

    public Double getSensitivity() {
        return this.sensitivitydB;
    }

    public Integer getSerialNumber() {
        return this.serialNum;
    }

    public boolean hasSensitivity() {
        return this.sensitivitydB != null;
    }

    public Double getSensitivitydBFS() {
        return this.sensitivitydBFS;
    }

    public boolean hasSensitivitydBFS() {
        return this.sensitivitydBFS != null;
    }

    public ActionResult calFileLoader(File file, SampleRates sampleRates, Component component, boolean bl) throws IOException {
        boolean bl2;
        String string;
        FA fA2 = new FA();
        double d2 = 0.0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        fA2.B();
        fA2.G = file.getName().toLowerCase().endsWith("csv");
        fA2.H = 0.099;
        this.clearLists();
        boolean bl3 = false;
        boolean bl4 = false;
        while ((string = bufferedReader.readLine()) != null) {
            double d3;
            double d4;
            block31: {
                String[] stringArray;
                int n2;
                int n3;
                ++fA2.I;
                if (!bl4 && (string.startsWith("Sample Rate:") || string.startsWith("* Sample Rate:"))) {
                    bl4 = true;
                    try {
                        if (string.startsWith("* ")) {
                            string = string.substring(2);
                        }
                        int n4 = Integer.parseInt(string.substring("Sample Rate:".length()).trim());
                        n3 = sampleRates != null && n4 != sampleRates.intValue() && !bl && RoomEQ_Wizard.s() ? 1 : 0;
                        if (n3 == 0 || (n2 = this.showRateMismatchWarning(component, n4, sampleRates)) == 0) continue;
                        fA2.A(null, "Sample rate mismatch");
                    }
                    catch (NumberFormatException numberFormatException) {
                        fA2.A("Line " + fA2.I + " has malformed sample rate value:\n\n" + string.substring("Sample Rate:".length()).trim() + "\n");
                    }
                    break;
                }
                if (!bl3) {
                    String string2 = string.toLowerCase();
                    n3 = string2.indexOf(SENS_PREFIX);
                    if (n3 >= 0) {
                        bl3 = true;
                        n2 = string2.indexOf(SENS_SUFFIX);
                        if (n2 < 0) {
                            fA2.A("Line " + fA2.I + " has malformed sensitivity entry, missing dB suffix:\n\n" + string + "\n");
                            break;
                        }
                        String string3 = string2.substring(n3 + SENS_PREFIX.length(), n2);
                        try {
                            double d5 = Double.parseDouble(string3.trim());
                            this.setSensitivity(d5);
                            this.captureSerialNumber(string2);
                            this.makeLogEntryWithSensitivity(d5, file);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            fA2.A("Line " + fA2.I + " has malformed sensitivity value:\n\n" + string3 + "\n");
                            break;
                        }
                    }
                    if (!string.startsWith("*") && (n2 = string2.indexOf(SENS_DBFS_PREFIX)) >= 0) {
                        int n5 = string2.indexOf(SENS_DBFS_SUFFIX);
                        if (n5 < 0) continue;
                        bl3 = true;
                        String string4 = string2.substring(n2 + SENS_DBFS_PREFIX.length(), n5);
                        try {
                            double d6 = Double.parseDouble(string4.trim());
                            WizardLogger.getLogger().log(Level.INFO, "Mic sensitivity {0} dBFS from {1}", new Object[]{d6, file.getName()});
                            this.setSensitivitydBFS(d6);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            fA2.A("Line " + fA2.I + " has malformed sensitivity value:\n\n" + string4 + "\n");
                            break;
                        }
                    }
                }
                if (!fA2.D()) {
                    this.checkForCommaAsDelimiter(string, fA2);
                    if (fA2.D()) {
                        fA2.I = 1;
                        fA2.H = 0.099;
                        this.clearLists();
                        bufferedReader.close();
                        bufferedReader = new BufferedReader(new FileReader(file));
                        string = bufferedReader.readLine();
                    }
                }
                if ((stringArray = (string = this.reformatLineString(fA2, string)).split(" +")).length < 2) continue;
                try {
                    d4 = Double.parseDouble(stringArray[0]);
                    if (d4 < 0.1 || d4 == fA2.H) continue;
                    if (d4 < fA2.H) {
                        if (!fA2.D()) {
                            fA2.D = true;
                            fA2.I = 1;
                            fA2.H = 0.099;
                            this.clearLists();
                            bufferedReader.close();
                            bufferedReader = new BufferedReader(new FileReader(file));
                            continue;
                        }
                        fA2.A("Line has frequency " + HE.K.format(d4) + " which is not higher than the preceding frequency " + HE.K.format(fA2.H) + "\n");
                        break;
                    }
                    fA2.H = d4;
                    d3 = Double.parseDouble(stringArray[1]);
                    if (stringArray.length <= 2) break block31;
                    try {
                        d2 = Double.parseDouble(stringArray[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        d2 = 0.0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            this.addCalPoint(d4, d3, d2);
        }
        bufferedReader.close();
        if (!fA2.A()) {
            if (!fA2.E()) {
                int n6;
                int n7 = n6 = this.freqList != null ? this.freqList.size() : 0;
                if (n6 >= 2) {
                    this.generateArrays();
                } else if (n6 == 0) {
                    fA2.A("No data", "REW could not find any data values in the\nfile, it may not be in a compatible format\n");
                } else {
                    fA2.A("Insufficient data", "There are not enough data values in the file\n\nRequire at least 2 values, found " + n6 + "\n");
                }
            } else {
                fA2.B = "Error importing data";
                fA2.C = "File parsing error at line " + fA2.I + "\n" + fA2.E + "\nSee Help for file format information.\n";
            }
            if (fA2.B != null && bl) {
                RoomEQ_Wizard.A(fA2.B, fA2.C, fI.E.isShowing() ? fI.E : g.getInstance(), bl);
            }
            if (fA2.B != null && !bl && RoomEQ_Wizard.s()) {
                this.showParseErrorDialog(fA2.C, fA2.B);
            }
        }
        if (bl2 = fA2.C()) {
            this.sourcePath = file.getPath();
            this.sourceName = file.getName();
        }
        return ActionResult.builder().success(bl2).message(fA2.C).build();
    }

    private String reformatLineString(FA fA2, String string) {
        if (fA2.D) {
            string = pointBetweenDigits.matcher(string).replaceAll("$1$2");
        } else if (!fA2.G) {
            string = commaAsGrouping.matcher(string).replaceAll("$1$2$3");
        }
        if (!fA2.G) {
            string = commaBetweenDigits.matcher(string).replaceAll("$1.$2");
        }
        string = tabsEtc.matcher(string).replaceAll(" ");
        string = string.trim();
        return string;
    }

    private void checkForCommaAsDelimiter(String string, FA fA2) {
        String string2 = string.trim();
        if (string2.length() > 0 && Character.isDigit(string2.charAt(0))) {
            if (pointThenCommaThenNotDigit.matcher(string).find(0)) {
                fA2.G = true;
            } else if (leadingZeroComma.matcher(string).find(0) || p1b.matcher(string).find(0) || p2.matcher(string).find(0) || p2b.matcher(string).find(0) || p2c.matcher(string).find(0)) {
                fA2.D = true;
            }
        }
    }

    private void captureSerialNumber(String string) {
        int n2 = string.indexOf(SERNO_PREFIX);
        if (n2 > 0) {
            String string2 = string.substring(n2 + SERNO_PREFIX.length(), string.length()).trim();
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            try {
                this.serialNum = Integer.valueOf(string2.trim());
            }
            catch (NumberFormatException numberFormatException) {
                WizardLogger.getLogger().log(Level.INFO, "Could not parse serial number string: {1}", string2);
            }
        }
    }

    private void makeLogEntryWithSensitivity(double d2, File file) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        if (this.serialNum != null) {
            WizardLogger.getLogger().log(Level.INFO, "Mic sensitivity {0} dB for serial number {1} from {2}", new Object[]{d2, numberFormat.format(this.serialNum), file.getName()});
        } else {
            WizardLogger.getLogger().log(Level.INFO, "Mic sensitivity {0} dB from {1}", new Object[]{d2, file.getName()});
        }
    }

    private void clearLists() {
        if (this.freqList != null) {
            this.freqList.clear();
            this.gainList.clear();
            this.phaseList.clear();
        }
    }

    private int showRateMismatchWarning(Component component, int n2, SampleRates sampleRates) {
        rC rC2 = new rC();
        rC2.B();
        int n3 = JOptionPane.showConfirmDialog(component, "The sample rate of this soundcard calibration data file\nis " + n2 + " Hz but it is being loaded into a cal entry for\n" + sampleRates.intValue() + " Hz, calibration data measured at a different\nrate will not provide accurate correction.\n\nPress OK to continue loading this calibration file or\nCancel to quit loading", "Sample rate does not match", 2, 2);
        rC2.A();
        return n3;
    }

    private void showParseErrorDialog(String string, String string2) {
        final JOptionPane jOptionPane = new JOptionPane(string, 0);
        final iE iE2 = new iE(fI.E.isShowing() ? fI.E : g.getInstance(), string2, false);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (iE2.isVisible() && propertyChangeEvent.getSource() == jOptionPane && string.equals("value")) {
                    iE2.setVisible(false);
                    iE2.dispose();
                }
            }
        });
        iE2.setContentPane(jOptionPane);
        iE2.setDefaultCloseOperation(2);
        int n2 = g.getInstance().getX();
        int n3 = g.getInstance().getY();
        iE2.setLocation(new Point(n2 + 100 + 50 * dialogPosn, n3 + 100 + 100 * dialogPosn));
        dialogPosn = (dialogPosn + 1) % 3;
        iE2.pack();
        ((Dialog)iE2).setVisible(true);
    }

    public static double cWeightdBTo5Hz(double d2) {
        if (d2 < 5.0) {
            return C_dB_5HZ;
        }
        return mE.B(d2);
    }

    public static double limitedGain(double d2) {
        if (lG.\u0478 && d2 < -20.0) {
            return -20.0;
        }
        return d2;
    }

    public double interpolatedValue(int n2, boolean bl, double d2, float[] fArray) {
        double d3 = this.freqArray[n2 - 1];
        double d4 = this.freqArray[n2];
        double d5 = fArray[n2 - 1];
        double d6 = fArray[n2];
        double d7 = bl && d3 > 0.0 && d4 > 0.0 && d2 > 0.0 ? d5 + (d6 - d5) * Math.log(d2 / d3) / Math.log(d4 / d3) : (d4 > d3 ? d5 + (d6 - d5) * (d2 - d3) / (d4 - d3) : d5);
        return d7;
    }
}

