/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.ObjectStreamException;
import java.io.Serializable;
import roomeqwizard.CEALimit;

public class CEA2010Data
implements Serializable {
    static final long serialVersionUID = -8371876496410666956L;
    static final double INVALID_CEA_PEAK = -180.0;
    static final float MIN_F = 16.0f;
    double ceaFreq = -1.0;
    double ceaPeak = 0.0;
    double ceaF0Freq = 0.0;
    double ceaF0Level = 0.0;
    boolean ceaLimitsExceeded = false;
    boolean isFromGenericBurst = false;
    private int f0LowIndex = 0;
    private int f0HiIndex = 0;
    private int fMaxIndex = 0;
    private int fMinIndex = 0;
    private double f0;
    private CEALimit ceaLimit;

    CEA2010Data(CEALimit cEALimit) {
        this.ceaFreq = -1.0;
        this.ceaPeak = -180.0;
        this.ceaLimit = cEALimit;
    }

    CEA2010Data(CEA2010Data cEA2010Data) {
        this.ceaFreq = cEA2010Data.ceaFreq;
        this.ceaPeak = cEA2010Data.ceaPeak;
        this.ceaF0Freq = cEA2010Data.ceaF0Freq;
        this.ceaF0Level = cEA2010Data.ceaF0Level;
        this.ceaLimitsExceeded = cEA2010Data.ceaLimitsExceeded;
        this.ceaLimit = cEA2010Data.ceaLimit;
        this.isFromGenericBurst = cEA2010Data.isFromGenericBurst;
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.ceaLimit == null) {
            this.ceaLimit = CEALimit.CEA2010;
        }
        return this;
    }

    int limitIndex(double d2) {
        return this.ceaLimit.getLimitIndex(d2);
    }

    float[][] getLimits() {
        return this.ceaLimit.getLimits();
    }

    void calcCEAIndices(double d2, double d3, float[] fArray) {
        this.fMaxIndex = (int)Math.round(this.getMaxFreq() / d3);
        this.fMinIndex = (int)Math.round(16.0 / d3);
        this.f0LowIndex = (int)Math.round(this.ceaLimit.getFundLowerLimit(d2) / d3);
        if (this.f0LowIndex < 0) {
            this.f0LowIndex = 0;
        }
        this.f0HiIndex = (int)Math.round(this.ceaLimit.getFundUpperLimit(d2) / d3);
        if (this.f0HiIndex >= fArray.length) {
            this.f0HiIndex = fArray.length - 1;
        }
        this.ceaF0Level = -1.7976931348623157E308;
        this.f0 = d2;
        for (int i2 = this.f0LowIndex; i2 <= this.f0HiIndex; ++i2) {
            float f2 = fArray[i2];
            if (!((double)f2 > this.ceaF0Level)) continue;
            this.ceaF0Level = f2;
            this.ceaF0Freq = (double)i2 * d3;
        }
        this.ceaLimitsExceeded = false;
    }

    void checkCEALimits(int n2, float f2, double d2) {
        if (!(this.ceaLimitsExceeded || n2 >= this.f0LowIndex && n2 <= this.f0HiIndex || n2 < this.fMinIndex || n2 > this.fMaxIndex)) {
            double d3;
            int n3 = this.limitIndex(this.f0);
            float[][] fArray = this.ceaLimit.getLimits();
            for (int i2 = fArray.length - 1; i2 >= 0; --i2) {
                float[] fArray2 = fArray[i2];
                double d4 = (double)fArray2[0] * this.f0;
                if (d4 > this.ceaLimit.getMaxFreq()) continue;
                double d5 = Math.min(this.ceaLimit.getMaxFreq(), (double)fArray2[1] * this.f0);
                if (n2 < (int)Math.round(d4 / d2) || n2 > (int)Math.round(d5 / d2) || !((double)f2 > this.ceaF0Level + (double)fArray2[n3])) continue;
                this.ceaLimitsExceeded = true;
                break;
            }
            if (n2 < (int)Math.round((d3 = Math.min(this.ceaLimit.getMaxFreq(), (double)fArray[0][1] * this.f0)) / d2) && (double)f2 > this.ceaF0Level) {
                this.ceaLimitsExceeded = true;
            }
        }
    }

    void updatePeak(double d2, double d3) {
        this.ceaFreq = d2;
        double d4 = this.isFromGenericBurst ? 0.0 : 2.38;
        this.ceaPeak = d3 > 0.0 ? 20.0 * Math.log10(d3) + d4 : -180.0;
    }

    boolean dataIsValid() {
        return this.ceaPeak != -180.0;
    }

    double getMaxFreq() {
        return this.ceaLimit.getMaxFreq();
    }

    CEALimit getCEALimit() {
        return this.ceaLimit;
    }

    String getLimitTitle() {
        return this.ceaLimit.getTitle();
    }
}

