/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.Arrays;
import java.util.logging.Level;
import javax.help.BadIDException;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import roomeqwizard.Equaliser;
import roomeqwizard.Filter;
import roomeqwizard.FilterSet;
import roomeqwizard.IB;
import roomeqwizard.MeasData;
import roomeqwizard.PE;
import roomeqwizard.SampleRates;
import roomeqwizard.WizardLogger;
import roomeqwizard.XE;
import roomeqwizard.fC;
import roomeqwizard.g;
import roomeqwizard.lG;
import roomeqwizard.uI;

class CA
extends Equaliser {
    private static final double D;
    private static final double[] E;
    private static final double[] B;
    int C = 0;

    CA() {
        super(fC.A().A(20).B(0).A(20.0).K(20000.0).G(0.1).I(-36.0).F(15.0).L(0.5).D(D / 10.0).B(D * 60.0).H(0.1).E(0.1).C(50.0).J(0.01).A(SampleRates.RATE96K).A());
        this.filterTypesToolTip = "Only Parametric filters supported for FBQ2496";
        this.filterTypes.clear();
        this.filterTypes.add(Filter.FilterTypes.NONE);
        this.filterTypes.add(Filter.FilterTypes.PK);
        this.filterTypes.add(Filter.FilterTypes.MODAL);
        this.filterPKQToolTip = "Bandwidth range is from 1/60 (0.017) to 10 octaves";
        this.pkName = "PEQ";
    }

    @Override
    String getQFormat(double d2) {
        if (d2 >= 1.0) {
            return "#.0";
        }
        return "0.000";
    }

    static String A() {
        return "FBQ2496";
    }

    @Override
    String getEqualiserName() {
        return "FBQ2496";
    }

    @Override
    public PE getManufacturer() {
        return PE.T;
    }

    @Override
    public String getModel() {
        return "FBQ2496";
    }

    @Override
    String getqOrBWUnit() {
        return "oct";
    }

    @Override
    String getQHeader() {
        return " BW oct ";
    }

    @Override
    boolean supportsSendFilters() {
        return true;
    }

    @Override
    void sendFilters(FilterSet filterSet, MeasData measData) {
        Object[] objectArray;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 2;
        int n3 = 1;
        if (!lG.\u01d7()) {
            objectArray = new String[]{"Show me", "Already Done", UIManager.getString("OptionPane.cancelButtonText")};
            n3 = JOptionPane.showOptionDialog(g.getDialogParent(), "<HTML><B><FONT COLOR=\"#C00000\">FBQ2496 midi communications are unreliable, check all the<BR>settings after the transfer!</FONT></B><BR><BR>Midi communications are enabled by default on the FBQ2496, but if<BR>Midi has been disabled or the Midi channel is not set to 1 the unit will<BR>need to be reconfigured to enable Midi communications, select the<BR><B>" + objectArray[0] + "</B> button to open a help window showing how to do this,<BR> or the <B>" + (String)objectArray[1] + "</B> button if Midi comms are already set up and<BR>you are ready to download filter settings.</HTML>", "FBQ2496 Midi Configuration", -1, 1, null, objectArray, objectArray[2]);
            switch (n3) {
                case 0: {
                    try {
                        XE.A("html.bfdcomms_midiconfig2", "javax.help.SecondaryWindow", null);
                    }
                    catch (BadIDException badIDException) {
                        WizardLogger.getLogger().log(Level.SEVERE, "Unable to access help topic:\n" + badIDException, badIDException);
                        badIDException.printStackTrace(System.err);
                        JOptionPane.showMessageDialog(g.getDialogParent(), "Unable to access the help topic\n", "Help Display Error", 0);
                    }
                    lG.j(true);
                    break;
                }
                case 1: {
                    lG.j(true);
                    break;
                }
            }
        }
        if (n3 == 1 && uI.A()) {
            objectArray = new String[]{"Left", "Right", "Both"};
            String string = (String)JOptionPane.showInputDialog(g.getDialogParent(), "Which equaliser bank should\n the filters be downloaded to?", "Select Equaliser Bank", 3, null, objectArray, objectArray[lG.\u0217()]);
            if (string != null) {
                this.progMonitor = new ProgressMonitor(g.getDialogParent(), "", null, 0, filterSet.getFilters().length);
                this.progMonitor.setMillisToDecideToPopup(0);
                this.progMonitor.setMillisToPopup(0);
                this.progMonitor.setProgress(0);
                this.progMonitor.setNote("Filter download via Midi");
                int n4 = Arrays.asList(objectArray).indexOf(string);
                lG.o(n4);
                Thread thread = this.A(n4, filterSet);
                thread.setPriority(5);
                thread.start();
            }
        }
    }

    private Thread A(final int n2, final FilterSet filterSet) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    long l2 = lG.\u01d5();
                    CA.this.progMonitor.setProgress(1);
                    CA.this.progMonitor.setNote("Selecting bank...");
                    uI.B(CA.this.C, n2);
                    Thread.sleep(l2);
                    CA.this.progMonitor.setNote("Setting all filters to PEQ...");
                    uI.A(CA.this.C);
                    Thread.sleep(l2);
                    Filter[] filterArray = filterSet.getFilters();
                    for (int i2 = 0; i2 < filterArray.length; ++i2) {
                        boolean bl;
                        CA.this.progMonitor.setProgress(i2 + 1);
                        CA.this.progMonitor.setNote("Downloading filters..." + (i2 + 1));
                        double d2 = 0.0;
                        boolean bl2 = bl = filterArray[i2].getFilterType() == Filter.FilterTypes.PK || filterArray[i2].getFilterType() == Filter.FilterTypes.MODAL;
                        if (bl && filterArray[i2].isEnabled()) {
                            d2 = filterArray[i2].getFilterGain();
                        }
                        double d3 = filterArray[i2].getFilterFc();
                        double d4 = CA.this.qToDisp(filterArray[i2].getFilterQ(), 0.0, 0.0);
                        uI.A(CA.this.C, i2, d3, d4, d2);
                        if (CA.this.progMonitor.isCanceled()) break;
                        Thread.sleep(l2);
                    }
                    uI.E(CA.this.C, 0);
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                uI.C.close();
                CA.this.progMonitor.close();
            }
        };
        return thread;
    }

    @Override
    IB getBFDFreq(double d2) {
        IB iB2 = new IB();
        int n2 = Arrays.binarySearch(E, this.getNearestFreq(d2));
        if (n2 >= 0) {
            iB2.A = n2 / 8;
            iB2.B = n2 - 8 * iB2.A;
        } else {
            iB2.A = -1;
        }
        return iB2;
    }

    @Override
    double getMaxQorBW() {
        return this.qToDisp(this.getMinQorBWSpVal(), 0.0, 0.0);
    }

    @Override
    double getMinQorBW() {
        return this.qToDisp(this.getMaxQorBWSpVal(), 0.0, 0.0);
    }

    @Override
    double getNextFreq(double d2) {
        int n2 = Math.min(this.A(d2) + 1, E.length - 1);
        return E[n2];
    }

    @Override
    double getPrevFreq(double d2) {
        int n2 = Math.max(this.A(d2) - 1, 0);
        return E[n2];
    }

    @Override
    double getNextFreq(double d2, int n2) {
        int n3 = Math.min(this.A(d2) + n2, E.length - 1);
        return E[n3];
    }

    @Override
    double getPrevFreq(double d2, int n2) {
        int n3 = Math.max(this.A(d2) - n2, 0);
        return E[n3];
    }

    private int A(double d2) {
        int n2 = Arrays.binarySearch(E, d2);
        if (n2 < 0) {
            if ((n2 = -n2 - 2) < 0) {
                n2 = 0;
            }
            if (d2 - E[n2] > E[n2 + 1] - d2 && ++n2 >= E.length - 1) {
                n2 = E.length - 1;
            }
        }
        return n2;
    }

    @Override
    double getNearestFreq(double d2) {
        int n2 = Arrays.binarySearch(E, d2);
        if (n2 < 0) {
            if ((n2 = -n2 - 2) < 0) {
                n2 = 0;
            }
            if (n2 < E.length - 1 && d2 - E[n2] > E[n2 + 1] - d2 && ++n2 >= E.length - 1) {
                n2 = E.length - 1;
            }
        }
        return E[n2];
    }

    @Override
    double getNextDispQ(double d2) {
        int n2 = Math.min(this.B(d2) + 1, B.length - 1);
        return B[n2];
    }

    @Override
    double getPrevDispQ(double d2) {
        int n2 = Math.max(this.B(d2) - 1, 0);
        return B[n2];
    }

    @Override
    double getNextDispQ(double d2, int n2) {
        int n3 = Math.min(this.B(d2) + n2, B.length - 1);
        return B[n3];
    }

    @Override
    double getPrevDispQ(double d2, int n2) {
        int n3 = Math.max(this.B(d2) - n2, 0);
        return B[n3];
    }

    int B(double d2) {
        int n2 = Arrays.binarySearch(B, d2);
        if (n2 < 0) {
            if ((n2 = -n2 - 2) < 0) {
                n2 = 0;
            }
            if (d2 - B[n2] > B[n2 + 1] - d2 && ++n2 >= B.length - 1) {
                n2 = B.length - 1;
            }
        }
        return n2;
    }

    @Override
    double getHigherDispQ(double d2) {
        return this.getPrevDispQ(d2);
    }

    @Override
    double getLowerDispQ(double d2) {
        return this.getNextDispQ(d2);
    }

    @Override
    double getNearestDispQ(double d2) {
        int n2 = Arrays.binarySearch(B, d2);
        if (n2 < 0) {
            if ((n2 = -n2 - 2) < 0) {
                n2 = 0;
            }
            if (n2 < B.length - 1 && d2 - B[n2] > B[n2 + 1] - d2 && ++n2 >= B.length - 1) {
                n2 = B.length - 1;
            }
        }
        return B[n2];
    }

    @Override
    double getNearestActualQ(double d2, double d3, double d4) {
        return this.dispToQ(this.getNearestDispQ(this.qToDisp(d2, d3, d4)), d3, d4);
    }

    @Override
    double getNextGain(double d2) {
        double d3 = Math.min(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() + 1.0), this.getMaxGain());
        if (d3 < -15.0) {
            d3 = Math.round(d3);
        }
        return d3;
    }

    @Override
    double getPrevGain(double d2) {
        double d3 = Math.max(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() - 1.0), this.getMinGain());
        if (d3 < -15.0) {
            d3 = Math.round(d3 - 0.5);
        }
        return d3;
    }

    @Override
    double getNextGain(double d2, int n2) {
        double d3 = Math.min(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() + (double)n2), this.getMaxGain());
        if (d3 < -15.0) {
            d3 = Math.round(d3);
        }
        return d3;
    }

    @Override
    double getPrevGain(double d2, int n2) {
        double d3 = Math.max(this.getGainStep() * (double)Math.round(d2 / this.getGainStep() - (double)n2), this.getMinGain());
        if (d3 < -15.0) {
            d3 = Math.round(d3 - 0.5);
        }
        return d3;
    }

    @Override
    double getNearestGain(double d2) {
        double d3 = Math.max(Math.min((double)Math.round(d2 / this.getGainStep()) * this.getGainStep(), this.getMaxGain()), this.getMinGain());
        if (d3 < -15.0) {
            d3 = Math.round(d3);
        }
        return d3;
    }

    @Override
    double qToDisp(double d2, double d3, double d4) {
        return D / d2;
    }

    @Override
    double dispToQ(double d2, double d3, double d4) {
        return D / d2;
    }

    static {
        int n2;
        D = Math.sqrt(2.0);
        E = new double[601];
        B = new double[]{0.016666666666666666, 0.03333333333333333, 0.05, 0.06666666666666667, 0.08333333333333333, 0.1, 0.1111111111111111, 0.125, 0.14285714285714285, 0.16666666666666666, 0.2, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 10.0};
        double d2 = Math.pow(10.0, 0.005);
        CA.E[0] = 20.0;
        for (n2 = 1; n2 < E.length; ++n2) {
            CA.E[n2] = E[n2 - 1] * d2;
        }
        for (n2 = 1; n2 < E.length; ++n2) {
            CA.E[n2] = CA.truncTo(E[n2], 5);
        }
    }
}

