/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.EnumMap;
import roomeqwizard.EK;
import roomeqwizard.HE;
import roomeqwizard.ModelParameter;
import roomeqwizard.MotionalImpedance;
import roomeqwizard.TSParams;

abstract class BaseImpedanceModel
implements MotionalImpedance,
Serializable {
    static final long serialVersionUID = 1L;
    protected double RES;
    protected double CMES;
    protected double LCES;
    protected double YLCES;
    protected double LCESAtOmegaS;
    protected double RESAtOmegaS;
    protected double QMS;
    protected double QES;
    protected double QTS;
    protected double omegaS;
    protected double peakOmega;
    protected double primaryOmegaS;
    protected double primaryCMES;
    protected boolean isPrimary;
    protected TSParams ts;

    BaseImpedanceModel() {
    }

    BaseImpedanceModel(TSParams tSParams) {
        this.ts = tSParams;
    }

    @Override
    public void initialise(double d2, float f2, float f3, float f4, double d3, double d4, boolean bl) {
        this.isPrimary = bl;
        this.omegaS = this.peakOmega = Math.PI * 2 * d2;
        if (bl) {
            this.primaryOmegaS = this.omegaS;
        }
        float f5 = (float)((double)f2 / d3);
        double d5 = d4 / d3;
        this.QMS = Math.sqrt((d5 * d5 - (double)(f5 * f5)) / (double)(f5 * f5 - 1.0f)) * d2 / (double)(f4 - f3);
        this.QES = this.QMS / (d5 - 1.0);
        this.QTS = this.QES * this.QMS / (this.QES + this.QMS);
        this.CMES = this.QES / (this.peakOmega * d3);
        this.LCES = 1.0 / (this.peakOmega * this.peakOmega * this.CMES);
    }

    @Override
    public void setPrimary(boolean bl) {
        this.isPrimary = bl;
    }

    @Override
    public void setPeakOmega(double d2) {
        this.peakOmega = d2;
    }

    @Override
    public double calculateError(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        boolean bl = false;
        int n2 = dArray.length;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            EK eK2 = this.ZM(dArray[i2]);
            double d3 = dArray2[i2] - eK2.B;
            double d4 = dArray3[i2] - eK2.A;
            d2 += (d3 * d3 + d4 * d4) * dArray4[i2];
        }
        return d2;
    }

    @Override
    public EK ZM(double d2) {
        this.calcCompliance(d2);
        EK eK2 = new EK(this.getYES(), d2 * this.CMES - 1.0 / (d2 * this.LCES));
        return EK.F(eK2);
    }

    protected double getYES() {
        return 1.0 / this.RES + this.YLCES;
    }

    protected void calcCompliance(double d2) {
    }

    protected double calcLCES(double d2) {
        return this.LCES;
    }

    @Override
    public double getResEquiv() {
        return this.RES;
    }

    @Override
    public double getLCES(double d2) {
        return this.calcLCES(d2);
    }

    @Override
    public double getOmegaS() {
        return this.omegaS;
    }

    @Override
    public double getQMS() {
        return this.QMS;
    }

    @Override
    public double getQES() {
        return this.QES;
    }

    @Override
    public double getQTS() {
        return this.QTS;
    }

    @Override
    public void setOmegaS(double d2) {
        this.omegaS = d2;
    }

    @Override
    public void setQMS(double d2) {
        this.QMS = d2;
    }

    @Override
    public void setQES(double d2) {
        this.QES = d2;
    }

    @Override
    public void setQTS(double d2) {
        this.QTS = d2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ModelParameter modelParameter : this.getModel().getParams()) {
            DecimalFormat decimalFormat = new DecimalFormat(modelParameter.getFormatSt());
            stringBuilder.append(modelParameter.getPlainSymbol()).append(": ");
            stringBuilder.append(decimalFormat.format(this.getParam(modelParameter) / modelParameter.getScaling()));
            if (modelParameter.getUnitSt().length() > 0) {
                stringBuilder.append(" ").append(modelParameter.getUnitSt());
            }
            stringBuilder.append("; ");
        }
        stringBuilder.append("\nQT ").append(HE.K.format(this.QTS));
        stringBuilder.append(", QES ").append(HE.K.format(this.QES));
        stringBuilder.append(", QMS ").append(HE.K.format(this.QMS));
        return stringBuilder.toString();
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ModelParameter modelParameter : this.getModel().getParams()) {
            DecimalFormat decimalFormat = new DecimalFormat(modelParameter.getFormatSt());
            stringBuilder.append(modelParameter.getPlainSymbol()).append(": ");
            stringBuilder.append(decimalFormat.format(this.getParam(modelParameter) / modelParameter.getScaling()));
            if (modelParameter.getUnitSt().length() > 0) {
                stringBuilder.append(" ").append(modelParameter.getUnitSt());
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    @Override
    public double[] paramValues() {
        ArrayList<ModelParameter> arrayList = this.getModel().getParams();
        double[] dArray = new double[arrayList.size()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = this.getParam(arrayList.get(i2));
        }
        return dArray;
    }

    @Override
    public void exportParameters(PrintWriter printWriter, String string) {
        for (ModelParameter modelParameter : this.getModel().getParams()) {
            DecimalFormat decimalFormat = new DecimalFormat(modelParameter.getFormatSt());
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(modelParameter.getPlainSymbol()).append(string);
            stringBuilder.append(decimalFormat.format(this.getParam(modelParameter) / modelParameter.getScaling()));
            stringBuilder.append(string).append(modelParameter.getUnitSt());
            printWriter.println(stringBuilder.toString());
        }
    }

    @Override
    public EnumMap<ModelParameter, Double> copySettings() {
        EnumMap<ModelParameter, Double> enumMap = new EnumMap<ModelParameter, Double>(ModelParameter.class);
        for (ModelParameter modelParameter : this.getModel().getParams()) {
            enumMap.put(modelParameter, this.getParam(modelParameter));
        }
        return enumMap;
    }
}

