/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public final class WindowUtils {
    private static final Logger LOG = Logger.getLogger(WindowUtils.class.getName());

    public static Point getPointForCentering(Window window) {
        Rectangle rectangle = WindowUtils.getUsableDeviceBounds(window);
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = window.getWidth();
        int n5 = window.getHeight();
        return new Point((n2 - n4) / 2 + rectangle.x, (n3 - n5) / 2 + rectangle.y);
    }

    private static Rectangle getUsableDeviceBounds(Window window) {
        Window window2 = window.getOwner();
        GraphicsConfiguration graphicsConfiguration = null;
        graphicsConfiguration = window2 == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : window2.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static Point getPointForCentering(JInternalFrame jInternalFrame) {
        try {
            GraphicsDevice[] graphicsDeviceArray;
            Point point = MouseInfo.getPointerInfo().getLocation();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
                if (point.x < rectangle.x || point.y < rectangle.y || point.x > rectangle.x + rectangle.width || point.y > rectangle.y + rectangle.height) continue;
                int n2 = rectangle.width;
                int n3 = rectangle.height;
                int n4 = jInternalFrame.getWidth();
                int n5 = jInternalFrame.getHeight();
                return new Point((n2 - n4) / 2 + rectangle.x, (n3 - n5) / 2 + rectangle.y);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getLocalizedMessage() + " - this can occur do to a Security exception in sandboxed apps");
        }
        return new Point(0, 0);
    }

    public static Window findWindow(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return WindowUtils.findWindow(component.getParent());
    }
}

