/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

public class Utilities {
    private static int operatingSystem = -1;
    private static Reference<Object> namesAndValues;

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(string) ? 1 : ("Windows 95".equals(string) ? 2 : ("Windows 98".equals(string) ? 4 : ("Windows 2000".equals(string) ? 8192 : (string.startsWith("Windows ") ? 32768 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : (string.endsWith("Linux") ? 16 : ("HP-UX".equals(string) ? 32 : ("AIX".equals(string) ? 64 : ("Irix".equals(string) ? 128 : ("SunOS".equals(string) ? 256 : ("Digital UNIX".equals(string) ? 512 : ("OS/2".equals(string) ? 2048 : ("OpenVMS".equals(string) ? 16384 : (string.equals("Mac OS X") ? 4096 : (string.startsWith("Darwin") ? 4096 : (string.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : 65536)))))))))))))))));
        }
        return operatingSystem;
    }

    private static synchronized HashMap[] initNameAndValues() {
        Object[] objectArray;
        if (namesAndValues != null && (objectArray = (HashMap[])namesAndValues.get()) != null) {
            return objectArray;
        }
        try {
            objectArray = KeyEvent.class.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            objectArray = new Field[]{};
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(objectArray.length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>(objectArray.length * 4 / 3 + 5, 0.75f);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string;
            if (!Modifier.isStatic(((Field)objectArray[i2]).getModifiers()) || !(string = ((Field)objectArray[i2]).getName()).startsWith("VK_")) continue;
            string = string.substring(3);
            try {
                int n2 = ((Field)objectArray[i2]).getInt(null);
                Integer n3 = new Integer(n2);
                hashMap.put(string, n3);
                hashMap2.put(n3, string);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (hashMap.get("CONTEXT_MENU") == null) {
            Integer n4 = new Integer(524);
            hashMap.put("CONTEXT_MENU", n4);
            hashMap2.put(n4, "CONTEXT_MENU");
            n4 = new Integer(525);
            hashMap.put("WINDOWS", n4);
            hashMap2.put(n4, "WINDOWS");
        }
        HashMap[] hashMapArray = new HashMap[]{hashMap, hashMap2};
        namesAndValues = new SoftReference<HashMap[]>(hashMapArray);
        return hashMapArray;
    }

    public static KeyStroke stringToKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(Locale.ENGLISH), "-", true);
        int n2 = 0;
        HashMap hashMap = Utilities.initNameAndValues()[0];
        int n3 = -1;
        try {
            String string2;
            while (true) {
                if ((string2 = stringTokenizer.nextToken()).equals("-")) {
                    if (n3 == -1) continue;
                    n2 |= n3;
                    n3 = -1;
                    continue;
                }
                if (!stringTokenizer.hasMoreElements()) break;
                n3 = Utilities.readModifiers(string2);
            }
            Integer n4 = (Integer)hashMap.get(string2);
            boolean bl = (n2 & 0x8000) != 0;
            boolean bl2 = ((n2 &= 0xFFFF7FFF) & 0x10000) != 0;
            n2 &= 0xFFFEFFFF;
            if (n4 != null) {
                if (bl && (Utilities.getOperatingSystem() & 0x1000) != 0 && !Utilities.usableKeyOnMac(n4, n2 |= Utilities.getMenuShortCutKeyMask())) {
                    n2 &= ~Utilities.getMenuShortCutKeyMask();
                    n2 |= 2;
                }
                if (bl2) {
                    n2 = Utilities.getOperatingSystem() == 4096 ? (n2 |= 2) : (n2 |= 8);
                }
                return KeyStroke.getKeyStroke(n4, n2);
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private static int getMenuShortCutKeyMask() {
        if (GraphicsEnvironment.isHeadless()) {
            return (Utilities.getOperatingSystem() & 0x1000) != 0 ? 4 : 2;
        }
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    private static boolean usableKeyOnMac(int n2, int n3) {
        boolean bl;
        if (n2 == 81) {
            return false;
        }
        boolean bl2 = (n3 & 4) != 0 || (n3 & 0x80) != 0;
        boolean bl3 = (n3 & 8) != 0 || (n3 & 0x200) != 0;
        boolean bl4 = bl = bl2 && (n3 & 0xFFFFFEFB) == 0;
        if (bl) {
            return n2 != 72 && n2 != 32 && n2 != 9;
        }
        return n2 != 68 || !bl2 || !bl3;
    }

    private static int readModifiers(String string) throws NoSuchElementException {
        int n2 = 0;
        block8: for (int i2 = 0; i2 < string.length(); ++i2) {
            switch (string.charAt(i2)) {
                case 'C': {
                    n2 |= 2;
                    continue block8;
                }
                case 'A': {
                    n2 |= 8;
                    continue block8;
                }
                case 'M': {
                    n2 |= 4;
                    continue block8;
                }
                case 'S': {
                    n2 |= 1;
                    continue block8;
                }
                case 'D': {
                    n2 |= 0x8000;
                    continue block8;
                }
                case 'O': {
                    n2 |= 0x10000;
                    continue block8;
                }
                default: {
                    throw new NoSuchElementException(string);
                }
            }
        }
        return n2;
    }
}

