/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Scanner;
import javax.swing.UIManager;

public class OS {
    private static final boolean osIsMacOsX;
    private static final boolean osIsWindows;
    private static final boolean osIsWindowsXP;
    private static final boolean osIsWindows2003;
    private static final boolean osIsWindowsVista;
    private static final boolean osIsLinux;
    private static final boolean osIsWindows7;
    private static final boolean osIsWindows8;
    private static final boolean osIsWindows8_1;
    private static final boolean osIsWindows10OrLater;
    private static final boolean osIsWindows8OrLater;

    public static String getOSVersion() {
        String string = System.getProperty("os.version").toLowerCase();
        if (osIsMacOsX) {
            String string2;
            String string3;
            if (Files.isExecutable(Paths.get("/usr/bin/sw_vers", new String[0])) && !(string3 = OS.getMacOsVersionNumber(string2 = "-productVersion")).contains("usage")) {
                string = string3;
            }
            if (string.equals("10.16")) {
                string = "11";
            }
        }
        return string;
    }

    public static String getMacOsVersionNumber(String string) {
        String string2;
        try (InputStream inputStream = new ProcessBuilder("/usr/bin/sw_vers", string).start().getInputStream();
             Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");){
            string2 = scanner.hasNext() ? scanner.next() : "";
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            string2 = System.getProperty("os.version").toLowerCase();
        }
        return string2;
    }

    public static String platformName(String string, String string2) {
        boolean bl;
        boolean bl2 = "mac os x".equals(string);
        boolean bl3 = string != null && string.contains("windows");
        boolean bl4 = "windows xp".equals(string);
        boolean bl5 = "windows 2003".equals(string);
        boolean bl6 = "windows vista".equals(string);
        boolean bl7 = bl3 && "6.1".equals(string2);
        boolean bl8 = bl3 && "6.2".equals(string2);
        boolean bl9 = bl3 && "6.3".equals(string2);
        boolean bl10 = bl = bl3 && Double.parseDouble(string2) >= 10.0;
        if (bl) {
            return "Windows " + ("10.0".equals(string2) ? "10" : string2);
        }
        if (bl9) {
            return "Windows 8.1";
        }
        if (bl8) {
            return "Windows 8";
        }
        if (bl7) {
            return "Windows 7";
        }
        if (bl6) {
            return "Windows Vista";
        }
        if (bl4) {
            return "Windows XP";
        }
        if (bl5) {
            return "Windows 2003";
        }
        if (bl2) {
            return "OS X " + string2;
        }
        return string + " " + string2;
    }

    public static boolean isMacOSX() {
        return osIsMacOsX;
    }

    public static boolean isWindows() {
        return osIsWindows;
    }

    public static boolean isWindows7() {
        return osIsWindows7;
    }

    public static boolean isWindows8() {
        return osIsWindows8;
    }

    public static boolean isWindows8OrLater() {
        return osIsWindows8OrLater;
    }

    public static boolean isWindows10OrLater() {
        return osIsWindows10OrLater;
    }

    public static boolean isWindowsXP() {
        return osIsWindowsXP;
    }

    public static boolean isWindowsVista() {
        return osIsWindowsVista;
    }

    public static boolean isLinux() {
        return osIsLinux;
    }

    public static boolean isUsingWindowsVisualStyles() {
        if (!OS.isWindows()) {
            return false;
        }
        boolean bl = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        if (!bl) {
            return false;
        }
        try {
            return System.getProperty("swing.noxp") == null;
        }
        catch (RuntimeException runtimeException) {
            return true;
        }
    }

    public static String getWindowsVisualStyle() {
        String string = UIManager.getString("win.xpstyle.name");
        if (string == null) {
            string = (String)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.colorName");
        }
        return string;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.version").toLowerCase();
        osIsLinux = string != null && string.contains("linux");
        osIsMacOsX = "mac os x".equals(string);
        osIsWindows = string != null && string.contains("windows");
        osIsWindowsXP = "windows xp".equals(string);
        osIsWindows2003 = "windows 2003".equals(string);
        osIsWindowsVista = "windows vista".equals(string);
        osIsWindows7 = osIsWindows && "6.1".equals(string2);
        osIsWindows8 = osIsWindows && "6.2".equals(string2);
        osIsWindows8_1 = osIsWindows && "6.3".equals(string2);
        osIsWindows10OrLater = osIsWindows && Double.parseDouble(string2) >= 10.0;
        osIsWindows8OrLater = osIsWindows && Double.parseDouble(string2) >= 6.2;
    }
}

