/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.JXFindBar;
import org.jdesktop.swingx.JXFindPanel;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.util.Utilities;

public class SearchFactory {
    private static SearchFactory searchFactory;
    protected JXFindPanel findPanel;
    protected JXFindBar findBar;
    protected JComponent lastFindBarTarget;
    private boolean useFindBar;
    private Point lastFindDialogLocation;
    private FindRemover findRemover;

    public static SearchFactory getInstance() {
        if (searchFactory == null) {
            searchFactory = new SearchFactory();
        }
        return searchFactory;
    }

    public KeyStroke getSearchAccelerator() {
        String string = "F";
        KeyStroke keyStroke = Utilities.stringToKey("D-" + string);
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke("control F");
        }
        return keyStroke;
    }

    public boolean isUseFindBar(JComponent jComponent, Searchable searchable) {
        return this.useFindBar;
    }

    public void showFindInput(JComponent jComponent, Searchable searchable) {
        if (this.isUseFindBar(jComponent, searchable)) {
            this.showFindBar(jComponent, searchable);
        } else {
            this.showFindDialog(jComponent, searchable);
        }
    }

    public void showFindBar(JComponent jComponent, Searchable searchable) {
        if (jComponent == null) {
            return;
        }
        if (this.findBar == null) {
            this.findBar = this.getSharedFindBar();
        } else {
            this.releaseFindBar();
        }
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (window instanceof JXFrame) {
            JXRootPane jXRootPane = ((JXFrame)window).getRootPaneExt();
            JToolBar jToolBar = jXRootPane.getToolBar();
            if (jToolBar == null) {
                jToolBar = new JToolBar();
                jXRootPane.setToolBar(jToolBar);
            }
            jToolBar.add((Component)this.findBar, 0);
            jXRootPane.revalidate();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.findBar);
        }
        this.lastFindBarTarget = jComponent;
        this.findBar.setLocale(jComponent.getLocale());
        jComponent.putClientProperty("match.highlighter", Boolean.TRUE);
        this.getSharedFindBar().setSearchable(searchable);
        this.installFindRemover(jComponent, this.findBar);
    }

    public JXFindBar getSharedFindBar() {
        if (this.findBar == null) {
            this.findBar = this.createFindBar();
            this.configureSharedFindBar();
        }
        return this.findBar;
    }

    public JXFindBar createFindBar() {
        return new JXFindBar();
    }

    protected void installFindRemover(Container container, Container container2) {
        if (container != null) {
            this.getFindRemover().addTarget(container);
        }
        this.getFindRemover().addTarget(container2);
    }

    private FindRemover getFindRemover() {
        if (this.findRemover == null) {
            this.findRemover = new FindRemover();
        }
        return this.findRemover;
    }

    protected void removeFromParent(JComponent jComponent) {
        Container container = jComponent.getParent();
        if (container != null) {
            container.remove(jComponent);
            if (container instanceof JComponent) {
                ((JComponent)container).revalidate();
            } else {
                container.invalidate();
                container.validate();
            }
        }
    }

    protected void stopSearching() {
        if (this.findPanel != null) {
            this.lastFindDialogLocation = this.hideSharedFindPanel(false);
            this.findPanel.setSearchable(null);
        }
        if (this.findBar != null) {
            this.releaseFindBar();
        }
    }

    protected void releaseFindBar() {
        this.findBar.setSearchable(null);
        if (this.lastFindBarTarget != null) {
            this.lastFindBarTarget.putClientProperty("match.highlighter", Boolean.FALSE);
            this.lastFindBarTarget = null;
        }
        this.removeFromParent(this.findBar);
    }

    protected void configureSharedFindBar() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchFactory.this.removeFromParent(SearchFactory.this.findBar);
            }
        };
        this.findBar.getActionMap().put("close", abstractAction);
    }

    public void showFindDialog(JComponent jComponent, Searchable searchable) {
        JXDialog jXDialog;
        JXDialog jXDialog2;
        Window window = null;
        if (jComponent != null) {
            jComponent.putClientProperty("match.highlighter", Boolean.FALSE);
            window = SwingUtilities.getWindowAncestor(jComponent);
        }
        if ((jXDialog2 = this.getDialogForSharedFindPanel()) != null && jXDialog2.getOwner().equals(window)) {
            jXDialog = jXDialog2;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(jXDialog);
        } else {
            Point point = this.hideSharedFindPanel(true);
            jXDialog = window instanceof Frame ? new JXDialog((Frame)window, (JComponent)this.getSharedFindPanel()) : (window instanceof Dialog ? new JXDialog((Dialog)window, (JComponent)this.getSharedFindPanel()) : new JXDialog(JOptionPane.getRootFrame(), (JComponent)this.getSharedFindPanel()));
            jXDialog.pack();
            if (point == null) {
                jXDialog.setLocationRelativeTo(window);
            } else {
                jXDialog.setLocation(point);
            }
        }
        if (jComponent != null) {
            jXDialog.setLocale(jComponent.getLocale());
        }
        this.getSharedFindPanel().setSearchable(searchable);
        this.installFindRemover(jComponent, jXDialog);
        jXDialog.setVisible(true);
    }

    public JXFindPanel getSharedFindPanel() {
        if (this.findPanel == null) {
            this.findPanel = this.createFindPanel();
            this.configureSharedFindPanel();
        }
        return this.findPanel;
    }

    public JXFindPanel createFindPanel() {
        return new JXFindPanel();
    }

    protected void configureSharedFindPanel() {
    }

    private JXDialog getDialogForSharedFindPanel() {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        return window instanceof JXDialog ? (JXDialog)window : null;
    }

    protected Point hideSharedFindPanel(boolean bl) {
        if (this.findPanel == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(this.findPanel);
        Point point = this.lastFindDialogLocation;
        if (window != null) {
            if (window.isVisible()) {
                point = window.getLocationOnScreen();
                window.setVisible(false);
            }
            if (bl) {
                this.findPanel.getParent().remove(this.findPanel);
                window.dispose();
            }
        }
        return point;
    }

    static {
        LookAndFeelAddons.getAddon();
    }

    public class FindRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;
        Set<Container> targets;

        public FindRemover() {
            this.updateManager();
        }

        public void addTarget(Container container) {
            this.getTargets().add(container);
        }

        private Set<Container> getTargets() {
            if (this.targets == null) {
                this.targets = new HashSet<Container>();
            }
            return this.targets;
        }

        private void updateManager() {
            if (this.focusManager != null) {
                this.focusManager.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Component component = this.focusManager.getPermanentFocusOwner();
            if (component == null) {
                return;
            }
            for (Container container : this.getTargets()) {
                if (container != component && !SwingUtilities.isDescendingFrom(component, container)) continue;
                return;
            }
            this.endSearching();
        }

        public void endSearching() {
            this.getTargets().clear();
            SearchFactory.this.stopSearching();
        }
    }
}

