/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.regex.Pattern;

public class PatternModel {
    private String rawText;
    private boolean backwards;
    private Pattern pattern;
    private int foundIndex = -1;
    private boolean caseSensitive;
    private PropertyChangeSupport propertySupport;
    private RegexCreator regexCreator;
    private boolean wrapping;
    private boolean incremental;

    public int getFoundIndex() {
        return this.foundIndex;
    }

    public void setFoundIndex(int n2) {
        int n3 = this.getFoundIndex();
        this.updateFoundIndex(n2);
        this.firePropertyChange("foundIndex", n3, this.getFoundIndex());
    }

    protected void updateFoundIndex(int n2) {
        if (n2 < 0) {
            this.foundIndex = n2;
            return;
        }
        this.foundIndex = this.isAutoAdjustFoundIndex() ? (this.backwards ? n2 - 1 : n2 + 1) : n2;
    }

    public boolean isAutoAdjustFoundIndex() {
        return !this.isIncremental();
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean bl) {
        boolean bl2 = this.isWrapping();
        this.wrapping = bl;
        this.firePropertyChange("wrapping", bl2, this.isWrapping());
    }

    public void setIncremental(boolean bl) {
        boolean bl2 = this.isIncremental();
        this.incremental = bl;
        this.firePropertyChange("incremental", bl2, this.isIncremental());
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String string) {
        String string2 = this.getRawText();
        boolean bl = this.isEmpty();
        this.rawText = string;
        this.updatePattern(this.createRegEx(string));
        this.firePropertyChange("rawText", string2, this.getRawText());
        this.firePropertyChange("empty", bl, this.isEmpty());
    }

    public boolean isEmpty() {
        return this.isEmpty(this.getRawText());
    }

    private String createRegEx(String string) {
        if (this.isEmpty(string)) {
            return null;
        }
        return this.getRegexCreator().createRegEx(string);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private void updatePattern(String string) {
        Pattern pattern = this.getPattern();
        if (this.isEmpty(string)) {
            this.pattern = null;
        } else if (pattern == null || !pattern.pattern().equals(string)) {
            this.pattern = Pattern.compile(string, this.getFlags());
        }
        this.firePropertyChange("pattern", pattern, this.getPattern());
    }

    private int getFlags() {
        return this.isCaseSensitive() ? 0 : this.getCaseInsensitiveFlag();
    }

    private int getCaseInsensitiveFlag() {
        return 66;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.propertySupport == null) {
            return;
        }
        this.propertySupport.firePropertyChange(string, object, object2);
    }

    private RegexCreator getRegexCreator() {
        if (this.regexCreator == null) {
            this.regexCreator = new RegexCreator();
        }
        return this.regexCreator;
    }

    public static class AnchoredSearchMode
    extends RegexCreator {
        public boolean isAutoDetect() {
            return true;
        }

        @Override
        public String createRegEx(String string) {
            if (this.isAutoDetect()) {
                StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
                if (!this.hasStartAnchor(string) && this.isStartAnchored()) {
                    stringBuffer.append("^");
                }
                stringBuffer.append(string);
                if (!this.hasEndAnchor(string) && this.isEndAnchored()) {
                    stringBuffer.append("$");
                }
                return stringBuffer.toString();
            }
            return super.createRegEx(string);
        }

        private boolean hasStartAnchor(String string) {
            return string.startsWith("^");
        }

        private boolean hasEndAnchor(String string) {
            int n2 = string.length();
            if (string.charAt(n2 - 1) != '$') {
                return false;
            }
            if (n2 == 1) {
                return true;
            }
            for (int i2 = n2 - 2; i2 >= 0; --i2) {
                if (string.charAt(i2) == '\\') continue;
                return (n2 - i2) % 2 == 0;
            }
            return n2 % 2 != 0;
        }

        public boolean isStartAnchored() {
            return "equals".equals(this.getMatchRule()) || "startsWith".equals(this.getMatchRule());
        }

        public boolean isEndAnchored() {
            return "equals".equals(this.getMatchRule()) || "endsWith".equals(this.getMatchRule());
        }
    }

    public static class RegexCreator {
        protected String matchRule;

        public String getMatchRule() {
            if (this.matchRule == null) {
                this.matchRule = this.getDefaultMatchRule();
            }
            return this.matchRule;
        }

        public String createRegEx(String string) {
            if ("contains".equals(this.getMatchRule())) {
                return this.createContainedRegEx(string);
            }
            if ("equals".equals(this.getMatchRule())) {
                return this.createEqualsRegEx(string);
            }
            if ("startsWith".equals(this.getMatchRule())) {
                return this.createStartsAnchoredRegEx(string);
            }
            if ("endsWith".equals(this.getMatchRule())) {
                return this.createEndAnchoredRegEx(string);
            }
            return string;
        }

        protected String createEndAnchoredRegEx(String string) {
            return Pattern.quote(string) + "$";
        }

        protected String createStartsAnchoredRegEx(String string) {
            return "^" + Pattern.quote(string);
        }

        protected String createEqualsRegEx(String string) {
            return "^" + Pattern.quote(string) + "$";
        }

        protected String createContainedRegEx(String string) {
            return Pattern.quote(string);
        }

        protected String getDefaultMatchRule() {
            return "contains";
        }
    }
}

