/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Container;
import java.io.Serializable;
import javax.swing.JComponent;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.PainterAware;

public class DefaultVisuals<T extends JComponent>
implements Serializable {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public void configureVisuals(T t2, CellContext cellContext) {
        this.configureState(t2, cellContext);
        this.configureColors(t2, cellContext);
        this.configureBorder(t2, cellContext);
        this.configurePainter(t2, cellContext);
    }

    protected void configurePainter(T t2, CellContext cellContext) {
        if (t2 instanceof PainterAware) {
            ((PainterAware)t2).setPainter(null);
        }
    }

    protected void configureState(T t2, CellContext cellContext) {
        ((JComponent)t2).setToolTipText(null);
        this.configureSizes(t2, cellContext);
        if (cellContext.getComponent() != null) {
            ((JComponent)t2).setFont(cellContext.getComponent().getFont());
            ((JComponent)t2).setEnabled(cellContext.getComponent().isEnabled());
            ((Container)t2).applyComponentOrientation(cellContext.getComponent().getComponentOrientation());
        }
    }

    protected void configureSizes(T t2, CellContext cellContext) {
        ((JComponent)t2).setPreferredSize(null);
        ((JComponent)t2).setMinimumSize(null);
        ((JComponent)t2).setMaximumSize(null);
    }

    protected void configureColors(T t2, CellContext cellContext) {
        if (cellContext.isSelected()) {
            ((JComponent)t2).setForeground(cellContext.getSelectionForeground());
            ((JComponent)t2).setBackground(cellContext.getSelectionBackground());
        } else {
            ((JComponent)t2).setForeground(this.getForeground(cellContext));
            ((JComponent)t2).setBackground(this.getBackground(cellContext));
        }
        if (cellContext.isFocused()) {
            this.configureFocusColors(t2, cellContext);
        }
    }

    protected void configureFocusColors(T t2, CellContext cellContext) {
        if (!cellContext.isSelected() && cellContext.isEditable()) {
            Color color = cellContext.getFocusForeground();
            if (color != null) {
                ((JComponent)t2).setForeground(color);
            }
            if ((color = cellContext.getFocusBackground()) != null) {
                ((JComponent)t2).setBackground(color);
            }
        }
    }

    protected void configureBorder(T t2, CellContext cellContext) {
        ((JComponent)t2).setBorder(cellContext.getBorder());
    }

    protected Color getForeground(CellContext cellContext) {
        if (this.unselectedForeground != null) {
            return this.unselectedForeground;
        }
        return cellContext.getForeground();
    }

    protected Color getBackground(CellContext cellContext) {
        if (this.unselectedBackground != null) {
            return this.unselectedBackground;
        }
        return cellContext.getBackground();
    }
}

