/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.windows;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicStatusBarUI;

public class WindowsStatusBarUI
extends BasicStatusBarUI {
    private static final Logger log = Logger.getLogger(WindowsStatusBarUI.class.getName());
    private BufferedImage leftImage;
    private BufferedImage middleImage;
    private BufferedImage rightImage;

    public WindowsStatusBarUI() {
        try {
            this.leftImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.leftImage")));
            this.middleImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.middleImage")));
            this.rightImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.rightImage")));
        }
        catch (Exception exception) {
            log.log(Level.FINE, exception.getLocalizedMessage(), exception);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsStatusBarUI();
    }

    @Override
    protected void paintBackground(Graphics2D graphics2D, JXStatusBar jXStatusBar) {
        if (this.leftImage == null || this.middleImage == null || this.rightImage == null) {
            log.severe("Failed to initialize necessary assets. Set logging to FINE to see more details.");
            return;
        }
        graphics2D.drawImage(this.leftImage, 0, 0, this.leftImage.getWidth(), jXStatusBar.getHeight(), null);
        if (jXStatusBar.isResizeHandleEnabled()) {
            graphics2D.drawImage(this.middleImage, this.leftImage.getWidth(), 0, jXStatusBar.getWidth() - this.leftImage.getWidth() - this.rightImage.getWidth(), jXStatusBar.getHeight(), null);
            graphics2D.drawImage(this.rightImage, jXStatusBar.getWidth() - this.rightImage.getWidth(), 0, this.rightImage.getWidth(), jXStatusBar.getHeight(), null);
        } else {
            graphics2D.drawImage(this.middleImage, this.leftImage.getWidth(), 0, jXStatusBar.getWidth() - this.leftImage.getWidth(), jXStatusBar.getHeight(), null);
        }
    }

    @Override
    protected Insets getSeparatorInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 1;
        insets.left = 4;
        insets.bottom = 0;
        insets.right = 4;
        return insets;
    }
}

