/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.painter.AbstractPainter;

class TextCrossingPainter<T extends JComponent>
extends AbstractPainter<T> {
    Rectangle paintIconR = new Rectangle();
    Rectangle paintViewR = new Rectangle();
    Rectangle paintTextR = new Rectangle();
    Insets insetss = new Insets(0, 0, 0, 0);
    Color crossColor;

    TextCrossingPainter() {
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, JComponent jComponent, int n2, int n3) {
        if (!(jComponent instanceof JLabel)) {
            return;
        }
        JLabel jLabel = (JLabel)jComponent;
        Insets insets = jLabel.getInsets(this.insetss);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = n2 - (insets.left + insets.right);
        this.paintViewR.height = n3 - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        SwingUtilities.layoutCompoundLabel(jLabel, jLabel.getFontMetrics(jLabel.getFont()), jLabel.getText(), null, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, jLabel.getIconTextGap());
        this.doPaint(graphics2D, this.paintTextR);
    }

    private void doPaint(Graphics2D graphics2D, Rectangle rectangle) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.getForeground());
        graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics2D.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height);
        graphics2D.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x - 1, rectangle.y + rectangle.height);
        graphics2D.setColor(color);
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        this.crossColor = color;
        this.firePropertyChange("foreground", color2, this.getForeground());
    }

    public Color getForeground() {
        return this.crossColor;
    }
}

