/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractSpinnerModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.renderer.FormatStringValue;

public class SpinningCalendarHeaderHandler
extends CalendarHeaderHandler {
    public static final String ARROWS_SURROUND_MONTH = "SpinningCalendarHeader.arrowsSurroundMonth";
    public static final String FOCUSABLE_SPINNER_TEXT = "SpinningCalendarHeader.focusableSpinnerText";
    private static final Logger LOG = Logger.getLogger(SpinningCalendarHeaderHandler.class.getName());
    private SpinnerModel yearSpinnerModel;
    private PropertyChangeListener monthPropertyListener;
    private FormatStringValue monthStringValue;

    @Override
    public void install(JXMonthView jXMonthView) {
        super.install(jXMonthView);
        this.getHeaderComponent().setActions(jXMonthView.getActionMap().get("previousMonth"), jXMonthView.getActionMap().get("nextMonth"), this.getYearSpinnerModel());
        this.componentOrientationChanged();
        this.monthStringBackgroundChanged();
        this.fontChanged();
        this.localeChanged();
    }

    @Override
    public void uninstall(JXMonthView jXMonthView) {
        this.getHeaderComponent().setActions(null, null, null);
        this.getHeaderComponent().setMonthText("");
        super.uninstall(jXMonthView);
    }

    @Override
    public SpinningCalendarHeader getHeaderComponent() {
        return (SpinningCalendarHeader)super.getHeaderComponent();
    }

    @Override
    protected SpinningCalendarHeader createCalendarHeader() {
        SpinningCalendarHeader spinningCalendarHeader = new SpinningCalendarHeader();
        if (Boolean.TRUE.equals(UIManager.getBoolean(FOCUSABLE_SPINNER_TEXT))) {
            spinningCalendarHeader.setSpinnerFocusable(true);
        }
        if (Boolean.TRUE.equals(UIManager.getBoolean(ARROWS_SURROUND_MONTH))) {
            spinningCalendarHeader.setArrowsSurroundMonth(true);
        }
        return spinningCalendarHeader;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.monthView.addPropertyChangeListener(this.getPropertyChangeListener());
    }

    @Override
    protected void uninstallListeners() {
        this.monthView.removePropertyChangeListener(this.getPropertyChangeListener());
        super.uninstallListeners();
    }

    protected void updateFormatters() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.monthView.getLocale());
        simpleDateFormat.applyPattern("MMMM");
        this.monthStringValue = new FormatStringValue(simpleDateFormat);
    }

    protected void firstDisplayedDayChanged() {
        ((YearSpinnerModel)this.getYearSpinnerModel()).fireStateChanged();
        this.getHeaderComponent().setMonthText(this.monthStringValue.getString(this.monthView.getFirstDisplayedDay()));
    }

    protected void localeChanged() {
        this.updateFormatters();
        this.firstDisplayedDayChanged();
    }

    private PropertyChangeListener getPropertyChangeListener() {
        if (this.monthPropertyListener == null) {
            this.monthPropertyListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("firstDisplayedDay".equals(propertyChangeEvent.getPropertyName())) {
                        SpinningCalendarHeaderHandler.this.firstDisplayedDayChanged();
                    } else if ("locale".equals(propertyChangeEvent.getPropertyName())) {
                        SpinningCalendarHeaderHandler.this.localeChanged();
                    }
                }
            };
        }
        return this.monthPropertyListener;
    }

    private int getYear() {
        Calendar calendar = this.monthView.getCalendar();
        return calendar.get(1);
    }

    private int getPreviousYear() {
        Calendar calendar = this.monthView.getCalendar();
        calendar.add(1, -1);
        return calendar.get(1);
    }

    private int getNextYear() {
        Calendar calendar = this.monthView.getCalendar();
        calendar.add(1, 1);
        return calendar.get(1);
    }

    private boolean setYear(Object object) {
        int n2 = (Integer)object;
        Calendar calendar = this.monthView.getCalendar();
        if (calendar.get(1) == n2) {
            return false;
        }
        calendar.set(1, n2);
        this.monthView.setFirstDisplayedDay(calendar.getTime());
        return true;
    }

    private SpinnerModel getYearSpinnerModel() {
        if (this.yearSpinnerModel == null) {
            this.yearSpinnerModel = new YearSpinnerModel();
        }
        return this.yearSpinnerModel;
    }

    protected static class SpinningCalendarHeader
    extends JXPanel {
        private AbstractButton prevButton;
        private AbstractButton nextButton;
        private JLabel monthText;
        private JSpinner yearSpinner;
        private boolean surroundMonth;

        public SpinningCalendarHeader() {
            this.initComponents();
        }

        public void setActions(Action action, Action action2, SpinnerModel spinnerModel) {
            this.prevButton.setAction(action);
            this.nextButton.setAction(action2);
            this.uninstallZoomAction();
            this.installZoomAction(spinnerModel);
        }

        public void setSpinnerFocusable(boolean bl) {
            ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setFocusable(bl);
        }

        public void setArrowsSurroundMonth(boolean bl) {
            if (this.surroundMonth == bl) {
                return;
            }
            this.surroundMonth = bl;
            this.removeAll();
            this.addComponents();
        }

        public void setMonthText(String string) {
            this.monthText.setText(string);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.monthText != null) {
                this.monthText.setFont(font);
                this.yearSpinner.setFont(font);
                this.yearSpinner.getEditor().setFont(font);
                ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setFont(font);
            }
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                this.getComponent(i2).setBackground(color);
            }
            if (this.yearSpinner != null) {
                this.yearSpinner.setBackground(color);
                this.yearSpinner.getEditor().setBackground(color);
                ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setBackground(color);
            }
        }

        private void installZoomAction(SpinnerModel spinnerModel) {
            if (spinnerModel == null) {
                return;
            }
            this.yearSpinner.setModel(spinnerModel);
        }

        private void uninstallZoomAction() {
        }

        private void initComponents() {
            this.createComponents();
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.addComponents();
        }

        private void addComponents() {
            if (this.surroundMonth) {
                this.add(this.prevButton);
                this.add(this.monthText);
                this.add(this.nextButton);
                this.add(Box.createHorizontalStrut(5));
                this.add(this.yearSpinner);
            } else {
                this.add(this.prevButton);
                this.add(Box.createHorizontalGlue());
                this.add(this.monthText);
                this.add(Box.createHorizontalStrut(5));
                this.add(this.yearSpinner);
                this.add(Box.createHorizontalGlue());
                this.add(this.nextButton);
            }
        }

        private void createComponents() {
            this.prevButton = this.createNavigationButton();
            this.nextButton = this.createNavigationButton();
            this.monthText = this.createMonthText();
            this.yearSpinner = this.createSpinner();
        }

        private JLabel createMonthText() {
            JLabel jLabel = new JLabel(){

                @Override
                public Dimension getMaximumSize() {
                    Dimension dimension = super.getMaximumSize();
                    dimension.width = Integer.MAX_VALUE;
                    dimension.height = Integer.MAX_VALUE;
                    return dimension;
                }
            };
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }

        private JSpinner createSpinner() {
            JSpinner jSpinner = new JSpinner();
            jSpinner.setFocusable(false);
            jSpinner.setBorder(BorderFactory.createEmptyBorder());
            JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(jSpinner);
            numberEditor.getFormat().setGroupingUsed(false);
            numberEditor.getTextField().setFocusable(false);
            jSpinner.setEditor(numberEditor);
            return jSpinner;
        }

        private AbstractButton createNavigationButton() {
            JXHyperlink jXHyperlink = new JXHyperlink();
            jXHyperlink.setContentAreaFilled(false);
            jXHyperlink.setBorder(BorderFactory.createEmptyBorder());
            jXHyperlink.setRolloverEnabled(true);
            jXHyperlink.setFocusable(false);
            return jXHyperlink;
        }
    }

    private class YearSpinnerModel
    extends AbstractSpinnerModel {
        private YearSpinnerModel() {
        }

        @Override
        public Object getNextValue() {
            return SpinningCalendarHeaderHandler.this.getNextYear();
        }

        @Override
        public Object getPreviousValue() {
            return SpinningCalendarHeaderHandler.this.getPreviousYear();
        }

        @Override
        public Object getValue() {
            return SpinningCalendarHeaderHandler.this.getYear();
        }

        @Override
        public void setValue(Object object) {
            if (SpinningCalendarHeaderHandler.this.setYear(object)) {
                this.fireStateChanged();
            }
        }

        @Override
        public void fireStateChanged() {
            super.fireStateChanged();
        }
    }
}

