/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.plaf.TitledPanelUI;

public class BasicTitledPanelUI
extends TitledPanelUI {
    private static final Logger LOG = Logger.getLogger(BasicTitledPanelUI.class.getName());
    protected JLabel caption;
    protected JXPanel topPanel;
    protected PropertyChangeListener titleChangeListener;
    protected JComponent left;
    protected JComponent right;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTitledPanelUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        assert (jComponent instanceof JXTitledPanel);
        JXTitledPanel jXTitledPanel = (JXTitledPanel)jComponent;
        this.installDefaults(jXTitledPanel);
        this.caption = this.createAndConfigureCaption(jXTitledPanel);
        this.topPanel = this.createAndConfigureTopPanel(jXTitledPanel);
        this.installComponents(jXTitledPanel);
        this.installListeners(jXTitledPanel);
    }

    protected void installDefaults(JXTitledPanel jXTitledPanel) {
        this.installProperty(jXTitledPanel, "titlePainter", UIManager.get("JXTitledPanel.titlePainter"));
        this.installProperty(jXTitledPanel, "titleForeground", UIManager.getColor("JXTitledPanel.titleForeground"));
        this.installProperty(jXTitledPanel, "titleFont", UIManager.getFont("JXTitledPanel.titleFont"));
        LookAndFeel.installProperty(jXTitledPanel, "opaque", false);
    }

    protected void uninstallDefaults(JXTitledPanel jXTitledPanel) {
    }

    protected void installComponents(JXTitledPanel jXTitledPanel) {
        this.topPanel.add((Component)this.caption, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, this.getCaptionInsets(), 0, 0));
        if (jXTitledPanel.getClientProperty("JXTitledPanel.rightDecoration") instanceof JComponent) {
            this.setRightDecoration((JComponent)jXTitledPanel.getClientProperty("JXTitledPanel.rightDecoration"));
        }
        if (jXTitledPanel.getClientProperty("JXTitledPanel.leftDecoration") instanceof JComponent) {
            this.setLeftDecoration((JComponent)jXTitledPanel.getClientProperty("JXTitledPanel.leftDecoration"));
        }
        if (!(jXTitledPanel.getLayout() instanceof BorderLayout)) {
            jXTitledPanel.setLayout(new BorderLayout());
        }
        jXTitledPanel.add((Component)this.topPanel, "North");
        if (SwingXUtilities.isUIInstallable(jXTitledPanel.getBorder())) {
            jXTitledPanel.setBorder(BorderUIResource.getRaisedBevelBorderUIResource());
        }
    }

    protected void uninstallComponents(JXTitledPanel jXTitledPanel) {
        jXTitledPanel.remove(this.topPanel);
    }

    protected Insets getCaptionInsets() {
        return UIManager.getInsets("JXTitledPanel.captionInsets");
    }

    protected JXPanel createAndConfigureTopPanel(JXTitledPanel jXTitledPanel) {
        JXPanel jXPanel = new JXPanel();
        jXPanel.setBackgroundPainter(jXTitledPanel.getTitlePainter());
        jXPanel.setBorder(BorderFactory.createEmptyBorder());
        jXPanel.setLayout(new GridBagLayout());
        jXPanel.setOpaque(false);
        return jXPanel;
    }

    protected JLabel createAndConfigureCaption(final JXTitledPanel jXTitledPanel) {
        JLabel jLabel = new JLabel(jXTitledPanel.getTitle()){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setForeground(jXTitledPanel.getTitleForeground());
                this.setFont(jXTitledPanel.getTitleFont());
            }
        };
        jLabel.setFont(jXTitledPanel.getTitleFont());
        jLabel.setForeground(jXTitledPanel.getTitleForeground());
        return jLabel;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        assert (jComponent instanceof JXTitledPanel);
        JXTitledPanel jXTitledPanel = (JXTitledPanel)jComponent;
        this.uninstallListeners(jXTitledPanel);
        this.topPanel.removeAll();
        jXTitledPanel.remove(this.topPanel);
        jXTitledPanel.putClientProperty("JXTitledPanel.leftDecoration", this.left);
        jXTitledPanel.putClientProperty("JXTitledPanel.rightDecoration", this.right);
        this.caption = null;
        this.topPanel = null;
        jXTitledPanel = null;
        this.left = null;
        this.right = null;
    }

    protected void installListeners(final JXTitledPanel jXTitledPanel) {
        this.titleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("title")) {
                    BasicTitledPanelUI.this.caption.setText((String)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("titleForeground")) {
                    BasicTitledPanelUI.this.caption.setForeground((Color)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("titleFont")) {
                    BasicTitledPanelUI.this.caption.setFont((Font)propertyChangeEvent.getNewValue());
                } else if ("titlePainter".equals(propertyChangeEvent.getPropertyName())) {
                    BasicTitledPanelUI.this.topPanel.setBackgroundPainter(jXTitledPanel.getTitlePainter());
                    BasicTitledPanelUI.this.topPanel.repaint();
                }
            }
        };
        jXTitledPanel.addPropertyChangeListener(this.titleChangeListener);
    }

    protected void uninstallListeners(JXTitledPanel jXTitledPanel) {
        jXTitledPanel.removePropertyChangeListener(this.titleChangeListener);
    }

    protected void installProperty(JComponent jComponent, String string, Object object) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(jComponent.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                Method method;
                Object object2;
                if (!propertyDescriptor.getName().equals(string) || (object2 = (method = propertyDescriptor.getReadMethod()).invoke((Object)jComponent, new Object[0])) != null && !(object2 instanceof UIResource)) continue;
                method = propertyDescriptor.getWriteMethod();
                method.invoke((Object)jComponent, object);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Failed to install property " + string, exception);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
    }

    @Override
    public void setRightDecoration(JComponent jComponent) {
        if (this.right != null) {
            this.topPanel.remove(this.right);
        }
        this.right = jComponent;
        if (this.right != null) {
            this.topPanel.add((Component)jComponent, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, UIManager.getInsets("JXTitledPanel.rightDecorationInsets"), 0, 0));
        }
    }

    @Override
    public JComponent getRightDecoration() {
        return this.right;
    }

    @Override
    public void setLeftDecoration(JComponent jComponent) {
        if (this.left != null) {
            this.topPanel.remove(this.left);
        }
        this.left = jComponent;
        if (this.left != null) {
            this.topPanel.add((Component)this.left, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, UIManager.getInsets("JXTitledPanel.leftDecorationInsets"), 0, 0));
        }
    }

    @Override
    public JComponent getLeftDecoration() {
        return this.left;
    }

    @Override
    public Container getTitleBar() {
        return this.topPanel;
    }
}

