/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.plaf.TipOfTheDayUI;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.tips.TipOfTheDayModel;

public class BasicTipOfTheDayUI
extends TipOfTheDayUI {
    protected JXTipOfTheDay tipPane;
    protected JPanel tipArea;
    protected Component currentTipComponent;
    protected Font tipFont;
    protected PropertyChangeListener changeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTipOfTheDayUI((JXTipOfTheDay)jComponent);
    }

    public BasicTipOfTheDayUI(JXTipOfTheDay jXTipOfTheDay) {
        this.tipPane = jXTipOfTheDay;
    }

    @Override
    public JDialog createDialog(Component component, JXTipOfTheDay.ShowOnStartupChoice showOnStartupChoice) {
        return this.createDialog(component, showOnStartupChoice, true);
    }

    protected JDialog createDialog(Component component, final JXTipOfTheDay.ShowOnStartupChoice showOnStartupChoice, boolean bl) {
        JButton jButton;
        JCheckBox jCheckBox;
        Locale locale = component == null ? null : component.getLocale();
        String string = UIManagerExt.getString("TipOfTheDay.dialogTitle", locale);
        Window window = component == null ? JOptionPane.getRootFrame() : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        final JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string, true) : new JDialog((Dialog)window, string, true);
        jDialog.getContentPane().setLayout(new BorderLayout(10, 10));
        jDialog.getContentPane().add((Component)this.tipPane, "Center");
        ((JComponent)jDialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jDialog.add("South", jPanel);
        if (showOnStartupChoice != null) {
            jCheckBox = new JCheckBox(UIManagerExt.getString("TipOfTheDay.showOnStartupText", locale), showOnStartupChoice.isShowingOnStartup());
            jPanel.add((Component)jCheckBox, "Center");
        } else {
            jCheckBox = null;
        }
        JPanel jPanel2 = new JPanel(new GridLayout(1, bl ? 3 : 2, 9, 0));
        jPanel.add((Component)jPanel2, "After");
        if (bl) {
            jButton = new JButton(UIManagerExt.getString("TipOfTheDay.previousTipText", locale));
            jPanel2.add(jButton);
            jButton.addActionListener(this.getActionMap().get("previousTip"));
        }
        jButton = new JButton(UIManagerExt.getString("TipOfTheDay.nextTipText", locale));
        jPanel2.add(jButton);
        jButton.addActionListener(this.getActionMap().get("nextTip"));
        JButton jButton2 = new JButton(UIManagerExt.getString("TipOfTheDay.closeText", locale));
        jPanel2.add(jButton2);
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (showOnStartupChoice != null) {
                    showOnStartupChoice.setShowingOnStartup(jCheckBox.isSelected());
                }
                jDialog.setVisible(false);
            }
        };
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                actionListener.actionPerformed(null);
            }
        });
        jDialog.getRootPane().setDefaultButton(jButton2);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                actionListener.actionPerformed(null);
            }
        });
        ((JComponent)jDialog.getContentPane()).registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        return jDialog;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults();
        this.installKeyboardActions();
        this.installComponents();
        this.installListeners();
        this.showCurrentTip();
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this.tipPane, actionMap);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("previousTip", new PreviousTipAction());
        actionMapUIResource.put("nextTip", new NextTipAction());
        return actionMapUIResource;
    }

    protected void installListeners() {
        this.changeListener = this.createChangeListener();
        this.tipPane.addPropertyChangeListener(this.changeListener);
    }

    protected PropertyChangeListener createChangeListener() {
        return new ChangeListener();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tipPane, "TipOfTheDay.background", "TipOfTheDay.foreground", "TipOfTheDay.font");
        LookAndFeel.installBorder(this.tipPane, "TipOfTheDay.border");
        LookAndFeel.installProperty(this.tipPane, "opaque", Boolean.TRUE);
        this.tipFont = UIManager.getFont("TipOfTheDay.tipFont");
    }

    protected void installComponents() {
        this.tipPane.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(UIManagerExt.getString("TipOfTheDay.didYouKnowText", this.tipPane.getLocale()));
        jLabel.setIcon(UIManager.getIcon("TipOfTheDay.icon"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(22, 15, 22, 15));
        this.tipPane.add("North", jLabel);
        this.tipArea = new JPanel(new BorderLayout(2, 2));
        this.tipArea.setOpaque(false);
        this.tipArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tipPane.add("Center", this.tipArea);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(420, 175);
    }

    protected void showCurrentTip() {
        int n2;
        if (this.currentTipComponent != null) {
            this.tipArea.remove(this.currentTipComponent);
        }
        if ((n2 = this.tipPane.getCurrentTip()) == -1) {
            JLabel jLabel = new JLabel();
            jLabel.setOpaque(true);
            jLabel.setBackground(UIManager.getColor("TextArea.background"));
            this.currentTipComponent = jLabel;
            this.tipArea.add("Center", this.currentTipComponent);
            return;
        }
        if (this.tipPane.getModel() == null || this.tipPane.getModel().getTipCount() == 0 || n2 < 0 && n2 >= this.tipPane.getModel().getTipCount()) {
            this.currentTipComponent = new JLabel();
        } else {
            TipOfTheDayModel.Tip tip = this.tipPane.getModel().getTipAt(n2);
            Object object = tip.getTip();
            if (object instanceof Component) {
                this.currentTipComponent = (Component)object;
            } else if (object instanceof Icon) {
                this.currentTipComponent = new JLabel((Icon)object);
            } else {
                String string;
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setBorder(null);
                jScrollPane.setOpaque(false);
                jScrollPane.getViewport().setOpaque(false);
                jScrollPane.setBorder(null);
                String string2 = string = object == null ? "" : object.toString();
                if (BasicHTML.isHTMLString(string)) {
                    JEditorPane jEditorPane = new JEditorPane("text/html", string);
                    jEditorPane.setFont(this.tipPane.getFont());
                    SwingXUtilities.setHtmlFont((HTMLDocument)jEditorPane.getDocument(), this.tipPane.getFont());
                    jEditorPane.setEditable(false);
                    jEditorPane.setBorder(null);
                    jEditorPane.setMargin(null);
                    jEditorPane.setOpaque(false);
                    jScrollPane.getViewport().setView(jEditorPane);
                } else {
                    JTextArea jTextArea = new JTextArea(string);
                    jTextArea.setFont(this.tipPane.getFont());
                    jTextArea.setEditable(false);
                    jTextArea.setLineWrap(true);
                    jTextArea.setWrapStyleWord(true);
                    jTextArea.setBorder(null);
                    jTextArea.setMargin(null);
                    jTextArea.setOpaque(false);
                    jScrollPane.getViewport().setView(jTextArea);
                }
                this.currentTipComponent = jScrollPane;
            }
        }
        this.tipArea.add("Center", this.currentTipComponent);
        this.tipArea.revalidate();
        this.tipArea.repaint();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(jComponent);
    }

    protected void uninstallListeners() {
        this.tipPane.removePropertyChangeListener(this.changeListener);
    }

    protected void uninstallComponents() {
    }

    protected void uninstallDefaults() {
    }

    class NextTipAction
    extends AbstractAction {
        public NextTipAction() {
            super("nextTip");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicTipOfTheDayUI.this.tipPane.nextTip();
        }

        @Override
        public boolean isEnabled() {
            return BasicTipOfTheDayUI.this.tipPane.isEnabled();
        }
    }

    class PreviousTipAction
    extends AbstractAction {
        public PreviousTipAction() {
            super("previousTip");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicTipOfTheDayUI.this.tipPane.previousTip();
        }

        @Override
        public boolean isEnabled() {
            return BasicTipOfTheDayUI.this.tipPane.isEnabled();
        }
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("currentTip".equals(propertyChangeEvent.getPropertyName())) {
                BasicTipOfTheDayUI.this.showCurrentTip();
            }
        }
    }
}

