/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class BasicTaskPaneUI
extends TaskPaneUI {
    private static FocusListener focusListener = new RepaintOnFocus();
    protected int titleHeight = 25;
    protected int roundHeight = 5;
    protected JXTaskPane group;
    protected boolean mouseOver;
    protected MouseInputListener mouseListener;
    protected PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.group = (JXTaskPane)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installProperty(this.group, "opaque", true);
        this.group.setBorder(this.createPaneBorder());
        ((JComponent)this.group.getContentPane()).setBorder(this.createContentPaneBorder());
        LookAndFeel.installColorsAndFont(this.group, "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
        LookAndFeel.installColorsAndFont((JComponent)this.group.getContentPane(), "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseInputListener();
        this.group.addMouseMotionListener(this.mouseListener);
        this.group.addMouseListener(this.mouseListener);
        this.group.addFocusListener(focusListener);
        this.propertyListener = this.createPropertyListener();
        this.group.addPropertyChangeListener(this.propertyListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        InputMap inputMap = (InputMap)UIManager.get("TaskPane.focusInputMap");
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.group, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.group, actionMap);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("toggleCollapsed", new ToggleCollapsedAction());
        return actionMapUIResource;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        super.uninstallUI(jComponent);
    }

    protected void uninstallListeners() {
        this.group.removeMouseListener(this.mouseListener);
        this.group.removeMouseMotionListener(this.mouseListener);
        this.group.removeFocusListener(focusListener);
        this.group.removePropertyChangeListener(this.propertyListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new ToggleListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new ChangeListener();
    }

    protected boolean isInBorder(MouseEvent mouseEvent) {
        return mouseEvent.getY() < this.getTitleHeight(mouseEvent.getComponent());
    }

    protected int getTitleHeight(Component component) {
        if (component instanceof JXTaskPane) {
            Icon icon;
            JXTaskPane jXTaskPane = (JXTaskPane)component;
            Font font = jXTaskPane.getFont();
            int n2 = this.titleHeight;
            if (font != null && !(font instanceof FontUIResource)) {
                n2 = Math.max(n2, jXTaskPane.getFontMetrics(font).getHeight());
            }
            if ((icon = jXTaskPane.getIcon()) != null) {
                n2 = Math.max(n2, icon.getIconHeight() + 4);
            }
            return n2;
        }
        return this.titleHeight;
    }

    protected Border createPaneBorder() {
        return new PaneBorder();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Component component = this.group.getComponent(0);
        if (!(component instanceof JXCollapsiblePane)) {
            return super.getPreferredSize(jComponent);
        }
        JXCollapsiblePane jXCollapsiblePane = (JXCollapsiblePane)component;
        Dimension dimension = jXCollapsiblePane.getPreferredSize();
        Border border = this.group.getBorder();
        if (border instanceof PaneBorder) {
            ((PaneBorder)border).label.setDisplayedMnemonic(this.group.getMnemonic());
            Dimension dimension2 = ((PaneBorder)border).getPreferredSize(this.group);
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
        } else {
            dimension.height += this.getTitleHeight(jComponent);
        }
        return dimension;
    }

    protected Border createContentPaneBorder() {
        Color color = UIManager.getColor("TaskPane.borderColor");
        return new CompoundBorder(new ContentPaneBorder(color), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    @Override
    public Component createAction(Action action) {
        JXHyperlink jXHyperlink = new JXHyperlink(action){

            @Override
            public void updateUI() {
                super.updateUI();
                BasicTaskPaneUI.this.configure(this);
            }
        };
        this.configure(jXHyperlink);
        return jXHyperlink;
    }

    protected void configure(JXHyperlink jXHyperlink) {
        jXHyperlink.setOpaque(false);
        jXHyperlink.setBorderPainted(false);
        jXHyperlink.setFocusPainted(true);
        jXHyperlink.setForeground(UIManager.getColor("TaskPane.titleForeground"));
    }

    protected void ensureVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicTaskPaneUI.this.group.scrollRectToVisible(new Rectangle(BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.group.getHeight()));
            }
        });
    }

    protected int getRoundHeight() {
        return this.roundHeight;
    }

    protected class PaneBorder
    implements Border,
    UIResource {
        protected Color borderColor = UIManager.getColor("TaskPane.borderColor");
        protected Color titleForeground = UIManager.getColor("TaskPane.titleForeground");
        protected Color specialTitleBackground = UIManager.getColor("TaskPane.specialTitleBackground");
        protected Color specialTitleForeground = UIManager.getColor("TaskPane.specialTitleForeground");
        protected Color titleBackgroundGradientStart = UIManager.getColor("TaskPane.titleBackgroundGradientStart");
        protected Color titleBackgroundGradientEnd = UIManager.getColor("TaskPane.titleBackgroundGradientEnd");
        protected Color titleOver = UIManager.getColor("TaskPane.titleOver");
        protected Color specialTitleOver;
        protected JLabel label;

        public PaneBorder() {
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = UIManager.getColor("TaskPane.specialTitleOver");
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.label.setIconTextGap(8);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(BasicTaskPaneUI.this.getTitleHeight(component), 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public Dimension getPreferredSize(JXTaskPane jXTaskPane) {
            this.configureLabel(jXTaskPane);
            Dimension dimension = this.label.getPreferredSize();
            dimension.width += 3;
            dimension.width += BasicTaskPaneUI.this.getTitleHeight(jXTaskPane);
            dimension.width += 3;
            dimension.height = BasicTaskPaneUI.this.getTitleHeight(jXTaskPane);
            return dimension;
        }

        protected void paintTitleBackground(JXTaskPane jXTaskPane, Graphics graphics) {
            if (jXTaskPane.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
            } else {
                graphics.setColor(this.titleBackgroundGradientStart);
            }
            graphics.fillRect(0, 0, jXTaskPane.getWidth(), BasicTaskPaneUI.this.getTitleHeight(jXTaskPane));
        }

        protected void paintTitle(JXTaskPane jXTaskPane, Graphics graphics, Color color, int n2, int n3, int n4, int n5) {
            this.configureLabel(jXTaskPane);
            this.label.setForeground(color);
            if (jXTaskPane.getFont() != null && !(jXTaskPane.getFont() instanceof FontUIResource)) {
                this.label.setFont(jXTaskPane.getFont());
            }
            graphics.translate(n2, n3);
            this.label.setBounds(0, 0, n4, n5);
            this.label.paint(graphics);
            graphics.translate(-n2, -n3);
        }

        protected void configureLabel(JXTaskPane jXTaskPane) {
            this.label.applyComponentOrientation(jXTaskPane.getComponentOrientation());
            this.label.setFont(jXTaskPane.getFont());
            this.label.setText(jXTaskPane.getTitle());
            this.label.setIcon(jXTaskPane.getIcon() == null ? new EmptyIcon() : jXTaskPane.getIcon());
        }

        protected void paintExpandedControls(JXTaskPane jXTaskPane, Graphics graphics, int n2, int n3, int n4, int n5) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(jXTaskPane, graphics, n2, n3, n4, n5);
            graphics.setColor(this.getPaintColor(jXTaskPane));
            this.paintChevronControls(jXTaskPane, graphics, n2, n3, n4, n5);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        protected Color getPaintColor(JXTaskPane jXTaskPane) {
            Color color = this.isMouseOverBorder() ? (BasicTaskPaneUI.this.mouseOver ? (jXTaskPane.isSpecial() ? this.specialTitleOver : this.titleOver) : (jXTaskPane.isSpecial() ? this.specialTitleForeground : (jXTaskPane.getForeground() == null || jXTaskPane.getForeground() instanceof ColorUIResource ? this.titleForeground : jXTaskPane.getForeground()))) : (jXTaskPane.isSpecial() ? this.specialTitleForeground : (jXTaskPane.getForeground() == null || jXTaskPane.getForeground() instanceof ColorUIResource ? this.titleForeground : jXTaskPane.getForeground()));
            return color;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JXTaskPane jXTaskPane = (JXTaskPane)component;
            int n6 = BasicTaskPaneUI.this.getTitleHeight(jXTaskPane) - 2 * BasicTaskPaneUI.this.getRoundHeight();
            int n7 = jXTaskPane.getWidth() - BasicTaskPaneUI.this.getTitleHeight(jXTaskPane);
            int n8 = BasicTaskPaneUI.this.getRoundHeight() - 1;
            int n9 = 3;
            int n10 = 0;
            int n11 = jXTaskPane.getWidth() - BasicTaskPaneUI.this.getTitleHeight(jXTaskPane) - 3;
            int n12 = BasicTaskPaneUI.this.getTitleHeight(jXTaskPane);
            if (!jXTaskPane.getComponentOrientation().isLeftToRight()) {
                n7 = jXTaskPane.getWidth() - n7 - n6;
                n9 = jXTaskPane.getWidth() - n9 - n11;
            }
            this.paintTitleBackground(jXTaskPane, graphics);
            this.paintExpandedControls(jXTaskPane, graphics, n7, n8, n6, n6);
            Color color = this.getPaintColor(jXTaskPane);
            if (jXTaskPane.hasFocus()) {
                this.paintFocus(graphics, color, 3, 3, n4 - 6, BasicTaskPaneUI.this.getTitleHeight(jXTaskPane) - 6);
            }
            this.paintTitle(jXTaskPane, graphics, color, n9, n10, n11, n12);
        }

        protected void paintRectAroundControls(JXTaskPane jXTaskPane, Graphics graphics, int n2, int n3, int n4, int n5, Color color, Color color2) {
            if (BasicTaskPaneUI.this.mouseOver) {
                int n6 = n2 + n4;
                int n7 = n3 + n5;
                graphics.setColor(color);
                graphics.drawLine(n2, n3, n6, n3);
                graphics.drawLine(n2, n3, n2, n7);
                graphics.setColor(color2);
                graphics.drawLine(n6, n3, n6, n7);
                graphics.drawLine(n2, n7, n6, n7);
            }
        }

        protected void paintOvalAroundControls(JXTaskPane jXTaskPane, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (jXTaskPane.isSpecial()) {
                graphics.setColor(this.specialTitleBackground.brighter());
                graphics.drawOval(n2, n3, n4, n5);
            } else {
                graphics.setColor(this.titleBackgroundGradientStart);
                graphics.fillOval(n2, n3, n4, n5);
                graphics.setColor(this.titleBackgroundGradientEnd.darker());
                graphics.drawOval(n2, n3, n4, n4);
            }
        }

        protected void paintChevronControls(JXTaskPane jXTaskPane, Graphics graphics, int n2, int n3, int n4, int n5) {
            ChevronIcon chevronIcon = jXTaskPane.isCollapsed() ? new ChevronIcon(false) : new ChevronIcon(true);
            int n6 = n2 + n4 / 2 - chevronIcon.getIconWidth() / 2;
            int n7 = n3 + (n5 / 2 - chevronIcon.getIconHeight());
            chevronIcon.paintIcon(jXTaskPane, graphics, n6, n7);
            chevronIcon.paintIcon(jXTaskPane, graphics, n6, n7 + chevronIcon.getIconHeight() + 1);
        }

        protected void paintFocus(Graphics graphics, Color color, int n2, int n3, int n4, int n5) {
            graphics.setColor(color);
            BasicGraphicsUtils.drawDashedRect(graphics, n2, n3, n4, n5);
        }

        protected boolean isMouseOverBorder() {
            return false;
        }
    }

    protected static class ContentPaneBorder
    implements Border,
    UIResource {
        Color color;

        public ContentPaneBorder(Color color) {
            this.color = color;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.setColor(this.color);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 1);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
            graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 1);
        }
    }

    protected static class ChevronIcon
    implements Icon {
        boolean up = true;

        public ChevronIcon(boolean bl) {
            this.up = bl;
        }

        @Override
        public int getIconHeight() {
            return 3;
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (this.up) {
                graphics.drawLine(n2 + 3, n3, n2, n3 + 3);
                graphics.drawLine(n2 + 3, n3, n2 + 6, n3 + 3);
            } else {
                graphics.drawLine(n2, n3, n2 + 3, n3 + 3);
                graphics.drawLine(n2 + 3, n3 + 3, n2 + 6, n3);
            }
        }
    }

    class ToggleCollapsedAction
    extends AbstractAction {
        private static final long serialVersionUID = 5676859881615358815L;

        public ToggleCollapsedAction() {
            super("toggleCollapsed");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicTaskPaneUI.this.group.setCollapsed(!BasicTaskPaneUI.this.group.isCollapsed());
        }

        @Override
        public boolean isEnabled() {
            return BasicTaskPaneUI.this.group.isVisible();
        }
    }

    class ToggleListener
    extends MouseInputAdapter {
        ToggleListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (BasicTaskPaneUI.this.isInBorder(mouseEvent)) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BasicTaskPaneUI.this.mouseOver = false;
                BasicTaskPaneUI.this.group.repaint(0, 0, BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.getTitleHeight(BasicTaskPaneUI.this.group));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(null);
            BasicTaskPaneUI.this.mouseOver = false;
            BasicTaskPaneUI.this.group.repaint(0, 0, BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.getTitleHeight(BasicTaskPaneUI.this.group));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (BasicTaskPaneUI.this.isInBorder(mouseEvent)) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                BasicTaskPaneUI.this.mouseOver = true;
            } else {
                mouseEvent.getComponent().setCursor(null);
                BasicTaskPaneUI.this.mouseOver = false;
            }
            BasicTaskPaneUI.this.group.repaint(0, 0, BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.getTitleHeight(BasicTaskPaneUI.this.group));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicTaskPaneUI.this.isInBorder(mouseEvent)) {
                BasicTaskPaneUI.this.group.setCollapsed(!BasicTaskPaneUI.this.group.isCollapsed());
            }
        }
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("collapsed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !BasicTaskPaneUI.this.group.isAnimated() || "animationState".equals(propertyChangeEvent.getPropertyName()) && "expanded".equals(propertyChangeEvent.getNewValue())) {
                if (BasicTaskPaneUI.this.group.isScrollOnExpand()) {
                    BasicTaskPaneUI.this.ensureVisible();
                }
            } else if ("icon".equals(propertyChangeEvent.getPropertyName()) || "title".equals(propertyChangeEvent.getPropertyName()) || "special".equals(propertyChangeEvent.getPropertyName())) {
                BasicTaskPaneUI.this.group.repaint();
            } else if ("mnemonic".equals(propertyChangeEvent.getPropertyName())) {
                SwingXUtilities.updateMnemonicBinding(BasicTaskPaneUI.this.group, "toggleCollapsed");
                Border border = BasicTaskPaneUI.this.group.getBorder();
                if (border instanceof PaneBorder) {
                    int n2 = (Integer)propertyChangeEvent.getNewValue();
                    ((PaneBorder)border).label.setDisplayedMnemonic(n2);
                }
            }
        }
    }

    static class RepaintOnFocus
    implements FocusListener {
        RepaintOnFocus() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }
    }
}

