/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.MonthViewUI;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicCalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.BasicCalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.CalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;

public class BasicMonthViewUI
extends MonthViewUI {
    private static final Logger LOG = Logger.getLogger(BasicMonthViewUI.class.getName());
    private static final int CALENDAR_SPACING = 10;
    public static final int MONTH_DOWN = 1;
    public static final int MONTH_UP = 2;
    protected static final int WEEK_HEADER_COLUMN = 0;
    protected static final int DAYS_IN_WEEK = 7;
    protected static final int FIRST_DAY_COLUMN = 1;
    protected static final int LAST_DAY_COLUMN = 7;
    protected static final int DAY_HEADER_ROW = 0;
    protected static final int WEEKS_IN_MONTH = 6;
    protected static final int FIRST_WEEK_ROW = 1;
    protected static final int LAST_WEEK_ROW = 6;
    @Deprecated
    protected String[] monthsOfTheYear;
    protected JXMonthView monthView;
    private PropertyChangeListener propertyChangeListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private Handler handler;
    private Date lastDisplayedDate;
    private boolean usingKeyboard = false;
    private Date pivotDate = null;
    private SortedSet<Date> originalDateSpan;
    protected boolean isLeftToRight;
    protected Icon monthUpImage;
    protected Icon monthDownImage;
    private int arrowPaddingX = 3;
    private int arrowPaddingY = 3;
    private int fullMonthBoxHeight;
    private int fullBoxWidth;
    private int fullBoxHeight;
    private int calendarWidth;
    private int calendarHeight;
    private int fullCalendarHeight;
    private int fullCalendarWidth;
    private int calendarRowCount = 1;
    private int calendarColumnCount = 1;
    protected Rectangle calendarGrid = new Rectangle();
    private String[] daysOfTheWeek;
    private CalendarRenderingHandler renderingHandler;
    private CellRendererPane rendererPane;
    private CalendarHeaderHandler calendarHeaderHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMonthViewUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.monthView = (JXMonthView)jComponent;
        this.monthView.setLayout(this.createLayoutManager());
        this.installRenderingHandler();
        this.installDefaults();
        this.installDelegate();
        this.installKeyboardActions();
        this.installComponents();
        this.updateLocale(false);
        this.updateZoomable();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallRenderingHandler();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.monthView.setLayout(null);
        this.monthView = null;
    }

    protected void installComponents() {
        this.setCalendarHeaderHandler(this.createCalendarHeaderHandler());
        this.getCalendarHeaderHandler().install(this.monthView);
    }

    protected void uninstallComponents() {
        this.getCalendarHeaderHandler().uninstall(this.monthView);
        this.setCalendarHeaderHandler(null);
    }

    protected void installDefaults() {
        LookAndFeel.installProperty(this.monthView, "opaque", Boolean.TRUE);
        if (SwingXUtilities.isUIInstallable(this.monthView.getBackground())) {
            this.monthView.setBackground(UIManagerExt.getColor("JXMonthView.background"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getForeground())) {
            this.monthView.setForeground(UIManagerExt.getColor("JXMonthView.foreground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getFont())) {
            this.monthView.setFont(UIManager.getFont("JXMonthView.font"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getMonthStringBackground())) {
            this.monthView.setMonthStringBackground(UIManagerExt.getColor("JXMonthView.monthStringBackground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getMonthStringForeground())) {
            this.monthView.setMonthStringForeground(UIManagerExt.getColor("JXMonthView.monthStringForeground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getDaysOfTheWeekForeground())) {
            this.monthView.setDaysOfTheWeekForeground(UIManagerExt.getColor("JXMonthView.daysOfTheWeekForeground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getSelectionBackground())) {
            this.monthView.setSelectionBackground(UIManagerExt.getColor("JXMonthView.selectedBackground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getSelectionForeground())) {
            this.monthView.setSelectionForeground(UIManagerExt.getColor("JXMonthView.selectedForeground"));
        }
        if (SwingXUtilities.isUIInstallable(this.monthView.getFlaggedDayForeground())) {
            this.monthView.setFlaggedDayForeground(UIManagerExt.getColor("JXMonthView.flaggedDayForeground"));
        }
        this.monthView.setBoxPaddingX(UIManagerExt.getInt("JXMonthView.boxPaddingX"));
        this.monthView.setBoxPaddingY(UIManagerExt.getInt("JXMonthView.boxPaddingY"));
    }

    protected void installDelegate() {
        this.isLeftToRight = this.monthView.getComponentOrientation().isLeftToRight();
        this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
        this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        this.setFirstDisplayedDay(this.monthView.getFirstDisplayedDay());
    }

    @Deprecated
    protected boolean isUIInstallable(Object object) {
        return object == null || object instanceof UIResource;
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        this.installKeyBindings(1);
        ActionMap actionMap = this.monthView.getActionMap();
        KeyboardAction keyboardAction = new KeyboardAction(0);
        actionMap.put("acceptSelection", keyboardAction);
        KeyboardAction keyboardAction2 = new KeyboardAction(1);
        actionMap.put("cancelSelection", keyboardAction2);
        actionMap.put("selectPreviousDay", new KeyboardAction(2));
        actionMap.put("selectNextDay", new KeyboardAction(3));
        actionMap.put("selectDayInPreviousWeek", new KeyboardAction(4));
        actionMap.put("selectDayInNextWeek", new KeyboardAction(5));
        actionMap.put("adjustSelectionPreviousDay", new KeyboardAction(6));
        actionMap.put("adjustSelectionNextDay", new KeyboardAction(7));
        actionMap.put("adjustSelectionPreviousWeek", new KeyboardAction(8));
        actionMap.put("adjustSelectionNextWeek", new KeyboardAction(9));
        actionMap.put("monthViewCommit", keyboardAction);
        actionMap.put("monthViewCancel", keyboardAction2);
        AbstractActionExt abstractActionExt = new AbstractActionExt(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicMonthViewUI.this.previousMonth();
            }
        };
        this.monthView.getActionMap().put("scrollToPreviousMonth", abstractActionExt);
        AbstractActionExt abstractActionExt2 = new AbstractActionExt(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicMonthViewUI.this.nextMonth();
            }
        };
        this.monthView.getActionMap().put("scrollToNextMonth", abstractActionExt2);
    }

    private void installKeyBindings(int n2) {
        InputMap inputMap = this.monthView.getInputMap(n2);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "adjustSelectionPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "adjustSelectionNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "adjustSelectionPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "adjustSelectionNextWeek");
    }

    private void uninstallKeyBindings(int n2) {
        InputMap inputMap = this.monthView.getInputMap(n2);
        inputMap.clear();
    }

    protected void uninstallKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.monthView.addPropertyChangeListener(this.propertyChangeListener);
        this.monthView.addMouseListener(this.mouseListener);
        this.monthView.addMouseMotionListener(this.mouseMotionListener);
        this.monthView.getSelectionModel().addDateSelectionListener(this.getHandler());
    }

    protected void uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.getHandler());
        this.monthView.removeMouseMotionListener(this.mouseMotionListener);
        this.monthView.removeMouseListener(this.mouseListener);
        this.monthView.removePropertyChangeListener(this.propertyChangeListener);
        this.mouseMotionListener = null;
        this.mouseListener = null;
        this.propertyChangeListener = null;
    }

    protected void installRenderingHandler() {
        this.setRenderingHandler(this.createRenderingHandler());
        if (this.getRenderingHandler() != null) {
            this.rendererPane = new CellRendererPane();
            this.monthView.add(this.rendererPane);
        }
    }

    protected void uninstallRenderingHandler() {
        if (this.getRenderingHandler() == null) {
            return;
        }
        this.monthView.remove(this.rendererPane);
        this.rendererPane = null;
        this.setRenderingHandler(null);
    }

    protected CalendarRenderingHandler createRenderingHandler() {
        return new RenderingHandler();
    }

    protected void setRenderingHandler(CalendarRenderingHandler calendarRenderingHandler) {
        this.renderingHandler = calendarRenderingHandler;
    }

    protected CalendarRenderingHandler getRenderingHandler() {
        return this.renderingHandler;
    }

    protected void updateComponentInputMap() {
        if (this.monthView.isComponentInputMapEnabled()) {
            this.installKeyBindings(2);
        } else {
            this.uninstallKeyBindings(2);
        }
    }

    protected void updateLocale(boolean bl) {
        Locale locale = this.monthView.getLocale();
        if (this.getRenderingHandler() != null) {
            this.getRenderingHandler().setLocale(locale);
        }
        this.monthsOfTheYear = new DateFormatSymbols(locale).getMonths();
        this.daysOfTheWeek = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (this.daysOfTheWeek == null) {
            this.daysOfTheWeek = new String[7];
            String[] stringArray = new DateFormatSymbols(locale).getShortWeekdays();
            this.daysOfTheWeek = new String[7];
            for (int i2 = 1; i2 <= 7; ++i2) {
                this.daysOfTheWeek[i2 - 1] = stringArray[i2];
            }
        }
        if (bl) {
            this.monthView.invalidate();
            this.monthView.validate();
        }
    }

    @Override
    public String[] getDaysOfTheWeek() {
        String[] stringArray = new String[this.daysOfTheWeek.length];
        System.arraycopy(this.daysOfTheWeek, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public boolean isUsingKeyboard() {
        return this.usingKeyboard;
    }

    public void setUsingKeyboard(boolean bl) {
        this.usingKeyboard = bl;
    }

    protected Rectangle getDayBoundsAtLocation(int n2, int n3) {
        Rectangle rectangle = this.getMonthDetailsBoundsAtLocation(n2, n3);
        if (rectangle == null || !rectangle.contains(n2, n3)) {
            return null;
        }
        int n4 = (n3 - rectangle.y) / this.fullBoxHeight;
        int n5 = (n2 - rectangle.x) / this.fullBoxWidth;
        return new Rectangle(rectangle.x + n5 * this.fullBoxWidth, rectangle.y + n4 * this.fullBoxHeight, this.fullBoxWidth, this.fullBoxHeight);
    }

    protected Rectangle getDayBoundsInMonth(Date date, int n2, int n3) {
        this.checkValidRow(n2, n3);
        if (0 == n3 && !this.monthView.isShowingWeekNumber()) {
            return null;
        }
        Rectangle rectangle = this.getMonthBounds(date);
        if (rectangle == null) {
            return null;
        }
        rectangle.y += this.getMonthHeaderHeight() + (n2 - 0) * this.fullBoxHeight;
        int n4 = n3 - 1;
        if (this.monthView.isShowingWeekNumber()) {
            ++n4;
        }
        if (this.isLeftToRight) {
            rectangle.x += n4 * this.fullBoxWidth;
        } else {
            int n5 = rectangle.x + rectangle.width - this.fullBoxWidth;
            rectangle.x = n5 - n4 * this.fullBoxWidth;
        }
        rectangle.width = this.fullBoxWidth;
        rectangle.height = this.fullBoxHeight;
        return rectangle;
    }

    protected Point getDayGridPositionAtLocation(int n2, int n3) {
        Rectangle rectangle = this.getMonthDetailsBoundsAtLocation(n2, n3);
        if (rectangle == null || !rectangle.contains(n2, n3)) {
            return null;
        }
        int n4 = (n3 - rectangle.y) / this.fullBoxHeight + 0;
        int n5 = (n2 - rectangle.x) / this.fullBoxWidth;
        int n6 = n5 + 1;
        if (!this.isLeftToRight) {
            int n7 = rectangle.x + rectangle.width;
            n6 = (n7 - n2) / this.fullBoxWidth + 1;
        }
        if (this.monthView.isShowingWeekNumber()) {
            --n6;
        }
        return new Point(n6, n4);
    }

    protected Date getDayInMonth(Date date, int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        Calendar calendar = this.getCalendar(date);
        int n4 = calendar.get(2);
        if (!CalendarUtils.isStartOfMonth(calendar)) {
            throw new IllegalStateException("calendar must be start of month but was: " + date.getTime());
        }
        CalendarUtils.startOfWeek(calendar);
        calendar.add(5, (n2 - 1) * 7 + (n3 - 1));
        if (calendar.get(2) == n4) {
            return calendar.getTime();
        }
        return null;
    }

    protected Point getDayGridPosition(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Calendar calendar = this.getCalendar(date);
        Date date2 = CalendarUtils.startOfDay(calendar, date);
        CalendarUtils.startOfWeek(calendar);
        int n2 = 1;
        while (calendar.getTime().before(date2)) {
            ++n2;
            calendar.add(5, 1);
        }
        Date date3 = CalendarUtils.startOfWeek(calendar, date);
        calendar.setTime(date);
        CalendarUtils.startOfMonth(calendar);
        int n3 = 1;
        while (calendar.getTime().before(date3)) {
            ++n3;
            calendar.add(3, 1);
        }
        return new Point(n2, n3);
    }

    @Override
    public Date getDayAtLocation(int n2, int n3) {
        Point point = this.getDayGridPositionAtLocation(n2, n3);
        if (point == null || point.x == 0 || point.y == 0) {
            return null;
        }
        Date date = this.getMonthAtLocation(n2, n3);
        return this.getDayInMonth(date, point.y, point.x);
    }

    protected Rectangle getDayBounds(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Point point = this.getDayGridPosition(date);
        Rectangle rectangle = this.getMonthBounds(date);
        rectangle.y += this.getMonthHeaderHeight() + (point.y - 0) * this.fullBoxHeight;
        if (this.monthView.isShowingWeekNumber()) {
            ++point.x;
        }
        --point.x;
        if (this.isLeftToRight) {
            rectangle.x += point.x * this.fullBoxWidth;
        } else {
            int n2 = rectangle.x + rectangle.width - this.fullBoxWidth;
            rectangle.x = n2 - point.x * this.fullBoxWidth;
        }
        rectangle.width = this.fullBoxWidth;
        rectangle.height = this.fullBoxHeight;
        return rectangle;
    }

    private void checkValidRow(int n2, int n3) {
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("illegal column in day grid " + n3);
        }
        if (n2 < 0 || n2 > 6) {
            throw new IllegalArgumentException("illegal row in day grid" + n2);
        }
    }

    private boolean isVisible(Date date) {
        return !this.getFirstDisplayedDay().after(date) && !this.getLastDisplayedDay().before(date);
    }

    protected int getTraversableGridPositionAtLocation(int n2, int n3) {
        Rectangle rectangle = this.getMonthHeaderBoundsAtLocation(n2, n3);
        if (rectangle == null) {
            return -1;
        }
        if (n3 < rectangle.y + this.arrowPaddingY) {
            return -1;
        }
        if (n3 > rectangle.y + rectangle.height - this.arrowPaddingY) {
            return -1;
        }
        rectangle.setBounds(rectangle.x + this.arrowPaddingX, n3, rectangle.width - 2 * this.arrowPaddingX, rectangle.height);
        if (!rectangle.contains(n2, n3)) {
            return -1;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, this.monthUpImage.getIconWidth(), this.monthUpImage.getIconHeight());
        if (rectangle2.contains(n2, n3)) {
            return this.isLeftToRight ? 1 : 2;
        }
        rectangle2.translate(rectangle.width - this.monthUpImage.getIconWidth(), 0);
        if (rectangle2.contains(n2, n3)) {
            return this.isLeftToRight ? 2 : 1;
        }
        return -1;
    }

    protected Rectangle getMonthHeaderBoundsAtLocation(int n2, int n3) {
        Rectangle rectangle = this.getMonthBoundsAtLocation(n2, n3);
        if (rectangle == null) {
            return null;
        }
        rectangle.height = this.getMonthHeaderHeight();
        return rectangle;
    }

    protected Rectangle getMonthDetailsBoundsAtLocation(int n2, int n3) {
        Rectangle rectangle = this.getMonthBoundsAtLocation(n2, n3);
        if (rectangle == null) {
            return null;
        }
        int n4 = rectangle.y + this.getMonthHeaderHeight();
        if (n3 < n4) {
            return null;
        }
        rectangle.y = n4;
        rectangle.height -= this.getMonthHeaderHeight();
        return rectangle;
    }

    protected Rectangle getMonthBoundsAtLocation(int n2, int n3) {
        if (!this.calendarGrid.contains(n2, n3)) {
            return null;
        }
        int n4 = (n3 - this.calendarGrid.y) / this.fullCalendarHeight;
        int n5 = (n2 - this.calendarGrid.x) / this.fullCalendarWidth;
        return new Rectangle(this.calendarGrid.x + n5 * this.fullCalendarWidth, this.calendarGrid.y + n4 * this.fullCalendarHeight, this.calendarWidth, this.calendarHeight);
    }

    protected Point getMonthGridPositionAtLocation(int n2, int n3) {
        if (!this.calendarGrid.contains(n2, n3)) {
            return null;
        }
        int n4 = (n3 - this.calendarGrid.y) / this.fullCalendarHeight;
        int n5 = (n2 - this.calendarGrid.x) / this.fullCalendarWidth;
        if (!this.isLeftToRight) {
            int n6 = this.calendarGrid.x + this.calendarGrid.width;
            n5 = (n6 - n2) / this.fullCalendarWidth;
        }
        return new Point(n5, n4);
    }

    protected Date getMonthAtLocation(int n2, int n3) {
        Point point = this.getMonthGridPositionAtLocation(n2, n3);
        if (point == null) {
            return null;
        }
        return this.getMonth(point.y, point.x);
    }

    protected Date getMonth(int n2, int n3) {
        Calendar calendar = this.getCalendar();
        calendar.add(2, n2 * this.calendarColumnCount + n3);
        return calendar.getTime();
    }

    protected Point getMonthGridPosition(Date date) {
        if (!this.isVisible(date)) {
            return null;
        }
        Calendar calendar = this.getCalendar();
        int n2 = calendar.get(2);
        int n3 = calendar.get(1);
        calendar.setTime(date);
        int n4 = calendar.get(2);
        int n5 = calendar.get(1);
        int n6 = n4 - n2 + (n5 - n3) * 12;
        int n7 = n6 / this.calendarColumnCount;
        int n8 = n6 % this.calendarColumnCount;
        return new Point(n8, n7);
    }

    protected Rectangle getMonthBounds(int n2, int n3) {
        int n4 = this.calendarGrid.y + n2 * this.fullCalendarHeight;
        int n5 = this.calendarGrid.x + n3 * this.fullCalendarWidth;
        if (!this.isLeftToRight) {
            n5 = this.calendarGrid.x + (this.calendarColumnCount - 1 - n3) * this.fullCalendarWidth;
        }
        return new Rectangle(n5, n4, this.calendarWidth, this.calendarHeight);
    }

    protected Rectangle getMonthBounds(Date date) {
        Point point = this.getMonthGridPosition(date);
        return point != null ? this.getMonthBounds(point.y, point.x) : null;
    }

    protected Rectangle getMonthHeaderBounds(Date date, boolean bl) {
        Point point = this.getMonthGridPosition(date);
        if (point == null) {
            return null;
        }
        Rectangle rectangle = this.getMonthBounds(point.y, point.x);
        rectangle.height = this.getMonthHeaderHeight();
        if (!bl) {
            // empty if block
        }
        return rectangle;
    }

    protected Dimension getMonthSize() {
        return new Dimension(this.calendarWidth, this.calendarHeight);
    }

    protected Dimension getDaySize() {
        return new Dimension(this.fullBoxWidth, this.fullBoxHeight);
    }

    protected int getMonthHeaderHeight() {
        return this.fullMonthBoxHeight;
    }

    private void calculateMonthGridLayoutProperties() {
        this.calculateMonthGridRowColumnCount();
        this.calculateMonthGridBounds();
    }

    private void calculateMonthGridBounds() {
        this.calendarGrid.setBounds(this.calculateCalendarGridX(), this.calculateCalendarGridY(), this.calculateCalendarGridWidth(), this.calculateCalendarGridHeight());
    }

    private int calculateCalendarGridY() {
        return (this.monthView.getHeight() - this.calculateCalendarGridHeight()) / 2;
    }

    private int calculateCalendarGridX() {
        return (this.monthView.getWidth() - this.calculateCalendarGridWidth()) / 2;
    }

    private int calculateCalendarGridHeight() {
        return this.calendarHeight * this.calendarRowCount + 10 * (this.calendarRowCount - 1);
    }

    private int calculateCalendarGridWidth() {
        return this.calendarWidth * this.calendarColumnCount + 10 * (this.calendarColumnCount - 1);
    }

    private void calculateMonthGridRowColumnCount() {
        int n2 = this.calendarColumnCount;
        int n3 = this.calendarRowCount;
        this.calendarRowCount = 1;
        this.calendarColumnCount = 1;
        if (!this.isZoomable()) {
            int n4;
            int n5 = (this.monthView.getWidth() - this.calendarWidth) / (this.calendarWidth + 10);
            if (n5 > 0) {
                this.calendarColumnCount += n5;
            }
            if ((n4 = (this.monthView.getHeight() - this.calendarHeight) / (this.calendarHeight + 10)) > 0) {
                this.calendarRowCount += n4;
            }
        }
        if (n2 != this.calendarColumnCount || n3 != this.calendarRowCount) {
            this.updateLastDisplayedDay(this.getFirstDisplayedDay());
        }
    }

    protected boolean isZoomable() {
        return this.monthView.isZoomable();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics);
        this.paint(graphics, jComponent);
    }

    protected void paintBackground(Graphics graphics) {
        if (this.monthView.isOpaque()) {
            graphics.setColor(this.monthView.getBackground());
            graphics.fillRect(0, 0, this.monthView.getWidth(), this.monthView.getHeight());
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Calendar calendar = this.getCalendar();
        for (int i2 = 0; i2 < this.calendarRowCount; ++i2) {
            for (int i3 = 0; i3 < this.calendarColumnCount; ++i3) {
                Rectangle rectangle2 = this.getMonthBounds(i2, i3);
                if (rectangle2.intersects(rectangle)) {
                    this.paintMonth(graphics, calendar);
                }
                calendar.add(2, 1);
            }
        }
    }

    protected void paintMonth(Graphics graphics, Calendar calendar) {
        this.paintMonthHeader(graphics, calendar);
        this.paintDayHeader(graphics, calendar);
        this.paintWeekHeader(graphics, calendar);
        this.paintDays(graphics, calendar);
    }

    protected void paintMonthHeader(Graphics graphics, Calendar calendar) {
        Rectangle rectangle = this.getMonthHeaderBounds(calendar.getTime(), false);
        this.paintDayOfMonth(graphics, rectangle, calendar, CalendarState.TITLE);
    }

    protected void paintDayHeader(Graphics graphics, Calendar calendar) {
        this.paintDaysOfWeekSeparator(graphics, calendar);
        Calendar calendar2 = (Calendar)calendar.clone();
        CalendarUtils.startOfWeek(calendar2);
        for (int i2 = 1; i2 <= 7; ++i2) {
            Rectangle rectangle = this.getDayBoundsInMonth(calendar.getTime(), 0, i2);
            this.paintDayOfMonth(graphics, rectangle, calendar2, CalendarState.DAY_OF_WEEK);
            calendar2.add(5, 1);
        }
    }

    protected void paintWeekHeader(Graphics graphics, Calendar calendar) {
        if (!this.monthView.isShowingWeekNumber()) {
            return;
        }
        this.paintWeekOfYearSeparator(graphics, calendar);
        int n2 = this.getWeeks(calendar);
        Calendar calendar2 = (Calendar)calendar.clone();
        for (int i2 = 1; i2 < 1 + n2; ++i2) {
            Rectangle rectangle = this.getDayBoundsInMonth(calendar.getTime(), i2, 0);
            this.paintDayOfMonth(graphics, rectangle, calendar2, CalendarState.WEEK_OF_YEAR);
            calendar2.add(3, 1);
        }
    }

    protected void paintDays(Graphics graphics, Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        CalendarUtils.startOfMonth(calendar2);
        Date date = calendar2.getTime();
        CalendarUtils.endOfMonth(calendar2);
        Date date2 = calendar2.getTime();
        calendar2.setTime(calendar.getTime());
        calendar2.setTime(calendar.getTime());
        CalendarUtils.startOfWeek(calendar2);
        for (int i2 = 1; i2 <= 6; ++i2) {
            for (int i3 = 1; i3 <= 7; ++i3) {
                CalendarState calendarState = null;
                if (calendar2.getTime().before(date)) {
                    if (this.monthView.isShowingLeadingDays()) {
                        calendarState = CalendarState.LEADING;
                    }
                } else if (calendar2.getTime().after(date2)) {
                    if (this.monthView.isShowingTrailingDays()) {
                        calendarState = CalendarState.TRAILING;
                    }
                } else {
                    CalendarState calendarState2 = calendarState = this.isToday(calendar2.getTime()) ? CalendarState.TODAY : CalendarState.IN_MONTH;
                }
                if (calendarState != null) {
                    Rectangle rectangle = this.getDayBoundsInMonth(date, i2, i3);
                    this.paintDayOfMonth(graphics, rectangle, calendar2, calendarState);
                }
                calendar2.add(5, 1);
            }
        }
    }

    protected void paintDayOfMonth(Graphics graphics, Rectangle rectangle, Calendar calendar, CalendarState calendarState) {
        JComponent jComponent = this.getRenderingHandler().prepareRenderingComponent(this.monthView, calendar, calendarState);
        this.rendererPane.paintComponent(graphics, jComponent, this.monthView, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    protected void paintWeekOfYearSeparator(Graphics graphics, Calendar calendar) {
        Rectangle rectangle = this.getSeparatorBounds(calendar, 1, 0);
        if (rectangle == null) {
            return;
        }
        graphics.setColor(this.monthView.getForeground());
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
    }

    protected void paintDaysOfWeekSeparator(Graphics graphics, Calendar calendar) {
        Rectangle rectangle = this.getSeparatorBounds(calendar, 0, 1);
        if (rectangle == null) {
            return;
        }
        graphics.setColor(this.monthView.getForeground());
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
    }

    private Rectangle getSeparatorBounds(Calendar calendar, int n2, int n3) {
        Rectangle rectangle = this.getDayBoundsInMonth(calendar.getTime(), n2, n3);
        if (rectangle == null) {
            return null;
        }
        if (n3 == 0) {
            rectangle.height *= 6;
            if (this.isLeftToRight) {
                rectangle.x += rectangle.width - 1;
            }
            rectangle.width = 1;
        } else if (n2 == 0) {
            int n4 = rectangle.width;
            rectangle.width *= 7;
            if (!this.isLeftToRight) {
                rectangle.x -= rectangle.width - n4;
            }
            rectangle.y += rectangle.height - 1;
            rectangle.height = 1;
        }
        return rectangle;
    }

    protected int getWeeks(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        CalendarUtils.endOfMonth(calendar2);
        Date date = calendar2.getTime();
        calendar2.setTime(calendar.getTime());
        CalendarUtils.startOfWeek(calendar2);
        int n2 = 0;
        while (date.after(calendar2.getTime())) {
            ++n2;
            calendar2.add(4, 1);
        }
        return n2;
    }

    private void traverseMonth(int n2) {
        if (n2 == 1) {
            this.previousMonth();
        } else if (n2 == 2) {
            this.nextMonth();
        }
    }

    private void nextMonth() {
        Date date = this.monthView.getUpperBound();
        if (date == null || date.after(this.getLastDisplayedDay())) {
            Calendar calendar = this.getCalendar();
            calendar.add(2, 1);
            this.monthView.setFirstDisplayedDay(calendar.getTime());
        }
    }

    private void previousMonth() {
        Date date = this.monthView.getLowerBound();
        if (date == null || date.before(this.getFirstDisplayedDay())) {
            Calendar calendar = this.getCalendar();
            calendar.add(2, -1);
            this.monthView.setFirstDisplayedDay(calendar.getTime());
        }
    }

    protected Calendar getCalendar() {
        return this.getCalendar(this.getFirstDisplayedDay());
    }

    protected Calendar getCalendar(Date date) {
        Calendar calendar = this.monthView.getCalendar();
        calendar.setTime(date);
        return calendar;
    }

    private void updateLastDisplayedDay(Date date) {
        Calendar calendar = this.getCalendar(date);
        calendar.add(2, this.calendarColumnCount * this.calendarRowCount - 1);
        CalendarUtils.endOfMonth(calendar);
        this.lastDisplayedDate = calendar.getTime();
    }

    @Override
    public Date getLastDisplayedDay() {
        return this.lastDisplayedDate;
    }

    protected void setFirstDisplayedDay(Date date) {
        this.updateLastDisplayedDay(date);
    }

    protected Date getFirstDisplayedDay() {
        return this.monthView.getFirstDisplayedDay();
    }

    protected int getFirstDisplayedMonth() {
        return this.getCalendar().get(2);
    }

    protected int getFirstDisplayedYear() {
        return this.getCalendar().get(1);
    }

    protected SortedSet<Date> getSelection() {
        return this.monthView.getSelection();
    }

    protected Date getToday() {
        return this.monthView.getToday();
    }

    protected boolean isToday(Date date) {
        return date.equals(this.getToday());
    }

    private boolean canSelectByMode() {
        return true;
    }

    protected void updateZoomable() {
        if (this.monthView.isZoomable()) {
            this.monthView.add(this.getCalendarHeaderHandler().getHeaderComponent());
        } else {
            this.monthView.remove(this.getCalendarHeaderHandler().getHeaderComponent());
        }
        this.monthView.revalidate();
        this.monthView.repaint();
    }

    protected CalendarHeaderHandler createCalendarHeaderHandler() {
        CalendarHeaderHandler calendarHeaderHandler = this.getHeaderFromUIManager();
        return calendarHeaderHandler != null ? calendarHeaderHandler : new BasicCalendarHeaderHandler();
    }

    protected CalendarHeaderHandler getHeaderFromUIManager() {
        Object object = UIManager.get("CalendarHeaderHandler");
        if (object instanceof String) {
            return this.instantiateClass((String)object);
        }
        return null;
    }

    private CalendarHeaderHandler instantiateClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            return this.instantiateClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    private CalendarHeaderHandler instantiateClass(Class<?> clazz) {
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (SecurityException securityException) {
            LOG.finer("cant instantiate CalendarHeaderHandler (security) " + clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.finer("cant instantiate CalendarHeaderHandler (missing parameterless constructo?)" + clazz);
        }
        if (constructor != null) {
            try {
                return (CalendarHeaderHandler)constructor.newInstance(new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.finer("cant instantiate CalendarHeaderHandler (missing parameterless constructo?)" + clazz);
            }
            catch (InstantiationException instantiationException) {
                LOG.finer("cant instantiate CalendarHeaderHandler (not instantiable) " + clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOG.finer("cant instantiate CalendarHeaderHandler (constructor not public) " + clazz);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.finer("cant instantiate CalendarHeaderHandler (Invocation target)" + clazz);
            }
        }
        return null;
    }

    protected void setCalendarHeaderHandler(CalendarHeaderHandler calendarHeaderHandler) {
        this.calendarHeaderHandler = calendarHeaderHandler;
    }

    protected CalendarHeaderHandler getCalendarHeaderHandler() {
        return this.calendarHeaderHandler;
    }

    @Deprecated
    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }

    private class KeyboardAction
    extends AbstractAction {
        public static final int ACCEPT_SELECTION = 0;
        public static final int CANCEL_SELECTION = 1;
        public static final int SELECT_PREVIOUS_DAY = 2;
        public static final int SELECT_NEXT_DAY = 3;
        public static final int SELECT_DAY_PREVIOUS_WEEK = 4;
        public static final int SELECT_DAY_NEXT_WEEK = 5;
        public static final int ADJUST_SELECTION_PREVIOUS_DAY = 6;
        public static final int ADJUST_SELECTION_NEXT_DAY = 7;
        public static final int ADJUST_SELECTION_PREVIOUS_WEEK = 8;
        public static final int ADJUST_SELECTION_NEXT_WEEK = 9;
        private int action;

        public KeyboardAction(int n2) {
            this.action = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            if (!BasicMonthViewUI.this.isUsingKeyboard()) {
                BasicMonthViewUI.this.originalDateSpan = BasicMonthViewUI.this.getSelection();
            }
            if (this.action >= 0 && this.action <= 1) {
                if (this.action == 1) {
                    if (BasicMonthViewUI.this.originalDateSpan != null && !BasicMonthViewUI.this.originalDateSpan.isEmpty()) {
                        BasicMonthViewUI.this.monthView.setSelectionInterval((Date)BasicMonthViewUI.this.originalDateSpan.first(), (Date)BasicMonthViewUI.this.originalDateSpan.last());
                    } else {
                        BasicMonthViewUI.this.monthView.clearSelection();
                    }
                    BasicMonthViewUI.this.monthView.cancelSelection();
                } else {
                    BasicMonthViewUI.this.monthView.commitSelection();
                }
                BasicMonthViewUI.this.setUsingKeyboard(false);
            } else if (this.action >= 2 && this.action <= 5) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                BasicMonthViewUI.this.pivotDate = null;
                this.traverse(this.action);
            } else if (this.isIntervalMode() && this.action >= 6 && this.action <= 9) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                this.addToSelection(this.action);
            }
        }

        private boolean isIntervalMode() {
            return BasicMonthViewUI.this.monthView.getSelectionMode() != DateSelectionModel.SelectionMode.SINGLE_SELECTION;
        }

        private void traverse(int n2) {
            Date date = BasicMonthViewUI.this.monthView.isSelectionEmpty() ? BasicMonthViewUI.this.monthView.getToday() : BasicMonthViewUI.this.monthView.getFirstSelectionDate();
            Calendar calendar = BasicMonthViewUI.this.getCalendar(date);
            switch (n2) {
                case 2: {
                    calendar.add(5, -1);
                    break;
                }
                case 3: {
                    calendar.add(5, 1);
                    break;
                }
                case 4: {
                    calendar.add(5, -7);
                    break;
                }
                case 5: {
                    calendar.add(5, 7);
                }
            }
            Date date2 = calendar.getTime();
            if (!date2.equals(date)) {
                BasicMonthViewUI.this.monthView.setSelectionInterval(date2, date2);
                BasicMonthViewUI.this.monthView.ensureDateVisible(date2);
            }
        }

        private void addToSelection(int n2) {
            boolean bl;
            Date date;
            Date date2;
            Date date3;
            Date date4;
            if (!BasicMonthViewUI.this.monthView.isSelectionEmpty()) {
                date3 = date4 = BasicMonthViewUI.this.monthView.getFirstSelectionDate();
                date = date2 = BasicMonthViewUI.this.monthView.getLastSelectionDate();
            } else {
                date = date2 = (date3 = (date4 = BasicMonthViewUI.this.monthView.getToday()));
            }
            if (BasicMonthViewUI.this.pivotDate == null) {
                BasicMonthViewUI.this.pivotDate = date3;
            }
            Calendar calendar = BasicMonthViewUI.this.getCalendar();
            switch (n2) {
                case 6: {
                    if (date.after(BasicMonthViewUI.this.pivotDate)) {
                        date = this.previousDay(calendar, date);
                        bl = false;
                        break;
                    }
                    date3 = this.previousDay(calendar, date3);
                    date = BasicMonthViewUI.this.pivotDate;
                    bl = true;
                    break;
                }
                case 7: {
                    if (date3.before(BasicMonthViewUI.this.pivotDate)) {
                        date3 = this.nextDay(calendar, date3);
                        bl = true;
                        break;
                    }
                    date = this.nextDay(calendar, date);
                    bl = false;
                    date3 = BasicMonthViewUI.this.pivotDate;
                    break;
                }
                case 8: {
                    if (date.after(BasicMonthViewUI.this.pivotDate)) {
                        Date date5 = this.previousWeek(calendar, date);
                        if (date5.after(BasicMonthViewUI.this.pivotDate)) {
                            date = date5;
                            bl = false;
                            break;
                        }
                        date3 = date5;
                        date = BasicMonthViewUI.this.pivotDate;
                        bl = true;
                        break;
                    }
                    date3 = this.previousWeek(calendar, date3);
                    bl = true;
                    break;
                }
                case 9: {
                    if (date3.before(BasicMonthViewUI.this.pivotDate)) {
                        Date date6 = this.nextWeek(calendar, date3);
                        if (date6.before(BasicMonthViewUI.this.pivotDate)) {
                            date3 = date6;
                            bl = true;
                            break;
                        }
                        date3 = BasicMonthViewUI.this.pivotDate;
                        date = date6;
                        bl = false;
                        break;
                    }
                    date = this.nextWeek(calendar, date);
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid adjustment action: " + n2);
                }
            }
            if (!date3.equals(date4) || !date.equals(date2)) {
                BasicMonthViewUI.this.monthView.setSelectionInterval(date3, date);
                BasicMonthViewUI.this.monthView.ensureDateVisible(bl ? date3 : date);
            }
        }

        private Date nextWeek(Calendar calendar, Date date) {
            calendar.setTime(date);
            calendar.add(5, 7);
            return calendar.getTime();
        }

        private Date previousWeek(Calendar calendar, Date date) {
            calendar.setTime(date);
            calendar.add(5, -7);
            return calendar.getTime();
        }

        private Date nextDay(Calendar calendar, Date date) {
            calendar.setTime(date);
            calendar.add(5, 1);
            return calendar.getTime();
        }

        private Date previousDay(Calendar calendar, Date date) {
            calendar.setTime(date);
            calendar.add(5, -1);
            return calendar.getTime();
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    LayoutManager,
    PropertyChangeListener,
    DateSelectionListener {
        private boolean armed;
        private Date startDate;
        private Date endDate;
        private Dimension preferredSize = new Dimension();

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n2;
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (BasicMonthViewUI.this.monthView.isTraversable() && (n2 = BasicMonthViewUI.this.getTraversableGridPositionAtLocation(mouseEvent.getX(), mouseEvent.getY())) != -1) {
                BasicMonthViewUI.this.traverseMonth(n2);
                return;
            }
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            Date date = BasicMonthViewUI.this.getDayAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (date == null) {
                return;
            }
            this.startDate = date;
            this.endDate = date;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_INTERVAL_SELECTION || BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION) {
                BasicMonthViewUI.this.pivotDate = this.startDate;
            }
            BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && mouseEvent.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(this.startDate, this.endDate);
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(this.startDate, this.endDate);
            }
            this.armed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (this.armed) {
                BasicMonthViewUI.this.monthView.commitSelection();
            }
            this.armed = false;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled() || !BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            Date date = BasicMonthViewUI.this.getDayAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (date == null) {
                return;
            }
            Date date2 = date;
            Date date3 = this.startDate;
            Date date4 = this.endDate;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_SELECTION) {
                if (date2.equals(date3)) {
                    return;
                }
                this.startDate = date2;
                this.endDate = date2;
            } else if (BasicMonthViewUI.this.pivotDate != null) {
                if (date2.before(BasicMonthViewUI.this.pivotDate)) {
                    this.startDate = date2;
                    this.endDate = BasicMonthViewUI.this.pivotDate;
                } else if (date2.after(BasicMonthViewUI.this.pivotDate)) {
                    this.startDate = BasicMonthViewUI.this.pivotDate;
                    this.endDate = date2;
                }
            } else {
                this.startDate = date2;
                this.endDate = date2;
                BasicMonthViewUI.this.pivotDate = date2;
            }
            if (this.startDate.equals(date3) && this.endDate.equals(date4)) {
                return;
            }
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && mouseEvent.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(this.startDate, this.endDate);
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(this.startDate, this.endDate);
            }
            this.armed = true;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            this.layoutContainer(container);
            return new Dimension(this.preferredSize);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension;
            JComponent jComponent;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = 0;
            Calendar calendar = BasicMonthViewUI.this.getCalendar();
            for (n3 = calendar.getMinimum(2); n3 <= calendar.getMaximum(2); ++n3) {
                calendar.set(2, n3);
                CalendarUtils.startOfMonth(calendar);
                JComponent jComponent2 = BasicMonthViewUI.this.getRenderingHandler().prepareRenderingComponent(BasicMonthViewUI.this.monthView, calendar, CalendarState.TITLE);
                Dimension dimension2 = jComponent2.getPreferredSize();
                n4 = Math.max(n4, dimension2.width);
                n5 = Math.max(n5, dimension2.height);
            }
            n3 = 0;
            int n6 = 0;
            calendar = BasicMonthViewUI.this.getCalendar();
            CalendarUtils.startOfWeek(calendar);
            for (n2 = 0; n2 < 7; ++n2) {
                jComponent = BasicMonthViewUI.this.getRenderingHandler().prepareRenderingComponent(BasicMonthViewUI.this.monthView, calendar, CalendarState.DAY_OF_WEEK);
                dimension = jComponent.getPreferredSize();
                n3 = Math.max(n3, dimension.width);
                n6 = Math.max(n6, dimension.height);
                calendar.add(5, 1);
            }
            calendar = BasicMonthViewUI.this.getCalendar();
            for (n2 = 0; n2 < calendar.getMaximum(5); ++n2) {
                jComponent = BasicMonthViewUI.this.getRenderingHandler().prepareRenderingComponent(BasicMonthViewUI.this.monthView, calendar, CalendarState.IN_MONTH);
                dimension = jComponent.getPreferredSize();
                n3 = Math.max(n3, dimension.width);
                n6 = Math.max(n6, dimension.height);
                calendar.add(5, 1);
            }
            n2 = 7;
            if (BasicMonthViewUI.this.monthView.isShowingWeekNumber()) {
                ++n2;
            }
            if (n4 > n3 * n2) {
                double d2 = n4 - n3 * n2;
                n3 = (int)((double)n3 + Math.ceil(d2 / (double)n2));
            }
            BasicMonthViewUI.this.fullBoxWidth = n3;
            BasicMonthViewUI.this.fullBoxHeight = n6;
            int n7 = n6 - 2 * BasicMonthViewUI.this.monthView.getBoxPaddingY();
            BasicMonthViewUI.this.fullMonthBoxHeight = Math.max(n7, n5);
            BasicMonthViewUI.this.calendarWidth = BasicMonthViewUI.this.fullBoxWidth * 7;
            if (BasicMonthViewUI.this.monthView.isShowingWeekNumber()) {
                BasicMonthViewUI.this.calendarWidth = BasicMonthViewUI.this.calendarWidth + BasicMonthViewUI.this.fullBoxWidth;
            }
            BasicMonthViewUI.this.fullCalendarWidth = BasicMonthViewUI.this.calendarWidth + 10;
            BasicMonthViewUI.this.calendarHeight = BasicMonthViewUI.this.fullBoxHeight * 7 + BasicMonthViewUI.this.fullMonthBoxHeight;
            BasicMonthViewUI.this.fullCalendarHeight = BasicMonthViewUI.this.calendarHeight + 10;
            int n8 = this.getPreferredRows();
            this.preferredSize.height = BasicMonthViewUI.this.calendarHeight * n8 + 10 * (n8 - 1);
            int n9 = this.getPreferredColumns();
            this.preferredSize.width = BasicMonthViewUI.this.calendarWidth * n9 + 10 * (n9 - 1);
            Insets insets = BasicMonthViewUI.this.monthView.getInsets();
            this.preferredSize.width += insets.left + insets.right;
            this.preferredSize.height += insets.top + insets.bottom;
            BasicMonthViewUI.this.calculateMonthGridLayoutProperties();
            if (BasicMonthViewUI.this.isZoomable()) {
                BasicMonthViewUI.this.getCalendarHeaderHandler().getHeaderComponent().setBounds(BasicMonthViewUI.this.getMonthHeaderBounds(BasicMonthViewUI.this.monthView.getFirstDisplayedDay(), false));
            }
        }

        private int getPreferredColumns() {
            return BasicMonthViewUI.this.isZoomable() ? 1 : BasicMonthViewUI.this.monthView.getPreferredColumnCount();
        }

        private int getPreferredRows() {
            return BasicMonthViewUI.this.isZoomable() ? 1 : BasicMonthViewUI.this.monthView.getPreferredRowCount();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("componentOrientation".equals(string)) {
                BasicMonthViewUI.this.isLeftToRight = BasicMonthViewUI.this.monthView.getComponentOrientation().isLeftToRight();
                BasicMonthViewUI.this.monthView.revalidate();
                BasicMonthViewUI.this.monthView.repaint();
            } else if ("selectionModel".equals(string)) {
                DateSelectionModel dateSelectionModel = (DateSelectionModel)propertyChangeEvent.getOldValue();
                dateSelectionModel.removeDateSelectionListener(BasicMonthViewUI.this.getHandler());
                dateSelectionModel = (DateSelectionModel)propertyChangeEvent.getNewValue();
                dateSelectionModel.addDateSelectionListener(BasicMonthViewUI.this.getHandler());
            } else if ("firstDisplayedDay".equals(string)) {
                BasicMonthViewUI.this.setFirstDisplayedDay((Date)propertyChangeEvent.getNewValue());
                BasicMonthViewUI.this.monthView.repaint();
            } else if ("boxPaddingX".equals(string) || "boxPaddingY".equals(string) || "traversable".equals(string) || "daysOfTheWeek".equals(string) || "border".equals(string) || "showingWeekNumber".equals(string) || "traversable".equals(string)) {
                BasicMonthViewUI.this.monthView.revalidate();
                BasicMonthViewUI.this.monthView.repaint();
            } else if ("zoomable".equals(string)) {
                BasicMonthViewUI.this.updateZoomable();
            } else if ("componentInputMapEnabled".equals(string)) {
                BasicMonthViewUI.this.updateComponentInputMap();
            } else if ("locale".equals(string)) {
                BasicMonthViewUI.this.updateLocale(true);
            } else {
                BasicMonthViewUI.this.monthView.repaint();
            }
        }

        public void valueChanged(DateSelectionEvent dateSelectionEvent) {
            BasicMonthViewUI.this.monthView.repaint();
        }
    }

    protected static class RenderingHandler
    extends BasicCalendarRenderingHandler {
        protected RenderingHandler() {
        }
    }
}

