/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.plaf.LoginPaneUI;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class BasicLoginPaneUI
extends LoginPaneUI {
    private JXLoginPane dlg;

    public BasicLoginPaneUI(JXLoginPane jXLoginPane) {
        this.dlg = jXLoginPane;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicLoginPaneUI((JXLoginPane)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults();
    }

    protected void installDefaults() {
        String string = this.dlg.getBannerText();
        if (string == null || string.equals("")) {
            this.dlg.setBannerText(UIManagerExt.getString("JXLoginPane.bannerString", this.dlg.getLocale()));
        }
        if ((string = this.dlg.getErrorMessage()) == null || string.equals("")) {
            this.dlg.setErrorMessage(UIManagerExt.getString("JXLoginPane.errorMessage", this.dlg.getLocale()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getBanner() {
        int n2 = 400;
        int n3 = 60;
        float f2 = (float)n2 * 0.05f;
        float f3 = (float)n3 * 0.75f;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            Font font = UIManager.getFont("JXLoginPane.bannerFont");
            graphics2D.setFont(font);
            Graphics2D graphics2D2 = graphics2D;
            try {
                if (!this.dlg.getComponentOrientation().isLeftToRight()) {
                    graphics2D2 = (Graphics2D)graphics2D.create();
                    graphics2D.scale(-1.0, 1.0);
                    graphics2D.translate(-n2, 0);
                    f2 = (float)n2 - ((float)font.getStringBounds(this.dlg.getBannerText(), graphics2D2.getFontRenderContext()).getWidth() + (float)n2 * 0.05f);
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics2D.setColor(UIManager.getColor("JXLoginPane.bannerDarkBackground"));
                graphics2D.fillRect(0, 0, n2, n3);
                GeneralPath generalPath = new GeneralPath(1);
                generalPath.moveTo(0.0f, (float)n3 * 0.6f);
                generalPath.curveTo((float)n2 * 0.167f, (float)n3 * 1.2f, (float)n2 * 0.667f, (float)n3 * -0.5f, n2, (float)n3 * 0.75f);
                generalPath.lineTo(n2, n3);
                generalPath.lineTo(0.0f, n3);
                generalPath.lineTo(0.0f, (float)n3 * 0.8f);
                generalPath.closePath();
                GradientPaint gradientPaint = new GradientPaint(0.0f, n3, UIManager.getColor("JXLoginPane.bannerDarkBackground"), 0.0f, 0.0f, UIManager.getColor("JXLoginPane.bannerLightBackground"));
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(generalPath);
                graphics2D2.setColor(UIManager.getColor("JXLoginPane.bannerForeground"));
                graphics2D2.drawString(this.dlg.getBannerText(), f2, f3);
            }
            finally {
                graphics2D2.dispose();
            }
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    private class LocaleHandler
    implements PropertyChangeListener {
        private LocaleHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof JComponent) {
                ((JComponent)object).updateUI();
            }
        }
    }
}

