/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicHyperlinkUI
extends BasicButtonUI {
    private static final Logger LOG = Logger.getLogger(BasicHyperlinkUI.class.getName());
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    private Color focusColor;
    private View ulv;
    private PropertyChangeListener pcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicHyperlinkUI.this.ulv = null;
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicHyperlinkUI();
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", false);
        abstractButton.setBorderPainted(false);
        abstractButton.setRolloverEnabled(true);
        if (SwingXUtilities.isUIInstallable(abstractButton.getBorder())) {
            abstractButton.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        }
        this.dashedRectGapX = UIManager.getInt("ButtonUI.dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt("ButtonUI.dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt("ButtonUI.dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt("ButtonUI.dashedRectGapHeight");
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        abstractButton.setHorizontalAlignment(10);
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        abstractButton.addPropertyChangeListener(this.pcListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this.pcListener);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        BasicHyperlinkUI.viewRect.x = insets.left;
        BasicHyperlinkUI.viewRect.y = insets.top;
        BasicHyperlinkUI.viewRect.width = abstractButton.getWidth() - (insets.right + BasicHyperlinkUI.viewRect.x);
        BasicHyperlinkUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BasicHyperlinkUI.viewRect.y);
        BasicHyperlinkUI.textRect.height = 0;
        BasicHyperlinkUI.textRect.width = 0;
        BasicHyperlinkUI.textRect.y = 0;
        BasicHyperlinkUI.textRect.x = 0;
        BasicHyperlinkUI.iconRect.height = 0;
        BasicHyperlinkUI.iconRect.width = 0;
        BasicHyperlinkUI.iconRect.y = 0;
        BasicHyperlinkUI.iconRect.x = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconRect);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                this.paintHTMLText(graphics, abstractButton, textRect, string, view);
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }

    protected void paintHTMLText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, View view) {
        rectangle.x += this.getTextShiftOffset();
        rectangle.y += this.getTextShiftOffset();
        if (abstractButton.getModel().isRollover()) {
            if (this.ulv == null) {
                this.ulv = ULHtml.createHTMLView(abstractButton, string);
            }
            this.ulv.paint(graphics, rectangle);
        } else {
            view.paint(graphics, rectangle);
        }
        rectangle.x -= this.getTextShiftOffset();
        rectangle.y -= this.getTextShiftOffset();
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        if (!abstractButton.getModel().isEnabled()) {
            ++rectangle.x;
        }
        super.paintText(graphics, abstractButton, rectangle, string);
        if (abstractButton.getModel().isRollover()) {
            this.paintUnderline(graphics, abstractButton, rectangle, string);
        }
    }

    private void paintUnderline(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getDescent();
        graphics.drawLine(rectangle.x + this.getTextShiftOffset(), rectangle.y + rectangle.height - n2 + 1 + this.getTextShiftOffset(), rectangle.x + rectangle.width + this.getTextShiftOffset(), rectangle.y + rectangle.height - n2 + 1 + this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        graphics.setColor(this.getFocusColor());
        Rectangle rectangle4 = this.getIconTextRect(abstractButton);
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BasicHyperlinkListener(abstractButton);
    }

    @Override
    public boolean contains(JComponent jComponent, int n2, int n3) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        return this.isInside(this.getIconTextRect(abstractButton), n2, n3);
    }

    private boolean isInside(Rectangle rectangle, int n2, int n3) {
        if (rectangle == null) {
            return false;
        }
        return rectangle.contains(n2, n3);
    }

    protected Rectangle getIconTextRect(AbstractButton abstractButton) {
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(abstractButton.getSize());
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : abstractButton.getIconTextGap());
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        rectangle4.y -= insets.top;
        return rectangle4;
    }

    static class ULHtml
    extends BasicHTML {
        private static BasicEditorKit basicHTMLFactory;
        private static ViewFactory basicHTMLViewFactory;
        private static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }font {text-decoration: underline}";

        ULHtml() {
        }

        public static View createHTMLView(JComponent jComponent, String string) {
            BasicEditorKit basicEditorKit = ULHtml.getFactory();
            Document document = basicEditorKit.createDefaultDocument(jComponent.getFont(), jComponent.getForeground());
            Object object = jComponent.getClientProperty("html.base");
            if (object instanceof URL) {
                ((HTMLDocument)document).setBase((URL)object);
            }
            StringReader stringReader = new StringReader(string);
            try {
                basicEditorKit.read(stringReader, document, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ViewFactory viewFactory = basicEditorKit.getViewFactory();
            View view = viewFactory.create(document.getDefaultRootElement());
            Renderer renderer = new Renderer(jComponent, viewFactory, view);
            return renderer;
        }

        static BasicEditorKit getFactory() {
            if (basicHTMLFactory == null) {
                basicHTMLViewFactory = new BasicHTMLViewFactory();
                basicHTMLFactory = new BasicEditorKit();
            }
            return basicHTMLFactory;
        }

        static class Renderer
        extends View {
            private int width;
            private View view;
            private ViewFactory factory;
            private JComponent host;

            Renderer(JComponent jComponent, ViewFactory viewFactory, View view) {
                super(null);
                this.host = jComponent;
                this.factory = viewFactory;
                this.view = view;
                this.view.setParent(this);
                this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
            }

            @Override
            public AttributeSet getAttributes() {
                return null;
            }

            @Override
            public float getPreferredSpan(int n2) {
                if (n2 == 0) {
                    return this.width;
                }
                return this.view.getPreferredSpan(n2);
            }

            @Override
            public float getMinimumSpan(int n2) {
                return this.view.getMinimumSpan(n2);
            }

            @Override
            public float getMaximumSpan(int n2) {
                return 2.1474836E9f;
            }

            @Override
            public void preferenceChanged(View view, boolean bl, boolean bl2) {
                this.host.revalidate();
                this.host.repaint();
            }

            @Override
            public float getAlignment(int n2) {
                return this.view.getAlignment(n2);
            }

            @Override
            public void paint(Graphics graphics, Shape shape) {
                Rectangle rectangle = shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }

            @Override
            public void setParent(View view) {
                throw new Error("Can't set parent on root view");
            }

            @Override
            public int getViewCount() {
                return 1;
            }

            @Override
            public View getView(int n2) {
                return this.view;
            }

            @Override
            public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
                return this.view.modelToView(n2, shape, bias);
            }

            @Override
            public Shape modelToView(int n2, Position.Bias bias, int n3, Position.Bias bias2, Shape shape) throws BadLocationException {
                return this.view.modelToView(n2, bias, n3, bias2, shape);
            }

            @Override
            public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
                return this.view.viewToModel(f2, f3, shape, biasArray);
            }

            @Override
            public Document getDocument() {
                return this.view.getDocument();
            }

            @Override
            public int getStartOffset() {
                return this.view.getStartOffset();
            }

            @Override
            public int getEndOffset() {
                return this.view.getEndOffset();
            }

            @Override
            public Element getElement() {
                return this.view.getElement();
            }

            @Override
            public void setSize(float f2, float f3) {
                this.width = (int)f2;
                this.view.setSize(f2, f3);
            }

            @Override
            public Container getContainer() {
                return this.host;
            }

            @Override
            public ViewFactory getViewFactory() {
                return this.factory;
            }
        }

        static class BasicDocument
        extends HTMLDocument {
            private static Class<?> clz;
            private static Method displayPropertiesToCSS;

            private static String displayPropertiesToCSS(Font font, Color color) {
                try {
                    return (String)displayPropertiesToCSS.invoke(null, font, color);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            BasicDocument(StyleSheet styleSheet, Font font, Color color) {
                super(styleSheet);
                this.setPreservesUnknownTags(false);
                this.setFontAndColor(font, color);
            }

            private void setFontAndColor(Font font, Color color) {
                this.getStyleSheet().addRule(BasicDocument.displayPropertiesToCSS(font, color));
            }

            static {
                String string = "com.sun.java.swing.SwingUtilities2";
                String string2 = "sun.swing.SwingUtilities2";
                try {
                    clz = Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new RuntimeException("Failed to find SwingUtilities2. Check the classpath.");
                    }
                }
                try {
                    displayPropertiesToCSS = clz.getMethod("displayPropertiesToCSS", Font.class, Color.class);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to use SwingUtilities2. Check the permissions and class version.");
                }
            }
        }

        static class BasicHTMLViewFactory
        extends HTMLEditorKit.HTMLFactory {
            BasicHTMLViewFactory() {
            }

            @Override
            public View create(Element element) {
                View view = super.create(element);
                if (view instanceof ImageView) {
                    ((ImageView)view).setLoadsSynchronously(true);
                }
                return view;
            }
        }

        static class BasicEditorKit
        extends HTMLEditorKit {
            private static StyleSheet defaultStyles;

            BasicEditorKit() {
            }

            @Override
            public StyleSheet getStyleSheet() {
                if (defaultStyles == null) {
                    defaultStyles = new StyleSheet();
                    StringReader stringReader = new StringReader(ULHtml.styleChanges);
                    try {
                        defaultStyles.loadRules(stringReader, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    stringReader.close();
                    defaultStyles.addStyleSheet(super.getStyleSheet());
                }
                return defaultStyles;
            }

            public Document createDefaultDocument(Font font, Color color) {
                StyleSheet styleSheet = this.getStyleSheet();
                StyleSheet styleSheet2 = new StyleSheet();
                styleSheet2.addStyleSheet(styleSheet);
                BasicDocument basicDocument = new BasicDocument(styleSheet2, font, color);
                basicDocument.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                basicDocument.setPreservesUnknownTags(false);
                return basicDocument;
            }

            @Override
            public ViewFactory getViewFactory() {
                return basicHTMLViewFactory;
            }
        }
    }

    public static class BasicHyperlinkListener
    extends BasicButtonListener {
        public BasicHyperlinkListener(AbstractButton abstractButton) {
            super(abstractButton);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
            if (abstractButton.isRolloverEnabled()) {
                abstractButton.setCursor(abstractButton.getModel().isRollover() ? Cursor.getPredefinedCursor(12) : null);
            }
            super.stateChanged(changeEvent);
        }
    }
}

