/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalBorders;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.util.JVM;
import org.jdesktop.swingx.util.OS;

public class ColumnHeaderRendererAddon
extends AbstractComponentAddon {
    private static final Logger LOG = Logger.getLogger(ColumnHeaderRendererAddon.class.getName());

    public ColumnHeaderRendererAddon() {
        super("ColumnHeaderRenderer");
    }

    @Override
    protected void addBasicDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        super.addBasicDefaults(lookAndFeelAddons, defaultsList);
        defaultsList.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "basic/resources/sort-jlf-up.png"));
        defaultsList.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "basic/resources/sort-jlf-dn.png"));
        this.hackMetalBorder(lookAndFeelAddons, defaultsList);
    }

    private void hackMetalBorder(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        if (border instanceof MetalBorders.TableHeaderBorder) {
            border = new BorderUIResource.CompoundBorderUIResource(border, BorderFactory.createEmptyBorder());
            defaultsList.add("ColumnHeaderRenderer.metalBorderHack", border);
        }
    }

    @Override
    protected void addLinuxDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        super.addLinuxDefaults(lookAndFeelAddons, defaultsList);
        if (this.isSynth()) {
            defaultsList.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "linux/resources/sort-gtk-up.png"));
            defaultsList.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "linux/resources/sort-gtk-dn.png"));
        }
    }

    @Override
    protected void addMacDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        super.addMacDefaults(lookAndFeelAddons, defaultsList);
        defaultsList.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "macosx/resources/sort-osx-up.png"));
        defaultsList.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "macosx/resources/sort-osx-dn.png"));
    }

    @Override
    protected void addWindowsDefaults(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        super.addWindowsDefaults(lookAndFeelAddons, defaultsList);
        if (OS.isWindowsXP()) {
            defaultsList.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-xp-up.png"));
            defaultsList.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-xp-dn.png"));
        } else {
            defaultsList.add("ColumnHeaderRenderer.upIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-w2k-up.png"));
            defaultsList.add("ColumnHeaderRenderer.downIcon", LookAndFeel.makeIcon(ColumnHeaderRendererAddon.class, "windows/resources/sort-w2k-dn.png"));
        }
        this.hackVistaHeaderBorder(lookAndFeelAddons, defaultsList);
    }

    private void hackVistaHeaderBorder(LookAndFeelAddons lookAndFeelAddons, DefaultsList defaultsList) {
        if (!OS.isWindowsVista() || lookAndFeelAddons instanceof WindowsClassicLookAndFeelAddons || !JVM.current().isOneDotFive()) {
            return;
        }
        defaultsList.add("ColumnHeaderRenderer.vistaBorderHack", new BorderUIResource.EmptyBorderUIResource(5, 5, 5, 5));
    }
}

