/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.painter.AbstractPainter;

public class BusyPainter
extends AbstractPainter<Object> {
    private int frame = -1;
    private int points = 8;
    private Color baseColor = new Color(200, 200, 200);
    private Color highlightColor = Color.BLACK;
    private int trailLength = 4;
    private Shape pointShape;
    private Shape trajectory;
    private JXBusyLabel.Direction direction = JXBusyLabel.Direction.RIGHT;
    private boolean paintCentered;

    public BusyPainter() {
        this(26);
    }

    public BusyPainter(int n2) {
        this(BusyPainter.getScaledDefaultPoint(n2), BusyPainter.getScaledDefaultTrajectory(n2));
    }

    protected static Shape getScaledDefaultTrajectory(int n2) {
        return new Ellipse2D.Float(n2 * 8 / 26 / 2, n2 * 8 / 26 / 2, n2 - n2 * 8 / 26, n2 - n2 * 8 / 26);
    }

    protected static Shape getScaledDefaultPoint(int n2) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, n2 * 8 / 26, 4.0f, 4.0f, 4.0f);
    }

    public BusyPainter(Shape shape, Shape shape2) {
        this.init(shape, shape2, Color.LIGHT_GRAY, Color.BLACK);
    }

    protected void init(Shape shape, Shape shape2, Color color, Color color2) {
        this.baseColor = color;
        this.highlightColor = color2;
        this.pointShape = shape;
        this.trajectory = shape2;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n2, int n3) {
        int n4;
        float f2;
        Rectangle rectangle = this.getTrajectory().getBounds();
        int n5 = n2 - rectangle.width - 2 * rectangle.x;
        int n6 = n3 - rectangle.height - 2 * rectangle.y;
        if (this.isPaintCentered()) {
            graphics2D.translate(n5 / 2, n6 / 2);
        }
        PathIterator pathIterator = this.trajectory.getPathIterator(null);
        float[] fArray = new float[6];
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float f3 = 0.0f;
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        do {
            int n7;
            try {
                n7 = pathIterator.currentSegment(fArray);
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
            if (n7 == 1 || n7 == 4 && (float_2.x != float_.x || float_2.y != float_.y)) {
                f2 = this.calcLine(fArray, float_);
                f3 += f2;
                arrayList.add(new float[]{f2, 0.0f, 0.0f, 0.0f, 0.0f, fArray[0], fArray[1], n7});
                float_.x = fArray[0];
                float_.y = fArray[1];
            }
            if (n7 == 0) {
                float_2.x = float_.x = fArray[0];
                float_2.y = float_.y = fArray[1];
            }
            if (n7 == 3) {
                f2 = this.calcCube(fArray, float_);
                f3 += f2;
                arrayList.add(new float[]{f2, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], n7});
                float_.x = fArray[4];
                float_.y = fArray[5];
            }
            if (n7 == 2) {
                f2 = this.calcLengthOfQuad(fArray, float_);
                f3 += f2;
                arrayList.add(new float[]{f2, fArray[0], fArray[1], 0.0f, 0.0f, fArray[2], fArray[3], n7});
                float_.x = fArray[2];
                float_.y = fArray[3];
            }
            pathIterator.next();
        } while (!pathIterator.isDone());
        f2 = f3 / (float)this.getPoints();
        ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
        arrayList2.add(new Point2D.Float(float_2.x, float_2.y));
        int n8 = 0;
        float[] fArray2 = (float[])arrayList.get(n8);
        float f4 = fArray2[0];
        float f5 = f2;
        Point2D.Float float_3 = new Point2D.Float(float_2.x, float_2.y);
        for (n4 = 1; n4 < this.getPoints(); ++n4) {
            while (f4 < f2) {
                float_2.x = fArray2[5];
                float_2.y = fArray2[6];
                fArray2 = (float[])arrayList.get(++n8);
                f5 = f2 - f4;
                f4 += fArray2[0];
            }
            f4 -= f2;
            Point2D.Float float_4 = this.calcPoint(f5, float_2, fArray2, n2, n3);
            arrayList2.add(float_4);
            float_3.x += float_4.x;
            float_3.y += float_4.y;
            f5 += f2;
        }
        float_3.x = (float)n2 / 2.0f;
        float_3.y = (float)n3 / 2.0f;
        n4 = 0;
        graphics2D.translate(float_3.x, float_3.y);
        for (Point2D.Float float_5 : arrayList2) {
            this.drawAt(graphics2D, n4++, float_5, float_3);
        }
        graphics2D.translate(-float_3.x, -float_3.y);
        if (this.isPaintCentered()) {
            graphics2D.translate(-n5 / 2, -n6 / 2);
        }
    }

    public boolean isPaintCentered() {
        return this.paintCentered;
    }

    private void drawAt(Graphics2D graphics2D, int n2, Point2D.Float float_, Point2D.Float float_2) {
        graphics2D.setColor(this.calcFrameColor(n2));
        this.paintRotatedCenteredShapeAtPoint(float_, float_2, graphics2D);
    }

    private void paintRotatedCenteredShapeAtPoint(Point2D.Float float_, Point2D.Float float_2, Graphics2D graphics2D) {
        Shape shape = this.getPointShape();
        double d2 = shape.getBounds().getHeight() / 2.0;
        double d3 = shape.getBounds().getWidth() / 2.0;
        double d4 = float_2.y - float_.y;
        double d5 = float_.x - float_2.x;
        double d6 = Math.signum(d4);
        double d7 = Math.signum(d5);
        d6 = d6 == 0.0 ? 1.0 : d6;
        d7 = d7 == 0.0 ? 1.0 : d7;
        d4 = Math.abs(d4);
        d5 = Math.abs(d5);
        double d8 = Math.atan(d4 / d5);
        d8 = d6 > 0.0 ? (d7 > 0.0 ? -d8 : -Math.PI + d8) : (d7 > 0.0 ? d8 : Math.PI - d8);
        double d9 = Math.sqrt(d4 * d4 + d5 * d5) - d3;
        double d10 = -d2;
        graphics2D.rotate(d8);
        graphics2D.translate(d9, d10);
        graphics2D.fill(shape);
        graphics2D.translate(-d9, -d10);
        graphics2D.rotate(-d8);
    }

    private Point2D.Float calcPoint(float f2, Point2D.Float float_, float[] fArray, int n2, int n3) {
        Point2D.Float float_2 = new Point2D.Float();
        if (fArray[7] == 1.0f) {
            float f3 = fArray[5] - float_.x;
            float f4 = fArray[6] - float_.y;
            float f5 = fArray[0];
            float_2.x = float_.x + f3 * f2 / f5;
            float_2.y = float_.y + f4 * f2 / f5;
        } else if (fArray[7] == 2.0f) {
            Point2D.Float float_3 = new Point2D.Float(fArray[1] / (float)n2, fArray[2] / (float)n3);
            Point2D.Float float_4 = new Point2D.Float(fArray[5] / (float)n2, fArray[6] / (float)n3);
            Point2D.Float float_5 = new Point2D.Float(float_.x / (float)n2, float_.y / (float)n3);
            float_2 = BusyPainter.getXY(f2 / fArray[0], float_5, float_3, float_4);
            float_2.x *= (float)n2;
            float_2.y *= (float)n3;
        } else if (fArray[7] == 3.0f) {
            float f6 = Math.abs(float_.x - fArray[5]);
            float f7 = Math.abs(float_.y - fArray[6]);
            float f8 = Math.abs(float_.x - fArray[1]) / f6;
            float f9 = Math.abs(float_.y - fArray[2]) / f7;
            float f10 = Math.abs(float_.x - fArray[3]) / f6;
            float f11 = Math.abs(float_.y - fArray[4]) / f7;
            float_2 = this.getXY(f2 / fArray[0], f8, f9, f10, f11);
            float f12 = float_.x - fArray[5];
            float f13 = float_.y - fArray[6];
            float_2.x = float_.x - float_2.x * f12;
            float_2.y = float_.y - float_2.y * f13;
        }
        return float_2;
    }

    private float calcLine(float[] fArray, Point2D.Float float_) {
        float f2 = float_.x - fArray[0];
        float f3 = float_.y - fArray[1];
        float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        return f4;
    }

    private float calcCube(float[] fArray, Point2D.Float float_) {
        float f2;
        float f3 = Math.abs(float_.x - fArray[4]);
        float f4 = Math.abs(float_.y - fArray[5]);
        float f5 = Math.abs(float_.x - fArray[0]) / f3;
        float f6 = Math.abs(float_.y - fArray[1]) / f4;
        float f7 = Math.abs(float_.x - fArray[2]) / f3;
        float f8 = Math.abs(float_.y - fArray[3]) / f4;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        for (f2 = 0.01f; f2 <= 1.0f; f2 += 0.01f) {
            Point2D.Float float_2 = this.getXY(f2, f5, f6, f7, f8);
            f9 += (float)Math.sqrt((float_2.x - f10) * (float_2.x - f10) + (float_2.y - f11) * (float_2.y - f11));
            f10 = float_2.x;
            f11 = float_2.y;
        }
        f2 = (Math.abs(f3) + Math.abs(f4)) / 2.0f * f9;
        return f2;
    }

    private float calcLengthOfQuad(float[] fArray, Point2D.Float float_) {
        float f2;
        Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
        Point2D.Float float_3 = new Point2D.Float(fArray[2], fArray[3]);
        float f3 = Math.abs(float_.x - float_2.x);
        float f4 = Math.abs(float_.y - float_2.y);
        float f5 = Math.abs(float_.x - float_3.x);
        float f6 = Math.abs(float_.y - float_3.y);
        float f7 = Math.max(f3, f5);
        float f8 = Math.max(f4, f6);
        float_2.x = f3 / f7;
        float_2.y = f4 / f8;
        float_3.x = f5 / f7;
        float_3.y = f6 / f8;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        for (f2 = 0.01f; f2 <= 1.0f; f2 += 0.01f) {
            Point2D.Float float_4 = BusyPainter.getXY(f2, new Point2D.Float(0.0f, 0.0f), float_2, float_3);
            f9 += (float)Math.sqrt((float_4.x - f10) * (float_4.x - f10) + (float_4.y - f11) * (float_4.y - f11));
            f10 = float_4.x;
            f11 = float_4.y;
        }
        f2 = Math.abs(fArray[2] - float_.x);
        float f12 = Math.abs(fArray[3] - float_.y);
        float f13 = (float)Math.sqrt(f2 * f2 + f12 * f12);
        return f9 * f13;
    }

    private Point2D.Float getXY(float f2, float f3, float f4, float f5, float f6) {
        float f7 = 1.0f - f2;
        float f8 = 3.0f * f2 * (f7 * f7);
        float f9 = 3.0f * (f2 * f2) * f7;
        float f10 = f2 * f2 * f2;
        Point2D.Float float_ = new Point2D.Float(f8 * f3 + f9 * f5 + f10, f8 * f4 + f9 * f6 + f10);
        return float_;
    }

    public static Point2D.Float getXY(float f2, Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3) {
        float f3 = 1.0f - f2;
        float f4 = f3 * f3;
        float f5 = 2.0f * f2 * f3;
        float f6 = f2 * f2;
        Point2D.Float float_4 = new Point2D.Float(f4 * float_.x + f5 * float_2.x + f6 * float_3.x, f4 * float_.y + f5 * float_2.y + f6 * float_3.y);
        return float_4;
    }

    private Color calcFrameColor(int n2) {
        if (this.frame == -1) {
            return this.getBaseColor();
        }
        for (int i2 = 0; i2 < this.getTrailLength(); ++i2) {
            if (this.direction == JXBusyLabel.Direction.RIGHT && n2 == (this.frame - i2 + this.getPoints()) % this.getPoints()) {
                float f2 = 1.0f - (float)(this.getTrailLength() - i2) / (float)this.getTrailLength();
                return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), f2);
            }
            if (this.direction != JXBusyLabel.Direction.LEFT || n2 != (this.frame + i2) % this.getPoints()) continue;
            float f3 = (float)i2 / (float)this.getTrailLength();
            return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), f3);
        }
        return this.getBaseColor();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int n2) {
        int n3 = this.getFrame();
        this.frame = n2;
        this.firePropertyChange("frame", n3, this.getFrame());
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int n2) {
        int n3 = this.getPoints();
        this.points = n2;
        this.firePropertyChange("points", n3, this.getPoints());
    }

    public int getTrailLength() {
        return this.trailLength;
    }

    public void setTrailLength(int n2) {
        int n3 = this.getTrailLength();
        this.trailLength = n2;
        this.firePropertyChange("trailLength", n3, this.getTrailLength());
    }

    public final Shape getPointShape() {
        return this.pointShape;
    }

    public final Shape getTrajectory() {
        return this.trajectory;
    }
}

