/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.ref.SoftReference;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.painter.Painter;

public abstract class AbstractPainter<T>
extends AbstractBean
implements Painter<T> {
    private transient SoftReference<BufferedImage> cachedImage;
    private boolean cacheCleared = true;
    private boolean cacheable = false;
    private boolean dirty = false;
    private BufferedImageOp[] filters = new BufferedImageOp[0];
    private boolean antialiasing = true;
    private Interpolation interpolation = Interpolation.NearestNeighbor;
    private boolean visible = true;

    public final BufferedImageOp[] getFilters() {
        BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[this.filters.length];
        System.arraycopy(this.filters, 0, bufferedImageOpArray, 0, bufferedImageOpArray.length);
        return bufferedImageOpArray;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean bl) {
        boolean bl2 = this.isCacheable();
        this.cacheable = bl;
        this.firePropertyChange("cacheable", bl2, this.isCacheable());
        if (!this.isCacheable()) {
            this.clearCache();
        }
    }

    public void clearCache() {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = bufferedImage = this.cachedImage == null ? null : this.cachedImage.get();
        if (bufferedImage != null) {
            bufferedImage.flush();
        }
        this.cacheCleared = true;
        if (!this.isCacheable()) {
            this.cachedImage = null;
        }
    }

    protected void validate(T t2) {
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean bl) {
        boolean bl2 = this.isDirty();
        this.dirty = bl;
        this.firePropertyChange("dirty", bl2, this.isDirty());
        if (this.isDirty()) {
            this.clearCache();
        }
    }

    protected boolean shouldUseCache() {
        return this.isCacheable() || this.filters.length > 0;
    }

    protected void configureGraphics(Graphics2D graphics2D) {
        if (this.isAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.getInterpolation().configureGraphics(graphics2D);
    }

    protected abstract void doPaint(Graphics2D var1, T var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paint(Graphics2D graphics2D, T t2, int n2, int n3) {
        if (graphics2D == null) {
            throw new NullPointerException("The Graphics2D must be supplied");
        }
        if (!this.isVisible() || n2 < 1 || n3 < 1) {
            return;
        }
        this.configureGraphics(graphics2D);
        if (this.shouldUseCache() || this.filters.length > 0) {
            boolean bl;
            this.validate(t2);
            BufferedImage bufferedImage = this.cachedImage == null ? null : this.cachedImage.get();
            boolean bl2 = bl = null == bufferedImage || bufferedImage.getWidth() != n2 || bufferedImage.getHeight() != n3;
            if (this.cacheCleared || bl || this.isDirty()) {
                if (bl) {
                    bufferedImage = GraphicsUtilities.createCompatibleTranslucentImage(n2, n3);
                }
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                try {
                    graphics2D2.setClip(0, 0, n2, n3);
                    if (!bl) {
                        BufferedImageOp[] bufferedImageOpArray = graphics2D2.getComposite();
                        graphics2D2.setComposite(AlphaComposite.Clear);
                        graphics2D2.fillRect(0, 0, n2, n3);
                        graphics2D2.setComposite((Composite)bufferedImageOpArray);
                    }
                    this.configureGraphics(graphics2D2);
                    this.doPaint(graphics2D2, t2, n2, n3);
                }
                finally {
                    graphics2D2.dispose();
                }
                for (BufferedImageOp bufferedImageOp : this.getFilters()) {
                    bufferedImage = bufferedImageOp.filter(bufferedImage, null);
                }
                if (this.shouldUseCache()) {
                    this.cachedImage = new SoftReference<BufferedImage>(bufferedImage);
                    this.cacheCleared = false;
                }
            }
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        } else {
            this.doPaint(graphics2D, t2, n2, n3);
        }
        this.setDirty(false);
    }

    public static enum Interpolation {
        Bicubic(RenderingHints.VALUE_INTERPOLATION_BICUBIC),
        Bilinear(RenderingHints.VALUE_INTERPOLATION_BILINEAR),
        NearestNeighbor(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

        private Object value;

        private Interpolation(Object object) {
            this.value = object;
        }

        private void configureGraphics(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.value);
        }
    }
}

