/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;

public class GraphicsUtilities {
    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static BufferedImage createCompatibleImage(int n2, int n3) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(n2, n3, 1) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n2, n3);
    }

    public static BufferedImage createCompatibleTranslucentImage(int n2, int n3) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(n2, n3, 2) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n2, n3, 3);
    }
}

