/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public class WeakEventListenerList
implements Serializable {
    protected transient List<WeakReference<? extends EventListener>> weakReferences;
    protected transient List<Class<? extends EventListener>> classes;

    public Object[] getListenerList() {
        List list = this.cleanReferences();
        Object[] objectArray = new Object[list.size() * 2];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            objectArray[2 * i2 + 1] = list.get(i2);
            objectArray[2 * i2] = this.getClasses().get(i2);
        }
        return objectArray;
    }

    private synchronized <T extends EventListener> List<T> cleanReferences() {
        ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
        for (int i2 = this.getReferences().size() - 1; i2 >= 0; --i2) {
            Object t2 = this.getReferences().get(i2).get();
            if (t2 == null) {
                this.getReferences().remove(i2);
                this.getClasses().remove(i2);
                continue;
            }
            arrayList.add(0, (EventListener)t2);
        }
        return arrayList;
    }

    private List<WeakReference<? extends EventListener>> getReferences() {
        if (this.weakReferences == null) {
            this.weakReferences = new ArrayList<WeakReference<? extends EventListener>>();
        }
        return this.weakReferences;
    }

    private List<Class<? extends EventListener>> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<Class<? extends EventListener>>();
        }
        return this.classes;
    }

    public synchronized <T extends EventListener> void add(Class<T> clazz, T t2) {
        if (t2 == null) {
            return;
        }
        if (!clazz.isInstance(t2)) {
            throw new IllegalArgumentException("Listener " + t2 + " is not of type " + clazz);
        }
        this.cleanReferences();
        this.getReferences().add(new WeakReference<T>(t2));
        this.getClasses().add(clazz);
    }

    public synchronized <T extends EventListener> void remove(Class<T> clazz, T t2) {
        if (t2 == null) {
            return;
        }
        if (!clazz.isInstance(t2)) {
            throw new IllegalArgumentException("Listener " + t2 + " is not of type " + clazz);
        }
        for (int i2 = 0; i2 < this.getReferences().size(); ++i2) {
            if (!t2.equals(this.getReferences().get(i2).get()) || clazz != this.getClasses().get(i2)) continue;
            this.getReferences().remove(i2);
            this.getClasses().remove(i2);
            break;
        }
    }
}

