/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class SearchPredicate
implements HighlightPredicate {
    private int highlightColumn;
    private int highlightRow;
    private Pattern pattern;

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
        if (this.isHighlightCandidate(component, componentAdapter)) {
            return this.test(component, componentAdapter);
        }
        return false;
    }

    private boolean test(Component component, ComponentAdapter componentAdapter) {
        int n2 = componentAdapter.viewToModel(componentAdapter.column);
        String string = componentAdapter.getString(n2);
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.pattern.matcher(string).find();
    }

    private boolean isHighlightCandidate(Component component, ComponentAdapter componentAdapter) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.highlightRow >= 0 && componentAdapter.row != this.highlightRow) {
            return false;
        }
        return this.highlightColumn < 0 || this.highlightColumn == componentAdapter.viewToModel(componentAdapter.column);
    }

    private boolean isEnabled() {
        Pattern pattern = this.getPattern();
        return pattern != null && !".*".equals(pattern.pattern());
    }
}

