/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class PatternPredicate
implements HighlightPredicate {
    private int highlightColumn;
    private int testColumn;
    private Pattern pattern;

    @Override
    public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
        if (this.isHighlightCandidate(component, componentAdapter)) {
            return this.test(component, componentAdapter);
        }
        return false;
    }

    private boolean test(Component component, ComponentAdapter componentAdapter) {
        if (!componentAdapter.isTestable(this.testColumn)) {
            return false;
        }
        String string = componentAdapter.getString(this.testColumn);
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.pattern.matcher(string).find();
    }

    private boolean isHighlightCandidate(Component component, ComponentAdapter componentAdapter) {
        return this.pattern != null && (this.highlightColumn < 0 || this.highlightColumn == componentAdapter.viewToModel(componentAdapter.column));
    }
}

