/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.List;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public interface HighlightPredicate {
    public static final HighlightPredicate ALWAYS = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return true;
        }
    };
    public static final HighlightPredicate NEVER = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return false;
        }
    };
    public static final HighlightPredicate ROLLOVER_ROW = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            if (!componentAdapter.getComponent().isEnabled()) {
                return false;
            }
            Point point = (Point)componentAdapter.getComponent().getClientProperty("swingx.rollover");
            return point != null && point.y == componentAdapter.row;
        }
    };
    public static final HighlightPredicate EDITABLE = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.isEditable();
        }
    };
    public static final HighlightPredicate READ_ONLY = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !componentAdapter.isEditable();
        }
    };
    public static final HighlightPredicate IS_LEAF = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.isLeaf();
        }
    };
    public static final HighlightPredicate IS_FOLDER = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !componentAdapter.isLeaf();
        }
    };
    public static final HighlightPredicate HAS_FOCUS = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.hasFocus();
        }
    };
    public static final HighlightPredicate EVEN = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.row % 2 == 0;
        }
    };
    public static final HighlightPredicate ODD = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !EVEN.isHighlighted(component, componentAdapter);
        }
    };
    public static final HighlightPredicate BIG_DECIMAL_NEGATIVE = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.getValue() instanceof BigDecimal && ((BigDecimal)componentAdapter.getValue()).compareTo(BigDecimal.ZERO) < 0;
        }
    };
    public static final HighlightPredicate INTEGER_NEGATIVE = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.getValue() instanceof Number && ((Number)componentAdapter.getValue()).intValue() < 0;
        }
    };
    public static final HighlightPredicate[] EMPTY_PREDICATE_ARRAY = new HighlightPredicate[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];

    public boolean isHighlighted(Component var1, ComponentAdapter var2);

    public static class TypeHighlightPredicate
    implements HighlightPredicate {
        private Class<?> clazz;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.getValue() != null ? this.clazz.isAssignableFrom(componentAdapter.getValue().getClass()) : false;
        }
    }

    public static class EqualsHighlightPredicate
    implements HighlightPredicate {
        private Object compareValue;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            if (this.compareValue == null) {
                return componentAdapter.getValue() == null;
            }
            return this.compareValue.equals(componentAdapter.getValue());
        }
    }

    public static class DepthHighlightPredicate
    implements HighlightPredicate {
        private List<Integer> depthList;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            int n2 = componentAdapter.getDepth();
            return this.depthList.contains(n2);
        }
    }

    public static class IdentifierHighlightPredicate
    implements HighlightPredicate {
        List<Object> columnList;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            int n2 = componentAdapter.viewToModel(componentAdapter.column);
            Object object = componentAdapter.getColumnIdentifierAt(n2);
            return object != null ? this.columnList.contains(object) : false;
        }
    }

    public static class ColumnHighlightPredicate
    implements HighlightPredicate {
        List<Integer> columnList;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            int n2 = componentAdapter.viewToModel(componentAdapter.column);
            return this.columnList.contains(n2);
        }
    }

    public static class RowGroupHighlightPredicate
    implements HighlightPredicate {
        private int linesPerGroup;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return componentAdapter.row / this.linesPerGroup % 2 == 1;
        }
    }

    public static class OrHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            for (HighlightPredicate highlightPredicate : this.predicate) {
                if (!highlightPredicate.isHighlighted(component, componentAdapter)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndHighlightPredicate
    implements HighlightPredicate {
        private List<HighlightPredicate> predicate;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            for (HighlightPredicate highlightPredicate : this.predicate) {
                if (highlightPredicate.isHighlighted(component, componentAdapter)) continue;
                return false;
            }
            return !this.predicate.isEmpty();
        }
    }

    public static class NotHighlightPredicate
    implements HighlightPredicate {
        private HighlightPredicate predicate;

        @Override
        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            return !this.predicate.isHighlighted(component, componentAdapter);
        }
    }
}

