/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.UIDependent;
import org.jdesktop.swingx.util.Contract;

public class CompoundHighlighter
extends AbstractHighlighter
implements UIDependent {
    public static final Highlighter[] EMPTY_HIGHLIGHTERS = new Highlighter[0];
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();
    private ChangeListener highlighterChangeListener;

    public CompoundHighlighter(Highlighter ... highlighterArray) {
        this((HighlightPredicate)null, highlighterArray);
    }

    public CompoundHighlighter(HighlightPredicate highlightPredicate, Highlighter ... highlighterArray) {
        super(highlightPredicate);
        this.setHighlighters(highlighterArray);
    }

    public void setHighlighters(Highlighter ... highlighterArray) {
        Contract.asNotNull(highlighterArray, "Highlighter must not be null");
        if (this.highlighters.isEmpty() && highlighterArray.length == 0) {
            return;
        }
        this.removeAllHighlightersSilently();
        for (Highlighter highlighter : highlighterArray) {
            this.addHighlighterSilently(highlighter, false);
        }
        this.fireStateChanged();
    }

    private void removeAllHighlightersSilently() {
        for (Highlighter highlighter : this.highlighters) {
            highlighter.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters.clear();
    }

    public void addHighlighter(Highlighter highlighter) {
        this.addHighlighter(highlighter, false);
    }

    public void addHighlighter(Highlighter highlighter, boolean bl) {
        this.addHighlighterSilently(highlighter, bl);
        this.fireStateChanged();
    }

    private void addHighlighterSilently(Highlighter highlighter, boolean bl) {
        Contract.asNotNull(highlighter, "Highlighter must not be null");
        if (bl) {
            this.highlighters.add(0, highlighter);
        } else {
            this.highlighters.add(this.highlighters.size(), highlighter);
        }
        this.updateUI(highlighter);
        highlighter.addChangeListener(this.getHighlighterChangeListener());
    }

    @Override
    public void updateUI() {
        for (Highlighter highlighter : this.highlighters) {
            this.updateUI(highlighter);
        }
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        this.highlighterChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CompoundHighlighter.this.fireStateChanged();
            }
        };
        return this.highlighterChangeListener;
    }

    private void updateUI(Highlighter highlighter) {
        if (highlighter instanceof UIDependent) {
            ((UIDependent)((Object)highlighter)).updateUI();
        }
    }

    @Override
    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        for (Highlighter highlighter : this.highlighters) {
            component = highlighter.highlight(component, componentAdapter);
        }
        return component;
    }
}

