/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.event.WeakEventListenerList;

public abstract class AbstractHighlighter
implements Highlighter {
    private transient ChangeEvent changeEvent;
    protected WeakEventListenerList listenerList = new WeakEventListenerList();
    private HighlightPredicate predicate;

    public AbstractHighlighter(HighlightPredicate highlightPredicate) {
        this.setHighlightPredicate(highlightPredicate);
    }

    public void setHighlightPredicate(HighlightPredicate highlightPredicate) {
        if (highlightPredicate == null) {
            highlightPredicate = HighlightPredicate.ALWAYS;
        }
        if (this.areEqual(highlightPredicate, this.getHighlightPredicate())) {
            return;
        }
        this.predicate = highlightPredicate;
        this.fireStateChanged();
    }

    public HighlightPredicate getHighlightPredicate() {
        return this.predicate;
    }

    @Override
    public Component highlight(Component component, ComponentAdapter componentAdapter) {
        if (this.canHighlight(component, componentAdapter) && this.getHighlightPredicate().isHighlighted(component, componentAdapter)) {
            component = this.doHighlight(component, componentAdapter);
        }
        return component;
    }

    protected boolean canHighlight(Component component, ComponentAdapter componentAdapter) {
        return true;
    }

    protected abstract Component doHighlight(Component var1, ComponentAdapter var2);

    protected boolean areEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return false;
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected final void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }
}

