/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ColorUtil {
    public static Color removeAlpha(Color color) {
        return ColorUtil.setAlpha(color, 255);
    }

    public static Color setAlpha(Color color, int n2) {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("invalid alpha value");
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
    }

    public static Color setBrightness(Color color, float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("invalid brightness value");
        }
        int n2 = color.getAlpha();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color2 = Color.getHSBColor(fArray[0], fArray[1], f2);
        return ColorUtil.setAlpha(color2, n2);
    }

    public static String toHexString(Color color) {
        return "#" + Integer.toHexString(color.getRGB() | 0xFF000000).substring(2);
    }

    public static void tileStretchPaint(Graphics graphics, JComponent jComponent, BufferedImage bufferedImage, Insets insets) {
        int n2 = insets.left;
        int n3 = insets.right;
        int n4 = insets.top;
        int n5 = insets.bottom;
        graphics.drawImage(bufferedImage, 0, 0, n2, n4, 0, 0, n2, n4, null);
        graphics.drawImage(bufferedImage, n2, 0, jComponent.getWidth() - n3, n4, n2, 0, bufferedImage.getWidth() - n3, n4, null);
        graphics.drawImage(bufferedImage, jComponent.getWidth() - n3, 0, jComponent.getWidth(), n4, bufferedImage.getWidth() - n3, 0, bufferedImage.getWidth(), n4, null);
        graphics.drawImage(bufferedImage, 0, n4, n2, jComponent.getHeight() - n5, 0, n4, n2, bufferedImage.getHeight() - n5, null);
        graphics.drawImage(bufferedImage, n2, n4, jComponent.getWidth() - n3, jComponent.getHeight() - n5, n2, n4, bufferedImage.getWidth() - n3, bufferedImage.getHeight() - n5, null);
        graphics.drawImage(bufferedImage, jComponent.getWidth() - n3, n4, jComponent.getWidth(), jComponent.getHeight() - n5, bufferedImage.getWidth() - n3, n4, bufferedImage.getWidth(), bufferedImage.getHeight() - n5, null);
        graphics.drawImage(bufferedImage, 0, jComponent.getHeight() - n5, n2, jComponent.getHeight(), 0, bufferedImage.getHeight() - n5, n2, bufferedImage.getHeight(), null);
        graphics.drawImage(bufferedImage, n2, jComponent.getHeight() - n5, jComponent.getWidth() - n3, jComponent.getHeight(), n2, bufferedImage.getHeight() - n5, bufferedImage.getWidth() - n3, bufferedImage.getHeight(), null);
        graphics.drawImage(bufferedImage, jComponent.getWidth() - n3, jComponent.getHeight() - n5, jComponent.getWidth(), jComponent.getHeight(), bufferedImage.getWidth() - n3, bufferedImage.getHeight() - n5, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
    }

    public static Color interpolate(Color color, Color color2, float f2) {
        float[] fArray = color2.getRGBComponents(null);
        float[] fArray2 = color.getRGBComponents(null);
        float[] fArray3 = new float[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            fArray3[i2] = fArray[i2] + (fArray2[i2] - fArray[i2]) * f2;
        }
        return new Color(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
    }
}

