/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.AbstractDateSelectionModel;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.util.Contract;

public class SingleDaySelectionModel
extends AbstractDateSelectionModel {
    private SortedSet<Date> selectedDates;
    private SortedSet<Date> unselectableDates;

    @Override
    public DateSelectionModel.SelectionMode getSelectionMode() {
        return DateSelectionModel.SelectionMode.SINGLE_SELECTION;
    }

    @Override
    public void addSelectionInterval(Date date, Date date2) {
        this.setSelection(date);
    }

    @Override
    public void setSelectionInterval(Date date, Date date2) {
        this.setSelection(date);
    }

    protected void setSelection(Date date) {
        throw new InternalError("Badly shrinked");
    }

    @Override
    public Date getFirstSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.first();
    }

    @Override
    public Date getLastSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.last();
    }

    public boolean isSelectable(Date date) {
        if (this.outOfBounds(date)) {
            return false;
        }
        return !this.inUnselectables(date);
    }

    private boolean inUnselectables(Date date) {
        for (Date date2 : this.unselectableDates) {
            if (!this.isSameDay(date2, date)) continue;
            return true;
        }
        return false;
    }

    private boolean outOfBounds(Date date) {
        if (this.belowLowerBound(date)) {
            return true;
        }
        return this.aboveUpperBound(date);
    }

    private boolean aboveUpperBound(Date date) {
        if (this.upperBound != null) {
            return this.endOfDay(this.upperBound).before(date);
        }
        return false;
    }

    private boolean belowLowerBound(Date date) {
        if (this.lowerBound != null) {
            return this.startOfDay(this.lowerBound).after(date);
        }
        return false;
    }

    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        this.selectedDates.clear();
        this.fireValueChanged(DateSelectionEvent.EventType.SELECTION_CLEARED);
    }

    @Override
    public SortedSet<Date> getSelection() {
        return new TreeSet<Date>(this.selectedDates);
    }

    @Override
    public boolean isSelected(Date date) {
        Contract.asNotNull(date, "date must not be null");
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.isSameDay(this.selectedDates.first(), date);
    }

    @Override
    public Date getNormalizedDate(Date date) {
        return new Date(date.getTime());
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedDates.isEmpty();
    }

    @Override
    public boolean isUnselectableDate(Date date) {
        return !this.isSelectable(date);
    }
}

