/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.event.EventListenerMap;

public abstract class AbstractDateSelectionModel
implements DateSelectionModel {
    public static final SortedSet<Date> EMPTY_DATES = Collections.unmodifiableSortedSet(new TreeSet());
    protected EventListenerMap listenerMap;
    protected boolean adjusting;
    protected Calendar calendar;
    protected Date upperBound;
    protected Date lowerBound;
    protected Locale locale;

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale.equals(this.getLocale())) {
            return;
        }
        this.locale = locale;
        this.calendar = this.calendar != null ? Calendar.getInstance(this.calendar.getTimeZone(), locale) : Calendar.getInstance(locale);
        this.fireValueChanged(DateSelectionEvent.EventType.CALENDAR_CHANGED);
    }

    protected Date startOfDay(Date date) {
        throw new InternalError("Badly shrinked");
    }

    protected Date endOfDay(Date date) {
        throw new InternalError("Badly shrinked");
    }

    protected boolean isSameDay(Date date, Date date2) {
        throw new InternalError("Badly shrinked");
    }

    @Override
    public Date getUpperBound() {
        return this.upperBound;
    }

    @Override
    public Date getLowerBound() {
        return this.lowerBound;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (bl == this.isAdjusting()) {
            return;
        }
        this.adjusting = bl;
        this.fireValueChanged(bl ? DateSelectionEvent.EventType.ADJUSTING_STARTED : DateSelectionEvent.EventType.ADJUSTING_STOPPED);
    }

    @Override
    public void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.listenerMap.add(DateSelectionListener.class, dateSelectionListener);
    }

    @Override
    public void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.listenerMap.remove(DateSelectionListener.class, dateSelectionListener);
    }

    protected void fireValueChanged(DateSelectionEvent.EventType eventType) {
        throw new InternalError("Badly shrinked");
    }
}

